#!/bin/sh

# Cores
EfeitoCorTitulo="\033[0;35m"
EfeitoCorOK="\033[0;32m"
EfeitoCorAlerta="\033[1;33m"
EfeitoCorErro="\033[0;31m"
EfeitoFecha="\033[0m"

# Variaveis gerais
versao_centos=`/bin/rpm -qa centos-release | cut -d '-' -f 3 | cut -d . -f 1`

unalias cp

clear

echo
echo -e "$EfeitoCorTitulo ################################################ $EfeitoFecha"
echo -e "$EfeitoCorTitulo # Script de Instalação de IceCast & Liquidsoap # $EfeitoFecha"
echo -e "$EfeitoCorTitulo # Criado por Cesar - cesarlwh@gmail.com        # $EfeitoFecha"
echo -e "$EfeitoCorTitulo ################################################ $EfeitoFecha"
echo

echo -e "$EfeitoCorOK Iniciando instalacao dos modulos... $EfeitoFecha"
echo

if [ "$1" == "--skip-inter" ]; then

echo
echo -e "$EfeitoCorAlerta Modo interativo desativado! $EfeitoFecha"
echo

silenciar="sim"

fi

yum install php-mysql netcat yum-utils telnet telnet-server git gcc gcc-c++ automake patch libcurl libsndfile -y

valida_yum=`echo $?`

if [ "$valida_yum" = "1" ]; then

echo
echo -e "$EfeitoCorAlerta Ocorreu um possivel erro ao instalar alguns modulos, verifique o LOG acima. $EfeitoFecha"
echo

read -n 1 -s -r -p "Aperte ENTER para continuar a instalação ou CTRL + C para cancelar."
echo

fi

yum-complete-transaction --cleanup-only

yum install openssl-devel -y

valida_yum=`echo $?`

if [ "$valida_yum" = "1" ]; then

echo
echo -e "$EfeitoCorAlerta Ocorreu um possivel erro ao instalar alguns modulos, verifique o LOG acima. $EfeitoFecha"
echo

read -n 1 -s -r -p "Aperte ENTER para continuar a instalação ou CTRL + C para cancelar."
echo

fi

yum -y groupinstall "Development Tools"

valida_yum=`echo $?`

if [ "$valida_yum" = "1" ]; then

echo
echo -e "$EfeitoCorAlerta Ocorreu um possivel erro ao instalar alguns modulos, verifique o LOG acima. $EfeitoFecha"
echo

read -n 1 -s -r -p "Aperte ENTER para continuar a instalação ou CTRL + C para cancelar."
echo

fi

mkdir /root/liquidsoap-sources
cd /root/liquidsoap-sources
wget -q https://dow.srvdns.ovh/lqsoap/liquidsoap-sources.zip
unzip liquidsoap-sources.zip
yum localinstall *.rpm -y

valida_yum=`echo $?`

if [ "$valida_yum" = "1" ]; then

echo
echo -e "$EfeitoCorAlerta Ocorreu um possivel erro ao instalar alguns modulos, verifique o LOG acima. $EfeitoFecha"
echo

read -n 1 -s -r -p "Aperte ENTER para continuar a instalação ou CTRL + C para cancelar."
echo

fi

yum install libcurl icecast psmisc netcat mercurial ladspa-devel libcurl-devel darcs bubblewrap lame-devel libmad-devel opus-devel taglib-devel flac-devel libtheora-devel libvorbis-devel speex-devel frei0r-devel -y

valida_yum=`echo $?`

if [ "$valida_yum" = "1" ]; then

echo
echo -e "$EfeitoCorAlerta Ocorreu um possivel erro ao instalar alguns modulos, verifique o LOG acima. $EfeitoFecha"
echo

read -n 1 -s -r -p "Aperte ENTER para continuar a instalação ou CTRL + C para cancelar."
echo

fi

yum -y groupinstall "Development Tools"

yum-config-manager --enable city-fan.org

yum update curl libcurl -y

valida_yum=`echo $?`

if [ "$valida_yum" = "1" ]; then

echo
echo -e "$EfeitoCorAlerta Ocorreu um possivel erro ao instalar alguns modulos, verifique o LOG acima. $EfeitoFecha"
echo

read -n 1 -s -r -p "Aperte ENTER para continuar a instalação ou CTRL + C para cancelar."
echo

fi

cd /root/liquidsoap-sources
sed -i 's/read BINDIR/BINDIR="$DEFAULT_BINDIR"/g' install.sh
sh install.sh
opam init --disable-sandboxing -a --bare
opam switch create 4.14.0

eval $(opam env)

if [ ! "$silenciar" ]; then
echo
read -n 1 -s -r -p "Pressione qualquer tecla para continuar..."
echo
fi

cd /root/liquidsoap-sources
wget https://dow.srvdns.ovh/lqsoap/liquidsoap-2.0.7.tar.bz2
tar -xvf liquidsoap-2.0.7.tar.bz2
cd liquidsoap-2.0.7/
opam pin add liquidsoap . --no-action -y

echo
echo -e "$EfeitoCorOK Configurando ffmpeg... $EfeitoFecha"
echo

cd ..
tar -zxf ffmpeg-4.4.tar.gz
cd ffmpeg-4.4/
./configure --enable-nonfree --enable-openssl --disable-yasm --enable-libmp3lame --enable-libx264 --enable-pic --enable-pic --enable-gpl --enable-shared --enable-decoder=aac --enable-filter=aformat --enable-filter=volume --enable-filter=aresample && make && make install
ldconfig
ffmpeg

if [ ! "$silenciar" ]; then
echo
read -n 1 -s -r -p "Pressione qualquer tecla para continuar..."
echo
fi

export PKG_CONFIG_PATH="/usr/local/lib/pkgconfig"

opam install liquidsoap ssl.0.5.9 ocurl taglib fdkaac mad lame vorbis cry faad.0.5.0 flac opus vorbis theora speex ogg xmlplaylist duppy ladspa dtools samplerate ffmpeg ffmpeg-avutil ffmpeg-avcodec ffmpeg-avdevice ffmpeg-av ffmpeg-avfilter ffmpeg-swresample ffmpeg-swscale frei0r -y --assume-depexts

eval $(opam env)

valida_ls1=`liquidsoap --version | grep -c 2.0.7`

if [ "$valida_ls1" = "0" ]; then

echo
echo -e "$EfeitoCorErro Falha na instalação do Liquidsoap, tentando novamente... $EfeitoFecha"
echo

opam reinstall liquidsoap ssl.0.5.9 ocurl taglib fdkaac mad lame vorbis cry faad.0.5.0 flac opus vorbis theora speex ogg xmlplaylist duppy ladspa dtools samplerate ffmpeg ffmpeg-avutil ffmpeg-avcodec ffmpeg-avdevice ffmpeg-av ffmpeg-avfilter ffmpeg-swresample ffmpeg-swscale frei0r -y --assume-depexts

eval $(opam env)

fi

valida_ls=`liquidsoap --version | grep -c 2.0.7`

if [ "$valida_ls" = "1" ]; then

mkdir /home/streaming/liquidsoap
mv -f /usr/share/icecast /home/streaming/
cp -f `whereis liquidsoap | awk '{ print $2;}'` /home/streaming/liquidsoap/
cp -f `whereis icecast | awk '{ print $2;}'` /home/streaming/icecast/

rm -rf /root/liquidsoap-sources

cd /home/streaming
rm -f liquidsoap-conf.tar.gz
wget -q https://dow.srvdns.ovh/lqsoap/liquidsoap-conf.tar.gz
tar -zxf liquidsoap-conf.tar.gz
rm -f liquidsoap-conf.tar.gz
chmod 777 /home/streaming/liquidsoap -Rf

sed -i '/certbot/d' /var/spool/cron/root

echo '* * * * * /home/streaming/liquidsoap/gerar-hora-certa' >> /var/spool/cron/root
echo "30 4 * * * certbot -n renew --pre-hook='/home/streaming/icecast/certbot-hook.sh listar' --post-hook='/home/streaming/icecast/certbot-hook.sh reiniciar;systemctl reload httpd'" >> /var/spool/cron/root
/bin/kill -HUP `cat /var/run/crond.pid`

echo
echo -e "$EfeitoCorOK Finalizando ajustes... $EfeitoFecha"
echo

cd /etc/letsencrypt/archive
for dominio in `find . -maxdepth 1 -type d | awk -F"./" '{print $2}'`;
do
if [ -d "/etc/letsencrypt/archive/${dominio}" ]; then
cat /etc/letsencrypt/live/${dominio}/fullchain.pem /etc/letsencrypt/live/${dominio}/privkey.pem > /home/streaming/icecast/${dominio}.pem
fi
done

echo
echo
/home/streaming/liquidsoap/liquidsoap --version
echo
echo

echo
echo -e "$EfeitoCorOK Instalação concluída com sucesso! $EfeitoFecha"
echo

else 

echo
echo -e "$EfeitoCorErro Falha na instalação do Liquidsoap, verificar logs acima e contactar suporte. $EfeitoFecha"
echo
echo

fi