<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="wmsdialog" tagdir="/WEB-INF/tags/wmsdialog" %>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<%@ taglib prefix="wmsutil" uri="/WEB-INF/tlds/wmsutil.tld" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>
<%@ attribute name="readonly" required="true" rtexprvalue="true" %>

<re:mark>Display all startup streams table</re:mark>

<c:set var="obj" >
	startupStreams
</c:set>
<c:if test="${fn:length(requestScope.formData[obj])>0}">
	<table class="table table-striped">
		<tr>
			<th width="30%"><wmsform:getlocalestring page="${page}" obj="${obj}.name"/></th>
			<th width="20%"><wmsform:getlocalestring page="${page}" obj="${obj}.mediaCasterType"/></th>
			<th width="20%"><wmsform:getlocalestring page="${page}" obj="${obj}.appName"/></th>
			<th width="20%"><wmsform:getlocalestring page="${page}" obj="${obj}.instanceName"/></th>
			<th width="10%"><wmsform:getlocalestring page="${page}" obj="${obj}.action"/></th>
		</tr>
		<c:forEach items="${requestScope.formData[obj]}" var="item">
			<tr>
				<c:choose>
					<c:when test="${readonly}">
						<td class="breakall">${wmsutil:escapeHtml(item.streamName)}</td>
						<td>${item.mediaCasterType}</td>
						<td>${wmsutil:escapeHtml(item.appName)}</td>
						<td>${item.instanceName}</td>
						<td></td>
					</c:when>
					<c:otherwise>
						<td class="breakall">${wmsutil:escapeHtml(item.streamName)}</td>
						<td>${item.mediaCasterType}</td>
						<td>${wmsutil:escapeHtml(item.appName)}</td>
						<td>${item.instanceName}</td>
						<td class="action-icons">
							<sec:authorize access="hasAnyRole('admin')">
							<!--
								<a href='#'><i class='fa fa-sign-in fa-2x icon-standalone-link' title='' data-placement='left' data-toggle='tooltip' data-delay='250' data-original-title='Connect to this stream'></i></a>&nbsp;&nbsp;
							 -->
								<a onclick='removeStartupStream("${wmsutil:escapeHtml(item.appName)}","${item.instanceName}","${wmsutil:escapeHtml(item.streamName)}")'><i class='fa fa-trash-o fa-2x icon-standalone-link' title='' data-placement='right' data-toggle='tooltip' data-delay='250' data-original-title='Delete Startup Stream'></i></a>
							</sec:authorize>
						</td>
					</c:otherwise>
				</c:choose>
			</tr>
		</c:forEach>
	</table>
</c:if>
<c:if test="${fn:length(requestScope.formData[obj])<=0}">
<wmsform:getlocalestring page="${page}" obj="noStreamsDefined"/>
</c:if>
<wmsdialog:deletestartupstream page="${page}"/>
<script>

var deleteStartupStreamName="";

function removeStartupStream(appName, appInstance, streamName)
{
	deleteStartupStreamName=streamName;
	deleteStartupStreamAppName=appName;
	deleteStartupStreamAppInstance=appInstance
	deleteStartupStreamShow();
}

var tblDataStartupStreams = new Array();

initTableDataStartupStreams();

function initTableDataStartupStreams()
{
	<c:set var="count" value="0"/>
	<c:forEach items="${requestScope.formData[obj]}" var="item">
		var newItem = new Object();
		newItem.name = "${item}";
		tblDataStartupStreams.push(newItem);
		<c:set var="count" value="${count + 1}"/>
	</c:forEach>
}
</script>
<script type="text/javascript">
    $(function () {
        $("[data-toggle='tooltip']").tooltip();
    });
</script>