<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="wmsdialog" tagdir="/WEB-INF/tags/wmsdialog" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>
<%@ attribute name="decodeOverlay" required="true" rtexprvalue="true" %>

<re:mark>Display all overlays tables</re:mark>

<c:set var="objOverlays" >
	overlaysList
</c:set>
<h4><wmsform:getlocalestring page="${page}" obj="overlaysList"/></h4>
<c:choose>
	<c:when test="${decodeOverlay}">
		<span class="help-block" id="decodeTableInfo"><wmsform:getlocalestring page="${page}" obj="${objOverlays}.decodeInfo"/></span>
	</c:when>
	<c:otherwise>
		<span class="help-block" id="encodeTableInfo"><wmsform:getlocalestring page="${page}" obj="${objOverlays}.encodeInfo"/></span>
	</c:otherwise>
</c:choose>
<c:choose>
	<c:when test="${fn:length(requestScope.formData[objOverlays]) == 0}">
		<div class="value">
			-None-
		</div>
	</c:when>
	<c:otherwise>
		<table class="table table-striped">
			<tr>
				<th style="vertical-align:bottom;text-align:center"><wmsform:getlocalestring page="${page}" obj="${objOverlays}.enabled"/></th>
				<th style="vertical-align:bottom"><wmsform:getlocalestring page="${page}" obj="${objOverlays}.overlayName"/></th>
				<th style="vertical-align:bottom"><wmsform:getlocalestring page="${page}" obj="${objOverlays}.imagePath"/></th>
			</tr>
			<c:forEach items="${requestScope.formData[objOverlays]}" var="item" varStatus="varStatus">
				<tr>
					<td>
						<c:choose>
							<c:when test="${item['enable']=='true'}">
								<center><input type="checkbox" disabled="disabled" checked="checked"></center>
							</c:when>
							<c:otherwise>
								<center><input type="checkbox" disabled="disabled"></center>
							</c:otherwise>
						</c:choose>
					</td>
					<td >
						<a href="javascript:overlayShow(${varStatus.index},${decodeOverlay})">${item['overlayName']}</a>
					</td>
					<td class='breakall'>${item['imagePath']}</td>
				</tr>
			</c:forEach>
		</table>
	</c:otherwise>
</c:choose>
<wmsdialog:viewoverlay page="transcoder.template.overlay"/>

<script>
var tblDataOverlay = new Array();
var tblIdxOverlay=0;

initTableDataOverlay();

function initTableDataOverlay()
{
	<c:set var="count" value="0"/>
	<c:forEach items="${requestScope.formData[objOverlays]}" var="item">
		var newItem = new Object();
		newItem.orgIdx = tblIdxOverlay++;
		newItem.removed = "${item['removed']}"==="true";
		newItem.enable = "${item['enable']}"=="true";
		newItem.overlayName = "${item['overlayName']}";
		newItem.imagePath = "${item['imagePath']}";
		newItem.checkForUpdates = "${item['checkForUpdates']}" == "true";
		newItem.opacity = "${item['opacity']}";
		newItem.width = "${item['width']}";
		newItem.height = "${item['height']}";
		newItem.align = "${item['align']}";
		newItem.xLocation = "${item['xLocation']}";
		newItem.yLocation = "${item['yLocation']}";
		newItem.index = "${item['index']}";
		tblDataOverlay.push(newItem);
		<c:set var="count" value="${count + 1}"/>
	</c:forEach>
	
	if(tblDataOverlay.length == 0)
	{
		$('#decodeTableInfo').hide();
		$('#encodeTableInfo').hide();
	}
}
</script>
