<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>
<%@ attribute name="obj" required="true" rtexprvalue="true" %>
<%@ attribute name="objUnits" required="false" rtexprvalue="true" %>
<%@ attribute name="showTitle" required="false" rtexprvalue="true" %>
<%@ attribute name="showEmptyValue" required="false" rtexprvalue="true" %>
<%@ attribute name="showEmptyString" required="false" rtexprvalue="true" %>
<%@ attribute name="bind" required="false" rtexprvalue="true" %>
<%@ attribute name="cssClassTitle" required="false" rtexprvalue="true" %>

<re:mark>Display a single int with units</re:mark>

<c:if test="${ empty objUnits}">
	<c:set var="objUnits">
		<wmsform:getlocalestring page="${page}" obj="${obj}.units"/>
	</c:set>
</c:if>
<c:set var="ctrlGroupClass">
	<wmsform:getctrlgroupclass obj="${obj}"/>
</c:set>
<c:if test="${ empty cssClassTitle}">
	<c:set var="cssClassTitle" value="control-label"/>
</c:if>

<div class="${ctrlGroupClass}" id="${obj}CtrlGroup">
	<c:if test="${ empty showTitle}">
		<label class="${cssClassTitle}">
			<wmsform:getlocalestring page="${page}" obj="${obj}"/>
		</label>
	</c:if>
	<div class="controls">

		<c:if test="${empty bind or bind=='true'}">
			<c:set var="objvalue"> 
				<wmsform:objvalue page="${page}" obj="${obj}"/>
			</c:set>
		</c:if>
		
		<div class="value">
			<div id="${obj}Value" style="display: inline-block">
				<c:choose>
					<c:when test="${objvalue==showEmptyValue && !empty showEmptyString }">
						${showEmptyString}
					</c:when>
					<c:otherwise>
						${objvalue}
					</c:otherwise>
				</c:choose>
			</div>
			<div id="${obj}Units" style="display: inline-block">
				<c:if test='${ not (fn:endsWith(objUnits,"units")) && not (objvalue==showEmptyValue && !empty showEmptyString) }'>
					${fn:trim(objUnits)}
				</c:if>
			</div>
			<wmsform:warnings path="view.${obj}"/>
		</div>
	</div>
</div>