<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>
<%@ attribute name="obj" required="true" rtexprvalue="true" %>
<%@ attribute name="cssClass" required="false" rtexprvalue="true" %>
<%@ attribute name="tooltip" required="false" rtexprvalue="true" %>
<%@ attribute name="readonly" required="false" rtexprvalue="true" %>
<%@ attribute name="required" required="false" rtexprvalue="true" %>
<%@ attribute name="autocapitalize" required="false" rtexprvalue="true" %>

<re:mark>Display a text box</re:mark>

<re:mark>Get the tooltip based on page and obj</re:mark>
<c:set var="tooltip_msg">
	<wmsform:getlocaletooltip page="${page}" obj="${obj}" tooltip="${tooltip}"/>
</c:set>
 
<c:set var="ctrlGroupClass">
	<wmsform:getctrlgroupclass obj="${obj}"/>
</c:set>
<c:if test="${empty autocapitalize }">
	<c:set var="autocapitalize" value="sentences"/>
</c:if>

<div class="${ctrlGroupClass}" id="${obj}CtrlGroup">
	<re:mark>Title</re:mark>
	<label class="control-label">
		<wmsform:getlocalestring  page="${page}" obj="${obj}"/>
		<c:if test="${! empty required}">
		*
		</c:if>
	</label>
	
	<div class="controls">
		<re:mark>Text box</re:mark>
		<c:choose>
			<c:when test="${empty readonly}">
				<form:textarea rows="3" path="${obj}" class="${cssClass}" title="${tooltip_msg}" value="bbb" autocapitalize="${autocapitalize}"/>
			</c:when>
			<c:otherwise>
				<form:textarea rows="3" path="${obj}" class="${cssClass}" title="${tooltip_msg}" readonly="${readonly}"/>
			</c:otherwise>
		</c:choose>
		
		<re:mark>Errors and warnings</re:mark>
		<wmsform:errors path="${obj}"/>
		<wmsform:warnings path="${obj}"/>
	</div>
</div>
<c:set var="objvalue"> 
	<wmsform:objvalue page="${page}" obj="${obj}"/>
</c:set>