<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>
<%@ attribute name="obj" required="true" rtexprvalue="true" %>
<%@ attribute name="objID" required="false" rtexprvalue="true" %>
<%@ attribute name="cssClass" required="false" rtexprvalue="true" %>
<%@ attribute name="cssClassTitle" required="false" rtexprvalue="true" %>
<%@ attribute name="cssSize" required="false" rtexprvalue="true" %>
<%@ attribute name="tooltip" required="false" rtexprvalue="true" %>
<%@ attribute name="readonly" required="false" rtexprvalue="true" %>
<%@ attribute name="required" required="false" rtexprvalue="true" %>
<re:mark>recomened not to use objunits but rather .units from messages_en file.</re:mark>
<%@ attribute name="objunits" required="false" rtexprvalue="true" %>

<re:mark>Display an autotune radio/text box combo</re:mark>
<c:set var="tooltip_msg">
	<wmsform:getlocaletooltip page="${page}" obj="${obj}" tooltip="${tooltip}"/>
</c:set>
<c:set var="ctrlGroupClass">
	<wmsform:getctrlgroupclass obj="${obj}"/>
</c:set>
<c:if test="${ empty cssClass}">
	<c:set var="cssClass" value="form-control"/>
</c:if>
<c:if test="${ empty cssSize}">
	<c:set var="cssSize" value="col-md-11"/>
</c:if>
<c:if test="${ empty readonly}">
	<c:set var="readonly" value="false"/>
</c:if>
<c:if test="${ empty cssClassTitle}">
	<c:set var="cssClassTitle" value="control-label"/>
</c:if>
<c:if test="${ empty objID}">
	<c:set var="objID" value="${obj}"/>
</c:if>
<c:if test="${ empty objunits}">
	<c:set var="objunits">
		<wmsform:getlocalestring page="${page}" obj="${obj}.units"/>
	</c:set>
</c:if>
	
<div class="${ctrlGroupClass}"  id="${obj}CtrlGroup">
	<form:hidden path="${obj}.units"/>
	<re:mark>Title</re:mark>
	<label class="${cssClassTitle}">
		<wmsform:getlocalestring page="${page}" obj="${obj}"/>
		<c:if test="${! empty required}">
			*
		</c:if>
	</label>
	<div class="radio">
		<form:radiobutton path="${obj}.setAutomatically" value="true"/>
	   	<wmsform:getlocalestring page="${page}" obj="setAutomatically"/>
	</div>
	<div class="radio">	
		<form:radiobutton path="${obj}.setAutomatically" value="false"/>
		<div class="row row-radioinput">
			<div class="${cssSize}">
		<form:input path="${obj}.value" title="${tooltip_msg}" class="${cssClass}" readonly="${readonly}"/>
			</div>
		</div>
		<c:if test='${ not (fn:endsWith(objunits,"units"))}'>
			<div class="help-block">
				${fn:trim(objunits)}
			</div>
		</c:if>
		<span class="help-block-has-error" id="${obj}ErrorMsg" style="display:none"></span>
		<re:mark>Errors and warnings</re:mark>
		<wmsform:errors path="${obj}"/> 
		<wmsform:warnings path="${obj}"/>
	</div>
</div>

<script>

$(document).ready(function() {
	$("input[name='${obj}.setAutomatically']").change(function() {
		if( $("input[name='${obj}.setAutomatically']:checked").val()=='false')
	    {
			$("#${objID}\\.value").attr("disabled", false);
	    }
	    else 
	    {
			$("#${objID}\\.value").attr("disabled", true);
	    	$("#${objID}\\.value").val('');
	    }
	});
	$("input[name='${obj}.setAutomatically']").change();
});

/*
function setTextDisableFor${obj}()
{
	if(!$("#${obj}\\.setAutomatically1").is(':checked'))
	{
		document.getElementById('${obj}.value').disabled=false;
	}
	else {
		document.getElementById('${obj}.value').disabled=true;
		document.getElementById('${obj}.value').value="";			
	}
}
*/
</script>