<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>
<%@ attribute name="obj" required="true" rtexprvalue="true" %>
<%@ attribute name="cssClass" required="false" rtexprvalue="true" %>
<%@ attribute name="cssClassTitle" required="false" rtexprvalue="true" %>
<%@ attribute name="cssSize" required="false" rtexprvalue="true" %>
<%@ attribute name="cssRow" required="false" rtexprvalue="true" %>
<%@ attribute name="ctrlGroupClass" required="false" rtexprvalue="true" %>
<%@ attribute name="tooltip" required="false" rtexprvalue="true" %>
<%@ attribute name="readonly" required="false" rtexprvalue="true" %>
<%@ attribute name="required" required="false" rtexprvalue="true" %>
<%@ attribute name="showTitle" required="false" rtexprvalue="true" %>
<%@ attribute name="bind" required="false" rtexprvalue="true" %>
<%@ attribute name="inputType" required="false" rtexprvalue="true" %>
<%@ attribute name="inputFilter" required="false" rtexprvalue="true" %>
<%@ attribute name="autocapitalize" required="false" rtexprvalue="true" %>
<%@ attribute name="helpIconId" required="false" rtexprvalue="true" %>
<%@ attribute name="helpIconDesc" required="false" rtexprvalue="true" %>
<%@ attribute name="helpIconName" required="false" rtexprvalue="true" %>


<re:mark>Display a text box</re:mark>

<re:mark>Get the tooltip based on page and obj</re:mark>
<c:set var="tooltip_msg">
	<wmsform:getlocaletooltip page="${page}" obj="${obj}" tooltip="${tooltip}"/>
</c:set>
<c:set var="ctrlGroupClass">
	<wmsform:getctrlgroupclass obj="${obj}"/>
</c:set>

<c:if test="${ empty readonly}">
	<c:set var="readonly" value="false"/>
</c:if>
<c:if test="${ empty bind}">
	<c:set var="bind" value="true"/>
</c:if>
<c:if test="${ empty cssClassTitle}">
	<c:set var="cssClassTitle" value="control-label"/>
</c:if>
<c:if test="${ empty cssClass}">
	<c:set var="cssClass" value="form-control"/>
</c:if>
<c:if test="${ empty cssSize}">
	<c:set var="cssSize" value="col-md-12"/>
</c:if>
<c:if test="${ empty cssRow}">
	<c:set var="cssRow" value="row"/>
</c:if>
<c:set var="objunits">
	<wmsform:getlocalestring page="${page}" obj="${obj}.units"/>
</c:set>
<c:if test="${ empty inputType}">
	<c:set var="inputType" value="text"/>
</c:if>
<c:if test="${empty autocapitalize }">
	<c:set var="autocapitalize" value="none"/>
</c:if>
<c:if test="${ empty required}">
	<c:set var="required" value="false"/>
</c:if>
<c:if test="${required=='yes'}">
	<c:set var="required" value="true"/>
</c:if>

<c:choose>
	<c:when test="${ inputFilter=='numerical'}">
		<script>
		$( '#${obj}' ).keypress(function( event ) {
			var code = String.fromCharCode(event.which);
			if (code.match(/[^0-9\.]/) && !(event.keyCode==8 || event.keyCode==46 || event.keyCode==9)){
				event.preventDefault();
			}
			var pos = $('#${obj}').getCursorPosition();
			var newcode = $('#${obj}').val().substring(0,pos)+code+$('#${obj}').val().substring(pos);
			if (!/^[0-9]+(\.[0-9]*)?$/.test(newcode))
			{
				event.preventDefault();
			}
		});
		</script>
	</c:when>
	<c:when test="${ inputFilter=='integer'}">
		<script>
		$( '#${obj}' ).keypress(function( event ) {
			var code = String.fromCharCode(event.which);
			if (code.match(/[^0-9]/) && !(event.keyCode==8 || event.keyCode==46 || event.keyCode==9)) {
				event.preventDefault();
			}
		});
		</script>
	</c:when>
	<c:when test="${ !empty inputFilter}">
		<script>
		$( '#${obj}' ).keypress(function( event ) {
			var code = String.fromCharCode(event.which);
			var pos = $('#${obj}').getCursorPosition();
			var newcode = $('#${obj}').val().substring(0,pos)+code+$('#${obj}').val().substring(pos);
			var newRegex = new RegExp("${inputFilter}","g");
			if (!newRegex.test(newcode) && !(event.keyCode==8 || event.keyCode==46 || event.keyCode==9))
			{
				event.preventDefault();
			}
		});
		</script>
	</c:when>
</c:choose>
<div class="${ctrlGroupClass}" id="${obj}CtrlGroup">
	<re:mark>Title</re:mark>
	<c:if test="${ empty showTitle}">
		<label class="${cssClassTitle}" for="${obj}">
		<wmsform:getlocalestring page="${page}" obj="${obj}"/>
		<c:if test="${required=='true'}">
			*
		</c:if>
		</label>
	</c:if>
	<script>
	</script>
	<re:mark>Text box</re:mark>
	<c:choose>
		<c:when test="${bind=='true'}">
			<c:choose>
				<c:when test="${inputType=='password'}">
					<div class="${cssRow}">
						<div class="${cssSize}">
							<form:password path="${obj}" title="${tooltip_msg}" class="${cssClass}" readonly="${readonly}"/>
							<c:if test="${! empty helpIconId}">
								<i id="${helpIconId}" class="fa fa-question-circle fa-2x" rel="popover" data-html="true" data-content="${helpIconDesc}" data-trigger="click" data-animation="true" data-placement="left" data-delay="150" data-original-title="${helpIconName}"></i>
							</c:if>
						</div>
					</div>
				</c:when>
				<c:otherwise>
					<div class="${cssRow}">
						<div class="${cssSize}">
							<form:input path="${obj}" title="${tooltip_msg}" class="${cssClass}" readonly="${readonly}" autocapitalize="${autocapitalize}"/>
							<c:if test="${! empty helpIconId}">
								<i id="${helpIconId}" class="fa fa-question-circle fa-2x" rel="popover" data-html="true" data-content="${helpIconDesc}" data-trigger="click" data-animation="true" data-placement="left" data-delay="150" data-original-title="${helpIconName}"></i>
							</c:if>
						</div>
					</div>
				</c:otherwise>
			</c:choose>
			<c:if test='${ not (fn:endsWith(objunits,"units"))}'>
				<div class="help-block">
					${fn:trim(objunits)}
				</div>
			</c:if>
			<span class="help-block-has-error" id="${obj}ErrorMsg" style="display:none"></span>
		</c:when>
		<c:otherwise>
			<c:choose>
				<c:when test="${readonly=='false'}">
					<div class="${cssRow}">
						<div class="${cssSize}">
							<input type="${inputType}" title="${tooltip_msg}" id="${obj}" class="${cssClass}" autocapitalize="${autocapitalize}"/>
							<c:if test="${! empty helpIconId}">
								<i id="${helpIconId}" class="fa fa-question-circle fa-2x" rel="popover" data-html="true" data-content="${helpIconDesc}" data-trigger="click" data-animation="true" data-placement="left" data-delay="150" data-original-title="${helpIconName}"></i>
							</c:if>
						</div>
					</div>
					<c:if test='${ not (fn:endsWith(objunits,"units"))}'>
						<div class="help-block">
							${fn:trim(objunits)}
						</div>
					</c:if>
					<span class="help-block-has-error" id="${obj}ErrorMsg" style="display:none"></span>
				</c:when>
				<c:otherwise>
					<div class="${cssRow}">
						<div class="${cssSize}">
							<input type="${inputType}" title="${tooltip_msg}" id="${obj}" class="${cssClass}" readonly/>
							<c:if test="${! empty helpIconId}">
								<i id="${helpIconId}" class="fa fa-question-circle fa-2x" rel="popover" data-html="true" data-content="${helpIconDesc}" data-trigger="click" data-animation="true" data-placement="left" data-delay="150" data-original-title="${helpIconName}"></i>
							</c:if>
						</div>
					</div>
					<c:if test='${ not (fn:endsWith(objunits,"units"))}'>
						<div class="help-block">
							${fn:trim(objunits)}
						</div>
					</c:if>
					<span class="help-block-has-error" id="${obj}ErrorMsg" style="display:none"></span>
				</c:otherwise>
			</c:choose>
		</c:otherwise>
	</c:choose>

	<re:mark>Errors and warnings</re:mark>
	<c:if test="${bind=='true'}">
		<wmsform:errors path="${obj}"/>
		<wmsform:warnings path="${obj}"/>
	</c:if>
	<c:set var="objhelp">
		<wmsform:getlocalestring page="${page}" obj="${obj}.help"/>
	</c:set>
	<c:choose>
		<c:when test='${ not (fn:endsWith(objhelp,"help"))}'>
			<span class="help-block">${fn:trim(objhelp)}</span>
		</c:when>
	</c:choose>
</div>

<script>
(function ($, undefined) {
    $.fn.getCursorPosition = function() {
        var el = $(this).get(0);
        var pos = 0;
        if('selectionStart' in el) {
            pos = el.selectionStart;
        } else if('selection' in document) {
            el.focus();
            var Sel = document.selection.createRange();
            var SelLength = document.selection.createRange().text.length;
            Sel.moveStart('character', -el.value.length);
            pos = Sel.text.length - SelLength;
        }
        return pos;
    }
})(jQuery);
</script>
