<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>
<%@ attribute name="obj" required="true" rtexprvalue="true" %>
<%@ attribute name="onClick" required="true" rtexprvalue="true" %>
<%@ attribute name="icon" required="false" rtexprvalue="true" %>
<%@ attribute name="iconRight" required="false" rtexprvalue="true" %>
<%@ attribute name="btnType" required="false" rtexprvalue="true" %>

<re:mark>Display a button</re:mark>
<c:set var="btnValue">
	<wmsform:getlocalestring page="${page}" obj="${obj}"/>
</c:set>
<c:if test="${ empty btnType}">
	<c:set var="btnType" value="btn btn-primary"/>
</c:if>

<a class="${btnType}" name="${obj}" id="${obj}" onClick="${onClick}"><i class="${icon}"></i> ${btnValue} <i class="${iconRight}"></i></a>

