<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%@ taglib prefix="wmsutil" uri="/WEB-INF/tlds/wmsutil.tld" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>

<div id="restartStreamTargetModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="restartStreamTargetModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<form class="form-modal"><fieldset>
				  <div class="modal-header">
					<button type="button" class="close" onClick="javascript:restartStreamTargetClose()">x</button>
					<h4 id="restartStreamTargetModalLabel" class="modal-title"><wmsform:getlocalestring page="restartStreamTargetDialog" obj="title"/></h4>
				  </div>
				  <div class="modal-body">
						<p class="breakall"><wmsform:getlocalestring page="restartStreamTargetDialog" obj="message"/> <b><span id="restartStreamTargetName"></span></b>?</p>
						<p class="text-warning"><wmsform:getlocalestring page="restartStreamTargetDialog" obj="warning"/></p>
				  </div>
				  <div class="modal-footer">
					<wmsform:buttoncancel  onClick="javascript:restartStreamTargetClose()"/>
					<wmsform:buttonok  onClick="javascript:doRestartStreamTarget()"/>
				  </div>
			</fieldset></form>
		</div>
	</div>
</div>
<script>
var currentStreamTarget;
var currentApp;

function restartStreamTargetShow(app, streamTargetName) {
	$('#restartStreamTargetName').text(streamTargetName);
	currentApp=app;
	currentStreamTarget=streamTargetName;
	$('#restartStreamTargetModal').on("shown.bs.modal", function() {});
	$('#restartStreamTargetModal').modal('show');	
}

function restartStreamTargetClose() {
	$('#restartStreamTargetModal').modal('hide');
	restartRefresh();
}

function doRestartStreamTarget() {
	$('#restartStreamTargetModal').on('hidden.bs.modal', function() {
		postAJAXForm('streamTarget/restart.htm','vhost=${wmsutil:urlEncode(vhost)}&appName='+encodeURIComponent(currentApp)+'&appType=${appType}&appSection=${appSection}&streamTargetName='+encodeURIComponent(currentStreamTarget)+'&returnPage=${page}');
	});
	restartStreamTargetClose();
}

</script>