<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>
<%@ attribute name="returnPage" required="true" rtexprvalue="true" %>

<div id="restartServerModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="restartServerModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<form class="form-modal"><fieldset>
				  <div class="modal-header">
					<button type="button" class="close" onClick="javascript:restartServerClose()">x</button>
					<h4 id="restartServerModalLabel" class="modal-title"><wmsform:getlocalestring page="${page}" obj="restartServerDialog.title"/></h4>
				  </div>
				  <div class="modal-body">
						<p><wmsform:getlocalestring page="${page}" obj="restartServerDialog.message"/></p>
						<p class="text-warning"><wmsform:getlocalestring page="${page}" obj="restartServerDialog.warning"/></p>
				  </div>
				  <div class="modal-footer">
					<wmsform:buttoncancel  onClick="javascript:restartServerClose()"/>
					<wmsform:buttonok  onClick="javascript:doRestartServer()"/>
				  </div>
			</fieldset></form>
		</div>
	</div>
</div>
<script>

function restartServerShow() {
	$('#restartServerModal').modal('show');	
}

function restartServerClose() {	
	$('#restartServerModal').modal('hide');
}

function doRestartServer() {
	$('#restartServerModal').on('hidden.bs.modal', function() {
		postAJAXForm('server/restart.htm','returnPage=${returnPage}');
	});
	restartServerClose();
}
</script>