<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>

<div id="overlayEditModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="overlayEditModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<fieldset>
				<div class="modal-header">
					<button type="button" class="close" onClick="javascript:overlayEditClose()">x</button>
					<h4 id="addOverlayEditModalLabel" class="modal-title"><wmsform:getlocalestring page="${page}" obj="addHeader"/></h4>
					<h4 id="editOverlayEditModalLabel" class="modal-title"><wmsform:getlocalestring page="${page}" obj="editHeader"/></h4>
				</div>
				<div class="modal-body">
					<span class="help-block" id="decodeInfo"><wmsform:getlocalestring page="${page}" obj="decodeInfo"/></span>
					<span class="help-block" id="encodeInfo"><wmsform:getlocalestring page="${page}" obj="encodeInfo"/></span>
			  
					<div class="row">
						<div class="col-md-12">
							<ul class="nav nav-tabs" >
								<li id="ImageEdit" >
									<a href="javascript:showImageEditTab()">Image</a>
								</li>
								<li id="ImageEditPlacement" >
									<a href="javascript:showImageEditPlacementTab()">Image Placement</a>
								</li>
							</ul>
						</div>
					</div>    
					<div class="row" id="tabContent">
						<div class="col-md-12">
							<div id="ViewMode">
								<div id="TabImageEdit" style="display:none">
									<wmsform:viewproperty page="${page}" obj="overlayName"  cssClassTitle="control-label" bind="false" />
									<wmsform:editproperty page="${page}" obj="overlayNameEdit" bind="false"  cssClassTitle="control-label" required="true" cssClass="form-control"/>
								
									<wmsform:editproperty page="${page}" obj="imagePath" cssClass="form-control" cssClassTitle="control-label"  required="true" bind="false"/>
									<h5 class="control-label"><wmsform:getlocalestring page="${page}" obj="imageOptions"/></h5>
									<wmsform:editpropertycheckbox page="${page}" obj="checkForUpdates" bind="false"/>
		
									<div class="form-group">
										<h5 class="control-label"><wmsform:getlocalestring page="${page}" obj="width"/></h5>
										<div class="radio">
											<input type="radio" name="widthRadio" value="width">
											<wmsform:getlocalestring page="${page}" obj="sameWidth"/>
										</div>
										<div class="radio">
											<input type="radio" name="widthRadio" value="pixels">
											<wmsform:editproperty page="${page}" obj="overlayWidth" cssRow="row row-radioinput" cssClass="form-control" showTitle="false" bind="false" cssSize="col-md-2 field-radioinput" inputFilter='integer'/>
										</div>
									</div>
										<div class="form-group">
										<h5 class="control-label"><wmsform:getlocalestring page="${page}" obj="height"/></h5>
										<div class="radio">
											<input type="radio" name="heightRadio" value="height">
											<wmsform:getlocalestring page="${page}" obj="sameHeight"/>
										</div>
										<div class="radio">
											<input type="radio" name="heightRadio" value="pixels">
											<wmsform:editproperty page="${page}" obj="overlayHeight" cssRow="row row-radioinput" cssClass="form-control" showTitle="false" bind="false" cssSize="col-md-2 field-radioinput" inputFilter='integer'/>
										</div>
									</div>
									<wmsform:editproperty page="${page}" obj="opacity"  cssClass="form-control" bind="false" cssSize="col-md-2" inputFilter='integer'/>
		
								</div>
								<div  id="TabImageEditPlacement" style="display:none">
		
									<h5 class="control-label"><wmsform:getlocalestring page="${page}" obj="align"/></h5>
									<div class="overlay-location form-group">
										<table class="overlay-location-table">
											<tr>
												<td>
													<input type="radio" name="alignRadio" value="left,top">
												</td>
												<td class="text-center">
													<input type="radio" name="alignRadio" value="hcenter,top">
												</td>
												<td class="text-right">
													<input type="radio" name="alignRadio" value="right,top">
												</td>
											</tr>
											<tr>
												<td>
													<input type="radio" name="alignRadio" value="left,vcenter">
												</td>
												<td class="text-center">
													<input type="radio" name="alignRadio" value="hcenter,vcenter">
												</td>
												<td class="text-right">
													<input type="radio" name="alignRadio" value="right,vcenter">
												</td>
											</tr>
											<tr>
												<td>
													<input type="radio" name="alignRadio" value="left,bottom">
												</td>
												<td class="text-center">
													<input type="radio" name="alignRadio" value="hcenter,bottom">
												</td>
												<td class="text-right">
													<input type="radio" name="alignRadio" value="right,bottom">
												</td>
											</tr>
										</table>
									</div>
									<wmsform:editproperty page="${page}" obj="xLocation"  cssClassTitle="control-label" cssClass="form-control" bind="false" cssSize="col-md-2" inputFilter="^-?[0-9]*$"/>
									<wmsform:editproperty page="${page}" obj="yLocation"  cssClassTitle="control-label" cssClass="form-control" bind="false" cssSize="col-md-2" inputFilter="^-?[0-9]*$"/>
		
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<div class="row">
						<div class="col-md-8">
							<div id="overlayImageDialogError" class="alert alert-danger" style="display:none"></div>
						</div>
						<div class="col-md-4">
							<wmsform:buttoncancel  onClick="overlayEditClose()"/>
							<wmsform:buttonprimary page="${page}" obj="addOverlay" onClick="javascript:overlaySave()"  icon="fa fa-plus icon-white"/>
							<wmsform:buttonprimary page="${page}" obj="applyOverlay" onClick="javascript:overlaySave()" />
						</div>
					</div>
				</div>
			</fieldset>
		</div>
	</div>
</div>
<c:set var="overlayNameEmptyError">
	<wmsform:getlocalestring page="${page}" obj="overlayName.empty"/>
</c:set>
<c:set var="overlayNameInvalidError">
	<wmsform:getlocalestring page="common" obj="invalidStreamName"/>
</c:set>
<c:set var="dupOverlayNameError">
	<wmsform:getlocalestring page="${page}" obj="overlayName.dup"/>
</c:set>
<c:set var="imagePathEmptyError">
	<wmsform:getlocalestring page="${page}" obj="imagePath.empty"/>
</c:set>
<c:set var="imagePathInvalidError">
	<wmsform:getlocalestring page="common" obj="invalidPathName"/>
</c:set>
<c:set var="widthError">
	<wmsform:getlocalestring page="${page}" obj="width.invalid"/>
</c:set>
<c:set var="heightError">
	<wmsform:getlocalestring page="${page}" obj="height.invalid"/>
</c:set>
<c:set var="heightWidthSumError">
	<wmsform:getlocalestring page="${page}" obj="heightWidthSum.invalid"/>
</c:set>
<c:set var="opacityError">
	<wmsform:getlocalestring page="${page}" obj="opacity.wrongValue"/>
</c:set>
<c:set var="offsetError">
	<wmsform:getlocalestring page="${page}" obj="offset.invalid"/>
</c:set>
<c:set var="overlayError">
	<wmsform:getlocalestring page="common" obj="formErrorTabs"/>
</c:set>

<script>

$(document).ready(function() {
	showImageEditTab();	
	$("input[name='widthRadio']").change(function() {
		toggleWidth();
	});
	$("input[name='heightRadio']").change(function() {
		toggleHeight();
	});
});

function toggleWidth()
{
    if( $("input[name='widthRadio']:checked").val()=='pixels')
    {
		$("#overlayWidth").attr("disabled", false);
    	$('#overlayWidth').val('0');
    }
    else 
    {
		$("#overlayWidth").attr("disabled", true);
    	$('#overlayWidth').val('');
    }
}

function toggleHeight()
{
    if( $("input[name='heightRadio']:checked").val()=='pixels')
    {
		$("#overlayHeight").attr("disabled", false);
    	$('#overlayHeight').val('0');
    }
    else 
    {
		$("#overlayHeight").attr("disabled", true);
    	$('#overlayHeight').val('');
    }
}
function showImageEditTab() {
	$('#TabImageEdit').show();
	$('#TabImageEditPlacement').hide();
	$('#ImageEdit').addClass('active');
	$('#ImageEditPlacement').removeClass();
}

function showImageEditPlacementTab() {
	$('#TabImageEdit').hide();
	$('#TabImageEditPlacement').show();
	$('#ImageEdit').removeClass();
	$('#ImageEditPlacement').addClass('active');	
}


function overlayEditShow(orgIdx,decodeOverlay) {
	$('#overlayModal').remove();	
	editIdx=orgIdx;
	if(decodeOverlay)
	{
		$('#decodeInfo').show();		
		$('#encodeInfo').hide();
	}
	else 
	{
		$('#encodeInfo').show();
		$('#decodeInfo').hide();		
	}
	
	//test to see if we don't want these.  If so, remove the div/span tags
	$('#decodeInfo').hide();		
	$('#encodeInfo').hide();

	if(orgIdx<0)
	{
		$('#overlayNameCtrlGroup').hide();
		$('#overlayNameEditCtrlGroup').show();

		$('#overlayNameEdit').val("");
		$('#imagePath').val("");
		$('#checkForUpdates').prop('checked', false);
		$('#opacity').val("100");
		$('#overlayWidth').val("");
		$("input[name='widthRadio'][value=width]").prop("checked", true);
		toggleWidth();
		$('#overlayHeight').val("");
		$("input[name='heightRadio'][value=height]").prop("checked", true);
		toggleHeight();
		$("input[name='alignRadio'][value='hcenter,vcenter']").prop("checked", true);
		$('#xLocation').val("0");
		$('#yLocation').val("0");

		$('#applyOverlay').hide();
		$('#addOverlay').show();
		$('#editOverlayEditModalLabel').hide();
		$('#addOverlayEditModalLabel').show();
	}
	else 
	{
		$('#overlayNameCtrlGroup').show();
		$('#overlayNameEditCtrlGroup').hide();

		$('#overlayNameValue').text(tblDataOverlay[orgIdx].overlayName);
		$('#overlayNameEdit').val(tblDataOverlay[orgIdx].overlayName);

		$('#imagePath').val(tblDataOverlay[orgIdx].imagePath);
		$('#checkForUpdates').prop('checked', tblDataOverlay[orgIdx].checkForUpdates);
		$('#opacity').val(tblDataOverlay[orgIdx].opacity);
		if(tblDataOverlay[orgIdx].width == "$"+"{ImageWidth}")
		{
			$("input[name='widthRadio'][value=width]").prop("checked", true);
			toggleWidth();
			$('#overlayWidth').val("");
		}
		else 
		{
			$("input[name='widthRadio'][value=pixels]").prop("checked", true);
			toggleWidth();
			$('#overlayWidth').val(tblDataOverlay[orgIdx].width);
		}
		if(tblDataOverlay[orgIdx].height == "$"+"{ImageHeight}")
		{
			$("input[name='heightRadio'][value=height]").prop("checked", true);
			toggleHeight();
			$('#overlayHeight').val("");
		}
		else 
		{
			$("input[name='heightRadio'][value=pixels]").prop("checked", true);
			toggleHeight();
			$('#overlayHeight').val(tblDataOverlay[orgIdx].height);
		}

		alignRdBtn="";
		if(tblDataOverlay[orgIdx].align.toLowerCase().indexOf("left")>=0)
		{
			alignRdBtn="left";
		}
		else if(tblDataOverlay[orgIdx].align.toLowerCase().indexOf("hcenter")>=0)
		{
			alignRdBtn="hcenter";
		}
		else if(tblDataOverlay[orgIdx].align.toLowerCase().indexOf("right")>=0)
		{
			alignRdBtn="right";
		}
		if(tblDataOverlay[orgIdx].align.toLowerCase().indexOf("top")>=0)
		{
			alignRdBtn+=",top";
		}
		else if(tblDataOverlay[orgIdx].align.toLowerCase().indexOf("vcenter")>=0)
		{
			alignRdBtn+=",vcenter";
		}
		else if(tblDataOverlay[orgIdx].align.toLowerCase().indexOf("bottom")>=0)
		{
			alignRdBtn+=",bottom";
		}
		if(alignRdBtn.indexOf(",")<0)
		{
			$("input[name='alignRadio'][value='hcenter,vcenter']").prop("checked", true);	
		}
		else 
		{
			$("input[name='alignRadio'][value='"+alignRdBtn+"']").prop("checked", true);			
		}
		$('#xLocation').val(tblDataOverlay[orgIdx].xLocation);
		$('#yLocation').val(tblDataOverlay[orgIdx].yLocation);

		$('#applyOverlay').show();
		$('#addOverlay').hide();
		$('#editOverlayEditModalLabel').show();
		$('#addOverlayEditModalLabel').hide();
	}
	
	
	$('#overlayNameEditCtrlGroup').attr('class', 'form-group');
	$('#overlayNameEditErrorMsg').html("");
	$('#overlayNameEditErrorMsg').hide();
	$('#imagePathCtrlGroup').attr('class', 'form-group');
	$('#imagePathErrorMsg').html("");
	$('#imagePathErrorMsg').hide();
	$('#overlayWidthCtrlGroup').attr('class', 'form-group');
	$('#overlayWidthErrorMsg').html("");
	$('#overlayWidthErrorMsg').hide();
	$('#overlayHeightCtrlGroup').attr('class', 'form-group');
	$('#overlayHeightErrorMsg').html("");
	$('#overlayHeightErrorMsg').hide();
	$('#opacityCtrlGroup').attr('class', 'form-group');
	$('#opacityErrorMsg').html("");
	$('#opacityErrorMsg').hide();
	$('#xLocationCtrlGroup').attr('class', 'form-group');
	$('#xLocationErrorMsg').html("");
	$('#xLocationErrorMsg').hide();
	$('#yLocationCtrlGroup').attr('class', 'form-group');
	$('#yLocationErrorMsg').html("");
	$('#yLocationErrorMsg').hide();
	$("#overlayImageDialogError").text("");
	$("#overlayImageDialogError").hide();
	
	$('#overlayEditModal').on("shown.bs.modal", function() {
	});
	$('#overlayEditModal').modal('show');	
}

function overlayEditClose() {
	$('#overlayEditModal').modal('hide');
}


function overlaySave() {
	var ok=true;
	$('#overlayNameEditCtrlGroup').attr('class', 'form-group');
	$('#overlayNameEditErrorMsg').html("");
	$('#overlayNameEditErrorMsg').hide();
	$('#imagePathCtrlGroup').attr('class', 'form-group');
	$('#imagePathErrorMsg').html("");
	$('#imagePathErrorMsg').hide();
	$('#overlayWidthCtrlGroup').attr('class', 'form-group');
	$('#overlayWidthErrorMsg').html("");
	$('#overlayWidthErrorMsg').hide();
	$('#overlayHeightCtrlGroup').attr('class', 'form-group');
	$('#overlayHeightErrorMsg').html("");
	$('#overlayHeightErrorMsg').hide();
	$('#opacityCtrlGroup').attr('class', 'form-group');
	$('#opacityErrorMsg').html("");
	$('#opacityErrorMsg').hide();
	$('#xLocationCtrlGroup').attr('class', 'form-group');
	$('#xLocationErrorMsg').html("");
	$('#xLocationErrorMsg').hide();
	$('#yLocationCtrlGroup').attr('class', 'form-group');
	$('#yLocationErrorMsg').html("");
	$('#yLocationErrorMsg').hide();

	if($('#overlayNameEdit').val() =="")
	{
		$('#overlayNameEditCtrlGroup').attr('class', 'form-group has-error');
		$('#overlayNameEditErrorMsg').html("${overlayNameEmptyError}");
		$('#overlayNameEditErrorMsg').show();
		ok=false;
	}
	if (!isValidStreamName($('#overlayNameEdit').val()))
	{
		$('#overlayNameEditCtrlGroup').attr('class', 'form-group has-error');
		$('#overlayNameEditErrorMsg').html("${overlayNameInvalidError}");
		$('#overlayNameEditErrorMsg').show();
		ok=false;
	}	
	if(editIdx<0)
	{
		for (tblItem in tblDataOverlay) {
			if(!tblDataOverlay[tblItem].removed)
			{
				if(tblDataOverlay[tblItem].overlayName==$("#overlayNameEdit").val())
				{
					$('#overlayNameEditCtrlGroup').attr('class', 'form-group has-error');
					$('#overlayNameEditErrorMsg').html("${dupOverlayNameError}");
					$('#overlayNameEditErrorMsg').show();
					ok=false;
				}
			}
		}
	}

	if($("#imagePath").val() =="")
	{
		$('#imagePathCtrlGroup').attr('class', 'form-group has-error');
		$('#imagePathErrorMsg').html("${imagePathEmptyError}");
		$('#imagePathErrorMsg').show();
		ok=false;
	}
	$("#imagePath").val(fixFilePathSlashes($("#imagePath").val()));
	if (!isValidPath($("#imagePath").val()))
	{
		$('#imagePathCtrlGroup').attr('class', 'form-group has-error');
		$('#imagePathErrorMsg').html("${imagePathInvalidError}");
		$('#imagePathErrorMsg').show();
		ok=false;
	}
	var op = parseInt($("#opacity").val());
	if(isNaN(op) || op<0 || op>100)
	{
		$('#opacityCtrlGroup').attr('class', 'form-group has-error');
		$('#opacityErrorMsg').html("${opacityError}");
		$('#opacityErrorMsg').show();
		ok=false;
	}
	var width = NaN;
    if( $("input[name='widthRadio']:checked").val()=='pixels')
    {
    	width = parseInt("0"+$('#overlayWidth').val());
		if(width < 4)
		{
			$('#overlayWidthCtrlGroup').attr('class', 'form-group has-error');
			$('#overlayWidthErrorMsg').html("${widthError}");
			$('#overlayWidthErrorMsg').show();
			width = NaN;
			ok=false;
		}
    }
	var height = NaN;
    if( $("input[name='heightRadio']:checked").val()=='pixels')
    {
    	height = parseInt("0"+$('#overlayHeight').val());
    	if(height < 4)
		{
			$('#overlayHeightCtrlGroup').attr('class', 'form-group has-error');
			$('#overlayHeightErrorMsg').html("${heightError}");
			$('#overlayHeightErrorMsg').show();
			height = NaN;
			ok=false;
		}
    }

    if (!isNaN(height) && !isNaN(width) && ((height+width)%2 != 0))
    {
		$('#overlayHeightCtrlGroup').attr('class', 'form-group has-error');
		$('#overlayHeightErrorMsg').html("${heightWidthSumError}");
		$('#overlayHeightErrorMsg').show();
   		ok=false;
    }
    
    var location = parseInt($('#xLocation').val());
	if(isNaN(location) || (location<0))
	{
		$('#xLocationCtrlGroup').attr('class', 'form-group has-error');
		$('#xLocationErrorMsg').html("${offsetError}");
		$('#xLocationErrorMsg').show();
		ok=false;
	}
    location = parseInt($('#yLocation').val());
	if(isNaN(location) || (location<0))
	{
		$('#yLocationCtrlGroup').attr('class', 'form-group has-error');
		$('#yLocationErrorMsg').html("${offsetError}");
		$('#yLocationErrorMsg').show();
		ok=false;
	}

	if(!ok)
	{
		$('#overlayImageDialogError').html("${overlayError}");
		$('#overlayImageDialogError').show();
		return;	
	}
	if(editIdx<0)
	{
		var newItem = new Object();
		newItem.orgIdx = tblIdxOverlay++;
		newItem.order = tblIdxOverlay;
		newItem.index= tblIdxOverlay;
		newItem.removed=false;
		newItem.overlayName=$("#overlayNameEdit").val();
		tblDataOverlay.push(newItem);
		editIdx=newItem.orgIdx;
	}
	tblDataOverlay[editIdx].imagePath=$("#imagePath").val();
	tblDataOverlay[editIdx].checkForUpdates = $('#checkForUpdates').prop('checked');

    if( $("input[name='widthRadio']:checked").val()=='pixels')
    {
    	tblDataOverlay[editIdx].width=parseInt("0"+$('#overlayWidth').val());
    }
    else 
    {
    	tblDataOverlay[editIdx].width="$"+"{ImageWidth}";    	
    }
    if( $("input[name='heightRadio']:checked").val()=='pixels')
    {
    	tblDataOverlay[editIdx].height=parseInt("0"+$('#overlayHeight').val());
    }
    else 
    {
    	tblDataOverlay[editIdx].height="$"+"{ImageHeight}";    	
    }
	tblDataOverlay[editIdx].opacity=parseInt("0"+$('#opacity').val());
	tblDataOverlay[editIdx].align=$("input[name='alignRadio']:checked").val();
	tblDataOverlay[editIdx].xLocation=parseInt($('#xLocation').val());
	tblDataOverlay[editIdx].yLocation=parseInt($('#yLocation').val());
    
	overlayEditClose();
	updateTableOverlay();
}
</script>