<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%@ taglib prefix="wmsutil" uri="/WEB-INF/tlds/wmsutil.tld" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>

<div id="deleteEncodeModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="deleteEncodeModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<form class="form-modal">
				<fieldset>
					  <div class="modal-header">
						<button type="button" class="close" onClick="javascript:deleteEncodeClose()">x</button>
						<h4 id="deleteEncodeModalLabel" class="modal-title"><wmsform:getlocalestring page="${page}" obj="deleteEncodeDialog.title"/></h4>
					  </div>
					  <div class="modal-body">
							<p class="breakall"><wmsform:getlocalestring page="${page}" obj="deleteEncodeDialog.message"/> <b><span id="deleteEncode"></span></b>?</p>
							<p class="text-warning"><wmsform:getlocalestring page="${page}" obj="deleteEncodeDialog.warning"/></p>
					  </div>
					  <div class="modal-footer">
						<wmsform:buttoncancel  onClick="javascript:deleteEncodeClose()"/>
						<wmsform:buttonok  onClick="javascript:doDeleteEncode()"/>
					  </div>
				</fieldset>
			</form>
		</div>
	</div>	
</div>

<script>

function deleteEncodeShow() {
	$('#deleteEncode').text(deleteEncode);
	$('#deleteEncodeModal').on("shown.bs.modal", function() {
	});
	$('#deleteEncodeModal').modal('show');	
}

function deleteEncodeClose() {
	$('#deleteEncodeModal').modal('hide');
}

function doDeleteEncode() {
	$('#deleteEncodeModal').on('hidden.bs.modal', function() {
		loadAjaxMainContent('server/transcodertemplate/delete_encode.htm','vhost=${wmsutil:urlEncode(vhost)}&appType=${appType}&appName=${wmsutil:urlEncode(appName)}&templateName=${wmsutil:urlEncode(templateName)}&encodeName='+encodeURIComponent(deleteEncode));
	});
	deleteEncodeClose();
	return;
}

</script>