<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>

<div id="addModuleModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="addModuleModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<form id="addModuleForm" class="form-modal"> 
				<fieldset>
				  <div class="modal-header">
					<button type="button" class="close" onClick="javascript:addModuleClose()">x</button>
					<h4 id="addModuleModalLabel" class="modal-title"><wmsform:getlocalestring page="newModule" obj="header"/></h4>
				  </div>
				  <div class="modal-body">
							<wmsform:editproperty page="newModule" obj="modName" cssClassTitle="control-label" required="yes" bind="false" cssClass="form-control"/>
							<wmsform:editproperty page="newModule" obj="modDescription" cssClassTitle="control-label" cssClass="form-control" required="yes" bind="false"/>
							<wmsform:editproperty page="newModule" obj="modClassName" cssClassTitle="control-label" cssClass="form-control" required="yes" bind="false"/>
				  </div>
				  <div class="modal-footer">
					<div class="row">
						<div class="col-md-8">
							<div id="newModule.error" class="alert alert-danger" style="display:none"></div>
						</div>
						<div class="col-md-4">
							<wmsform:buttoncancel  onClick="javascript:addModuleClose()"/>
							<wmsform:buttonadd  onClick="javascript:doaddModule()"/>
						</div>
					</div>
				  </div>
				</fieldset>
			</form>
		</div>
	</div>
</div>

<c:set var="ModNameError">
	<wmsform:getlocalestring page="newModule" obj="modName.empty"/>
</c:set>
<c:set var="ModDescriptionError">
	<wmsform:getlocalestring page="newModule" obj="modDescription.empty"/>
</c:set>
<c:set var="ModClassNameError">
	<wmsform:getlocalestring page="newModule" obj="modClassName.empty"/>
</c:set>
<script>
function addModuleShow() {
	$('#newModule.error').html(""); 
	$('#newModule.error').hide();
	$('#modName').val("");
	$('#modDescription').val("");
	$('#modClassName').val("");
	$('#modNameCtrlGroup').attr('class', 'form-group');
	$('#modNameErrorMsg').html("");
	$('#modNameErrorMsg').hide();
	$('#modDescriptionCtrlGroup').attr('class', 'form-group');
	$('#modDescriptionErrorMsg').html("");
	$('#modDescriptionErrorMsg').hide();
	$('#modClassNameCtrlGroup').attr('class', 'form-group');
	$('#modClassNameErrorMsg').html("");
	$('#modClassNameErrorMsg').hide();

	$('#addModuleModal').on("shown.bs.modal", function() {
	});
	$('#addModuleModal').modal('show');	
}

function addModuleClose() {
	$('#addModuleModal').modal('hide');
}

function doaddModule() {
	//need to check values
	var ok=true;
	$('#modNameCtrlGroup').attr('class', 'form-group');
	$('#modNameErrorMsg').html("");
	$('#modNameErrorMsg').hide();
	$('#modDescriptionCtrlGroup').attr('class', 'form-group');
	$('#modDescriptionErrorMsg').html("");
	$('#modDescriptionErrorMsg').hide();
	$('#modClassNameCtrlGroup').attr('class', 'form-group');
	$('#modClassNameErrorMsg').html("");
	$('#modClassNameErrorMsg').hide();
	
	if($('#modName').val() =="")
	{
		$('#modNameCtrlGroup').attr('class', 'form-group has-error');
		$('#modNameErrorMsg').html("${ModNameError}");
		$('#modNameErrorMsg').show();
		ok=false;
	}
	if($('#modDescription').val() =="")
	{
		$('#modDescriptionCtrlGroup').attr('class', 'form-group has-error');
		$('#modDescriptionErrorMsg').html("${ModDescriptionError}");
		$('#modDescriptionErrorMsg').show();
		ok=false;
	}
	if($('#modClassName').val() =="")
	{
		$('#modClassNameCtrlGroup').attr('class', 'form-group has-error');
		$('#modClassNameErrorMsg').html("${ModClassNameError}");
		$('#modClassNameErrorMsg').show();
		ok=false;
	}
	if(!ok)
	{
		return;	
	}
	var newItem = new Object();
	newItem.orgIdx = tblIdxModules++;
	newItem.order = tblIdxModules;
	newItem.removed=false;
	newItem.name=$('#modName').val();
	newItem.description=$('#modDescription').val();
	newItem.className=$('#modClassName').val();
	tblDataModules.push(newItem);
	addModuleClose();
	updateTableModules();
}

</script>