<h4>About Startup Streams</h4>
<p>Wowza Streaming Engine includes a system for re-streaming live streams called <em>MediaCaster</em>. The MediaCaster system is used for re-streaming IP camera streams (RTSP/RTP streams), SHOUTcast/Icecast streams, streams from native RTP or MPEG-TS encoders, and RTMP streams from other Wowza media servers. When the server starts, the MediaCaster system can pull streams from these sources automatically and make them available for streaming to all player technologies supported by the server. These streams must be identified in a <em>Startup Streams</em> list.</p>

<p>To add a startup stream, click <strong>Add Startup Stream</strong> and enter information about the stream in the <strong>Add to Startup Streams</strong> dialog box.</p>

<p>To delete a startup stream, click the <strong>Delete</strong> icon for the stream.</p>

<h5>Startup Stream Settings</h5>
<p>Provide the following information about the stream in the <strong>Add to Startup Streams</strong> dialog box:</p>
<ul>
	<li><strong>Stream Name</strong>. Enter the name of the live stream (for example, <strong>myStream</strong>) The stream name must be unique and can't contain less-than (&lt;), greater-than (&gt;), quotation (&#39; and &quot;), forward slash (&#47;), backslash (&#92;), pipe (&#124;), question mark (&#63;), double-dot (..), and tilde (&#126;) characters.

	<li><strong>Application Name</strong>. Select the name of a live application that's configured in the Wowza Streaming Engine server. This application will be used to stream the startup stream.

	<li><strong>Application Instance</strong>. Select the default application instance (<strong>_definst_</strong>) or specify an alternate application instance to use for re-streaming. The application instance is created if it doesn't exist.

	<li><strong>MediaCaster Type</strong>. Select the MediaCaster type in the list that corresponds to the stream type:<br /><br />
	<p>Select <strong>rtp</strong> for IP camera streams (RTSP/RTP streams) and for streams from native RTP and MPEG-TS encoders.</p>

	<p>Select <strong>shoutcast</strong> for SHOUTcast/Icecast streams.</p>

	<p>Select <strong>liverepeater</strong> if the stream is an RTMP stream pulled from another Wowza media server.</p>

	<p>Select <strong>applehls</strong> for Apple HLS streams pulled from a live source.</p>

	<p>Select <strong>mpegtstcp</strong> for MPEG-TS streams pulled from a live source over TCP.</p>

	<p>Select <strong>srt</strong> to accept SRT connections.</p>

</ul>

<blockquote><strong>Note:</strong> The <strong>rtp-record</strong> and <strong>shoutcast-record</strong> MediaCaster types are used for re-streaming but also record the stream to a single file in the application's streaming file directory. If the source starts and stops, the file is versioned with a version number and a new file is started. You can control the container format used (MP4 or FLV) by specifying a stream name prefix in the source. If you specify the <strong>mp4:</strong> prefix, the stream is recorded to an MP4 (QuickTime) container. An MP4 container can only record H.264, AAC, and MP3 media data. If you specify the <strong>flv:</strong> prefix, the stream is recorded to an FLV container. The FLV container is the only option if you're recording with Flash Player. To apply advanced recording capabilities to these streams, you can use the <strong>Incoming Streams</strong> feature in Wowza Streaming Engine instead.</blockquote>