<h4>About SMIL Files</h4>
<p>Synchronized Multimedia Integration Language (SMIL) files organize streams of various bitrates into groups for HTTP adaptive bitrate streaming. A player selects a stream in the group that's best-suited to its available bandwidth and processor power. If conditions change, the player can switch to a different stream in the group that's better-suited to the current conditions.</p>

<p>Streams that are grouped together in SMIL files must have aligned key frames for adaptive bitrate switching to work correctly. This is done by encoding multiple bitrate streams from the same source with identical key frame intervals and frame rates. Sources for adaptive bitrate streams can include transcoded or transrated live streams created by Wowza Transcoder, live streams published by a live source, and pre-encoded video on demand (VOD) files created by an encoder.</p>

<blockquote><strong>Note:</strong> Adaptive bitrate streaming is supported by the <strong>MPEG-DASH</strong>, <strong>Apple HLS</strong>, <strong>Adobe HDS</strong>, and <strong>Microsoft Smooth Streaming</strong> HTTP streaming protocols. You must enable one or more of these <strong>Playback Types</strong> on the application's <strong>Setup</strong> tab to deliver streams that are referenced in SMIL files.</blockquote>

<h5>Adding and Removing SMIL Files</h5>
<p>To add a SMIL file, click <strong>Add SMIL File</strong>. In the <strong>Add SMIL File</strong> dialog box, enter a file name for the new SMIL file in the <strong>SMIL File Name</strong> field. The name value can't contain less-than (&lt;), greater-than (&gt;), colon (&#58;), quotation (&#39; and &quot;), forward slash (&#47;), backslash (&#92;), pipe (&#124;), question mark (&#63;), asterisk (&#42;), double-dot (..), and tilde (&#126;) characters. In the <strong>Title</strong> field, you can add an optional <strong>title</strong> attribute to the &lt;smil&gt; tag in the SMIL file.</p>

<p>You can also add a SMIL file by copying an existing SMIL file and adjusting its settings. To copy an existing SMIL file for further modification, click <strong>Copy SMIL File</strong>. In the <strong>Copy SMIL File</strong> dialog box, select the SMIL file to copy and specify a new file name for the copied file.</p>

<p>After you add a SMIL file to the system, click <strong>Add SMIL Stream</strong> to add a reference to one of the adaptive bitrate streams in your streaming presentation to the SMIL file. You should add a reference for each of the adaptive bitrate streams that are part of the streaming presentation.</p>

<p>To delete a SMIL file, click the <strong>Delete</strong> icon for the SMIL file.</p>

<h5>Editing SMIL Files</h5>
<p>To add or remove streams referenced in a SMIL file, or to change the tag attributes for a stream referenced in a SMIL file, click the SMIL file name in the list.</p>

<p>To change SMIL file properties, such as the <strong>title</strong> attribute value or the order in which the streams are listed, click the <strong>Edit</strong> icon for the SMIL file.</p>
<blockquote><strong>Note:</strong> Players evaluate streams in the order that they're referenced in the &lt;switch&gt; container and select the first stream that's suitable for playback under current conditions. You should arrange the streams in a desirable order. For example, to ensure that a player selects and plays the highest bitrate stream that it can, given current network conditions and its available CPU resources, arrange the streams from the highest to lowest bitrate. If you plan to stream to a variety of players where network conditions may vary, you can help to ensure that most players can play a stream by arranging the streams from the lowest to highest bitrate. Use the <strong>Move Up</strong> and <strong>Move Down</strong> icons to arrange the streams in the desired order.</blockquote>

<h5>Adding SMIL Files to Startup Streams</h5>
<p>Live streams referenced in a SMIL file can be started automatically when Wowza Streaming Engine starts so that they're immediately available for streaming to all player technologies supported by the server. To add the SMIL file to the list of streams that are started automatically, click the <strong>Add to Startup Streams</strong> icon for the SMIL file. For instructions about how to configure startup streams, go to the <a href="javascript:lastServerMC='vhostStartupStreams';loadAjaxSideBar('SB_Server.html','')">Startup Streams page</a>.</p>

<h5>Re-streaming SMIL File Streams</h5>
<p>Wowza Streaming Engine includes a system for re-streaming live streams called <em>MediaCaster</em>. The MediaCaster system is used for re-streaming IP camera streams (RTSP/RTP streams), SHOUTcast/Icecast streams, streams from native RTP or MPEG-TS encoders, and RTMP streams from other Wowza media servers. The MediaCaster system can pull the streams that are referenced in a SMIL file and make them available for streaming to all player technologies supported by the server.</p>

<p>The MediaCaster system works on-demand. When the first request is received from a player for the SMIL file, a source stream referenced in the SMIL file is made available to the player. When the last player stops viewing a stream, the MediaCaster system waits for a timeout period. If no other players request the SMIL file, all streams are stopped and aren't available for streaming until another request is made.</p>

<p>To enable re-streaming of streams that are referenced in a SMIL file, click the <strong>Connect</strong> icon for the SMIL file and configure the following options in the <strong>Connect a SMIL File</strong> dialog box:</p>
<ul>
	<li><strong>Application Name</strong>. Select the name of a live application that's configured in the Wowza Streaming Engine server.

	<li><strong>Application Instance</strong>. Select the default application instance (<strong>_definst_</strong>) or specify an alternate application instance to use for re-streaming. The application instance is created if it doesn't exist.

	<li><strong>MediaCaster Type</strong>. Select the MediaCaster type in the list that corresponds to the stream type:<br /><br />
	<p>Select <strong>rtp</strong> for IP camera streams (RTSP/RTP streams) and for streams from native RTP and MPEG-TS encoders.</p>

	<p>Select <strong>shoutcast</strong> for SHOUTcast/Icecast streams.</p>

	<p>Select <strong>liverepeater</strong> if the stream is an RTMP stream pulled from another Wowza media server.</p>

	<p>Select <strong>applehls</strong> for Apple HLS streams pulled from a live source.</p>

	<p>Select <strong>mpegtstcp</strong> for MPEG-TS streams pulled from a live source over TCP.</p>

	<p>Select <strong>srt</strong> to accept SRT connections.</p>

</ul>

<blockquote><strong>Note:</strong> The <strong>rtp-record</strong> and <strong>shoutcast-record</strong> MediaCaster types are used for re-streaming but also record the stream to a single file in the application's streaming file directory. If the source starts and stops, the file is versioned with a version number and a new file is started. You can control the container format used (MP4 or FLV) by specifying a stream name prefix in the source. If you specify the <strong>mp4:</strong> prefix, the stream is recorded to an MP4 (QuickTime) container. An MP4 container can only record H.264, AAC, and MP3 media data. If you specify the <strong>flv:</strong> prefix, the stream is recorded to an FLV container. The FLV container is the only option if you're recording with Flash Player. To apply advanced recording capabilities to these streams, you can use the <strong>Incoming Streams</strong> feature in Wowza Streaming Engine instead.</blockquote>