<%@ include file="/WEB-INF/jsp/taglibs.jsp" %>

<div>
	<div class="row">
		<wmsform:pageerror/>
		<wmsform:pagewarning/>
		<wmsform:pageinformation/>
	</div>
	<div class="row">
        <div class="col-md-7">
      		<happ><wmsform:getlocalestring page="servervhostsetup" obj="header"/></happ><br>
	      	<small class="text-muted">${wmsutil:escapeHtml(vhost)}</small>
        </div>
        <div class="col-md-5 appbuttons" id="VhostButtons">
                <wmsform:buttonrestart onClick="javascript:restartVHostShow()"/>
                <c:choose>
                <c:when test="${running}">
                    <wmsform:buttonstop  onClick="javascript:stopVHostShow()"/> 
                </c:when>
                <c:otherwise>
                    <wmsform:buttonstart  onClick="javascript:startVHostShow()" /> 
                </c:otherwise>
                </c:choose>
	    </div>
	</div>
	<sec:authorize access="hasAnyRole('advUser')">
	    <div class="row">
			<div class="col-md-12">
				<p></p>
				<ul class="nav nav-tabs" >
					<li id="VhostBasic" class="active">
						<a href="javascript:showBasicTab()">Basic</a>
					</li>
					<li id="VhostAdvanced" >
						<a href="javascript:showAdvTab()">Properties</a>
					</li>
				</ul>
			</div>
		</div>
	</sec:authorize>
	<sec:authorize access="!hasAnyRole('advUser')">
		<hr>
	</sec:authorize>
	<div class="row" id="tabContent">
		<div class="col-md-12">
	      	<div class="row">
				<div id="ViewMode">
					<div  id="TabBasic">
						<jsp:include page="ViewBasic.jsp" flush="true" />
					</div>
					<div id="TabAdv" style="display:none">
						<jsp:include page="ViewAdv.jsp" flush="true" />
				 	</div>
				 </div>
				 <div id="EditMode">
					<div  id="TabEditBasic">
                       	<div id="BasicEditColumn" class="col-md-8 main-content">
                               <form:form method="post" commandName="formData" id="defaultForm"> 
                                   <wmsform:errors path="errorMessage" cssClass="alert alert-danger"/>
									   <wmsform:rightrailhideshow/>
                                   <form:hidden path="ignoreWarnings" />
                                   <jsp:include page="EditBasic.jsp" flush="true" />
                               </form:form>
						</div>
                        <div id="HelpBasicEdit" class="col-md-4 well-help pull-right right-rail">
                            <jsp:include page="HelpBasic_${formData.currentLocale}.jsp" flush="true" />
                        </div>
					</div>
					<div id="TabEditAdv" style="display:none">
                       	<div class="col-md-12">
                               <form:form method="post" commandName="formDataAdv" id="defaultFormAdv"> 
                                   <wmsform:errors path="errorMessage" cssClass="alert alert-danger"/>
		                            <jsp:include page="EditAdv.jsp" flush="true" />
                                   <form:hidden path="ignoreWarnings" />	
                               </form:form>
                           </div>
					</div>
                    <div id="TabEditStatus" style="display:none">
                        <div class="col-md-12">
                        </div>
                    </div>
			 	</div>
			</div>
		</div>
	</div>
   	<wmsform:setwarnings/>	
   	<wmsdialog:stopvhost page="vhostsetup" vhost="${vhost}"/>
   	<wmsdialog:startvhost page="vhostsetup" vhost="${vhost}"/>
   	<wmsdialog:restartvhost page="vhostsetup" returnPage="vhostsetup" vhost="${vhost}"/>
</div>

<script>
$(document).ready(function() {
	
	if(typeof(lastTab) === 'undefined') {
		lastTab="Basic";
	}
		
	if("${mode}"=="edit")
	{
		$('#ViewMode').hide();	
		$('#EditMode').show();
		$('#VhostButtons').hide();				
	}
	else 
	{
		$('#ViewMode').show();		
		$('#EditMode').hide();		
		$('#VhostButtons').show();				
	}
	if(lastTab=="Advanced")
	{
		showAdvTab();
	}
	else 
	{
		showBasicTab();
	}
});

function showBasicTab() {
	if("${mode}"=="edit" && lastTab!='Basic')
	{
		lastTab='Basic';
		loadVhostSetup();
		return;
	}
	lastTab='Basic';
	createCookie("lastTab",lastTab);
	$('#TabBasic').show();
	$('#TabEditBasic').show();
	$('#TabAdv').hide();
	$('#TabEditAdv').hide();
	$('#TabStatus').hide();
	$('#TabEditStatus').hide();
	$('#VhostBasic').addClass('active');
	$('#VhostAdvanced').removeClass();
	$('#VhostStatus').removeClass();
}

function showAdvTab() {
	if("${mode}"=="edit" && lastTab!='Advanced')
	{
		lastTab='Advanced';
		loadVhostSetup();
		return;
	}
	lastTab='Advanced';
	createCookie("lastTab",lastTab);
	$('#TabBasic').hide();
	$('#TabEditBasic').hide();
	$('#TabAdv').show();
	$('#TabEditAdv').show();
	$('#TabStatus').hide();
	$('#TabEditStatus').hide();
	$('#VhostBasic').removeClass();
	$('#VhostAdvanced').addClass('active');	
	$('#VhostStatus').removeClass();
}

</script>
<script type="text/javascript">
    $(function () {
        $("[data-toggle='tooltip']").tooltip();
    });
</script>

