<%@ include file="/WEB-INF/jsp/taglibs.jsp" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<wmsform:setpagetitle page="vhostPerformance.threadPoolSizes"/>

<div>
	<div class="row">
		<!--wmsform:pageerror/-->
		<wmsform:pagewarning/>
		<wmsform:pageinformation/>
	</div>
	<div class="row">
		<div class="col-md-12">
			<happ><wmsform:getlocalestring page="serverPerformance.virtualHostThreadPools" obj="header"/></happ>
			<br><small class="text-muted">${wmsutil:escapeHtml(vhost)}</small>
		</div>
	</div>
	<div>
		<hr>
	</div>
	<div class="row">
		<div class="col-md-12">
			<div id="ViewMode" class="row">
				<jsp:include page="ViewBasic.jsp" flush="true" />
			</div>
			<div id="EditMode" class="row">
				<div class="col-md-8 main-content">
					<form:form method="post" commandName="formData" id="defaultForm">
						<wmsform:errors path="errorMessage" cssClass="alert alert-danger" />
						<wmsform:rightrailhideshow/>
						<jsp:include page="EditBasic.jsp" flush="true" />
						<form:hidden path="ignoreWarnings" />
					</form:form>
				</div>
				<div id="HelpStores" class="col-md-4 right-rail well-help pull-right">
					<jsp:include page="HelpBasic_${formData.currentLocale}.jsp" flush="true" />
				</div>
			</div>
		</div>
	</div>
	<wmsform:setwarnings/>
	<wmsdialog:restartvhost page="vhostsetup" returnPage="vhostPerformance.threadPoolSizes" vhost="${vhost}"/>
</div>

<script>
$(document).ready(function() {
	
	if("${mode}"=="edit")
	{
		$('#ViewMode').hide();
		$('#EditMode').show();
	}
	else 
	{
		$('#ViewMode').show();
		$('#EditMode').hide();
	}
});
</script>













