<%@ include file="/WEB-INF/jsp/taglibs.jsp" %>

<h4>About Java Settings</h4>
<p>The Java heap is an area in memory where objects created in a Java class reside during program execution. When an executing program has finished using an object, a Java garbage collector reclaims the memory in the Java heap that was used by the object. Wowza Streaming Engine includes several garbage collection (GC) options. For more information, see <a href="https://www.wowza.com/docs/how-to-do-performance-tuning#tune_java" target="_blank"><i class="fa fa-external-link"></i>&nbsp;Tune Java settings</a>.</p>

<blockquote><strong>Note:</strong> By default, the server uses the <strong>Development level</strong> Java heap size option, which is suitable for application development environments but should be changed if you deploy the server in production environments where it may use memory extensively when heavily loaded. An inadequate Java heap size setting may cause the server to fail with an "OutOfMemory" Java exception.</blockquote>

<h5>Java Heap Size</h5>
<ul>
	<li><strong>Development level</strong>. Sets the heap size to a predefined value that's appropriate for application development environments. This heap size setting is lower than recommended for media servers in high-volume production environments, which typically are heavily loaded.
	<li><strong>Production level</strong>. Sets the heap size to a predefined value that's appropriate for production use.
	<li><strong>Custom level</strong>. Enter a custom heap size value between <strong>512</strong> and <strong>10240</strong> megabytes (MB).
</ul>

<h5>Java Garbage Collection (GC) Settings</h5>
<ul>
	<li><strong>Concurrent collector</strong>. Uses a Java garbage collector that's designed for applications that prefer shorter GC pauses and that can share processor resources with the garbage collector while the application is running.
	<li><strong>G1 (Garbage-First) collector (recommended)</strong>. Uses a Java garbage collector that's designed for low pause time, high-throughput applications. The G1 collector is a server-style garbage collector, targeted for multi-processor machines with large memories and is fully supported in Oracle JDK&nbsp;7 Update&nbsp;4 and later releases.
	<li><strong>Custom collector settings</strong>. Enter a custom value to tune GC performance.
</ul>