<%@ include file="/WEB-INF/jsp/taglibs.jsp"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>

<wmsform:setpagetitle page="appconfig.monitoring" appName="${appName}"/>

<link href="css/wowza-charts.css" rel="stylesheet">

<div class="row hidden-sm">
	<div class="row">
		<wmsform:pageerror/>
		<wmsform:pagewarning/>
		<wmsform:pageinformation/>
	</div>
	<div class="col-md-5">
		<happ>${wmsutil:escapeHtml(appName)} <wmsform:getlocalestring page="appconfig.monitoring" obj="head"/></happ>
		<br /><small class="text-muted"><wmsform:getlocalestring page="common" obj="LocalBrowserTime"></wmsform:getlocalestring></small>
	</div>
	<wmsform:applicationbuttons page="monitoring"/>
</div>
<div style="margin-top:-10px">
<hr>
</div>
<c:choose>
<c:when test="${statsEnabled==false}">
	<div class="row">
		<div class="alert alert-warning">
			<h4><wmsform:getlocalestring page="common" obj="MonitoringDisabled"/></h4>
			<wmsform:getlocalestring page="common" obj="MonitoringDisabledExtended"></wmsform:getlocalestring>
		</div>
	</div>
</c:when>
<c:when test="${error!=null}">
	<div class="row">
		<div class="alert alert-warning">
			<h4><wmsform:getlocalestring page="common" obj="MonitoringDisabled"/></h4>
			${error}
		</div>
	</div>
</c:when>
<c:otherwise>
<div>
	<div id="app-monitoring-now">
		<c:if test="${app!=null}">
			<div class="row">
				<div class="col-md-6">
					<h4><wmsform:getlocalestring page="appconfig.monitoring" obj="connections" /> <small><wmsform:getlocalestring page="appconfig.monitoring" obj="connections.sub" /></small></h4>
					<div class="row">
						<div class="col-md-6">
							<table class="table table-condensed table-hover">
								<tr>
									<td><strong><strong><wmsform:getlocalestring page="common" obj="total" /></strong></td>
									<td><strong><span class="app-connection-count pull-right" id="app-total-connections">${app.totalConnections}</span></strong></td>
								</tr>
								<tr>
									<td><wmsform:getlocalestring page="common" obj="adobeHDS" /></td>
									<td><span class="app-connection-count pull-right" id="app-sanjose-connections">${app.connectionCount.SANJOSE}</span></td>
								</tr>
								<tr>
									<td><wmsform:getlocalestring page="common" obj="adobeRTMP" /></td>
									<td><span class="app-connection-count pull-right" id="app-rtmp-connections">${app.connectionCount.RTMP}</span></td>
								</tr>
								<tr>
									<td><wmsform:getlocalestring page="common" obj="appleHLS" /></td>
									<td><span class="app-connection-count pull-right" id="app-cupertino-connections">${app.connectionCount.CUPERTINO}</span></td>
								</tr>
								<tr>
									<td><wmsform:getlocalestring page="common" obj="microsoftSmooth" /></td>
									<td><span class="app-connection-count" id="app-smooth-connections">${app.connectionCount.SMOOTH}</span></td>
								</tr>
								<tr>
									<td><wmsform:getlocalestring page="common" obj="mpegDash" /></td>
									<td><span class="app-connection-count" id="app-dash-connections">${app.connectionCount.MPEGDASH}</span></td>
								</tr>
								<tr>
									 <td><wmsform:getlocalestring page="common" obj="rtspRtp" /></td>
									 <td><span class="app-connection-count" id="app-rtp-connections">${app.connectionCount.RTP}</span></td>
								 </tr>
							 </table>
						</div>
						<div class="col-md-6">
							<div id="piecharts" style="height: 180px;margin-top:40px;" class="wowza-pie-charts"></div>
						</div>
					</div>
				</div>
				<div class="col-md-6">
					<h4><wmsform:getlocalestring page="appconfig.monitoring" obj="applicationUptime" /></h4>
					<div id="uptime-time-up-label"><p><strong>${wmsutil:escapeHtml(appName)}</strong><wmsform:getlocalestring page="appconfig.monitoring" obj="applicationUptime.date" /><span id="uptime-time"></span></p></div>
					<div id="uptime-time-down-label"><p><strong>${wmsutil:escapeHtml(appName)}</strong><wmsform:getlocalestring page="appconfig.monitoring" obj="applicationUptime.down" /></span></p></div>
					<div id="uptime-pretty-up-label"><p><strong>${wmsutil:escapeHtml(appName)}</strong><wmsform:getlocalestring page="appconfig.monitoring" obj="applicationUptime.uptime" /><span id="uptime-pretty"></span></p></div>
					<div id="uptime-pretty-down-label"><p><strong>${wmsutil:escapeHtml(appName)}</strong><wmsform:getlocalestring page="appconfig.monitoring" obj="applicationUptime.down" /></p></div>
					<h4><wmsform:getlocalestring page="appconfig.monitoring" obj="networkTroughput" /></h4>
					<p><strong><wmsform:getlocalestring page="common" obj="bytesIn" /></strong> <span id="bytes-in">${app.bytesIn}</span>
					&nbsp;@&nbsp;
					<span id="bytes-in-rate" style="display: inline;">${app.bytesInRate}</span></p>
					<p><strong><wmsform:getlocalestring page="common" obj="bytesOut" /></strong> <span id="bytes-out">${app.bytesOut}</span>
					&nbsp;@&nbsp;
					<span id="bytes-out-rate" style="display: inline;">${app.bytesOutRate}</span></p>
				</div>
			</div>
			<hr />
		</c:if>
		<c:if test="${app==null}">
			<h3><wmsform:getlocalestring page="appconfig.monitoring" obj="noData"/></h3>
		</c:if>
		<div id="noData" class="alert alert-warning" style="display: none;">
			<h3><wmsform:getlocalestring page="appconfig.monitoring" obj="noData"/></h3>
		</div>
	</div>
	<div id="series-charts" class="wowza-series-chart row" style="margin-left:-15px"></div>
</div>

<script language="javascript">
$(document).ready(function() {

	if(isNaN(${app.uptime})||${app.uptime}==0) {
		$("#uptime-pretty").html("not running");
		$("#uptime-time").html("not running");
		$("#uptime-time-up-label").hide();
		$("#uptime-pretty-up-label").hide();
		$("#uptime-time-down-label").show();
		$("#uptime-pretty-down-label").show();
	} else {
		$("#uptime-time-down-label").hide();
		$("#uptime-pretty-down-label").hide();
		$("#uptime-time-up-label").show();
		$("#uptime-pretty-up-label").show();
		WOWZA.Util.setUptimeSeconds(${app.uptime}*1000, "#uptime-pretty", "#uptime-time",false);
	}
 	var pieData = {
		connections:{label: "",
			data: [
			 {label:"HDS", data: ${app.connectionCount.SANJOSE}},
			 {label:"RTMP", data: ${app.connectionCount.RTMP}},
			 {label:"HLS", data: ${app.connectionCount.CUPERTINO}},
			 {label:"DASH", data: ${app.connectionCount.MPEGDASH}},
			 {label:"Smooth", data: ${app.connectionCount.SMOOTH}},
			 {label:"RTSP/RTP", data: ${app.connectionCount.RTP}}
			 ]
		}
	};
	var pies = WOWZA.Charts.Pie("piecharts", pieData,{legend: {
		show: false
	},
	colors: WOWZA.Util.FlotColors, classes:"col-md-12"});
	var updateFn = function() {
		this.charts = pies;
		this.id = updateIntervalId;
		updateCharts(charts);
	}
	var updateIntervalId = setInterval(updateFn, 5000);
	pies.id = updateIntervalId;
	$(document).on("preContentNavigation", function(e) {
		clearInterval(updateIntervalId);
		$(document).off("preContentNavigation", arguments.callee);
	});
	$("#bytes-in-rate").html(WOWZA.Util.HumanReadableBits(${app.bytesInRate}*8, 'bits/s'));
	$("#bytes-out-rate").html(WOWZA.Util.HumanReadableBits(${app.bytesOutRate}*8, 'bits/s'));
	showPastStatistics();
});
function showPastStatistics() {
	window.setTimeout(function() {
		var seriesData = ${series};
		var charts = WOWZA.Charts.Series("series-charts", seriesData, {
			baseUrl: "applications/monitoring/historical.jsdata",
			vhost: "${vhost}",
			appName: "${appName}",
			resize: true,
			legend:{
				show: true
			},
			grid: {
				hoverable: true,
				clickable: true,
				borderWidth: 1,
				backgroundColor: '#f5f5f5'
			},
			xaxis: {
				mode: "time",
				timezone: "browser",
				twelveHourClock:true
			},
			series: {
				points: {
					radius: 3,
					show: false
				}
			},
			colors: WOWZA.Util.FlotColors
		});
		if(seriesData.data["connections"]) {
			charts.series.controls["connections"].defaultTimePicker.selector.trigger('change');
			charts.series.controls["network"].defaultTimePicker.selector.trigger('change');
		} else {
			$("#noData").fadeIn(1000);
		}
	},100);

};

function updateCharts(context) {
 	$.ajax({
		url: 'applications/monitoring/app.jsdata?vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}',
		cache: false
	}).fail(function(jqXHR, textStatus) {
		alert("Request failed: "+textStatus);
		clearInterval(context.id);
	}).done( function(newData) {
		if (!(newData instanceof Object) && newData.substring(0, 6) == "Error:") {
			$('#mainContent').html(newData);
			return;
		} else if (!(newData instanceof Object) && newData.substring(0, redirectLoginString.length) == redirectLoginString) {
			document.location = "login.htm" + location.hash;
			return;
		}
		var app = newData.appStats;
		if(isNaN(app.uptime)||app.uptime==0) {
			$("#uptime-pretty").html("not running");
			$("#uptime-time").html("not running");
			$("#uptime-time-up-label").hide();
			$("#uptime-pretty-up-label").hide();
			$("#uptime-time-down-label").show();
			$("#uptime-pretty-down-label").show();
		} else {
			$("#uptime-time-down-label").hide();
			$("#uptime-pretty-down-label").hide();
			$("#uptime-time-up-label").show();
			$("#uptime-pretty-up-label").show();
			WOWZA.Util.setUptimeSeconds(app.uptime*1000, "#uptime-pretty", "#uptime-time",false);
		}
		$("#bytes-in").html(app.bytesIn);
		$("#bytes-in-rate").html(WOWZA.Util.HumanReadableBits(app.bytesInRate*8, 'bits/s'));
		$("#bytes-out").html(app.bytesOut);
		$("#bytes-out-rate").html(WOWZA.Util.HumanReadableBits(app.bytesOutRate*8, 'bits/s'));

		$("#app-total-connections").html(app.totalConnections);
		$("#app-sanjose-connections").html(app.connectionCount.SANJOSE);
		$("#app-rtmp-connections").html(app.connectionCount.RTMP);
		$("#app-cupertino-connections").html(app.connectionCount.CUPERTINO);
		$("#app-dash-connections").html(app.connectionCount.MPEGDASH);
		$("#app-smooth-connections").html(app.connectionCount.SMOOTH);
		$("#app-rtp-connections").html(app.connectionCount.RTP);

		context.plots.connections.setData([
				 {label:"HDS", data: app.connectionCount.SANJOSE, color: WOWZA.Util.ProtocolColorMap['HDS']},
				 {label:"RTMP", data: app.connectionCount.RTMP, color: WOWZA.Util.ProtocolColorMap['RTMP']},
				 {label:"HLS", data: app.connectionCount.CUPERTINO, color: WOWZA.Util.ProtocolColorMap['HLS']},
				 {label:"DASH", data: app.connectionCount.MPEGDASH, color: WOWZA.Util.ProtocolColorMap['DASH']},
				 {label:"Smooth", data: app.connectionCount.SMOOTH, color: WOWZA.Util.ProtocolColorMap['Smooth']},
				 {label:"RTSP/RTP", data: app.connectionCount.RTP, color: WOWZA.Util.ProtocolColorMap['RTSP/RTP']}
				 ]);
		context.plots.connections.draw();
	});
};
</script>
</c:otherwise>
</c:choose>
