<%@ include file="/WEB-INF/jsp/taglibs.jsp" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>

<c:set var="queryParam">
	appName=${wmsutil:urlEncode(appName)}&vhost=${wmsutil:urlEncode(vhost)}
</c:set>
<wmsform:setpagetitle page="appconfig.transcoder" appName="${appName}"/>

<c:set var="licensed" value="${requestScope.formData['licensed']}"/>

<div class="col-md-8 main-content">
	<wmsform:rightrailhideshow/>
	<c:choose>
		<c:when test="${!licensed}">
			<p><wmsform:getlocalestring page="transcoder.unlicensed" obj="header"/></p>
		</c:when>
		<c:otherwise>
			<p><wmsform:getlocalestring page="appconfig.transcoder" obj="header"/></p>
		    <div id="view.transcoder.generic.warnings" class="alert alert-warning" style="display:none"></div>
			<c:choose>
				<c:when test="${not transcoderEnabled}">
					<script>
				    	appTranID="appName=" + getGoodJqueryID("${appName}") + ":transcoder:enabled";
				    	$('[id="'+appTranID+'"]').hide();
				    </script>
					<label class="control-label"><wmsform:getlocalestring page="appconfig.transcoder" obj="disabledMessage"/></label>
		            <sec:authorize access="hasAnyRole('admin')">
		               	<p><wmsform:buttonedit onClick="javascript:loadAjaxMainContent('applications/${appType}/transcoder/edit.htm','${queryParam}')"/> 
		            	<wmsform:button page="appconfig.transcoder" obj="enableTranscoderBtn" onClick="javascript:loadAjaxMainContent('applications/${appType}/transcoder/enableTranscoder.htm','vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}')" cssClass="btn btn-default"/></p>
					</sec:authorize>
				</c:when>
				<c:otherwise>
					<script>
				    	appTranID="appName=" + getGoodJqueryID("${appName}") + ":transcoder:enabled";
				    	$('[id="'+appTranID+'"]').show();
				    </script>
					<label class="control-label"><wmsform:getlocalestring page="appconfig.transcoder" obj="enabledMessage"/></label>
					<sec:authorize access="hasAnyRole('admin')">
						  <p><wmsform:buttonedit onClick="javascript:loadAjaxMainContent('applications/${appType}/transcoder/edit.htm','${queryParam}')"/> 
		         		  <wmsform:button page="appconfig.transcoder" obj="disableTranscoderBtn" onClick="javascript:loadAjaxMainContent('applications/${appType}/transcoder/disableTranscoder.htm','vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}')" cssClass="btn btn-default"/></p>
		            </sec:authorize>
				</c:otherwise>
			</c:choose>
		    <wmsform:viewproperty page="appconfig.transcoder" obj="transcoderTemplateDir"/>
			<label class="control-label"><wmsform:getlocalestring page="appconfig.transcoder" obj="transcoder"/></label>
		    <wmsform:viewpropertycheckbox page="appconfig.transcoder" obj="matchTemplate"/>
		    <wmsform:viewproperty page="appconfig.transcoder" obj="fallbackTemplate" showEmptyString="-Not Set-"/>
			<hr />
	    
			<h4><wmsform:getlocalestring page="transcoder" obj="tableTitle"/></h4>
			<sec:authorize access="hasAnyRole('admin')">
				<p>
					<c:if test="${fn:length(requestScope.formData['templates'])>0}">
						<wmsform:buttonprimary page= "transcoder" obj="copyTemplate" onClick="javascript:copyTranscoderTemplateShow();" icon="fa fa-files-o"/>
					</c:if>
					<wmsform:button page= "transcoder" obj="addTemplate" onClick="javascript:addTranscoderTemplateShow();" icon="fa fa-plus"/>
				</p>
			</sec:authorize>
			<wmstable:viewtranscodertemplates page="transcoder" readonly='false'/>
	   </c:otherwise>
	</c:choose>
</div>
<div id="HelpBasic" class="col-md-4 right-rail well-help pull-right">
    <jsp:include page="HelpBasic_${formData.currentLocale}.jsp" flush="true" />
</div>

<wmsdialog:addtranscodertemplate page="transcoder"/>
<wmsdialog:copytranscodertemplate page="transcoder"/>

<script>
$(document).ready(function() {
	if("${licensed}"=="false" && "${mode}"!="edit")
	{
		lastTab="Basic";
		$('#AppAdvanced').hide();
	}
});
</script>


