<%@ include file="/WEB-INF/jsp/taglibs.jsp" %>
<c:set var="queryParam">
		appName=${wmsutil:urlEncode(appName)}&vhost=${wmsutil:urlEncode(vhost)}
</c:set>
<wmsform:setpagetitle page="appconfig.securityplayback" appName="${appName}"/>

<c:set var="sharedSecret" value="${requestScope.formData['sharedSecret']}"/>
<c:set var="secureTokenState" value="${requestScope.formData['secureTokenState']}"/>

<c:set var="version2">
	<wmsform:getlocalestring page="appconfig.securityplayback" obj="secureTokenStateOption.version2"/>
</c:set>
<c:set var="disabled">
	<wmsform:getlocalestring page="appconfig.securityplayback" obj="secureTokenStateOption.disabled"/>
</c:set>

<div class="col-md-8 main-content">
	<wmsform:rightrailhideshow/>
	<p><wmsform:getlocalestring page="appconfig.securityplayback" obj="header"/></p>
    <p><wmsform:buttonedit onClick="javascript:loadAjaxMainContent('applications/${appType}/securityplayback/edit.htm','${queryParam}')"/></p>
    
	<c:if test="${appType =='live' or appType=='liveedge' or appType=='livehttporigin'}">
		<label class="control-label"><wmsform:getlocalestring page="appconfig" obj="options"/></label>
		<wmsform:viewpropertycheckbox page="appconfig.securityplayback" obj="requireSecureRTMPConnection"/>
	</c:if>

	<label class="${cssClassTitle}">
		<wmsform:getlocalestring page="appconfig.securityplayback" obj="secureTokenState"/>
	</label>
		<wmsform:viewproperty page="appconfig.securityplayback" obj="secureTokenStatus" showTitle="false"/>
	
	<c:if test="${secureTokenState != disabled}">
		<wmsform:viewproperty page="appconfig.securityplayback" obj="sharedSecret"/>
		<c:if test="${secureTokenState == version2}">
			<wmsform:viewproperty page="appconfig.securityplayback" obj="hashAlgorithm"/>
			<wmsform:viewpropertycheckbox page="appconfig.securityplayback" obj="useTEAForRTMP"/> 
			<wmsform:viewpropertycheckbox page="appconfig.securityplayback" obj="useClientIPInHash"/> 
			<wmsform:viewproperty page="appconfig.securityplayback" obj="queryParameterPrefix"/>
		</c:if>
	</c:if>		
	
   	<c:set var="ipPrefix">
   		<wmsform:objvalue page="appconfig.securityplayback" obj="restrictedPlaybackIpPrefix"/>
   	</c:set> 
  	<wmsform:viewproperty page="appconfig.securityplayback" obj="restrictedPlaybackIpList" showEmptyString="Not enabled" prefix="${ipPrefix}"/>

</div>
<div id="HelpBasic" class="col-md-4 right-rail well-help pull-right">
    <jsp:include page="HelpBasic_${formData.currentLocale}.jsp" flush="true" />
</div>
