<%@ include file="/WEB-INF/jsp/taglibs.jsp" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>

<c:set var="queryParam">
	appName=${wmsutil:urlEncode(appName)}&vhost=${wmsutil:urlEncode(vhost)}
</c:set>

<c:set var="emailSubject">
	<wmsform:getlocalestring page="appconfig.publishers.encoders.jvc" obj="email.subject" />
</c:set>

<c:set var="emailMessage">
	<wmsform:getlocalestring page="appconfig.publishers.encoders.jvc" obj="email.message" />
</c:set>

<p><a href="javascript:returnStreamFile()"><i class="fa fa-arrow-left"></i><wmsform:getlocalestring page="appconfig.publishers" obj="incoming.returnlink" /></a></p>
<p><wmsform:getlocalestring page="common" obj="requiredField"/></p>

<re:mark>hidden attributes are added to query params so don't include them on AJAX calls</re:mark>
<fieldset>
	<form:hidden path="vhost" />
	<form:hidden path="uiAppName" />
	<form:hidden path="uiAppType" />
	<form:hidden path="section" />	
	<form:hidden path="version"/>
	<form:hidden path="streamCreateConnect"/>
	<form:hidden path="encoderHaveIP"/>
	<form:hidden path="encoderUseMpegTs"/>
</fieldset>

<div class="row">
	<div class="col-md-12">
		<div class="row">
			<wmsform:pageerror/>
			<wmsform:pagewarning/>
			<wmsform:pageinformation/>
		</div>
		<%-- <wmsform:errors path="errorMessage" cssClass="alert alert-danger"/>
		<div id="encoder.warnings" class="alert alert-warning" style="display:none"><button type="button" class="close" data-dismiss="alert">&times;</button></div> --%>
		<div class="media">
			<img src="img/jvc-logo.png" />
			<div class="media-body">
				<p class="lead">
					<wmsform:getlocalestring page="appconfig.publishers.encoders.jvc" obj="description" />
				</p>
			</div>
		</div>
	</div>
</div>
<div class="row">
	<div class="col-md-12">
		<b><wmsform:getlocalestring page="appconfig.publishers.encoders.jvc" obj="connectionType" /></b>

		<div class="radio">
			<label><input type="radio"
				name="appconfig.publishers.encoders.jvc" id="radioTs"
				value="encoderUseMpegTs" checked> <wmsform:getlocalestring
					page="appconfig.publishers.encoders.jvc" obj="encoderUseMpegTs" /></label>
		</div>
		<div id="setUpMpegTs" class="container">
			<wmsform:editproperty page="appconfig.publishers.encoders.jvc" obj="publishersStreamFileName" required="true" />
			<div id="publishersStreamFileNameWarnings" class="alert alert-danger"></div>

			<wmsform:editproperty page="appconfig.publishers.encoders.jvc" obj="mpegTsUdpPort" required="true" readonly="false"/>
			<br>
			<div class="control-label">
				<wmsform:buttonprimary page="appconfig.publishers.encoders.jvc"
					obj="CreateConnectionTS"
					onClick="javascript:doMpegTsValidation()"
					icon="fa fa-video-camera" />
			</div>
			<div id="incomingStreamsLinkTs"><p><a href="javascript:goToIncomingStreams()"><i class="fa fa-arrow-right"></i> See the incoming stream you created</a></p></div>
			<!-- <p><a id="incomingStreamsLinkTs" href="javascript:goToIncomingStreams()"><i class="fa fa-arrow-right"></i> See the incoming stream you created</a></p> -->
			<br />
		</div>
		
		<div class="radio">
			<label><input type="radio" name="appconfig.publishers.encoders.jvc" id="radioRtmp"
				value="encoderUseRtmp"> <wmsform:getlocalestring page="appconfig.publishers.encoders.jvc" obj="encoderUseRtmp" /></label>
		</div>
		<div id="setUpRtmp" class="container">
			<wmsform:getlocalestring page="appconfig.publishers.encoders.jvc" obj="rtmp" /> <br>
			<b> <wmsform:getlocalestring page="appconfig.publishers.encoders.jvc" obj="rtmpURL" /> </b> rtmp://${formData.hostServer}:${formData.hostPort}/${wmsutil:escapeHtml(appName)}<br>
			<wmsform:getlocalestring page="appconfig.publishers.encoders.jvc" obj="rtmpStreamName" /> <br />
			<small class="text-muted"><wmsform:getlocalestring page="appconfig.publishers.encoders.jvc" obj="note" /> </small> <br />
			<small class="text-muted"><wmsform:getlocalestring page="appconfig.publishers.encoders.jvc" obj="note2" /> </small> <br />

			<br />
			<p>
				<wmsform:getlocalestring page="appconfig.publishers.encoders.jvc" obj="descriptionEmail" />
			</p>
			<div class="row">
				<div class="col-md-12">
					<div class="row">
						<div class="input-group col-md-7">
							<input class="form-control" name="emailAddressRTSP" id="emailAddressRTSP" type="text" placeholder="Email Address"><span
								class="input-group-btn"><button class="btn btn-default" name="emailLinkRTSP" id="emailLinkRTSP"> <!-- onClick="javascript:sendEmail();return false;" !!!return false doesn't work in Firefox 33.1 -->
									<i class="fa fa-envelope"></i>
									<fmt:message key='common.email' />
								</button></span>
						</div>
					</div>
					<div class="help-block">
						<wmsform:getlocalestring page="appconfig.publishers.encoders.jvc" obj="tableFooter" />
					</div>
				</div>
			</div>
			
			<div class="row">
				<div class="input-group col-md-7"><wmsform:getlocalestring page="appconfig.publishers.encoders.jvc" obj="rtmpCopy" /><br/>
					<input class="form-control" name="RtmpUrl" id="RtmpUrl" type="text" placeholder="rtmp url">
				</div>
			</div>
			
		</div>

		<% /* rtsp is 554 and set by server. User is always "prohd" password can be blank */ %>
		<div id="incomingStreamsLinkRtsp"></div>
<%-- 
when RTSP is fixed in JVC, we can enable it here.  Ed said we can duplicate the stream name 
field for each of MPEG-TS and RTSP radio buttons if needed since it is not global to RTMP. 
		<div class="radio">
			<label><input type="radio"
				name="appconfig.publishers.encoders.jvc" id="radioRtsp"
				value="encoderHaveIP"> <wmsform:getlocalestring
					page="appconfig.publishers.encoders.jvc" obj="encoderHaveIP" /></label>
		</div>
		<div id="setUpRtsp" class="container">
			<wmsform:editproperty page="appconfig.publishers.encoders.jvc"
				obj="cameraIpAddress" required="true" />
			<wmsform:editproperty page="appconfig.publishers.encoders.jvc"
				obj="encoderPass" inputType="password" />
			<wmsform:editproperty page="appconfig.publishers.encoders.jvc"
				obj="encoderPass2" inputType="password" />
			<wmsform:buttonprimary page="appconfig.publishers.encoders.jvc"
				obj="CreateConnectionRTSP" 
				onClick="javascript:doRtspValidation()"
				icon="fa fa-video-camera" />
			<div id="incomingStreamsLinkRtsp"><p><a href="javascript:goToIncomingStreams()"><i class="fa fa-arrow-right"></i> See the incoming stream you created</a></p></div>
		</div>
--%>
		<br />

		<b><wmsform:getlocalestring page="appconfig.publishers.encoders.jvc" obj="configureEncoder" /></b>
		<div class="container">
			<wmsform:getlocalestring page="appconfig.publishers.encoders.jvc" obj="configureEncoder2" />
		</div>
	</div>
</div>
<c:set var="dupStreamFileNameError">
	<wmsform:getlocalestring page="common" obj="StreamFileName.dup"/>
</c:set>
<c:set var="blankNameError">
	<wmsform:getlocalestring page="common" obj="emptyField"/>
</c:set>
<c:set var="invalidNameError">
	<wmsform:getlocalestring page="common" obj="invalidFileName"/>
</c:set>
<c:set var="invalidNameLengthError">
	<wmsform:getlocalestring page="common" obj="invalidFileNameLength"/>
</c:set>
<c:set var="blankPortError">
	<wmsform:getlocalestring page="common" obj="emptyField"/>
</c:set>
<c:set var="notANumberError">
	<wmsform:getlocalestring page="common" obj="invalidNumber"/>
</c:set>
<c:set var="invalidPortRangeError">
	<wmsform:getlocalestring page="common" obj="port.error"/>
</c:set>

<script>
//default page layout
$(document).ready(function() {
	/* $('#publishersStreamFileNameErrorMsg').hide(); */
	$('#publishersStreamFileNameWarnings').hide();
	$('#mpegTsUdpPortErrorMsg').hide();
	$('#incomingStreamsLinkTs').hide();
	$('#incomingStreamsLinkRtsp').hide();

	incomingStreamsLinkRtsp.href = "javascript:";/* noStreamYet() */
	incomingStreamsLinkTs.href = "javascript:";
	$('#incomingStreamsLinkRtsp').addClass('text-muted');
	$('#incomingStreamsLinkTs').addClass('text-muted');

	//radio state is not being saved to model so we pass it to controller on post. set up radio state here.
	if ($("encoderHaveIP").val() == "true") //"${requestScope.formData['encoderHaveIP']}"
	{
		$("#radioRtsp").attr('checked', 'true');
		$("#radioRtmp").removeAttr('checked');
		$("#radioTs").removeAttr('checked');
	}
	if ($("encoderUseMpegTs").val() == "true")
	{
		$("#radioTs").attr('checked', 'true');
		$("#radioRtmp").removeAttr('checked');
		$("#radioRtsp").removeAttr('checked');
	}
	if ($("encoderUseRtmp").val() == "true")
	{
		$("#radioRtmp").attr('checked', 'true');
		$("#radioTs").removeAttr('checked');
		$("#radioRtsp").removeAttr('checked');
	}

	//set up RTSP, RTMP or MPEG TS on page ready
	if ($("#radioTs").is(':checked'))
	{
		if ($("streamCreateConnect").val() == "true"){
			$('#incomingStreamsLinkTs').show();
			$('#incomingStreamsLinkTs').removeClass('text-muted');
			incomingStreamsLinkTs.href = "javascript:goToIncomingStreams()";
		}

		$('#cameraIpAddress').attr('readonly', 'true');
		$('#encoderPass').attr('readonly', 'true');
		$('#encoderPass2').attr('readonly', 'true');
		$('#CreateConnectionRTSP').addClass('disabled');

		$('#mpegTsUdpPort').removeAttr('readonly');
		$('#publishersStreamFileName').removeAttr('readonly');
		$('#CreateConnectionTS').removeClass('disabled');

		
		$('#emailAddressRTSP').attr('readonly', 'true');
		$('#RtmpUrl').attr('readonly', 'true');
		$('#emailLinkRTSP').addClass('disabled');
		
		$('#radioTs').attr('value', 'true');
		$('#radioRtmp').attr('value', 'false');
		$('#radioRtsp').attr('value', 'false');
	}

	if ($("#radioRtsp").is(':checked'))
	{
		if ($("streamCreateConnect").val() == "true"){
			$('#incomingStreamsLinkRtsp').show();
			incomingStreamsLinkRtsp.href = "javascript:goToIncomingStreams()";
			$('#incomingStreamsLinkRtsp').removeClass('text-muted');
		}

		$('#cameraIpAddress').removeAttr('readonly');
		$('#encoderPass').removeAttr('readonly');
		$('#encoderPass2').removeAttr('readonly');
		$('#CreateConnectionRTSP').removeClass('disabled');

		$('#mpegTsUdpPort').attr('readonly', 'true');
		$('#publishersStreamFileName').attr('readonly', 'true');
		$('#CreateConnectionTS').addClass('disabled');

		$('#emailAddressRTSP').attr('readonly', 'true');
		$('#RtmpUrl').attr('readonly', 'true');
		$('#emailLinkRTSP').addClass('disabled');
		
		$('#radioTs').attr('value', 'false');
		$('#radioRtmp').attr('value', 'false');
		$('#radioRtsp').attr('value', 'true');
	}

	if ($("#radioRtmp").is(':checked'))
	{
		
		$('#mpegTsUdpPort').attr('readonly', 'true');
		$('#publishersStreamFileName').attr('readonly', 'true');
		$('#CreateConnectionTS').addClass('disabled');

		$('#cameraIpAddress').attr('readonly', 'true');
		$('#encoderPass').attr('readonly', 'true');
		$('#encoderPass2').attr('readonly', 'true');
		$('#CreateConnectionRTSP').addClass('disabled');

		$('#emailAddressRTSP').removeAttr('readonly');
		$('#RtmpUrl').removeAttr('readonly');
		$('#emailLinkRTSP').removeClass('disabled');
		
		$('#radioTs').attr('value', 'false');
		$('#radioRtsp').attr('value', 'false');
		$('#radioRtmp').attr('value', 'true');
	}

	var url = "rtmp://${formData.hostServer}:${formData.hostPort}/${wmsutil:escapeHtml(appName)}";
	$('#emailLinkRTSP').click(function(event) {
		
		// /*we are in a form:form where method is post (MainAppView.jsp). prevent that.*/
		event.preventDefault ? event.preventDefault() : event.returnValue = false;

		var emailBody = "${emailMessage}";
		emailBody += url;
		location.href = "mailto:" + $("#emailAddressRTSP").val() + "?subject=" + encodeURIComponent("${emailSubject}")
				+ "&body=" + encodeURIComponent(emailBody);
	});

	$("#RtmpUrl").val(url);
	$("#RtmpUrl").focus(function() {
		this.select();
	});

});

// onChange="javascript:hasIPAddress() for radioTs object"
$("#radioTs").on("change", function () {
/* 	$('#incomingStreamsLinkTs').removeClass('text-muted');
	$('#incomingStreamsLinkRtsp').addClass('text-muted');
*/
	$('#cameraIpAddress').attr('readonly', 'true');
	$('#encoderPass').attr('readonly', 'true');
	$('#encoderPass2').attr('readonly', 'true');
	$('#CreateConnectionRTSP').addClass('disabled');

	$('#radioTs').attr('value', 'true');
	$('#radioRtmp').attr('value', 'false');
	$('#radioRtsp').attr('value', 'false');
	$('#mpegTsUdpPort').removeAttr('readonly');
	$('#publishersStreamFileName').removeAttr('readonly');
	$('#CreateConnectionTS').removeClass('disabled');

	$('#emailAddressRTSP').attr('readonly', 'true');
	$('#RtmpUrl').attr('readonly', 'true');
	$('#emailLinkRTSP').addClass('disabled');
});
$("#radioRtsp").on("change", function () {
/* 	$('#incomingStreamsLinkTs').addClass('text-muted');
	$('#incomingStreamsLinkRtsp').removeClass('text-muted');
 */	
	$('#cameraIpAddress').removeAttr('readonly');
	$('#encoderPass').removeAttr('readonly');
	$('#encoderPass2').removeAttr('readonly');
	$('#CreateConnectionRTSP').removeClass('disabled');
	
	$('#radioTs').attr('value', 'false');
	$('#radioRtmp').attr('value', 'false');
	$('#radioRtsp').attr('value', 'true');
	$('#mpegTsUdpPort').attr('readonly', 'true');
	$('#publishersStreamFileName').attr('readonly', 'true');
	$('#CreateConnectionTS').addClass('disabled');

	$('#emailAddressRTSP').attr('readonly', 'true');
	$('#RtmpUrl').attr('readonly', 'true');
	$('#emailLinkRTSP').addClass('disabled');
});
$("#radioRtmp").on("change", function () {
	$('#cameraIpAddress').attr('readonly', 'true');
	$('#encoderPass').attr('readonly', 'true');
	$('#encoderPass2').attr('readonly', 'true');
	$('#CreateConnectionRTSP').addClass('disabled');
	
	$('#radioTs').attr('value', 'false');
	$('#radioRtsp').attr('value', 'false');
	$('#radioRtmp').attr('value', 'true');
	$('#mpegTsUdpPort').attr('readonly', 'true');
	$('#publishersStreamFileName').attr('readonly', 'true');
	$('#CreateConnectionTS').addClass('disabled');

	$('#emailAddressRTSP').removeAttr('readonly');
	$('#RtmpUrl').removeAttr('readonly');
	$('#emailLinkRTSP').removeClass('disabled');
});
function returnStreamFile() {
	loadApplication('${wmsutil:escapeHtml(appName)}','${appType}','publishers');
	//loadAjaxMainContent("applications/${appType}/publishers/view.htm", "appName=${wmsutil:urlEncode(appName)}");
}

function goToIncomingStreams()
{
	loadApplication('${wmsutil:escapeHtml(appName)}' , '${appType}' , 'incomingstreams_details' , 'instance=_definst_&stream=' + $("#publishersStreamFileName").val() + '.stream&uiAppType=' + $("#uiAppType").val() + '&uiAppName=' + $("#uiAppName").val());
}

function noStreamYet()
{
	alert("Please fill out required fields and click Create Connection to generate the stream you want to see");
}

function validateStreamName() {
	$('#publishersStreamFileNameErrorMsg').hide();

	var ok=true;
	var fname= $("#publishersStreamFileName").val().trim();

	if(fname.lastIndexOf(".stream", fname.length - 7) != -1)
	{
		fname = fname.substr(0,fname.length-7);
	}
	else if(!isValidFileName(fname))
	{
		$('#publishersStreamFileNameErrorMsg').html("Stream File: ${invalidNameError}");
		$('#publishersStreamFileNameErrorMsg').show();
		ok=false;
	}
	else if(!isValidFileNameLength(fname))
	{
		$('#publishersStreamFileNameErrorMsg').html("Stream File: ${invalidNameLengthError}");
		$('#publishersStreamFileNameErrorMsg').show();
		ok=false;
	}
	else if(fname=="")
	{
		$('#publishersStreamFileNameErrorMsg').html("${blankNameError}");
		$('#publishersStreamFileNameErrorMsg').show();
		ok=false;
	}

	return ok;
} //end validateStreamName

function doMpegTsValidation() {
	var ok = validateStreamName();
	//var fname= $("#publishersStreamFileName").val().trim();
	$('#mpegTsUdpPortErrorMsg').hide();

	uri = $("#mpegTsUdpPort").val().trim();
	if (isNaN(uri))
	{
		$('#mpegTsUdpPortErrorMsg').html("${notANumberError}");
		$('#mpegTsUdpPortErrorMsg').show();
		ok=false;
	}
	else if(uri=="")
	{
		$('#mpegTsUdpPortErrorMsg').html("${blankPortError}");
		$('#mpegTsUdpPortErrorMsg').show();
		ok=false;
	}
	else if ((parseInt(uri,10) < 1) || (parseInt(uri,10) > 65535))
	{
		$('#mpegTsUdpPortErrorMsg').html("${invalidPortRangeError}");
		$('#mpegTsUdpPortErrorMsg').show();
		ok=false;
	}

	if(ok)
	{
		//uri = "udp://0.0.0.0:"+uri;
		doMpegTsAction();//fname,uri
	}
}//end doMpegTsValidation

function  doMpegTsAction() {
	var connectionType;
	if ($("#radioRtsp").is(':checked')){
		connectionType = true;
		connectionType=encodeURIComponent(connectionType);
	}
	else{
		connectionType = false;
		connectionType=encodeURIComponent(connectionType);
		}
	//uri=encodeURIComponent(uri);
	//all EDIT form data is available but not in model yet.
	postAJAXForm('applications/${appType}/publishers/encoder/JVC.htm','appName=${wmsutil:urlEncode(appName)}&connectionType='+connectionType); //'uri='+uri+'&publishersStreamFileName='+streamName
}

function doRtspValidation() {

	var ok = validateStreamName();
	
	$('#cameraIpAddressErrorMsg').hide();

	var ipAddress= $("#cameraIpAddress").val().trim();
	if(ipAddress=="")
	{
		$('#cameraIpAddressErrorMsg').html("${blankNameError}");
		$('#cameraIpAddressErrorMsg').show();
		ok=false;
	}

	if(ok)
	{
		//rtspPort is 554, added by server. "rtsp://prohd:" + encoderPass + "@" + ipAddress + "/stream"
		doRtspAction();
	}
}

function doRtspAction() {
	var connectionType;
	if ($("#radioRtsp").is(':checked')){
		connectionType = true;
		connectionType=encodeURIComponent(connectionType);
	}
	else{
		connectionType = false;
		connectionType=encodeURIComponent(connectionType);
		}

	postAJAXForm('applications/${appType}/publishers/encoder/JVC.htm','appName=${wmsutil:urlEncode(appName)}&connectionType='+connectionType);	//vhost is included in form:hidden vhost=${wmsutil:urlEncode(vhost)}&
}
function loadSourceSecurity()
{
	loadApplication("${wmsutil:urlEncode(appName)}","${appType}","securitypub");
}
</script>
