<%@ include file="/WEB-INF/jsp/taglibs.jsp" %>

<h5>Application Description</h5>
<p>Enter a description that will help you to remember details about your application.</p>

<c:if test="${appType=='live' or appType=='liveedge' or appType=='vod' or appType=='vodedge'}">
<h5>Playback Types</h5>
<p>Enable streaming to specific endpoints by selecting one or more of the following <strong>Playback Types</strong>:
    <ul>
        <li><strong>MPEG-DASH</strong>. Stream to DASH clients via Dynamic Adaptive Streaming over HTTP (DASH).
        <li><strong>Apple HLS</strong>. Stream to Apple iOS devices and Android devices via Apple HTTP Live Streaming protocol.
        <li><strong>Adobe RTMP</strong>. Stream to Adobe Flash Player via Real Time Messaging Protocol.
        <li><strong>Adobe HDS</strong>. Stream to Adobe Flash Player via Adobe HTTP Dynamic Streaming protocol.
        <li><strong>Microsoft Smooth Streaming</strong>. Stream to Smooth Streaming clients via Microsoft Smooth Streaming protocol.
        <li><strong>RTSP/RTP</strong>. Stream to RTSP/RTP-based players and devices (including Android devices) via interleaved Real Time Streaming Protocol/Real-time Transport Protocol.
    </ul>
</p>
</c:if>

<c:if test="${appType=='livehttporigin' or appType=='vodhttporigin'}">
<h5>Playback Types</h5>
<p>Enable HTTP streaming to specific endpoints by selecting one or more of the following <strong>Playback Types</strong>:
    <ul>
        <li><strong>MPEG-DASH</strong>. Stream to DASH clients via Dynamic Adaptive Streaming over HTTP (DASH).
        <li><strong>Apple HLS</strong>. Stream to Apple iOS devices via Apple HTTP Live Streaming protocol.
        <li><strong>Adobe HDS</strong>. Stream to Adobe Flash Player via Adobe HTTP Dynamic Streaming protocol.
        <li><strong>Microsoft Smooth Streaming</strong>. Stream to Smooth Streaming clients via Microsoft Smooth Streaming protocol.
    </ul>
</p>
</c:if>

<c:if test="${appType=='live' or appType=='liveedge'}">
<h5>Low-latency Streams</h5>
<p>Select <strong>Low-latency stream</strong> to use this application to publish and play live video content to one or a few client applications, such as in a video chat.</p>

<blockquote><strong>Note:</strong><br />The <strong>Low-latency stream</strong> option is only available for the Adobe RMTP playback type.</blockquote>
</c:if>

<c:if test="${appType=='live' or appType=='livehttporigin'}">
<h5>Record all incoming streams</h5>
<p>Select <strong>Record all incoming streams</strong> to record all incoming streams published to this application. The entire duration of the stream is recorded to a single file in the application's streaming file directory. If the live source starts and stops, the file is versioned with a version number and a new file is started. You can control the container format used (MP4 or FLV) by specifying a stream name prefix in the source configuration. If you specify the <strong>mp4:</strong> prefix, the stream is recorded to an MP4 (QuickTime) container. An MP4 container can only record H.264, AAC, and MP3 media data. If you specify the <strong>flv:</strong> prefix, the stream is recorded to an FLV container. The FLV container is the only option if you're recording with Flash Player.</p>

<p>To stop recording all incoming streams, clear <strong>Record all incoming streams</strong> and restart the application.</p>

<blockquote><strong>Notes:</strong><br />If you enable the <strong>Record all incoming streams</strong> option for this application and configure the <strong>Incoming Streams</strong> feature for this application to also record an incoming stream, two or more copies of the recording will be created. The file name of the recording created by the <strong>Record all incoming streams</strong> option is the same as the stream name. The <strong>Incoming Streams</strong> feature creates one or more recordings with file names that include the stream name and other information, depending on selected segmentation and versioning options.<br /><br />To record RTSP/RTP streams from IP cameras, native-RTP encoders, and MPEG-TS encoders and SHOUTCAST/Icecast streams, go to the <strong>Stream Files</strong> page for this application and configure the MediaCaster system to record these streams. To record all stream types with more control over the recording process, go to the <strong>Incoming Streams</strong> page for this application.</blockquote>
</c:if>

<h5>Cross-origin resource sharing (CORS)</h5>
<p>Select <strong>Cross-origin resource sharing (CORS)</strong> to enable CORS HTTP headers to be added to all responses for HTTP-based streams. For details, see <a href="https://www.wowza.com/docs/how-to-enable-cross-origin-resource-sharing-cors-for-http-based-streams" target="_blank"><i class="fa fa-external-link"></i>&nbsp;Enable cross-origin resource sharing in Wowza Streaming Engine</a>.</p>

<c:if test="${appType=='liveedge'}">
<h5>Origin URLs</h5>
<p>Add the origin server URL for the stream in <strong>Primary Origin URL</strong>. For redundancy, define a backup origin server for the stream by entering its URL in <strong>Secondary Origin URL</strong>. The origin URLs must use one of the following URL prefixes: wowz:&#47;&#47;, wowzs:&#47;&#47;, rtmp:&#47;&#47;, or rtmps:&#47;&#47;</p>
</c:if>

<c:if test="${appType=='live' or appType=='livehttporigin'}">
<h5>Streaming File Directory</h5>
<p>Specify the content directory on the server where files required for streaming live content, such as SDP, SMIL, or Stream files, are stored. You can select the default or an application-specific directory, or specify a custom directory to store the files. If you specify a custom directory, the directory path value can't contain less-than (&lt;), greater-than (&gt;), quotation (&#39; and &quot;), backslash (&#92;), pipe (&#124;), question mark (&#63;), and asterisk (&#42;) characters.</p>
</c:if>

<c:if test="${appType=='vod' or appType=='vodhttporigin'}">
<h5>Content Directory</h5>
<p>Specify the content directory on the server where media content files required for streaming are stored. You can select the default or an application-specific directory, or specify a custom directory to store the files. If you specify a custom directory, the directory path value can't contain less-than (&lt;), greater-than (&gt;), quotation (&#39; and &quot;), backslash (&#92;), pipe (&#124;), question mark (&#63;), and asterisk (&#42;) characters.</p>
</c:if>

<c:if test="${appType=='vodedge'}">
<h5>Media Cache Sources</h5>
<p>Media Cache Sources are HTTP-based servers and network-attached file systems that provide file-based content to the Media Cache system for re-streaming. You can specify that some or all Media Cache Sources configured on the system can be accessed by this application. To configure Media Cache Sources, go to the <a href="javascript:lastServerMC='mediaCache';loadAjaxSideBar('SB_Server.html','')">Media Cache page</a>.</p>
</c:if>

<c:if test="${appType=='live' or appType=='liveedge' or appType=='livehttporigin'}">
<h5>Closed Caption Sources</h5>
<p>Select the appropriate closed caption sources to enable the application to ingest the caption data and deliver as CEA-608-formatted SEI data in Apple HLS streams or as <strong>onTextData</strong> events in Adobe HDS and Adobe RTMP streams. The server can decode the following types of closed caption data in live streams:</p>
<ul>
	<li>Action Message Format (AMF) <strong>onTextData</strong> events
	<li>AMF <strong>onCaptionInfo</strong> events
	<li>Embedded CEA-608 captions
</ul>

<p>For more information, see <a href="https://www.wowza.com/docs/how-to-configure-closed-captioning-for-live-streaming" target="_blank"><i class="fa fa-external-link"></i>&nbsp;Configure closed captioning for Wowza Streaming Engine live streams</a>.</p>
</c:if>

<c:if test="${appType=='vod' or appType=='vodedge' or appType=='livehttporigin' or appType=='vodhttporigin'}">
<h5>Closed Caption Sources</h5>
<p>Select the appropriate closed caption sources to enable the application to ingest the caption data and deliver as CEA-608-formatted SEI data in Apple HLS streams or as <strong>onTextData</strong> events in Adobe HDS and Adobe RTMP streams.</p>

<p>Select <strong>Embedded 3GPP / MPEG-4 Timed Text tracks</strong> to enable the application to ingest and parse 3GPP/MPEG-4 Timed Text tracks embedded in MP4 video files.</p>

<p>For captions defined in external companion files (<strong>TTML/DXFP</strong>, <strong>SRT</strong>, <strong>WebVTT</strong>, and/or <strong>SCC</strong>), select the file format(s) that specify the caption data and make sure that the files are stored in the same content directory as the associated video file.</p>

<p>For more information, see <a href="https://www.wowza.com/docs/how-to-configure-closed-captioning-for-video-on-demand-streaming" target="_blank"><i class="fa fa-external-link"></i>&nbsp;Configure closed captioning for Wowza Streaming Engine video-on-demand streams</a>.</p>
</c:if>

<c:if test="${appType=='live' or appType=='vod'}">
<h5>Maximum Connections</h5>
<p>Specify the maximum number of simultaneous connections that the application can support. Select <strong>Limit number of connections</strong>, and then enter a positive non-zero integer value in the box.</p>
</c:if>
