#!/bin/bash

ROOTUID="0"

if [ "$(id -u)" -ne "$ROOTUID" ] ; then
    echo "This script must be executed with root privileges."
    exit 1
fi

# delete upstart symlinks
rm -f /etc/init.d/WowzaStreamingEngine
rm -f /etc/init.d/WowzaStreamingEngineManager
rm -f /usr/bin/WowzaStreamingEngined
rm -f /usr/bin/WowzaStreamingEngineManagerd

# copy the upstart service files
mkdir -p /usr/lib/systemd/system
cp -f /usr/local/WowzaStreamingEngine/bin/WowzaStreamingEngine.service /usr/lib/systemd/system
cp -f /usr/local/WowzaStreamingEngine/manager/bin/WowzaStreamingEngineManager.service /usr/lib/systemd/system

# install and start services
systemctl daemon-reload
systemctl enable WowzaStreamingEngine.service
systemctl start WowzaStreamingEngine.service
systemctl enable WowzaStreamingEngineManager.service
systemctl start WowzaStreamingEngineManager.service