<?php
ini_set("memory_limit", "256M");
ini_set("max_execution_time", 3600);
ini_set("date.timezone","America/Sao_Paulo");

require_once("".str_replace("/robots","",realpath(dirname(__FILE__)))."/admin/inc/conecta.php");
require_once("".str_replace("/robots","",realpath(dirname(__FILE__)))."/admin/inc/funcoes.php");
require_once("".str_replace("/robots","",realpath(dirname(__FILE__)))."/admin/inc/classe.ssh.php");

function tempo_exec_live($date){$first = new DateTime($date);$second = new DateTime("now");$diff = $first->diff( $second );$minutes = $diff->days * 24 * 60;$minutes += $diff->h * 60;$minutes += $diff->i;return $minutes;}

parse_str($argv[1],$opcoes);

list($inicial,$final) = explode("-",$opcoes["registros"]);

echo "[".date("d/m/Y H:i:s")."] Processo Iniciado.\n";

$data_atual_servidor = date("Y-m-d H:i");

$query = mysqli_query($conexao,"SELECT *, DATE_FORMAT(data_inicio,'%Y-%m-%d %H:%i') AS data_inicio, DATE_FORMAT(data_fim,'%Y-%m-%d %H:%i') AS data_fim FROM lives ORDER by codigo ASC LIMIT ".$inicial.", ".$final."");
while ($dados_live = mysqli_fetch_array($query)) {

$dados_stm = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM streamings where codigo = '".$dados_live["codigo_stm"]."'"));
$dados_servidor = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM servidores where codigo = '".$dados_stm["codigo_servidor"]."'"));

$data_atual = formatar_data("Y-m-d H:i", $data_atual_servidor, $dados_stm["timezone"]);

////////////////////////////
// Inicializao de lives //
////////////////////////////

if($dados_stm["status"] == 1 && $dados_servidor["status"] == "on") {

if($dados_live["status"] == 2 && $dados_live["data_inicio"] == $data_atual) {

// Conexao SSH
$ssh = new SSH();
$ssh->conectar($dados_servidor["ip"],$dados_servidor["porta_ssh"]);
$ssh->autenticar("root",code_decode($dados_servidor["senha"],"D"));

$ssh->executar('echo OK;screen -dmS '.$dados_stm["login"].'_'.$dados_live["codigo"].';screen -r '.$dados_stm["login"].'_'.$dados_live["codigo"].' -X stuff "/usr/local/bin/ffmpeg -re -i '.$dados_live["servidor_stm"].' -c:v copy -c:a copy -bsf:a aac_adtstoasc -preset ultrafast -strict experimental -threads 1 -f flv \''.$dados_live["servidor_live"].'\' "$(echo -ne "\015")');

sleep(5);

$resultado = $ssh->executar("/bin/ps aux | /bin/grep ffmpeg | /bin/grep rtmp | /bin/grep ".$dados_stm["login"]." | /bin/grep ".$dados_live["tipo"]." | /usr/bin/wc -l");

if($resultado > 0) {

echo "[".$dados_stm["login"]."][".$data_atual_servidor."][".$dados_live["data_inicio"]."] Iniciando live ".$dados_live["tipo"]."\n";

// Atualiza status para transmitindo
mysqli_query($conexao,"Update lives set status = '1' where codigo = '".$dados_live["codigo"]."'");

} else {

echo "[".$dados_stm["login"]."][".$data_atual_servidor."][".$dados_live["data_inicio"]."] Erro ao iniciar live ".$dados_live["tipo"]."\n";

// Atualiza status para transmitindo
mysqli_query($conexao,"Update lives set status = '3' where codigo = '".$dados_live["codigo"]."'");

} 

}

} // FIM -> Verifica se o streaming e servidor esta ON/OFF

//////////////////////////
// Finalizao de lives //
//////////////////////////

if($dados_live["status"] == 1 && $dados_live["data_fim"] == $data_atual) {

// Conexao SSH
$ssh = new SSH();
$ssh->conectar($dados_servidor["ip"],$dados_servidor["porta_ssh"]);
$ssh->autenticar("root",code_decode($dados_servidor["senha"],"D"));

$ssh->executar("echo OK;screen -X -S ".$dados_stm["login"]."_".$dados_live["codigo"]." quit");

echo "[".$dados_stm["login"]."][".$data_atual_servidor."][".$dados_live["data_fim"]."] Live ".$dados_live["tipo"]." finalizada.\n";

// Atualiza status para transmitindo
mysqli_query($conexao,"Update lives set status = '0' where codigo = '".$dados_live["codigo"]."'");
}

////////////////////////////////////////////////////////
// Finalizao de lives com mais de 24hs de execusso //
////////////////////////////////////////////////////////
$tempo_exec = tempo_exec_live($dados_live["data_inicio"]);

if($dados_live["status"] == 1 && $tempo_exec > 1440) {

// Conexao SSH
$ssh = new SSH();
$ssh->conectar($dados_servidor["ip"],$dados_servidor["porta_ssh"]);
$ssh->autenticar("root",code_decode($dados_servidor["senha"],"D"));

$ssh->executar("echo OK;screen -X -S ".$dados_stm["login"]."_".$dados_live["codigo"]." quit");

echo "[".$dados_stm["login"]."][".$data_atual_servidor."][".$dados_live["data_fim"]."] Live ".$dados_live["tipo"]." finalizada por estar transmitindo a mais de 24hs.\n";

// Atualiza status para transmitindo
mysqli_query($conexao,"Update lives set status = '0' where codigo = '".$dados_live["codigo"]."'");

}

} // FIM -> while


// Remove registros de lives finalizadas a mais de 3 dias
$data_live_finalizada = date("Y-m-d",mktime (0, 0, 0, date("m")  , date("d")-3, date("Y")));
mysqli_query($conexao,"Delete From lives WHERE data_inicio < '".$data_live_finalizada."' AND status = 0");



echo "\n[".date("d/m/Y H:i:s")."] Processo Concludo.\n\n";

?>