-- Painel de Streaming de Video
-- Criado por Cesar - cesarlwh@gmail.com
-- Se voce nao comprou este painel comigo, sinto dizer que esta correndo risco de seguranca e de seus dados serem expostos

CREATE TABLE `acessos_paginas` (
  `codigo` int(10) NOT NULL,
  `pagina` varchar(255) NOT NULL,
  `total` int(10) NOT NULL
) ENGINE=MyISAM;

CREATE TABLE `acessos_players` (
  `codigo` int(10) NOT NULL,
  `player` varchar(255) NOT NULL,
  `total` int(10) NOT NULL
) ENGINE=MyISAM;

CREATE TABLE `administradores` (
  `codigo` int(10) NOT NULL,
  `nome` varchar(255) NOT NULL,
  `usuario` varchar(255) NOT NULL,
  `senha` varchar(255) NOT NULL
) ENGINE=MyISAM;

CREATE TABLE `agendamentos_relay` (
  `codigo` int(10) NOT NULL,
  `codigo_stm` int(10) NOT NULL,
  `frequencia` int(1) NOT NULL,
  `data_inicio` date NOT NULL,
  `hora_inicio` char(2) NOT NULL,
  `minuto_inicio` char(2) NOT NULL,
  `data_termino` date NOT NULL,
  `hora_termino` char(2) NOT NULL,
  `minuto_termino` char(2) NOT NULL,
  `dias` varchar(50) NOT NULL,
  `url_rtmp` text NOT NULL
) ENGINE=MyISAM;

CREATE TABLE `agendamentos_relay_logs` (
  `codigo` int(10) NOT NULL,
  `codigo_agendamento` int(10) NOT NULL,
  `codigo_stm` int(10) NOT NULL,
  `data` datetime NOT NULL,
  `url_rtmp` varchar(255) NOT NULL
) ENGINE=MyISAM;

CREATE TABLE `apps` (
  `codigo` int(10) NOT NULL,
  `codigo_stm` int(10) NOT NULL,
  `tv_nome` varchar(255) NOT NULL,
  `tv_site` varchar(255) NOT NULL,
  `tv_facebook` varchar(255) NOT NULL,
  `hash` varchar(255) NOT NULL,
  `apk` varchar(255) NOT NULL,
  `zip` varchar(255) NOT NULL,
  `package` varchar(255) NOT NULL,
  `aviso` text NOT NULL,
  `status` int(1) NOT NULL DEFAULT 0,
  `data` datetime NOT NULL,
  `source` varchar(255) NOT NULL DEFAULT 'source1',
  `log_build` longtext NOT NULL,
  `compilado` char(3) DEFAULT 'nao'
) ENGINE=MyISAM;

CREATE TABLE `atalhos` (
  `codigo` int(10) NOT NULL,
  `codigo_stm` int(10) NOT NULL,
  `menu` varchar(255) NOT NULL,
  `lang` varchar(255) NOT NULL,
  `ordem` int(10) NOT NULL
) ENGINE=MyISAM;

CREATE TABLE `avisos` (
  `codigo` int(10) NOT NULL,
  `codigo_servidor` int(10) NOT NULL,
  `area` varchar(255) NOT NULL,
  `titulo` varchar(255) NOT NULL,
  `descricao` longtext NOT NULL,
  `data` date NOT NULL,
  `mensagem` longtext NOT NULL,
  `status` char(3) NOT NULL DEFAULT 'sim'
) ENGINE=MyISAM;

CREATE TABLE `avisos_desativados` (
  `codigo` int(10) NOT NULL,
  `codigo_aviso` int(10) NOT NULL,
  `login` varchar(255) NOT NULL,
  `area` varchar(255) NOT NULL,
  `data` date NOT NULL
) ENGINE=MyISAM;

CREATE TABLE `bloqueios_login` (
  `codigo` int(10) NOT NULL,
  `codigo_cliente` int(10) NOT NULL,
  `codigo_stm` int(10) NOT NULL,
  `data` datetime NOT NULL,
  `ip` varchar(255) NOT NULL,
  `navegador` varchar(255) NOT NULL,
  `tentativas` int(10) NOT NULL
) ENGINE=MyISAM;

CREATE TABLE `configuracoes` (
  `dominio_padrao` varchar(255) NOT NULL,
  `codigo_servidor_atual` int(10) NOT NULL,
  `manutencao` char(3) NOT NULL DEFAULT 'nao',
  `idioma_painel` varchar(255) NOT NULL DEFAULT 'pt-br'
) ENGINE=MyISAM;

CREATE TABLE `configuracoes_backup` (
  `ftp_servidor` varchar(255) NOT NULL,
  `ftp_usuario` varchar(255) NOT NULL,
  `ftp_senha` varchar(255) NOT NULL,
  `bkp_arquivos` char(3) NOT NULL,
  `bkp_mysql` char(3) NOT NULL,
  `bkp_mysql_stats` char(3) NOT NULL,
  `log` longtext NOT NULL
) ENGINE=MyISAM;

CREATE TABLE `dicas_rapidas` (
  `codigo` int(10) NOT NULL,
  `titulo` varchar(255) NOT NULL,
  `mensagem` text NOT NULL,
  `exibir` char(3) NOT NULL DEFAULT 'sim'
) ENGINE=MyISAM;

CREATE TABLE `dicas_rapidas_acessos` (
  `codigo` int(10) NOT NULL,
  `codigo_stm` int(10) NOT NULL,
  `codigo_dica` int(10) NOT NULL,
  `total` int(10) NOT NULL DEFAULT 0
) ENGINE=MyISAM;

CREATE TABLE `dominios_bloqueados` (
  `dominio` varchar(255) NOT NULL
) ENGINE=MyISAM;

CREATE TABLE `espectadores_conectados` (
  `codigo` int(10) NOT NULL,
  `codigo_stm` int(10) NOT NULL,
  `ip` varchar(255) NOT NULL,
  `tempo_conectado` varchar(255) NOT NULL,
  `pais_sigla` varchar(255) NOT NULL,
  `pais_nome` varchar(255) NOT NULL,
  `cidade` varchar(255) NOT NULL,
  `estado` varchar(255) NOT NULL,
  `player` varchar(255) NOT NULL,
  `latitude` varchar(255) NOT NULL DEFAULT '0.0',
  `longitude` varchar(255) NOT NULL DEFAULT '0.0'
) ENGINE=MyISAM;

CREATE TABLE `estatisticas` (
  `codigo` int(10) NOT NULL,
  `codigo_stm` int(10) NOT NULL,
  `data` date NOT NULL,
  `hora` time NOT NULL,
  `ip` varchar(255) NOT NULL DEFAULT '000.000.000.000',
  `pais` varchar(255) NOT NULL,
  `tempo_conectado` int(20) NOT NULL DEFAULT 0,
  `player` varchar(255) NOT NULL,
  `cidade` varchar(255) NOT NULL,
  `estado` varchar(255) NOT NULL
) ENGINE=MyISAM;

CREATE TABLE `ip_cameras` (
  `codigo` int(10) NOT NULL,
  `codigo_stm` int(10) NOT NULL,
  `nome` varchar(255) NOT NULL,
  `rtsp` text NOT NULL,
  `stream` varchar(255) NOT NULL,
  `data_cadastro` datetime NOT NULL
) ENGINE=MyISAM;

CREATE TABLE `lives` (
  `codigo` int(10) NOT NULL,
  `codigo_stm` int(10) NOT NULL,
  `data_inicio` datetime NOT NULL,
  `data_fim` datetime NOT NULL,
  `tipo` varchar(255) NOT NULL,
  `servidor_stm` varchar(255) NOT NULL,
  `servidor_live` varchar(255) NOT NULL,
  `status` int(1) NOT NULL DEFAULT 0
) ENGINE=MyISAM;

CREATE TABLE `logs` (
  `codigo` int(10) NOT NULL,
  `data` datetime NOT NULL,
  `host` varchar(255) NOT NULL DEFAULT 'http://',
  `ip` varchar(255) NOT NULL,
  `navegador` varchar(255) NOT NULL,
  `log` text NOT NULL
) ENGINE=MyISAM;

CREATE TABLE `logs_streamings` (
  `codigo` int(10) NOT NULL,
  `codigo_stm` int(10) NOT NULL,
  `data` datetime NOT NULL,
  `host` varchar(255) NOT NULL,
  `ip` varchar(255) NOT NULL,
  `navegador` varchar(255) NOT NULL,
  `log` text NOT NULL
) ENGINE=MyISAM;

CREATE TABLE `playlists` (
  `codigo` int(10) NOT NULL,
  `codigo_stm` int(10) NOT NULL,
  `nome` varchar(255) NOT NULL,
  `data` datetime NOT NULL,
  `comerciais` char(3) NOT NULL DEFAULT 'nao'
) ENGINE=MyISAM;

CREATE TABLE `playlists_agendamentos` (
  `codigo` int(10) NOT NULL,
  `codigo_stm` int(10) NOT NULL,
  `codigo_playlist` int(10) NOT NULL,
  `servidor_relay` varchar(255) NOT NULL,
  `frequencia` int(1) NOT NULL DEFAULT 1,
  `data` date NOT NULL,
  `hora` char(2) NOT NULL,
  `minuto` char(2) NOT NULL,
  `dias` varchar(50) NOT NULL,
  `tipo` varchar(50) NOT NULL DEFAULT 'playlist'
) ENGINE=MyISAM;

CREATE TABLE `playlists_agendamentos_logs` (
  `codigo` int(10) NOT NULL,
  `codigo_agendamento` int(10) NOT NULL DEFAULT 0,
  `codigo_stm` int(10) NOT NULL DEFAULT 0,
  `data` datetime DEFAULT NULL,
  `playlist` varchar(255) DEFAULT NULL
) ENGINE=MyISAM;

CREATE TABLE `playlists_videos` (
  `codigo` int(10) NOT NULL,
  `codigo_playlist` int(10) NOT NULL,
  `path_video` varchar(255) NOT NULL,
  `video` varchar(255) NOT NULL,
  `width` int(10) NOT NULL,
  `height` int(10) NOT NULL,
  `bitrate` int(10) NOT NULL,
  `duracao` char(10) NOT NULL,
  `duracao_segundos` int(11) NOT NULL,
  `tipo` varchar(255) NOT NULL DEFAULT 'video',
  `ordem` int(10) NOT NULL
) ENGINE=MyISAM;

CREATE TABLE `revendas` (
  `codigo` int(10) NOT NULL,
  `codigo_revenda` int(10) NOT NULL,
  `id` char(6) NOT NULL,
  `nome` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `senha` varchar(255) NOT NULL,
  `streamings` int(10) NOT NULL,
  `espectadores` int(10) NOT NULL,
  `bitrate` int(10) NOT NULL,
  `espaco` int(10) NOT NULL,
  `subrevendas` int(10) NOT NULL DEFAULT 0,
  `chave_api` longtext NOT NULL,
  `status` int(1) NOT NULL DEFAULT 1,
  `url_suporte` text DEFAULT NULL,
  `data_cadastro` datetime NOT NULL,
  `dominio_padrao` varchar(255) NOT NULL,
  `stm_exibir_tutoriais` char(3) NOT NULL DEFAULT 'sim',
  `url_tutoriais` varchar(255) NOT NULL DEFAULT 'http://',
  `stm_exibir_downloads` char(3) NOT NULL DEFAULT 'sim',
  `stm_exibir_mini_site` char(3) NOT NULL DEFAULT 'nao',
  `stm_exibir_app_android_painel` char(3) NOT NULL DEFAULT 'sim',
  `idioma_painel` char(10) NOT NULL DEFAULT 'pt-br',
  `tipo` int(1) NOT NULL DEFAULT 1,
  `ultimo_acesso_data` datetime NOT NULL,
  `ultimo_acesso_ip` varchar(255) NOT NULL DEFAULT '000.000.000.000',
  `stm_exibir_app_android` char(3) NOT NULL DEFAULT 'sim',
  `url_logo` text NOT NULL,
  `transcoder` char(3) NOT NULL DEFAULT 'nao',
  `codigo_servidor_privado` int(10) NOT NULL DEFAULT 0,
  `lives` char(3) NOT NULL DEFAULT 'nao'
) ENGINE=MyISAM;

CREATE TABLE `revendas_planos` (
  `codigo` int(10) NOT NULL,
  `codigo_revenda` int(10) NOT NULL,
  `nome` varchar(255) NOT NULL,
  `espectadores` int(10) NOT NULL,
  `bitrate` int(10) NOT NULL,
  `espaco_ftp` int(10) NOT NULL,
  `ipcameras` int(10) NOT NULL,
  `subrevendas` int(10) NOT NULL,
  `streamings` int(10) NOT NULL DEFAULT 0,
  `tipo` char(10) NOT NULL DEFAULT 'streaming',
  `aplicacao` varchar(10) NOT NULL DEFAULT 'live'
) ENGINE=MyISAM;

CREATE TABLE `screen_size` (
  `codigo` int(11) NOT NULL,
  `width` varchar(255) NOT NULL,
  `height` varchar(255) NOT NULL,
  `data` datetime NOT NULL
) ENGINE=MyISAM;

CREATE TABLE `servidores` (
  `codigo` int(10) NOT NULL,
  `nome` varchar(255) NOT NULL DEFAULT 'Stm',
  `ip` varchar(255) NOT NULL,
  `senha` varchar(255) NOT NULL,
  `porta_ssh` int(6) NOT NULL DEFAULT 6985,
  `status` char(3) NOT NULL DEFAULT 'on',
  `limite_streamings` int(10) NOT NULL DEFAULT 150,
  `load` float NOT NULL,
  `trafego` varchar(255) NOT NULL,
  `trafego_out` varchar(255) NOT NULL,
  `ordem` int(10) NOT NULL,
  `mensagem_manutencao` text NOT NULL,
  `grafico_trafego` text NOT NULL,
  `exibir` char(3) NOT NULL DEFAULT 'sim'
) ENGINE=MyISAM;

CREATE TABLE `streamings` (
  `codigo` int(10) NOT NULL,
  `codigo_cliente` int(10) NOT NULL,
  `codigo_servidor` int(10) NOT NULL,
  `login` varchar(255) NOT NULL,
  `senha` varchar(255) NOT NULL,
  `senha_transmissao` varchar(255) NOT NULL,
  `autenticar_live` char(3) NOT NULL DEFAULT 'sim',
  `espectadores` int(10) NOT NULL,
  `bitrate` int(10) NOT NULL,
  `espaco` int(10) NOT NULL DEFAULT 0,
  `espaco_usado` int(10) NOT NULL,
  `ipcameras` int(10) NOT NULL DEFAULT 0,
  `ftp_dir` varchar(255) NOT NULL,
  `identificacao` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `timezone` varchar(255) NOT NULL DEFAULT 'America/Sao_Paulo',
  `formato_data` char(11) NOT NULL DEFAULT 'd/m/Y H:i:s',
  `descricao` varchar(255) NOT NULL,
  `idioma_painel` char(10) NOT NULL DEFAULT 'pt-br',
  `pagina_inicial` varchar(255) NOT NULL DEFAULT '/informacoes',
  `exibir_atalhos` char(3) NOT NULL DEFAULT 'nao',
  `player_autoplay` char(5) NOT NULL DEFAULT 'true',
  `player_volume_inicial` char(3) NOT NULL DEFAULT '1.0',
  `permitir_alterar_senha` char(3) NOT NULL DEFAULT 'sim',
  `data_cadastro` datetime NOT NULL,
  `aplicacao` char(10) DEFAULT 'live',
  `player_titulo` varchar(255) NOT NULL,
  `player_descricao` varchar(255) NOT NULL,
  `status_gravando` char(3) NOT NULL DEFAULT 'nao',
  `gravador_arquivo` varchar(255) NOT NULL,
  `gravador_data_inicio` datetime NOT NULL,
  `exibir_app_android` char(3) NOT NULL DEFAULT 'sim',
  `status` int(1) NOT NULL DEFAULT 1,
  `transcoder` char(3) NOT NULL DEFAULT 'nao',
  `transcoder_instalado` char(3) NOT NULL DEFAULT 'nao',
  `transcoder_qualidades` varchar(255) NOT NULL DEFAULT '720p|360p|240p|160p',
  `aparencia_exibir_stats_espectadores` char(3) NOT NULL DEFAULT 'sim',
  `aparencia_exibir_stats_ftp` char(3) NOT NULL DEFAULT 'sim',
  `app_nome` varchar(255) NOT NULL,
  `app_email` varchar(255) NOT NULL,
  `app_whatsapp` varchar(255) NOT NULL,
  `app_url_logo` varchar(255) NOT NULL,
  `app_url_icone` varchar(255) NOT NULL,
  `app_url_background` varchar(255) NOT NULL,
  `app_url_facebook` varchar(255) NOT NULL,
  `app_url_instagram` varchar(255) NOT NULL,
  `app_url_twitter` varchar(255) NOT NULL,
  `app_url_site` varchar(255) NOT NULL,
  `app_url_chat` varchar(255) NOT NULL,
  `app_url_camera_studio` varchar(255) NOT NULL,
  `app_cor_texto` char(7) NOT NULL DEFAULT '#FFFFFF',
  `app_cor_menu_claro` char(7) NOT NULL DEFAULT '#7386d5',
  `app_cor_menu_escuro` char(7) NOT NULL DEFAULT '#6d7fcc',
  `app_url_youtube` varchar(255) NOT NULL,
  `app_text_prog` longtext NOT NULL,
  `app_text_hist` longtext NOT NULL,
  `ultima_playlist` int(10) NOT NULL,
  `tema_dark` char(3) NOT NULL DEFAULT 'nao',
  `lives` char(3) NOT NULL DEFAULT 'sim',
  `watermark_posicao` varchar(255) NOT NULL
) ENGINE=MyISAM;

CREATE TABLE `tutoriais` (
  `codigo` int(10) NOT NULL,
  `titulo` varchar(255) NOT NULL,
  `data` date NOT NULL,
  `vizualizacoes` int(10) NOT NULL,
  `tutorial` longtext NOT NULL
) ENGINE=MyISAM;


ALTER TABLE `acessos_paginas`
  ADD PRIMARY KEY (`codigo`);

ALTER TABLE `acessos_players`
  ADD PRIMARY KEY (`codigo`);

ALTER TABLE `administradores`
  ADD PRIMARY KEY (`codigo`);

ALTER TABLE `agendamentos_relay`
  ADD PRIMARY KEY (`codigo`);

ALTER TABLE `agendamentos_relay_logs`
  ADD PRIMARY KEY (`codigo`);

ALTER TABLE `apps`
  ADD PRIMARY KEY (`codigo`);

ALTER TABLE `atalhos`
  ADD PRIMARY KEY (`codigo`);

ALTER TABLE `avisos`
  ADD PRIMARY KEY (`codigo`);

ALTER TABLE `avisos_desativados`
  ADD PRIMARY KEY (`codigo`);

ALTER TABLE `bloqueios_login`
  ADD PRIMARY KEY (`codigo`);

ALTER TABLE `dicas_rapidas`
  ADD PRIMARY KEY (`codigo`);

ALTER TABLE `dicas_rapidas_acessos`
  ADD PRIMARY KEY (`codigo`);

ALTER TABLE `espectadores_conectados`
  ADD PRIMARY KEY (`codigo`);

ALTER TABLE `estatisticas`
  ADD PRIMARY KEY (`codigo`),
  ADD KEY `indice_stm` (`codigo_stm`),
  ADD KEY `indice_pais` (`codigo_stm`,`pais`(10)),
  ADD KEY `indice_data` (`codigo_stm`,`data`),
  ADD KEY `indice_tempo_conectado` (`codigo_stm`,`tempo_conectado`),
  ADD KEY `indice_ip` (`codigo_stm`,`ip`(15)),
  ADD KEY `indice_robot` (`codigo_stm`,`data`,`ip`(12)),
  ADD KEY `player` (`player`),
  ADD KEY `codigo_stm` (`codigo_stm`,`data`,`hora`);

ALTER TABLE `ip_cameras`
  ADD PRIMARY KEY (`codigo`);

ALTER TABLE `lives`
  ADD PRIMARY KEY (`codigo`);

ALTER TABLE `logs`
  ADD PRIMARY KEY (`codigo`);

ALTER TABLE `logs_streamings`
  ADD PRIMARY KEY (`codigo`);

ALTER TABLE `playlists`
  ADD PRIMARY KEY (`codigo`);

ALTER TABLE `playlists_agendamentos`
  ADD PRIMARY KEY (`codigo`),
  ADD KEY `indice_data` (`data`);

ALTER TABLE `playlists_videos`
  ADD PRIMARY KEY (`codigo`);

ALTER TABLE `revendas`
  ADD PRIMARY KEY (`codigo`);

ALTER TABLE `revendas_planos`
  ADD PRIMARY KEY (`codigo`);

ALTER TABLE `screen_size`
  ADD PRIMARY KEY (`codigo`);

ALTER TABLE `servidores`
  ADD PRIMARY KEY (`codigo`);

ALTER TABLE `streamings`
  ADD PRIMARY KEY (`codigo`);

ALTER TABLE `tutoriais`
  ADD PRIMARY KEY (`codigo`);


ALTER TABLE `acessos_paginas`
  MODIFY `codigo` int(10) NOT NULL AUTO_INCREMENT;

ALTER TABLE `acessos_players`
  MODIFY `codigo` int(10) NOT NULL AUTO_INCREMENT;

ALTER TABLE `administradores`
  MODIFY `codigo` int(10) NOT NULL AUTO_INCREMENT;

ALTER TABLE `agendamentos_relay`
  MODIFY `codigo` int(10) NOT NULL AUTO_INCREMENT;

ALTER TABLE `agendamentos_relay_logs`
  MODIFY `codigo` int(10) NOT NULL AUTO_INCREMENT;

ALTER TABLE `apps`
  MODIFY `codigo` int(10) NOT NULL AUTO_INCREMENT;

ALTER TABLE `atalhos`
  MODIFY `codigo` int(10) NOT NULL AUTO_INCREMENT;

ALTER TABLE `avisos`
  MODIFY `codigo` int(10) NOT NULL AUTO_INCREMENT;

ALTER TABLE `avisos_desativados`
  MODIFY `codigo` int(10) NOT NULL AUTO_INCREMENT;

ALTER TABLE `bloqueios_login`
  MODIFY `codigo` int(10) NOT NULL AUTO_INCREMENT;

ALTER TABLE `dicas_rapidas`
  MODIFY `codigo` int(10) NOT NULL AUTO_INCREMENT;

ALTER TABLE `dicas_rapidas_acessos`
  MODIFY `codigo` int(10) NOT NULL AUTO_INCREMENT;

ALTER TABLE `espectadores_conectados`
  MODIFY `codigo` int(10) NOT NULL AUTO_INCREMENT;

ALTER TABLE `estatisticas`
  MODIFY `codigo` int(10) NOT NULL AUTO_INCREMENT;

ALTER TABLE `ip_cameras`
  MODIFY `codigo` int(10) NOT NULL AUTO_INCREMENT;

ALTER TABLE `lives`
  MODIFY `codigo` int(10) NOT NULL AUTO_INCREMENT;

ALTER TABLE `logs`
  MODIFY `codigo` int(10) NOT NULL AUTO_INCREMENT;

ALTER TABLE `logs_streamings`
  MODIFY `codigo` int(10) NOT NULL AUTO_INCREMENT;

ALTER TABLE `playlists`
  MODIFY `codigo` int(10) NOT NULL AUTO_INCREMENT;

ALTER TABLE `playlists_agendamentos`
  MODIFY `codigo` int(10) NOT NULL AUTO_INCREMENT;

ALTER TABLE `playlists_videos`
  MODIFY `codigo` int(10) NOT NULL AUTO_INCREMENT;

ALTER TABLE `revendas`
  MODIFY `codigo` int(10) NOT NULL AUTO_INCREMENT;

ALTER TABLE `revendas_planos`
  MODIFY `codigo` int(10) NOT NULL AUTO_INCREMENT;

ALTER TABLE `screen_size`
  MODIFY `codigo` int(11) NOT NULL AUTO_INCREMENT;

ALTER TABLE `servidores`
  MODIFY `codigo` int(10) NOT NULL AUTO_INCREMENT;

ALTER TABLE `streamings`
  MODIFY `codigo` int(10) NOT NULL AUTO_INCREMENT;

ALTER TABLE `tutoriais`
  MODIFY `codigo` int(10) NOT NULL AUTO_INCREMENT;
COMMIT;

UPDATE `streamings` set transcoder_qualidades = '720p|360p|240p|160p';
ALTER TABLE `streamings` ADD `webrtc_chave` VARCHAR(255) NOT NULL;