<?php
require_once("inc/protecao-revenda.php");

// Estatísticas
$total_streamings = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM streamings WHERE codigo_cliente = '".$dados_revenda["codigo"]."'"));
$total_streamings_subrevendas = mysqli_fetch_array(mysqli_query($conexao,"SELECT SUM(streamings) as total FROM revendas WHERE codigo_revenda = '".$dados_revenda["codigo"]."'"));
$espectadores = mysqli_fetch_array(mysqli_query($conexao,"SELECT SUM(espectadores) as total FROM streamings WHERE codigo_cliente = '".$dados_revenda["codigo"]."'"));
$espectadores_subrevendas = mysqli_fetch_array(mysqli_query($conexao,"SELECT SUM(espectadores) as total FROM revendas WHERE codigo_revenda = '".$dados_revenda["codigo"]."'"));
$espaco_subrevendas = mysqli_fetch_array(mysqli_query($conexao,"SELECT SUM(espaco) as total FROM revendas WHERE codigo_revenda = '".$dados_revenda["codigo"]."'"));
$espaco_streamings = mysqli_fetch_array(mysqli_query($conexao,"SELECT SUM(espaco) as total FROM streamings WHERE codigo_cliente = '".$dados_revenda["codigo"]."'"));

$total_espectadores = $espectadores["total"]+$espectadores_subrevendas["total"];

$porcentagem_uso_streamings = ($dados_revenda["streamings"] == 0) ? "0" : ($total_streamings+$total_streamings_subrevendas["total"])*100/$dados_revenda["streamings"];
$porcentagem_uso_espectadores = ($dados_revenda["espectadores"] == 0) ? "0" : $total_espectadores*100/$dados_revenda["espectadores"];
$porcentagem_uso_espaco_ftp = ($dados_revenda["espaco"] == 0) ? "0" : ($espaco_subrevendas["total"]+$espaco_streamings["total"])*100/$dados_revenda["espaco"];

$stat_streamings_descricao = "(".$total_streamings." / ".str_replace("999999","<code>".lang_info_ilimitado."</code>",$dados_revenda["streamings"]).")";
$stat_espectadores_descricao = "(".$total_espectadores." / ".str_replace("999999","<code>".lang_info_ilimitado."</code>",$dados_revenda["espectadores"]).")";
$stat_espaco_descricao = "(".tamanho(($espaco_subrevendas["total"]+$espaco_streamings["total"]))." / ".tamanho($dados_revenda["espaco"]).")";

?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
        <title>[<?php echo $dados_revenda["id"]; ?>] Revenda - Reseller</title>
  <link rel="stylesheet" href="/inc/materialdesignicons.min.css">
  <link rel="stylesheet" href="/inc/font-awesome.min.css">
  <link rel="stylesheet" href="/inc/vendor.bundle.base.css">
  <link rel="stylesheet" href="/inc/vendor.bundle.addons.css">  
  <?php if($dados_revenda["tema_dark"] == "sim") { ?>
  <link rel="stylesheet" href="/inc/theme-dark.css">
  <?php } else { ?>
  <link rel="stylesheet" href="/inc/theme.css">
  <?php } ?>
  <link rel="shortcut icon" href="/img/favicon.ico" />
  <script type="text/javascript" src="/admin/inc/ajax-revenda.js"></script>
  <script type="text/javascript" src="/admin/inc/javascript.js"></script>
</head>
<body>
  <div class="container-scroller">
    <nav class="navbar col-lg-12 col-12 p-0 fixed-top d-flex flex-row">
      <div class="text-center navbar-brand-wrapper d-flex align-items-center justify-content-center">
        <?php if($dados_revenda["url_logo"]) { ?>
        <a class="navbar-brand brand-logo" href="/admin/revenda"><img id="logo" src="<?php echo $dados_revenda["url_logo"]; ?>" title="Painel" height="60" border="0"></a>
        <?php } else { ?>
        <a class="navbar-brand brand-logo" href="/admin/revenda"><span>Painel Revenda</span></a>
        <?php } ?>
        <a class="navbar-brand brand-logo-mini" href="/admin/revenda"><i class="fa fa-video-camera text-muted"></i></a>
      </div>
      <div class="navbar-menu-wrapper d-flex align-items-center justify-content-end justify-content-lg-start">
        <button class="navbar-toggler navbar-toggler align-self-center" type="button" data-toggle="minimize">
          <span class="mdi mdi-menu text-icones"></span>
        </button>
        <ul class="navbar-nav mr-lg-2">
          <li class="nav-item nav-search d-none d-lg-block">
            <div class="input-group">
              <div class="input-group-prepend">
                <span class="input-group-text" id="search">
                  <i class="mdi mdi-magnify"></i>
                </span>
              </div>
              <input type="text" class="form-control" id="busca_chave" placeholder="Busca" aria-label="search" aria-describedby="search">
            </div>
          </li>
        </ul>
        <ul class="navbar-nav navbar-nav-right">
          <li class="nav-item dropdown">
            <a class="nav-link count-indicator dropdown-toggle" id="notificationDropdown" href="#" data-toggle="dropdown">
              <i class="mdi mdi-bell-outline mx-0"></i>
              <span class="count"></span>            
            </a>
            <div class="dropdown-menu dropdown-menu-right navbar-dropdown preview-list" aria-labelledby="notificationDropdown" style="min-width: 300px">
              <a class="dropdown-item">
                <p class="mb-0 font-weight-normal float-left"><?php echo lang_info_pagina_informacoes_revenda_tab_avisos; ?></p>
              </a>
              <div class="dropdown-divider"></div>
              <?php carregar_avisos_revenda($conexao); ?>
            </div>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="/admin/sair"><i class="mdi mdi-logout f-22 text-icones" data-toggle="tooltip" data-placement="bottom" title="Sair/logout"></i></a>
          </li>
        </ul>
        <button class="navbar-toggler navbar-toggler-right d-lg-none align-self-center" type="button" data-toggle="offcanvas">
          <span class="mdi mdi-menu text-icones"></span>
        </button>
      </div>
    </nav>
    <div class="container-fluid page-body-wrapper">
      <nav class="sidebar sidebar-offcanvas" id="sidebar">
        <ul class="nav">
          <li class="nav-item">
            <a class="nav-link" href="/admin/revenda">
              <i class="fa fa-home text-icones"></i>
              <span class="menu-title">Dashboard</span>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="/admin/revenda-streamings">
              <i class="fa fa-video-camera text-icones"></i>
              <span class="menu-title"><?php echo lang_menu_streaming; ?></span>
            </a>
          </li>
          <?php if($dados_revenda["subrevendas"] > 0 && ($dados_revenda["tipo"] == 1 || $dados_revenda["tipo"] == 2)) { ?>
          <li class="nav-item">
            <a class="nav-link" href="/admin/revenda-subrevendas">
              <i class="fa fa-users text-icones"></i>
              <span class="menu-title"><?php echo lang_menu_subrevenda; ?></span>
            </a>
          </li>
          <?php } ?>
          <li class="nav-item">
            <a class="nav-link" href="/admin/revenda-busca-avancada">
              <i class="fa fa-search text-icones"></i>
              <span class="menu-title"><?php echo lang_menu_busca_avancada; ?></span>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" data-toggle="collapse" href="#integracao" aria-expanded="false" aria-controls="integracao">
              <i class="fa fa-tasks text-icones"></i>
              <span class="menu-title"><?php echo lang_menu_integracao; ?></span>
              <i class="menu-arrow"></i>
            </a>
            <div class="collapse" id="integracao">
              <ul class="nav flex-column sub-menu">
                <li class="nav-item"> <a class="nav-link" href="/admin/revenda-api"> <?php echo lang_menu_integracao_api; ?></a></li>
                <li class="nav-item"> <a class="nav-link" href="/admin/revenda-modulo-whmcs"> <?php echo lang_menu_integracao_modulo_whmcs; ?></a></li>
              </ul>
            </div>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="/admin/revenda-configuracoes">
              <i class="fa fa-cog text-icones"></i>
              <span class="menu-title"><?php echo lang_menu_configuracoes; ?></span>
            </a>
          </li>   
        </ul>
        </ul>
      </nav>
      <!-- partial -->
      <div class="main-panel">
        <div class="content-wrapper">
          <div id="local-status-acoes"><?php echo $_SESSION['status_acao'];unset($_SESSION['status_acao']); ?></div>
          <form method="post" action="/admin/revenda-cadastra-streaming" name="cadastrar">
          <div class="row">            

            <div class="col-lg-12">
              <div class="card">
                  <div class="card-header">
                    <header><?php echo lang_info_pagina_cadastrar_streaming_tab_titulo; ?></header>
                  </div>
                <div class="card-body">
                    <table width="100%" border="0" align="center" cellpadding="0" cellspacing="0">
                                          <tr>
                                            <td height="50" align="left" style="padding-left:5px;"><strong><?php echo lang_info_pagina_cadastrar_streaming_login; ?></strong></td>
                                            <td align="left"><input name="login" type="text" class="form-control" id="login" style="width:100%;" value="" /></div>
                                        </td>
                                          </tr>
                                          <tr>
                                            <td width="160" height="50" align="left" style="padding-left:5px;"><strong><?php echo lang_info_pagina_cadastrar_streaming_espectadores; ?></strong></td>
                                        <td align="left"><input name="espectadores" type="text" class="form-control" id="espectadores" style="width:100%;" value="" />&nbsp;
                                        <?php if($dados_revenda["espectadores"] == '999999') { ?>
                                        <input type="checkbox" id="espectadores_ilimitados" onclick="configurar_ilimitados('espectadores');" style="vertical-align:middle" />&nbsp;<code><?php echo lang_info_pagina_cadastrar_streaming_espectadores_ilimitados; ?></code>
                                        <?php } ?>
                                        </td>
                                      </tr>
                                      <tr>
                                        <td height="50" align="left" style="padding-left:5px;"><strong><?php echo lang_info_pagina_cadastrar_streaming_bitrate; ?></strong></td>
                                        <td align="left"><div class="input-group"><input name="bitrate" type="text" class="form-control" id="bitrate" style="width:60%;" value="" /><span class="input-group-append" id="basic-addon3"><label class="input-group-text">Kbps</label></span></div>
                                    </td>
                                      </tr>
                                      <tr>
                                        <td height="50" align="left" style="padding-left:5px;"><strong><?php echo lang_info_pagina_cadastrar_streaming_espaco_ftp; ?></strong></td>
                                        <td align="left"><div class="input-group"><input name="espaco" type="text" class="form-control" id="espaco" style="width:60%;" value="" /><span class="input-group-append" id="basic-addon3"><label class="input-group-text">MB</label></span></div></td>
                                      </tr>
                                      <tr>
                                        <td height="50" align="left" style="padding-left:5px;"><strong><?php echo lang_info_pagina_cadastrar_streaming_senha; ?></strong></td>
                                        <td align="left"><div class="input-group"><input name="senha" type="text" class="form-control" id="senha" style="width:60%; vertical-align:middle" value="" /><span class="input-group-append" id="basic-addon3" onclick="gerar_senha('senha');"><label class="input-group-text" style="cursor: pointer;"><i class="fa fa-lock text-yellow">&nbsp;</i></label></span></div></td>
                                      </tr>
                                      <tr>
                                        <td height="50" align="left" style="padding-left:5px;"><strong><?php echo lang_info_pagina_cadastrar_streaming_identificacao; ?></strong></td>
                                        <td align="left"><input name="identificacao" type="text" class="form-control" id="identificacao" style="width:100%;" data-toggle="tooltip" data-placement="bottom" title="<?php echo lang_info_pagina_cadastrar_streaming_identificacao_ajuda; ?>" /></td>
                                      </tr>
                                      <tr>
                                        <td height="50" align="left" style="padding-left:5px;"><strong><?php echo lang_info_pagina_cadastrar_streaming_idioma; ?></strong></td>
                                        <td align="left">
                                        <select name="idioma_painel" id="idioma_painel" class="form-control" style="width:100%;" data-toggle="tooltip" data-placement="bottom" title="<?php echo lang_info_pagina_cadastrar_streaming_idioma_ajuda; ?>">
                                          <option value="pt-br" selected="selected">Portugu&ecirc;s(Brasil)</option>
                                          <option value="es">Espa&ntilde;ol</option>
                                          <option value="en-us">English(USA)</option>
                                        </select></td>
                                      </tr>
                                      <tr>
                                        <td height="50" align="left" style="padding-left:5px;"><strong><?php echo lang_info_pagina_cadastrar_streaming_email; ?></strong></td>
                                        <td align="left"><input name="email" type="text" class="form-control" id="email" style="width:100%;" data-toggle="tooltip" data-placement="bottom" title="<?php echo lang_info_pagina_cadastrar_streaming_email_ajuda; ?>" /></td>
                                          </tr>
                                          <tr>
                                            <td width="150" height="30" align="left" style="padding-left:5px;"><strong><?php echo lang_info_pagina_cadastrar_streaming_aplicacao; ?></strong></td>
                                            <td align="left">
                                              <select name="aplicacao" id="aplicacao" class="form-control" style="width:100%;" onchange="validar_aplicacao( this.value );" data-toggle="tooltip" data-placement="bottom" title="<?php echo lang_info_pagina_cadastrar_streaming_aplicacao_info_ajuda; ?>">
                                              <option value="tvstation" selected="selected">Tv Station (live & playlist)</option>
                                              <option value="webrtc">WebRTC(baixo delay ao vivo)</option>
                                              <option value="live">Live</option>
                                              <option value="vod">OnDemand</option>
                                              <option value="ipcamera">IP Camera</option>
                                            </select></td>
                                          </tr>
                                          <tr>
                                            <td height="50" colspan="2" align="right"><button type="button" class="btn btn-info" onClick="document.cadastrar.submit();"><?php echo lang_botao_titulo_cadastrar; ?></button></td>
                                          </tr>
                                    </table>
                </div>
              </div>
            </div>        

            <div class="col-lg-12">
              <div class="card">
                  <div class="card-header">
                    <header><?php echo lang_info_pagina_cadastrar_streaming_aba_recursos; ?></header>
                  </div>
                <div class="card-body">
                     <table width="100%" border="0" align="center" cellpadding="0" cellspacing="0">
                                          <tr>
                                            <td width="170" height="50" align="left" style="padding-left:5px;"><strong><?php echo lang_info_pagina_cadastrar_streaming_permitir_alterar_senha; ?></strong></td>
                                            <td align="left"><input type="checkbox" id="permitir_alterar_senha" name="permitir_alterar_senha" value="sim" checked /></td>
                                          </tr>
                                          <tr>
                                            <td height="50" align="left" style="padding-left:5px;"><strong><?php echo lang_info_pagina_cadastrar_streaming_app_android; ?></strong></td>
                                                <td align="left"><input type="checkbox" id="exibir_app_android" name="exibir_app_android" value="sim" checked /></td>
                                            </tr>
                                          <tr>
                                            <td height="50" align="left" style="padding-left:5px;"><strong><?php echo lang_info_pagina_cadastrar_streaming_autenticacao; ?></strong></td>
                                                <td align="left" data-toggle="tooltip" data-placement="bottom" title="<?php echo lang_info_pagina_cadastrar_streaming_autenticacao_info; ?>"><input type="checkbox" id="autenticar_live" name="autenticar_live" value="sim" checked /></td>
                                            </tr>
                                          <?php if($dados_revenda["lives"] == 'sim') { ?>
                                          <tr>
                                            <td height="50" align="left" style="padding-left:5px;"><strong>Lives</strong></td>
                                            <td align="left"><input type="checkbox" id="lives" name="lives" value="sim" checked /></td>
                                          </tr>
                                          <?php } ?>
                                        </table>
                </div>
              </div>
            </div>

            <div class="col-lg-12">
              <div class="card">
                  <div class="card-header">
                    <header><?php echo lang_info_pagina_cadastrar_subrevenda_estatisticas_tab_titulo; ?></header>
                  </div>
                <div class="card-body">
                    <p class="mb-10"><?php echo lang_info_pagina_cadastrar_subrevenda_estatisticas_stm; ?> <small><?php echo $stat_streamings_descricao; ?></small></p>
                                        <div class="progress mb-30">
                                            <div class="progress-bar bg-twitter" style="width:<?php echo $porcentagem_uso_streamings; ?>%"></div>
                                        </div>
                                        <p class="mb-10"><?php echo lang_info_pagina_cadastrar_subrevenda_estatisticas_espectadores; ?> <small><?php echo $stat_espectadores_descricao; ?></small></p>
                                        <div class="progress mb-30">
                                            <div class="progress-bar bg-twitter" style="width:<?php echo $porcentagem_uso_espectadores; ?>%"></div>
                                        </div>
                                        <p class="mb-10"><?php echo lang_info_pagina_cadastrar_subrevenda_estatisticas_espaco_ftp; ?> <small><?php echo $stat_streamings_descricao; ?></small></p>
                                        <div class="progress mb-30">
                                            <div class="progress-bar bg-twitter" style="width:<?php echo $porcentagem_uso_espaco; ?>%"></div>
                                        </div>
                </div>
              </div>
            </div>

          </div>
        </form>
        </div>
      </div>
      <!-- modal -->
      <div class="modal fade" id="avisos" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo $lang['lang_info_pagina_informacoes_tab_avisos']; ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body" id="avisos-conteudo"><img src="/img/ajax-loader.gif" align="center" /></div>
            </div>
        </div>
        </div>
                
        <div class="modal fade" id="log-sistema" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-body" id="log-sistema-conteudo" style="text-align:center"><img src="/img/ajax-loader.gif" /></div>
            </div>
        </div>
      </div>
    </div>
  </div>
  <script src="/inc/vendor.bundle.base.js"></script>
  <script src="/inc/vendor.bundle.addons.js"></script>
  <script src="/inc/theme.js"></script>
  <script>
  $('#busca_chave').keypress(function (e) {
    if (e.which == 13) {
       window.location = "/admin/revenda-streamings/resultado/porta/"+document.getElementById("busca_chave").value;
    }
  }); 
  </script>
</body>
</html>