angular.module('MonstaFTP').run(['$templateCache', function($templateCache) {$templateCache.put('application/frontend/templates/body-files.html','<div id="files" ng-controller="FileBrowserController as vm" ng-mousedown="vm.handleBodyClick($event)" oncontextmenu="return false">\n    <ng-include src="\'application/frontend/templates/body-order-by.html\'"></ng-include>\n    <div class="dropdown">\n        <button data-toggle="dropdown" style="display: none" id="extras-dropdown-button"></button>\n        <ul class="dropdown-menu" id="extras-dropdown">\n            <li ng-click="vm.initiateMakeItem(\'FILE\')" ng-show="vm.allowFileCreation &amp;&amp; !vm.contextMenuItemHidden(\'new-file\')">\n                <a href="#">\n                    <i class="fa fa-file-o fa-fw"></i> {{ \'NEW_FILE_DEFERRED_ACTION\'|translate }}\n                </a>\n            </li>\n            <li ng-click="vm.initiateMakeItem(\'FOLDER\')" ng-show="!vm.contextMenuItemHidden(\'new-folder\')">\n                <a href="#">\n                    <i class="fa fa-folder-o fa-fw"></i> {{ \'NEW_FOLDER_DEFERRED_ACTION\'|translate }}\n                </a>\n            </li>\n            <li role="separator" class="divider" ng-show="(!vm.contextMenuItemHidden(\'new-folder\') || (!vm.contextMenuItemHidden(\'new-file\') &amp;&amp; vm.allowFileCreation)) &amp;&amp; !vm.contextMenuItemHidden(\'paste\')"></li>\n            <li data-name="paste" ng-click="vm.performPaste()" ng-show="!vm.contextMenuItemHidden(\'paste\')">\n                <a href="#" ng-class="{inactive: !hasPasteSource}" >\n                    <i class="fa fa-clipboard fa-fw"></i> {{ \'PASTE_ACTION\'|translate }}\n                </a>\n            </li>\n        </ul>\n    </div>\n    <table>\n        <thead class="mobile-hide">\n            <tr>\n                <td class="spacer"></td>\n                <td class="icon" ng-hide="vm.browserColumnHidden(\'icon\')"></td>\n                <td class="file" ng-hide="vm.browserColumnHidden(\'name\')">\n                    <monsta-reorder vm="vm" sort-name="NAME" sort-identifier="name"></monsta-reorder>\n                </td>\n                <td class="spacer"></td>\n                <td class="size" ng-hide="vm.browserColumnHidden(\'size\')">\n                    <monsta-reorder vm="vm" sort-name="SIZE" sort-identifier="size"></monsta-reorder>\n                </td>\n                <td class="modified" ng-hide="vm.browserColumnHidden(\'modified\')">\n                    <monsta-reorder vm="vm" sort-name="CHANGED" sort-identifier="modified"></monsta-reorder>\n                </td>\n                <td class="spacer"></td>\n                <td class="permissions" ng-hide="vm.browserColumnHidden(\'permissions\')">\n                    {{ "PERMISSIONS"|translate }}\n                </td>\n                <td class="other" ng-hide="vm.browserColumnHidden(\'properties\')"></td>\n                <td class="spacer"></td>\n            </tr>\n        </thead>\n        <tbody>\n            <tr ng-if="vm.uiOperationFactory.currentDirectory != null && vm.uiOperationFactory.currentDirectory != \'\' && vm.uiOperationFactory.currentDirectory != \'/\'">\n                <td class="spacer"></td>\n                <td class="icon" ng-click="vm.navigateUpOneLevel()" ng-hide="vm.browserColumnHidden(\'icon\')">\n                    <i class="fa fa-level-up fa-fw"></i>\n                </td>\n                <td class="file" ng-hide="vm.browserColumnHidden(\'name\')">\n                    <span class="up" ng-click="vm.navigateUpOneLevel()">..</span>\n                </td>\n                <td class="spacer"></td>\n                <td class="size" ng-hide="vm.browserColumnHidden(\'size\')"></td>\n                <td class="modified mobile-hide" ng-hide="vm.browserColumnHidden(\'modified\')"></td>\n                <td class="spacer mobile-hide"></td>\n                <td class="permissions mobile-hide" ng-hide="vm.browserColumnHidden(\'permissions\')"></td>\n                <td class="other" ng-hide="vm.browserColumnHidden(\'properties\')"></td>\n                <td class="spacer mobile-hide"></td>\n            </tr>\n            <tr ng-repeat="item in directoryList" ng-class-odd="\'tr-odd\'" ng-class-even="\'tr-even\'"\n                ng-class="{\'ui-selected\': selectedItems.indexOf($index) != -1}"\n                class="context-catcher-tr"\n                ng-mousedown="vm.rowMouseDown($event)"\n                ng-mousemove="vm.rowMouseMove($event, $index)"\n                ng-mouseup="vm.rowMouseUp($index)"\n                ng-mouseleave="vm.rowMouseLeave($event)"\n                data-index="{{ $index }}">\n                <td class="spacer"></td>\n                <td class="icon" ng-hide="vm.browserColumnHidden(\'icon\')">\n                    <i class="fa {{ item|icon }} fa-fw"></i>\n                </td>\n                <td class="file" ng-hide="vm.browserColumnHidden(\'name\')">\n                    <div class="dropdown file-toolbar" ondragstart="return false;">\n                        <button data-toggle="dropdown" class="context-catcher-button">\n                            <i ng-if="!vm.shouldHideContextMenu()" class="fa fa-caret-down"></i>\n                        </button>\n                        <div class="file-wrapper">\n                            <span ng-click="handleClick($event, $index)">{{ item.name|spaces_to_nbsp }}</span>\n                        </div>\n                        <ul class="dropdown-menu" ng-if="!vm.shouldHideContextMenu()">\n                            <li ng-click="handleClick($event, $index)" ng-show="item.isDirectory &amp;&amp; selectedItems.length == 1 &amp;&amp; !vm.contextMenuItemHidden(\'open\')">\n                                <a href="#">\n                                    <i class="fa fa-fw fa-folder-open-o"></i> {{"OPEN_ACTION"|translate}}\n                                </a>\n                            </li>\n                            <li ng-class="{disabled: !vm.isLicensed}" ng-if="vm.enableFileEdit" ng-click="editItem(item)" ng-show="vm.itemIsEditable(item.isDirectory, item.name) &amp;&amp; selectedItems.length == 1 &amp;&amp; !vm.contextMenuItemHidden(\'edit\')">\n                                <a href="#">\n                                    <i class="fa fa-fw fa-pencil-square-o"></i> {{"EDIT_ACTION"|translate}}\n                                </a>\n                            </li>\n                            <li ng-if="vm.isArchiveFilename(item.name)" ng-click="vm.initiateArchiveExtract(item)" ng-show="vm.archiveUploadAllowed &amp;&amp; !vm.contextMenuItemHidden(\'extract\')">\n                                <a href="#">\n                                    <i class="fa fa-fw fa-expand"></i> {{"EXTRACT_ACTION"|translate}}\n                                </a>\n                            </li>\n                            <li ng-if="vm.enableFileView && !vm.enableFileEdit" ng-click="editItem(item)" ng-show="vm.itemIsEditable(item.isDirectory, item.name) &amp;&amp; selectedItems.length == 1 &amp;&amp; !vm.contextMenuItemHidden(\'view\')">\n                                <a href="#">\n                                    <i class="fa fa-fw fa-eye"></i> {{"VIEW_ACTION"|translate}}\n                                </a>\n                            </li>\n                            <li ng-click="vm.downloadSelectedFiles()" ng-hide="vm.contextMenuItemHidden(\'download\')">\n                                <a href="#">\n                                    <i class="fa fa-fw fa-download"></i> {{"DOWNLOAD_ACTION"|translate}}\n                                </a>\n                            </li>\n                            <li ng-click="vm.copyItemName(item.name)" ng-hide="vm.contextMenuItemHidden(\'copy-name\')">\n                                <a href="#">\n                                    <i class="fa fa-fw fa-clipboard"></i> {{"COPY_NAME_ACTION"|translate}}\n                                </a>\n                            </li>\n                            <li ng-click="vm.createZip()" ng-hide="vm.contextMenuItemHidden(\'create-zip\')">\n                                <a href="#">\n                                    <i class="fa fa-fw fa-file-archive-o"></i> {{"CREATE_ZIP_ACTION"|translate}}\n                                </a>\n                            </li>\n\n                            <li role="separator" class="divider"\n                                ng-show="(!vm.contextMenuItemHidden(\'open\') || !vm.contextMenuItemHidden(\'edit\') || !vm.contextMenuItemHidden(\'view\') || !vm.contextMenuItemHidden(\'download\') || !vm.contextMenuItemHidden(\'copy-name\') || !vm.contextMenuItemHidden(\'create-zip\'))"></li>\n                            <li ng-click="vm.initiateCutOfSelectedPaths()" ng-hide="vm.contextMenuItemHidden(\'cut\')">\n                                <a href="#">\n                                    <i class="fa fa-fw fa-scissors"></i> {{"CUT_ACTION"|translate}}\n                                </a>\n                            </li>\n                            <li ng-click="vm.initiateCopyOfSelectedPaths()" ng-hide="vm.contextMenuItemHidden(\'cut\')">\n                                <a href="#">\n                                    <i class="fa fa-fw fa-clone"></i> {{"COPY_ACTION"|translate}}\n                                </a>\n                            </li>\n                            <li ng-click="initiateRenameOfItem(item)" ng-show="selectedItems.length == 1 &amp;&amp; !vm.contextMenuItemHidden(\'rename\')">\n                                <a href="#">\n                                       <i class="fa fa-fw fa-i-cursor">_</i> {{"RENAME_DEFERRED_ACTION"|translate}}\n                                </a>\n                            </li>\n                            <li ng-click="vm.initiateDeleteOfSelectedPaths()" ng-hide="vm.contextMenuItemHidden(\'delete\')">\n                                <a href="#">\n                                    <i class="fa fa-fw fa-trash-o"></i> {{"DELETE_DEFERRED_ACTION"|translate}}\n                                </a>\n                            </li>\n                            <li ng-if="vm.enableChmod" ng-click="vm.initiateChmodOfSelectedItems()" ng-hide="vm.contextMenuItemHidden(\'chmod\')">\n                                <a href="#">\n                                    <i class="fa fa-fw fa-key"></i> {{"CHMOD_ACTION"|translate}}\n                                </a>\n                            </li>\n                            <li role="separator" class="divider" ng-show="selectedItems.length == 1 &amp;&amp; !vm.contextMenuItemHidden(\'properties\')"></li>\n                            <li ng-click="vm.showProperties(item)" ng-show="selectedItems.length == 1 &amp;&amp; !vm.contextMenuItemHidden(\'properties\')">\n                                <a href="#">\n                                    <i class="fa fa-info-circle fa-fw"></i> {{ \'PROPERTIES\'|translate }}\n                                </a>\n                            </li>\n                        </ul>\n                    </div>\n                </td>\n                <td class="spacer"></td>\n                <td class="size" ng-hide="vm.browserColumnHidden(\'size\')">\n                    <span ng-show="!item.isDirectory">{{ item.size|file_size }}</span>\n                </td>\n                <td class="modified mobile-hide" ng-hide="vm.browserColumnHidden(\'modified\')">\n                    {{ item.modificationDate|file_last_modified }}\n                </td>\n                <td class="spacer mobile-hide"></td>\n                <td class="permissions mobile-hide" ng-hide="vm.browserColumnHidden(\'permissions\')">\n                    <span ng-click="vm.initiateChmodOfItem(item)">{{ item|item_permission_description }}</span>\n                </td>\n                <td class="other" ng-click="vm.showProperties(item)" title="{{ \'PROPERTIES\'|translate }}" ng-hide="vm.browserColumnHidden(\'properties\')">\n                    <i class="fa fa-ellipsis-v"></i>\n                </td>\n                <td class="spacer mobile-hide"></td>\n            </tr>\n        </tbody>\n    </table>\n</div>');
$templateCache.put('application/frontend/templates/body-footer.html','<div id="footer" class="toolbar" ng-controller="FooterController as vm">\n    <div class="float-left">\n        <input type="file" id="upload-placeholder" style="display: none" multiple>\n        <input type="file" id="upload-folder-placeholder" style="display: none" directory mozdirectory webkitdirectory odirectory msdirectory>\n        <div class="dropup mobile-show float-left">\n            <button class="fa fa-bars fa-fw active" data-toggle="dropdown" aria-haspopup="true"\n                    aria-expanded="false"></button>\n            <ul class="dropdown-menu">\n                <monsta-footer-menu-item\n                        ng-if="vm.enableChmod"\n                        vm="vm" active-condition="selectedItemsCount > 0"\n                        item-title="CHMOD_ACTION" identifier="chmod" icon-class="fa-key"></monsta-footer-menu-item>\n                <monsta-footer-menu-item\n                        vm="vm" active-condition="selectedItemsCount > 0"\n                        item-title="CUT_ACTION" identifier="cut" icon-class="fa-cut">\n                </monsta-footer-menu-item>\n                <monsta-footer-menu-item\n                        vm="vm" active-condition="selectedItemsCount > 0"\n                        item-title="COPY_ACTION" identifier="copy" icon-class="fa-copy">\n                </monsta-footer-menu-item>\n\n                <monsta-footer-menu-item\n                        vm="vm" active-condition="hasPasteSource == true"\n                        item-title="PASTE_ACTION" identifier="paste" icon-class="fa-clipboard">\n                </monsta-footer-menu-item>\n\n                <monsta-footer-menu-item\n                        vm="vm" active-condition="selectedItemsCount > 0"\n                        item-title="DELETE_DEFERRED_ACTION" identifier="delete" icon-class="fa-trash">\n                </monsta-footer-menu-item>\n\n                \n\n                         </ul>\n        </div>\n        <div class="dropup float-left">\n            <button class="fa fa-upload fa-fw active" title="{{ \'UPLOAD_DEFERRED_ACTION\'|translate }}" data-toggle="dropdown" aria-haspopup="true"\n                    aria-expanded="false" ng-hide="vm.itemHidden(\'upload\')"></button>\n            <ul class="dropdown-menu">\n                <monsta-footer-menu-item\n                        vm="vm" item-title="UPLOAD_FILE_DEFERRED_ACTION" identifier="upload-file"\n                        icon-class="fa-file-text-o">\n                </monsta-footer-menu-item>\n\n                <monsta-footer-menu-item\n                        vm="vm" item-title="UPLOAD_FOLDER_DEFERRED_ACTION" identifier="upload-folder"\n                        icon-class="fa-folder-o">\n                </monsta-footer-menu-item>\n\n     </ul>\n        </div>\n        <div class="float-left">\n            <monsta-footer-button\n                    vm="vm" active-condition="selectedItemsCount > 0" item-title="DOWNLOAD_ACTION" identifier="download"\n                    icon-class="fa-download">\n            </monsta-footer-button>\n        </div>\n        <div class="mobile-hide float-left">\n        </div>\n        <div class="dropup float-left">\n            <button class="fa fa-plus-square-o fa-fw active" title="{{ \'NEW_FILE_FOLDER_DEFERRED_ACTION\'|translate }}" data-toggle="dropdown" aria-haspopup="true"\n                    aria-expanded="false" ng-hide="vm.itemHidden(\'new-item\')"></button>\n            <ul class="dropdown-menu">\n                <monsta-footer-menu-item\n                        ng-if="vm.enableFileEdit"\n                        active-condition="vm.isLicensed"\n                        disabled-condition="!vm.isLicensed"\n                        vm="vm" item-title="NEW_FILE_DEFERRED_ACTION" identifier="new-file"\n                        icon-class="fa-file-o">\n                </monsta-footer-menu-item>\n\n                <monsta-footer-menu-item\n                        vm="vm" item-title="NEW_FOLDER_DEFERRED_ACTION" identifier="new-folder"\n                        icon-class="fa-folder-o">\n                </monsta-footer-menu-item>\n            </ul>\n        </div>\n\n        <div class="float-left">\n            <monsta-footer-button\n                    ng-if="vm.enableFileEdit"\n                    vm="vm" active-condition="editorActive == true" item-title="SHOW_EDITOR_ACTION" identifier="show-editor"\n                    disabled-condition="!vm.isLicensed"\n                    icon-class="fa-pencil-square-o">\n            </monsta-footer-button>\n            <monsta-footer-button\n                    ng-if="!vm.enableFileEdit &amp;&amp; vm.enableFileView"\n                    vm="vm" active-condition="editorActive == true" item-title="SHOW_EDITOR_ACTION" identifier="show-editor"\n                    icon-class="fa-eye">\n            </monsta-footer-button>\n        </div>\n\n        <div class="mobile-hide float-left">\n            <monsta-footer-button\n                    vm="vm" active-condition="selectedItemsCount > 0" item-title="CUT_ACTION" identifier="cut"\n                    icon-class="fa-cut">\n            </monsta-footer-button>\n\n            <monsta-footer-button\n                    vm="vm" active-condition="selectedItemsCount > 0" item-title="COPY_ACTION" identifier="copy"\n                    icon-class="fa-copy">\n            </monsta-footer-button>\n\n            <monsta-footer-button\n                    vm="vm" active-condition="hasPasteSource == true" item-title="PASTE_ACTION" identifier="paste"\n                    icon-class="fa-clipboard">\n            </monsta-footer-button>\n\n            <monsta-footer-button\n                    vm="vm" active-condition="selectedItemsCount > 0" item-title="DELETE_DEFERRED_ACTION" identifier="delete"\n                    icon-class="fa-trash">\n            </monsta-footer-button>\n            \n            <monsta-footer-button\n                    ng-if="vm.enableChmod"\n                    vm="vm" active-condition="selectedItemsCount > 0" item-title="CHMOD_ACTION" identifier="chmod"\n                    icon-class="fa-key">\n            </monsta-footer-button>\n        </div>\n    </div>\n    <div class="float-right">\n        <div id="session" class="dropup" ng-class="{\'open\': vm.sessionDisplayForce}">\n            <button class="fa fa-info-circle fa-fw" title="{{ \'SESSION_INFORMATION\'|translate }}" data-toggle="dropdown"\n                    aria-haspopup="true" aria-expanded="false" ng-class="{active: vm.isLoggedIn, inactive: !vm.isLoggedIn}"\n                    ng-hide="vm.itemHidden(\'session-information\')"></button>\n            <ul class="dropdown-menu dropdown-menu-right">\n                <li title="{{ \'CURRENT_HOST\'|translate }}" ng-if="vm.showRemoteServerAddress"\n                    ng-hide="currentHost == null || vm.itemHidden(\'remote-server\')">\n                    <i class="fa fa-server fa-fw"></i> {{ currentHost }}\n                </li>\n                <li title="{{ \'CURRENT_USER\'|translate }}" ng-hide="currentUsername == null || vm.itemHidden(\'username\')">\n                    <i class="fa fa-user fa-fw"></i> {{ currentUsername }}\n                </li>\n                <li title="{{ \'FILE_UPLOAD_LIMIT\'|translate }}" ng-hide="maxUploadBytes == -1 || vm.itemHidden(\'upload-limit\')">\n                    <i class="fa fa-upload fa-fw"></i> {{ maxUploadBytes|file_size }}\n                </li>\n                <li title="{{ \'CURRENT_VERSION\'|translate }}" ng-hide="vm.itemHidden(\'version\')">\n                    <i class="fa fa-info-circle fa-fw"></i> {{ "VERSION"|translate }} {{ currentVersion }}\n                </li>\n            </ul>\n        </div>\n    </div>\n    <div class="version-alerter float-right" ng-show="newVersionAvailable && !vm.itemHidden(\'new-version-alert\')">\n    \t<a href="#" ng-click="vm.showUpdateModal()"><i class="fa fa-exclamation-triangle fa-fw fa-2x active version-alert" title="{{ NEW_VERSION_AVAILABLE|translate }}"></i></a>\n    </div>\n</div>');
$templateCache.put('application/frontend/templates/body-header.html','<div id="header" class="toolbar" ng-controller="HeaderController as vm">\n    <div class="float-left">\n        <button class="fa fa-chevron-left fa-fw" ng-class="{active: vm.canGoBack, inactive: !vm.canGoBack}"\n                ng-click="vm.navigateBack()" title="{{ \'BACK_ACTION\'|translate }}"\n                ng-hide="vm.itemHidden(\'back\')"></button>\n        <button class="fa fa-chevron-right fa-fw" ng-class="{active: vm.canGoForward, inactive: !vm.canGoForward}"\n                ng-click="vm.navigateForward()" title="{{ \'FORWARD_ACTION\'|translate }}"\n                ng-hide="vm.itemHidden(\'forward\')"></button>\n        <button ng-click="vm.refresh()" class="fa fa-refresh fa-fw active" title="{{ \'REFRESH_ACTION\'|translate }}"\n            ng-hide="vm.itemHidden(\'refresh\')"></button>\n        <!--button class="fa fa-search fa-fw active" title="{{ \'SEARCH_DEFERRED_ACTION\'|translate }}"></button-->\n    </div>\n    <div class="float-right">\n        <span class="spacer"></span>\n        <span class="spacer"></span>\n        <button class="fa fa-bars fa-fw active" id="slidebar-toggle" title="{{ \'MENU_ACTION\'|translate }}"></button>\n    </div>\n</div>');
$templateCache.put('application/frontend/templates/body-history.html','<div id="history" class="dropdown" ng-controller="HistoryController as vm">\n    <button class="fa fa-history fa-fw" data-toggle="dropdown" aria-haspopup="true" aria-expanded="true" title="{{ \'HISTORY\'|translate }}">\n        <span class="caret"></span>\n    </button>\n    <ul id="history-ul" class="dropdown-menu .pull-down" aria-labelledby="history-toggle" >\n        <li title="{{ path }}" ng-repeat="path in vm.sortedHistory" ng-click="historyClick(path)">\n            <span>{{ path }}</span>\n        </li>\n\n    \t<li class="title" ng-show="vm.recentHistory.length == 0 &amp;&amp; vm.sortedHistory.length == 0" translate>\n            HISTORY_EMPTY_MESSAGE\n        </li>\n    </ul>\n    <div id="breadcrumb" ng-controller="BreadcrumbController as bc" ondragstart="return false;">\n        <ol id="breadcrumb-ol" class="breadcrumb">\n            <li ng-click="bc.changeDirectoryToItem(0)" id="breadcrumb__home_link">\n                <a href="#">\n                    <i class="fa fa-home fa-fw"></i>\n    \t\t\t</a>\n            </li>\n        </ol>\n    </div>\n</div>');
$templateCache.put('application/frontend/templates/body-order-by.html','<div id="order-by" class="mobile-show">\n    <div class="dropdown">\n        <button data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">\n            {{ vm.sortName|sort_description|translate }}\n            <i class="fa" ng-class="{\'fa-caret-up\': !vm.sortReversed, \'fa-caret-down\': vm.sortReversed}" aria-hidden="true"></i>\n        </button>\n        <ul class="dropdown-menu">\n            <monsta-reorder-mobile vm="vm" sort-name="NAME" sort-identifier="name"></monsta-reorder-mobile>\n            <monsta-reorder-mobile vm="vm" sort-name="SIZE" sort-identifier="size"></monsta-reorder-mobile>\n            <monsta-reorder-mobile vm="vm" sort-name="CHANGED" sort-identifier="modified"></monsta-reorder-mobile>\n            <monsta-reorder-mobile vm="vm" sort-name="TYPE" sort-identifier="type"></monsta-reorder-mobile>\n        </ul>\n    </div>    \n</div>    ');
$templateCache.put('application/frontend/templates/body-slidebar.html','<div id="slidebar" off-canvas="slidebar right overlay" ng-controller="SlidebarController as vm">\n    <i class="fa fa-sign-in fa-fw" title="{{ \'LOG_OUT_DEFERRED_ACTION\'|translate }}" ng-click="vm.initiateLogout()" ng-hide="vm.itemHidden(\'logout\')"></i>\n    <i ng-if="vm.showChangeServerButton" ng-hide="vm.itemHidden(\'change-server\')" class="fa fa-server fa-fw" title="{{ \'CHANGE_SERVER_ACTION\'|translate }}" ng-click="vm.showLoginPanel()"></i>\n    <i class="fa fa-cog fa-fw" title="{{ \'SETTINGS\'|translate }}" ng-click="vm.showSettingsModal()" ng-hide="vm.itemHidden(\'settings\')"></i>\n    \n</div>');
$templateCache.put('application/frontend/templates/modal-addons.html','<div class="modal fade" id="modal-addons" tabindex="-1" role="dialog" aria-labelledby="modal-addons-label"\n     ng-controller="ModalAddonsController as vm">\n    <div class="modal-dialog" role="document">\n        <div class="modal-content">\n            <div class="modal-header label-warning">\n                <button type="button" class="close" data-dismiss="modal" aria-label="{{ \'DISMISS_CLOSE_ACTION\'|translate }}"><span\n                        aria-hidden="true">&times;</span></button>\n                <h4 class="modal-title" id="modal-addons-label">{{\'ADD_ONS\'|translate}}</h4>\n            </div>\n            <div class="modal-body">\n                <div class="alert alert-danger" role="alert" ng-if="!vm.openSslAvailable">\n                    <p>Your PHP install does not have the OpenSSL library enabled, without it your license key can not be read.\n                        Please see the\n                        <a href="http://php.net/manual/en/book.openssl.php" target="mftp-new" rel="nofollow noreferrer">PHP OpenSSL Documentation</a>\n                        for installation instructions and more information.\n                    </p>\n                </div>\n\n                <div class="license-type">{{ vm.productEditionShortName|translate }}</div>\n                <span ng-show="vm.isLicensed">\n                    {{ \'LICENSE_VALID_UNTIL_MESSAGE\'|translate:{ expiry_date:vm.formattedExpiryDate } }}\n                </span>\n                <div>\n                    <p class="alert alert-danger" ng-show="vm.licenseExpired">\n                    {{ \'LICENSE_EXPIRED_ON_MESSAGE\'|translate:{ expiry_date:vm.formattedExpiryDate } }}\n                    <br/>\n                    <a href="http://redirect.monstaftp.com/renew" target="mftp-new" rel="noopener noreferrer" translate>RENEW_NOW_MESSAGE</a>\n                    </p>\n                </div>\n                <span ng-show="!vm.isLicensed && !vm.licenseExpired">\n                    <a href="http://redirect.monstaftp.com/upgrade" target="mftp-new" rel="noopener noreferrer" translate>UPGRADE_MESSAGE_GENERAL</a>\n                </span>\n                <textarea ng-model="vm.models.license" placeholder="{{ (vm.isLicensed ? \'LICENSE_UPDATE_PLACEHOLDER\' : \'LICENSE_NEW_PLACEHOLDER\')|translate }}"> </textarea>\n                <div class="alert alert-danger" role="alert"\n                     ng-hide="vm.licenseUpdateError == null || vm.licenseUpdateError == \'\'">\n                    <strong class="error--attention" translate>ERROR_ATTENTION</strong> {{ vm.licenseUpdateError }}\n                </div>\n                <button class="btn btn-primary" ng-click="vm.updateLicense()" translate>SAVE_LICENSE_ACTION</button>\n            </div>\n            <div class="modal-footer">\n                <button type="button" class="btn btn-default" data-dismiss="modal">{{ \'DISMISS_OK_ACTION\'|translate }}</button>\n            </div>\n        </div>\n    </div>\n</div>');
$templateCache.put('application/frontend/templates/modal-chmod.html','<div class="modal fade" id="modal-chmod" tabindex="-1" role="dialog" aria-labelledby="modal-chmod-label" ng-controller="ModalPermissionsController">\n\t<div class="modal-dialog" role="document">\n\t\t<div class="modal-content">\n\t\t\t<div class="modal-header label-warning">\n\t\t\t\t<button type="button" class="close" data-dismiss="modal" aria-label="{{ \'DISMISS_CLOSE_ACTION\'|translate }}"><span aria-hidden="true">&times;</span></button>\n\t\t\t\t<h4 class="modal-title" id="modal-chmod-label">{{ \'CHANGE_FILE_PERMISSIONS\'|translate }}</h4>\n\t\t\t</div>\n\t\t\t<div class="modal-body">\n        \t\t<fieldset>\n                    <legend translate>PERMISSIONS_OWNER</legend>\n                    <div>\n                        <input type="checkbox" ng-model="permissions.ownerRead" id="modal-permissions-owner-read"> \n                        \t<label for="modal-permissions-owner-read" translate>PERMISSIONS_READ</label>\n                    </div>\n                    <div>\n                        <input type="checkbox" ng-model="permissions.ownerWrite" id="modal-permissions-owner-write"> \n                        \t<label for="modal-permissions-owner-write" translate>PERMISSIONS_WRITE</label>\n                    </div>\n                    <div>\n                        <input type="checkbox" ng-model="permissions.ownerExecute" id="modal-permissions-owner-execute"> \n                        \t<label for="modal-permissions-owner-execute" translate>PERMISSIONS_EXECUTE</label>\n                    </div>\n                </fieldset>\n                <fieldset>\n                    <legend translate>PERMISSIONS_GROUP</legend>\n                    <div>\n                        <input type="checkbox" ng-model="permissions.groupRead" id="modal-permissions-group-read"> \n                        \t<label for="modal-permissions-group-read" translate>PERMISSIONS_READ</label>\n                    </div>\n                    <div>\n                        <input type="checkbox" ng-model="permissions.groupWrite" id="modal-permissions-group-write"> \n                        \t<label for="modal-permissions-group-write" translate>PERMISSIONS_WRITE</label>\n                    </div>\n                    <div>\n                        <input type="checkbox" ng-model="permissions.groupExecute" id="modal-permissions-group-execute"> \n                        \t<label for="modal-permissions-group-execute" translate>PERMISSIONS_EXECUTE</label>\n                    </div>\n                </fieldset>\n                <fieldset>\n                    <legend translate>PERMISSIONS_OTHER</legend>\n                    <div>\n                        <input type="checkbox" ng-model="permissions.otherRead" id="modal-permissions-other-read"> \n                        \t<label for="modal-permissions-other-read" translate>PERMISSIONS_READ</label>\n                    </div>\n                    <div>\n                        <input type="checkbox" ng-model="permissions.otherWrite" id="modal-permissions-other-write"> \n                        \t<label for="modal-permissions-other-write" translate>PERMISSIONS_WRITE</label>\n                    </div>\n                    <div>\n                        <input type="checkbox" ng-model="permissions.otherExecute" id="modal-permissions-other-execute"> \n                        \t<label for="modal-permissions-other-execute" translate>PERMISSIONS_EXECUTE</label>\n                    </div>\n                </fieldset>\n                <fieldset>\n                    <legend translate>PERMISSIONS_MANUAL</legend>\n                     <input type="text" ng-model="formattedPermissions" ng-model-options="{ updateOn: \'blur\' }" \n                     \tng-focus="manualFocus()" ng-keyup="keyUp($event)" maxlength="3">\n                     <span class="alert alert-danger" role="alert" ng-show="invalidRange" translate>PERMISSIONS_INVALID_NUMBER_MESSAGE</span>\n                </fieldset>\n\t\t\t</div>\n            <div class="modal-footer">\n                <button type="button" class="btn btn-default" ng-click="cancelClick()" ng-disabled="saving">{{ \'DISMISS_CANCEL_ACTION\'|translate }}</button>\n                <button type="button" class="btn btn-default" ng-click="okClick()" ng-disabled="saving">{{ (saving ? "SAVING_ACTIVITY_STATUS" : \'DISMISS_OK_ACTION\')|translate }}</button>\n            </div>\n\t\t</div>\n\t</div>\n</div>');
$templateCache.put('application/frontend/templates/modal-choice.html','<div class="modal fade" id="modal-choice" tabindex="-1" role="dialog" aria-labelledby="modal-choice-label"\n     ng-controller="ModalChoiceController as vm" data-backdrop="static" data-keyboard="false">\n    <div class="modal-dialog" role="document">\n        <div class="modal-content">\n            <div class="modal-header label-warning">\n                <button type="button" class="close" ng-click="vm.handleCancel()"\n                        aria-label="{{ \'DISMISS_CLOSE_ACTION\'|translate }}">\n                    <span aria-hidden="true">&times;</span>\n                </button>\n                <h4 class="modal-title" id="modal-confirm-label" translate>{{ vm.title }}</h4>\n            </div>\n            <div class="modal-body">\n                <div translate>{{ vm.message }}</div>\n                <div ng-if="vm.checkboxText !== null" class="checkbox">\n                    <label for="id_choice_checkbox">\n                        <input type="checkbox" ng-model="vm.checkboxChecked" id="id_choice_checkbox">\n                        {{ vm.checkboxText|translate }}\n                    </label>\n                </div>\n            </div>\n            <div class="modal-footer">\n                <button class="btn btn-default pull-left" ng-click="vm.handleCancel()" translate>DISMISS_CANCEL_ACTION</button>\n                <button ng-repeat="callback in vm.callbacks track by $index" type="button" class="btn btn-default"\n                        ng-click="vm.handleCallback($index)" translate>{{ callback[0] }}</button>\n            </div>\n        </div>\n    </div>\n</div>');
$templateCache.put('application/frontend/templates/modal-confirm.html','<div class="modal fade" id="modal-confirm" tabindex="-1" role="dialog" aria-labelledby="modal-confirm-label"\n     ng-controller="ModalConfirmController as modalConfirmController">\n    <div class="modal-dialog" role="document">\n        <div class="modal-content">\n            <div class="modal-header label-warning">\n                <button type="button" class="close" data-dismiss="modal" aria-label="{{ \'DISMISS_CLOSE_ACTION\'|translate }}">\n                    <span aria-hidden="true">&times;</span>\n                </button>\n                <h4 class="modal-title" id="modal-confirm-label" translate>WARNING_ATTENTION</h4>\n            </div>\n            <div class="modal-body">\n                {{ modalConfirmController.message }}\n            </div>\n            <div class="modal-footer">\n                <button type="button" class="btn btn-default" ng-click="modalConfirmController.cancel()" translate>DISMISS_CANCEL_ACTION</button>\n                <button type="button" class="btn btn-danger" ng-click="modalConfirmController.ok()" translate>DISMISS_CONFIRM_ACTION</button>\n            </div>\n        </div>\n    </div>\n</div>');
$templateCache.put('application/frontend/templates/modal-editor.html','<div class="modal fade" id="modal-editor" tabindex="-1" role="dialog" aria-labelledby="modal-file-editor-label"\n     ng-controller="FileEditorController as fileEditorController">\n    <div class="modal-dialog" role="document">\n        <div class="modal-content">\n            <div class="modal-body">\n                <div class="tab-content">\n                    <div ng-repeat="editorFile in editorFiles track by editorFile.path" role="tabpanel" class="tab-pane"\n                         ng-class="{active: editorFile.path == activeFile.path, in: editorFile.path == activeFile.path}">\n                        <div class="file-editor-display" id="editor_display_{{ editorFile.path }}" ng-show="licenseFactory.isLicensed()"></div>\n                        <textarea id="editor_ta_{{ editorFile.path }}" class="file-editor-textarea"\n                                  ng-hide="licenseFactory.isLicensed()"\n                                  ng-model="editorFile.contents" ng-change="textChange(editorFile.path)"\n                                  ng-readonly="!fileEditorController.allowEdit"></textarea>\n                    </div>\n                </div>\n                <div class="dropup">\n                    <div class="file-path" aria-haspopup="true" aria-expanded="false" ng-class="{ \'cursor-pointer\': licenseFactory.isLicensed() }"\n                         ng-click="fileEditorController.fileListClick($event)">\n                        <i class="fa fa-caret-up" ng-show="licenseFactory.isLicensed()"></i>\n                        <span ng-class="{\'unsaved-file\': activeFile.dirty }"></span>{{ activeFile.path }}\n                    </div>\n                    <ul class="dropdown-menu" role="tablist" ng-show="licenseFactory.isLicensed()">\n                        <li ng-repeat="editorFile in editorFiles track by $index" role="presentation"\n                            ng-class="{active: editorFile.path == activeFile.path, in: editorFile.path == activeFile.path}"\n                            ng-click="activateTab(editorFile.path, $event)"\n                            ondragstart="return false;">\n                            <div>\n                                <a href="#" aria-controls="fel" role="tab">\n                                    <button class="close" type="button"\n                                            ng-click="closeTabForFile(editorFile.name, editorFile.path)">&times;\n                                    </button>\n                                    <span data-placement="top" title="{{ editorFile.path }}"\n                                          ng-class="{\'unsaved-file\': editorFile.dirty }">\n                                        {{ editorFile.path }}\n                                    </span>\n                                </a>\n                            </div>\n                        </li>\n                    </ul>\n                </div>\n            </div>\n            <div class="modal-footer">\n                <div class="logo"></div>\n                <span class="autosave" ng-show="licenseFactory.isLicensed() && fileEditorController.allowEdit">\n\t\t\t\t\t<input type="checkbox" ng-model="settings.autoSave" id="id_auto_save">\n                    <label for="id_auto_save" translate>AUTO_SAVE_ACTION</label>\n\t\t\t\t</span>\n                <button type="button" class="btn btn-default" ng-if="fileEditorController.allowEdit"\n                        ng-click="saveActiveFile(false, false)"\n                        ng-disabled="activeFile.saving">\n                    <span ng-show="!activeFile.saving" translate>SAVE_ACTION</span>\n                    <i ng-show="activeFile.saving" class="fa fa-spinner fa-spin fa-fw"></i>\n                </button>\n                <button type="button" class="btn btn-default" ng-click="fileEditorController.hide()" translate>DISMISS_CLOSE_ACTION</button>\n            </div>\n        </div>\n    </div>\n</div>');
$templateCache.put('application/frontend/templates/modal-error.html','<div class="modal fade" id="modal-error" tabindex="-1" role="dialog" aria-labelledby="modal-error-label"\n     ng-controller="ModalErrorController as vm">\n    <div class="modal-dialog" role="document">\n        <div class="modal-content">\n            <div class="modal-header label-danger">\n                <button type="button" class="close" data-dismiss="modal" aria-label="{{ \'DISMISS_CLOSE_ACTION\'|translate }}">\n                    <span aria-hidden="true">&times;</span>\n                </button>\n                <h4 class="modal-title" id="modal-error-label" translate>ERROR_ATTENTION</h4>\n            </div>\n            <div class="modal-body" ng-bind-html="vm.message|html_safe"></div>\n            <div class="modal-footer">\n                <button type="button" class="btn btn-default" ng-click="vm.hide()" translate>DISMISS_OK_ACTION</button>\n            </div>\n        </div>\n    </div>\n</div>');
$templateCache.put('application/frontend/templates/modal-login-ftp.html','<form>\n    <div class="alert alert-danger" role="alert" ng-if="!vm.ftpConnectionAvailable">\n        <p>Your PHP install does not have the Sockets or FTP PHP libraries enabled, and will not be able to connect to\n            FTP servers. For information on how to activate them please see\n            <a href="http://redirect.monstaftp.com/enable-ftp-php" target="mftp-new" rel="noopener noreferrer">this article</a>.\n        </p>\n    </div>\n\n    <div class="input-wrapper float-fix" ng-if="vm.configurationSettable(\'ftp\', \'host\')">\n        <div class="float-left width-host">\n            {{ \'HOST\'|translate }}:\n            <br>\n            <input type="text" ng-model="configuration.ftp.host" required ng-keypress="handleLoginKeyPress($event)" ng-if="vm.hostEntryIsText(\'ftp\')">\n            <select ng-if="!vm.hostEntryIsText(\'ftp\')" ng-model="configuration.ftp.host" class="form-control">\n                <option ng-repeat="host in vm.getHostOptions(\'ftp\')" ng-value="host">{{ host }}</option>\n            </select>\n        </div>\n        <div class="spacer"></div>\n        <div class="float-right width-port" ng-if="vm.configurationSettable(\'ftp\', \'port\')">\n            {{ \'PORT\'|translate }}:\n            <br><input type="text" ng-model="configuration.ftp.port" placeholder="{{ defaults.ftp.port }}" required ng-keypress="handleLoginKeyPress($event)">\n        </div>\n    </div>\n              \n    <div class="input-wrapper" ng-if="vm.configurationSettable(\'ftp\', \'username\')">\n        {{ \'USERNAME\'|translate }}:\n        <br><input type="text" ng-model="configuration.ftp.username" required ng-keypress="handleLoginKeyPress($event)">\n    </div>\n          \n    <div class="input-wrapper" ng-if="vm.configurationSettable(\'ftp\', \'password\')">\n        {{ \'PASSWORD\'|translate }}:\n        <br><input type="password" ng-model="configuration.ftp.password" required ng-keypress="handleLoginKeyPress($event)">\n    </div>\n\n    <div class="input-wrapper" ng-if="vm.configurationSettable(\'ftp\', \'initialDirectory\')">\n        {{ \'INITIAL_DIRECTORY\'|translate }}:\n        <br><input type="text" ng-model="configuration.ftp.initialDirectory" required ng-keypress="handleLoginKeyPress($event)">\n    </div>\n\n    <span ng-hide="vm.loginItemHidden(\'remember-login\')">\n        <input type="checkbox" ng-model="metaConfiguration.rememberLogin" name="login_save" value="1" tabindex="-1" id="id_ftp_login_save" ng-click="vm.rememberLoginToggle()">\n            <label class="login-cb-label" for="id_ftp_login_save">{{ \'KEEP_ME_LOGGED_IN\'|translate }}</label>\n        </span>\n    </div>\n</form>');
$templateCache.put('application/frontend/templates/modal-login-link.html','<div class="modal fade" id="modal-login-link" tabindex="-1" role="dialog" aria-labelledby="modal-login-link-label"\n     ng-controller="ModalLoginLinkController as vm" data-backdrop="static" data-keyboard="false">\n    <div class="modal-dialog" role="document">\n        <div class="modal-content">\n            <div class="modal-header label-warning">\n                <h4 class="modal-title" id="modal-login-link-label" translate>GENERATE_LOGIN_LINK_TITLE</h4>\n            </div>\n            <div class="modal-body text-center">\n                <div class="alert alert-danger" role="alert" ng-show="vm.configURL == null" translate>LOGIN_LINK_BAD_CONFIGURATION_MESSAGE</div>\n                <div ng-hide="vm.configURL == null">\n                    <textarea>{{ vm.configURL }}</textarea>\n                    <br/>\n                    <span translate>LOGIN_LINK_HINT</span>\n                    <br/>\n                    <a href="#" ng-show="vm.supportsCopy" ng-click="vm.copy()" translate>COPY_LOGIN_LINK_PROMPT</a>\n                </div>\n            </div>\n\n            <div class="modal-footer">\n                <button type="button" class="btn btn-default" ng-click="vm.hide()" translate>DISMISS_CLOSE_ACTION</button>\n            </div>\n        </div>\n    </div>\n</div>');
$templateCache.put('application/frontend/templates/modal-login-mock.html','<form>\n    <div class="input-wrapper" ng-if="vm.configurationSettable(\'mock\', \'username\')">\n        {{ \'USERNAME\'|translate }}:\n        <br><input type="text" ng-model="configuration.mock.username" required ng-keypress="handleLoginKeyPress($event)">\n    </div>\n          \n    <div class="input-wrapper" ng-if="vm.configurationSettable(\'mock\', \'password\')">\n        {{ \'PASSWORD\'|translate }}:\n        <br><input type="password" ng-model="configuration.mock.password" required ng-keypress="handleLoginKeyPress($event)">\n    </div>\n    \n    <div class="input-wrapper" ng-if="vm.configurationSettable(\'mock\', \'initialDirectory\')">\n        {{ \'INITIAL_DIRECTORY\'|translate }}:\n        <br><input type="text" ng-model="configuration.mock.initialDirectory" required ng-keypress="handleLoginKeyPress($event)">\n    </div>\n        \n    <div class="input-wrapper" ng-hide="vm.loginItemHidden(\'remember-login\')">\n        <input type="checkbox" ng-model="metaConfiguration.rememberLogin" name="login_save" value="1" tabindex="-1"> {{ \'KEEP_ME_LOGGED_IN\'|translate }}\n    </div>\n</form>');
$templateCache.put('application/frontend/templates/modal-login-sftp.html','<form>\n    <div class="input-wrapper float-fix" ng-if="vm.configurationSettable(\'sftp\', \'host\')">\n        <div class="float-left width-host">\n            {{ \'HOST\'|translate }}:\n            <br>\n            <input type="text" ng-model="configuration.sftp.host" required ng-keypress="handleLoginKeyPress($event)" ng-if="vm.hostEntryIsText(\'sftp\')">\n            <select ng-if="!vm.hostEntryIsText(\'sftp\')" ng-model="configuration.sftp.host" class="form-control">\n                <option ng-repeat="host in vm.getHostOptions(\'sftp\')" ng-value="host">{{ host }}</option>\n            </select>\n        </div>\n        <div class="spacer"></div>\n        <div class="float-right width-port" ng-if="vm.configurationSettable(\'sftp\', \'port\')">\n            {{ \'PORT\'|translate }}:\n            <br><input type="text" ng-model="configuration.sftp.port" placeholder="{{ defaults.sftp.port }}" ng-keypress="handleLoginKeyPress($event)">\n        </div>\n    </div>\n\n    <div class="input-wrapper" ng-if="vm.configurationSettable(\'sftp\', \'remoteUsername\')">\n        {{ \'USERNAME\'|translate }}:\n        <br><input type="text" ng-model="configuration.sftp.remoteUsername" required ng-keypress="handleLoginKeyPress($event)">\n    </div>\n\n    <div class="input-wrapper" ng-if="vm.configurationSettable(\'sftp\', \'initialDirectory\')">\n        {{ \'INITIAL_DIRECTORY\'|translate }}:\n        <br><input type="text" ng-model="configuration.sftp.initialDirectory" required ng-keypress="handleLoginKeyPress($event)">\n    </div>\n\n    <div class="input-wrapper" ng-if="vm.configurationSettable(\'sftp\', \'authenticationModeName\')">\n        {{ \'AUTHENTICATION_TYPE\'|translate }}:\n        <br>\n        <select ng-model="configuration.sftp.authenticationModeName" class="form-control">\n            <option value="Password" translate>PASSWORD</option>\n            <option value="PublicKeyFile" translate>SSH_AUTH_MODE_PUBLIC_KEY_FILE</option>\n            <option value="Agent" translate>SSH_AUTH_MODE_AGENT</option>\n        </select>\n    </div>\n    <div ng-show="vm.showDisabledSFTPAuthMessage()">\n        <span translate>SFTP_AUTHENTICATION_DISABLED_MESSAGE</span>\n        <a href="http://redirect.monstaftp.com/enable-ssh-auth"\n           target="mftp-new" rel="noopener noreferrer" translate>SFTP_AUTHENTICATION_ENABLED_INSTRUCTIONS_MESSAGE</a>\n    </div>\n    <div class="input-wrapper" ng-if="vm.configurationSettable(\'sftp\', \'password\')"\n         ng-show="configuration.sftp.authenticationModeName == \'Password\' || configuration.sftp.authenticationModeName == \'PublicKeyFile\'">\n        <span ng-show="configuration.sftp.authenticationModeName == \'PublicKeyFile\'">{{ \'PRIVATE_KEY\'|translate }} </span>\n        {{ \'PASSWORD\'|translate }}<span ng-show="configuration.sftp.authenticationModeName == \'PublicKeyFile\'"> {{ \'OPTIONAL_OPTIONAL\'|translate }}</span>:\n        <br><input type="password" ng-model="configuration.sftp.password" ng-keypress="handleLoginKeyPress($event)">\n    </div>\n\n    <div class="input-wrapper" ng-if="vm.configurationSettable(\'sftp\', \'privateKeyFilePath\')"\n         ng-show="configuration.sftp.authenticationModeName == \'PublicKeyFile\' || configuration.sftp.authenticationModeName == \'HostKeyFile\'">\n        {{ \'PRIVATE_KEY\'|translate }}:\n        <br><input type="text" ng-model="configuration.sftp.privateKeyFilePath" ng-keypress="handleLoginKeyPress($event)">\n    </div>\n\n    <div class="input-wrapper" ng-if="vm.configurationSettable(\'sftp\', \'publicKeyFilePath\')"\n         ng-show="configuration.sftp.authenticationModeName == \'PublicKeyFile\' || configuration.sftp.authenticationModeName == \'HostKeyFile\'">\n        {{ \'PUBLIC_KEY\'|translate }}:\n        <br><input type="text" ng-model="configuration.sftp.publicKeyFilePath" ng-keypress="handleLoginKeyPress($event)">\n    </div>\n\n    <div class="input-wrapper" ng-hide="vm.loginItemHidden(\'remember-login\')">\n        <input type="checkbox" ng-model="metaConfiguration.rememberLogin" name="login_save" value="1" tabindex="-1" id="id_sftp_login_save" ng-click="vm.rememberLoginToggle()">\n        <label class="login-cb-label" for="id_sftp_login_save">{{ \'KEEP_ME_LOGGED_IN\'|translate }}</label>\n    </div>\n</form>');
$templateCache.put('application/frontend/templates/modal-login.html','<div class="modal fade" id="modal-login" tabindex="-1" role="dialog" aria-labelledby="modal-login-label"\n     ng-controller="LoginPanelController as vm">\n    <div class="modal-dialog" role="document">\n        <div class="modal-content">\n            <div class="modal-header label-warning">\n                <button ng-show="vm.isAuthenticated" type="button" class="close" data-dismiss="modal"\n                        aria-label="{{ \'DISMISS_CLOSE_ACTION\'|translate }}">\n                    <span aria-hidden="true">&times;</span>\n                </button>\n                <h4 class="modal-title" id="modal-login-label" translate>LOGIN</h4>\n            </div>\n            <div class="modal-body">\n\n                <ul class="nav nav-tabs" id="login-tab-links" ng-if="connectionTypes.length > 1">\n                    <li ng-repeat="connectionTypeIterator in connectionTypes" role="presentation"\n                        ng-class="{active: connectionTypeIterator[0] == connectionType }">\n                        <a href="" aria-controls="login-{{ connectionTypeIterator[0]}}"\n                           role="tab" ng-click="vm.selectTab(connectionTypeIterator[0])">\n                            {{ connectionTypeIterator[1]}}\n                        </a>\n                    </li>\n                </ul>\n\n                <div class="alert alert-warning" role="alert" ng-if="vm.showMissingLanguageMessage">\n                    <p>The language file could not be loaded. If you\'re running PHP under IIS, you will need to enable\n                        the JSON\n                        MIME type. Please see <a href="http://redirect.monstaftp.com/iis-enable-json" target="mftp-new"\n                                                 rel="noopener noreferrer">this article</a>.\n                    </p>\n                </div>\n\n                <div class="alert alert-danger" role="alert"\n                     ng-hide="storedAuthenticationErrorMessage == null || storedAuthenticationErrorMessage == \'\'">\n                    <strong class="error--attention" translate>ERROR_ATTENTION</strong> {{\n                    storedAuthenticationErrorMessage }}\n                </div>\n\n                <div class="input-wrapper float-fix" ng-show="vm.shouldShowProfiles() && !masterPasswordValid">\n                    <div class="float-left width-passwd">\n                        <input type="password" name="" ng-model="metaConfiguration.masterPassword"\n                               ng-keypress="masterPasswordKeypress($event)"\n                               placeholder="{{ (hasServerSavedAuthentication ? \'MASTER_PASSWORD_ENTER_PLACEHOLDER\' : \'MASTER_PASSWORD_SET_PLACEHOLDER\')|translate }}">\n                    </div>\n                    <div class="spacer"></div>\n                    <div class="float-right width-login">\n                        <i class="fa fa-sign-in fa-2x fa-fw" ng-click="handleAuthGo()"></i>\n                    </div>\n                </div>\n\n                <div class="input-wrapper" ng-show="masterPasswordValid && licenseFactory.isLicensed()">\n                    <select ng-model="metaConfiguration.savedProfileIndex" class="form-control"\n                            ng-change="handleProfileChange()">\n                        <option value="" translate>LOAD_PROFILE_DEFERRED_ACTION</option>\n                        <option ng-repeat="profile in savedAuthentication[connectionType] track by $index"\n                                value="{{ $index }}">\n                            {{ vm.getProfileName(profile, false) }}\n                        </option>\n                        <option value="new" translate>NEW_DEFERRED_ACTION</option>\n                    </select>\n                </div>\n\n                <div class="input-wrapper"\n                     ng-show="masterPasswordValid && licenseFactory.isLicensed() && vm.profileIsSelected()">\n                    {{ \'PROFILE_NAME_LABEL\'|translate }}:\n                    <br><input type="text" ng-model="metaConfiguration.enteredProfileName"\n                               placeholder="{{ vm.getDefaultProfileName() }}">\n                </div>\n\n                <div class="alert alert-danger" role="alert"\n                     ng-hide="connectionErrorMessage == null || connectionErrorMessage == \'\'">\n                    <strong class="error--attention" translate>ERROR_ATTENTION</strong> {{ connectionErrorMessage }}\n                    <!--TODO: get connectionErrorCode from API -->\n                </div>\n\n                <!-- Tab content -->\n                <div class="tab-content">\n                    <div ng-repeat="connectionTypeIterator in connectionTypes" role="tabpanel"\n                         class="tab-pane fade" ng-class="{\'active in\': connectionTypeIterator[0] == connectionType}"\n                         id="login-{{ connectionTypeIterator[0] }}">\n                        <ng-include\n                                src="\'application/frontend/templates/modal-login-\' + connectionTypeIterator[0] + \'.html\'"></ng-include>\n                    </div>\n                </div>\n            </div>\n\n            <div class="modal-footer">\n                \n\n                <button type="button" class="btn btn-default float-left ng-cloak" ng-click="vm.showPasswordManager()"\n                        ng-show="vm.showPasswordManagementButton" translate>\n                    SHOW_PASSWORD_MANAGEMENT\n                </button>\n\n                <button type="button" class="btn btn-danger float-left" ng-click="initiateProfileDelete()"\n                        ng-hide="shouldHideDeleteButton()" translate>\n                    DELETE_DEFERRED_ACTION\n                </button>\n\n                <button type="button" class="btn btn-default float-left"\n                        ng-if="vm.showLoginLinkButton &amp;&amp; licenseFactory.isLicensed()"\n                        ng-hide="vm.loginItemHidden(\'login-link\')"\n                        ng-click="vm.showLoginLink()" title="{{ \'GENERATE_LOGIN_LINK_ACTION\'|translate }}"><i\n                        class="fa fa-link icon-rotate-135"></i></button>\n                <button type="button" class="btn btn-primary" ng-click="connect()" translate data-mf="connect-button">\n                    CONNECT\n                </button>\n            </div>\n        </div>\n    </div>\n</div>');
$templateCache.put('application/frontend/templates/modal-password-management.html','<div class="modal fade" id="modal-password-management" tabindex="-1" role="dialog" aria-labelledby="modal-addons-label"\n     ng-controller="ModalPasswordManagementController as vm" data-keyboard="false" data-backdrop="static">\n    <div class="modal-dialog" role="document">\n        <div class="modal-content">\n            <div class="modal-header label-warning">\n                <h4 class="modal-title" id="modal-password-management-label">{{\'PASSWORD_MANAGEMENT\'|translate}}</h4>\n            </div>\n            <div class="modal-body">\n                <ul class="nav nav-tabs" role="tablist" ng-if="vm.resetPasswordAvailable == vm.forgotPasswordAvailable">\n                    <li role="presentation" ng-class="{\'active\': vm.currentTab == \'forgot\'}">\n                        <a href="#" ng-click="vm.currentTab = \'forgot\'" aria-controls="form-forgot-password" role="tab" data-toggle="tab" translate>FORGOT_PASSWORD</a>\n                    </li>\n                    <li role="presentation" ng-click="vm.currentTab = \'reset\'" ng-class="{\'active\': vm.currentTab == \'reset\'}">\n                        <a href="#" aria-controls="form-reset-password" role="tab" data-toggle="tab" translate>RESET_PASSWORD</a>\n                    </li>\n                </ul>\n\n                <div class="tab-content">\n                    <div role="tabpanel" class="tab-pane" ng-class="{\'active\': vm.currentTab == \'forgot\'}" id="form-forgot-password" ng-if="vm.forgotPasswordAvailable" ng-show="vm.currentTab == \'forgot\'">\n                        <h4 ng-if="vm.resetPasswordAvailable != vm.forgotPasswordAvailable" translate>FORGOT_PASSWORD</h4>\n                        <div class="input-wrapper instructions">\n                            <p translate>FORGOT_PASSWORD_INSTRUCTIONS</p>\n                        </div>\n                        <div class="input-wrapper float-fix">\n                            {{ \'PASSWORD_MANAGEMENT_USERNAME_LABEL\'|translate }}:\n                            <br><input type="text" ng-model="vm.model.forgotPasswordUsername" placeholder="{{ \'PASSWORD_MANAGEMENT_USERNAME_LABEL\'|translate }}">\n                        </div>\n\n                        <div class="alert alert-danger" role="alert" ng-show="vm.forgotPasswordFailed">\n                            {{ vm.forgotPasswordFailedMessage|translate }}\n                        </div>\n\n                        <div class="alert alert-success" role="alert" ng-show="vm.forgotPasswordSucceeded">\n                            {{ vm.forgotPasswordSucceededMessage|translate }}\n                        </div>\n\n                        <div class="input-wrapper float-fix">\n                            <button type="button" class="btn btn-primary float-right" ng-click="vm.initiateForgotPassword()">\n                                {{ \'INITIATE_FORGOT_PASSWORD\'|translate }}\n                            </button>\n                        </div>\n                    </div>\n\n                    <div role="tabpanel" class="tab-pane" ng-class="{\'active\': vm.currentTab == \'reset\'}"  id="form-reset-password" ng-if="vm.resetPasswordAvailable" ng-show="vm.currentTab == \'reset\'">\n                        <h4 ng-if="vm.resetPasswordAvailable != vm.forgotPasswordAvailable" translate>RESET_PASSWORD</h4>\n                        <div class="input-wrapper instructions">\n                            <p translate>RESET_PASSWORD_INSTRUCTIONS</p>\n                        </div>\n                        <div class="input-wrapper float-fix">\n                            {{ \'PASSWORD_MANAGEMENT_USERNAME_LABEL\'|translate }}:\n                            <br><input type="text" ng-model="vm.model.resetPasswordUsername" placeholder="{{ \'PASSWORD_MANAGEMENT_USERNAME_LABEL\'|translate }}">\n                        </div>\n\n                        <div class="input-wrapper float-fix">\n                            {{ \'CURRENT_PASSWORD_LABEL\'|translate }}:\n                            <br><input type="password" ng-model="vm.model.currentPassword" placeholder="{{ \'CURRENT_PASSWORD_LABEL\'|translate }}">\n                        </div>\n\n                        <div class="input-wrapper float-fix">\n                            {{ \'NEW_PASSWORD_LABEL\'|translate }}:\n                            <br><input type="password" ng-model="vm.model.resetPassword" placeholder="{{ \'NEW_PASSWORD_LABEL\'|translate }}">\n                        </div>\n\n                        <div class="input-wrapper float-fix">\n                            {{ \'CONFIRM_PASSWORD_LABEL\'|translate }}:\n                            <br><input type="password" ng-model="vm.model.confirmPassword" placeholder="{{ \'CONFIRM_PASSWORD_LABEL\'|translate }}">\n                        </div>\n\n                        <div class="alert alert-danger" role="alert" ng-show="vm.resetPasswordFailed">\n                            {{ vm.resetPasswordFailedMessage|translate }}\n                        </div>\n\n                        <div class="alert alert-success" role="alert" ng-show="vm.resetPasswordSucceeded">\n                            {{ vm.resetPasswordSucceededMessage|translate }}\n                        </div>\n\n                        <div class="input-wrapper float-fix">\n                            <button type="button" class="btn btn-primary float-right" ng-click="vm.initiateResetPassword()">\n                                {{ \'INITIATE_RESET_PASSWORD\'|translate }}\n                            </button>\n                        </div>\n                    </div>\n                </div>\n            </div>\n            <div class="modal-footer">\n                <button type="button" class="btn btn-default" ng-click="vm.showLoginPanel()">\n                    {{ \'SHOW_LOGIN_FORM\'|translate }}\n                </button>\n            </div>\n        </div>\n    </div>\n</div>');
$templateCache.put('application/frontend/templates/modal-prompt.html','<div class="modal fade" id="modal-prompt" tabindex="-1" role="dialog" aria-labelledby="modal-prompt-label" \n\tng-controller="ModalPromptController as modalPromptController">\n    <div class="modal-dialog" role="document">\n        <div class="modal-content">\n            <div class="modal-header label-warning">\n                <button type="button" class="close" data-dismiss="modal" aria-label="{{ \'DISMISS_CLOSE_ACTION\'|translate }}">\n                    <span aria-hidden="true">&times;</span>\n                </button>\n                <h4 class="modal-title" id="modal-prompt-label">{{ title }}</h4>\n            </div>\n            <div class="modal-body">\n            \t<div class="alert alert-danger" role="alert" ng-show="errorSet"><strong class="error--attention" translate>ERROR_ATTENTION</strong> {{ errorMessage }}</div>\n                <input type="text" name="" ng-model="final" placeholder="{{ placeHolder|translate }}" ng-keypress="handlePromptKeypress($event)">\n            </div>\n            <div class="modal-footer">\n                <button type="button" class="btn btn-default" data-dismiss="modal" ng-disabled="isBusy" translate>DISMISS_CANCEL_ACTION</button>\n                <button type="button" class="btn btn-default" ng-click="successClose()" ng-disabled="isBusy">{{ dismissMessage }}</button>\n            </div>\n        </div>\n    </div>\n</div>');
$templateCache.put('application/frontend/templates/modal-properties.html','<div class="modal fade" id="modal-properties" tabindex="-1" role="dialog" aria-labelledby="modal-properties-label"\n\t ng-controller="ModalPropertiesController as vm">\n    <div class="modal-dialog" role="document">\n        <div class="modal-content">\n            <div class="modal-header label-warning">\n                <button type="button" class="close" data-dismiss="modal"\n                        aria-label="{{ \'DISMISS_CLOSE_ACTION\'|translate}}">\n                    <span aria-hidden="true">&times;</span>\n                </button>\n                <h4 class="modal-title" id="modal-properties-label" translate>PROPERTIES</h4>\n            </div>\n            <div class="modal-body">\n                <table ng-if="vm.item != null">\n                \t<tr title="{{ \'NAME\'|translate }}">\n                \t\t<td class="icon"><i class="fa fa-info-circle fa-fw"></i></td>\n                \t\t<td><div class="property">{{ vm.item.name }}</div></td>\n                \t</tr>\n                \t<tr title="{{ \'MODIFICATION_DATE\'|translate }}">\n                \t\t<td class="icon"><i class="fa fa-history fa-fw"></td>\n                \t\t<td><div class="property">{{ (vm.item.modificationDate * 1000)|date:"medium" }}</div></td>\n                \t</tr>\n                \t<tr title="{{ \'SIZE\'|translate }}">\n                \t\t<td class="icon"><i class="fa fa-hdd-o fa-fw"></td>\n                \t\t<td><div class="property">{{ vm.item.size|number }} {{ "BYTE"|translate:{size:vm.item.size} }}\n                            <span ng-show="vm.item.size >= 1024">({{ vm.item.size|file_size }})</span></div>\n                        </td>\n                \t</tr>\n                \t<tr title="{{ \'OWNER\'|translate }}">\n                \t\t<td class="icon"><i class="fa fa-user fa-fw"></td>\n                \t\t<td><div class="property">{{ vm.item.ownerUserName }}</div></td>\n                \t</tr>\n                \t<tr title="{{ \'GROUP\'|translate }}">\n                \t\t<td class="icon"><i class="fa fa-users fa-fw"></td>\n                \t\t<td><div class="property">{{ vm.item.ownerGroupName }}</div></td>\n                \t</tr>\n                \t<tr title="{{ \'PERMISSIONS\'|translate }}">\n                \t\t<td class="icon"><i class="fa fa-key fa-fw"></td>\n                \t\t<td><div class="property">{{ vm.item|item_permission_description }} (0{{ vm.item.numericPermissions.toString(8) }})</div></td>\n                \t</tr>\n                </table>\n            </div>\n            <div class="modal-footer">\n                <button type="button" class="btn btn-default" data-dismiss="modal" translate>DISMISS_CLOSE_ACTION</button>\n            </div>\n        </div>\n    </div>\n</div>');
$templateCache.put('application/frontend/templates/modal-search.html','<div class="modal fade" id="modal-search" tabindex="-1" role="dialog" aria-labelledby="modal-search-label">\n\t<div class="modal-dialog" role="document">\n\t\t<div class="modal-content">\n\t\t\t<div class="modal-header label-warning">\n\t\t\t\t<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>\n\t\t\t\t<h4 class="modal-title" id="modal-search-label">Search</h4>\n\t\t\t</div>\n\t\t\t<div class="modal-body">\n\t\t\t\t<input type="text" name="" placeholder="Enter new folder name...">\n\t\t\t</div>\n\t\t\t<div class="modal-footer">\n\t\t\t\t<button type="button" class="btn btn-default">OK</button>\n\t\t\t\t<button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>\n\t\t\t</div>\n\t\t</div>\n\t</div>\n</div>');
$templateCache.put('application/frontend/templates/modal-settings.html','<div class="modal fade" id="modal-settings" tabindex="-1" role="dialog" aria-labelledby="modal-settings-label"\n     ng-controller="ModalSettingsController as vm">\n    <div class="modal-dialog" role="document">\n        <div class="modal-content">\n            <div class="modal-header label-warning">\n                <button type="button" class="close" data-dismiss="modal" aria-label="{{ \'DISMISS_CLOSE_ACTION\'|translate }}">\n                    <span aria-hidden="true">&times;</span></button>\n                <h4 class="modal-title" id="modal-settings-label" translate>SETTINGS</h4>\n            </div>\n            <div class="modal-body">\n                <fieldset>\n                    <legend translate>LANGUAGE_LABEL</legend>\n                    <select ng-model="vm.applicationSettings.language">\n                        <option ng-repeat="languageCodeAndName in vm.languageFiles track by $index" value="{{ languageCodeAndName[0] }}">{{ languageCodeAndName[1] }}</option>\n                    </select>\n                </fieldset>\n            </div>\n            <div class="modal-footer">\n                <button type="button" class="btn btn-default" data-dismiss="modal" translate>DISMISS_CANCEL_ACTION</button>\n                <button type="button" class="btn btn-primary" ng-click="vm.saveSettings()" translate>SAVE_ACTION</button>\n            </div>\n        </div>\n    </div>\n</div>');
$templateCache.put('application/frontend/templates/modal-transfers.html','<div class="modal fade" id="modal-transfers" tabindex="-1" role="dialog" aria-labelledby="modal-transfers-label"\n     ng-controller="ModalTransferController as vm" data-backdrop="static" data-keyboard="false">\n    <div class="modal-dialog" role="document">\n        <div class="modal-content">\n            <div class="modal-header label-warning">\n                <div class="float-right">{{ midNum || vm.currentUploadNumber }} {{\n                    \'COMPLETED_OF_TOTAL_JOINER\'|translate }} {{ vm.completedUploadTotal }}</div>\n                <h4 class="modal-title" id="modal-transfers-label">{{ \'FILE_TRANSFER\'|translate }}</h4>\n            </div>\n            <div class="modal-body">\n                <div class="file" ng-repeat="upload in vm.uploads | limitTo:1:0">\n                    <div class="status">\n                        <div class="icon">\n                            <i class="fa {{ upload|icon }} fa-fw"></i>\n                        </div>\n                        <div class="name" ng-if="upload.remotePath == null">\n                            {{ midName || upload.name }}\n                        </div>\n                        <div class="name" ng-if="upload.remotePath != null">\n                            {{ midName || vm.remotePathToRelative(upload.remotePath) }}\n                        </div>\n                        <button class="close" type="button" ng-click="vm.abortItem(upload)">\xD7</button>\n                    </div>\n                    <div class="progress">\n                        <upload-progress-bar transfer="upload" stage="1"></upload-progress-bar>\n\t\t\t\t\t</div>\n                    <div class="status">\n                        <div class="transferred" ng-show="upload.archiveExtractMax == 0">\n                            {{ vm.fsFilter(currentFakeItems) }} {{ \'COMPLETED_OF_TOTAL_JOINER\'|translate }}\n                            {{ vm.fsFilter(vm.uploads[midUploadCount].stats.totalItems) }}\n                        </div>\n                        <div class="transferred" ng-show="upload.archiveExtractMax != 0">\n                            {{ upload.archiveExtractCurrent }} {{ \'COMPLETED_OF_TOTAL_JOINER\'|translate }} {{ upload.archiveExtractMax }}\n                        </div>\n                        <div class="rate">\n\t\t\t\t\t\t\t<span ng-hide="upload.stats.completedItems == upload.stats.totalItems || !upload.stats.hasBeenStarted()">\n                                {{ upload|transfer_rate}}\n                            </span>\n                            <span ng-show="upload.stats.completedItems == upload.stats.totalItems && !upload.isArchive && !upload.hasError">\n                                <span ng-show="$root.completedUploadTotal != $root.currentUploadNumber" translate>UPLOAD_TRANSFERRING_TO_SERVER_MESSAGE</span>\n                                <span ng-show="$root.completedUploadTotal == $root.currentUploadNumber" translate>UPLOAD_PROCESSING_SERVER_MESSAGE</span>\n                            </span>\n                            <span ng-show="upload.hasError">\n                                {{ \'UPLOAD_FAILED_MESSAGE\'|translate }}\n                                <span ng-if="upload.errorText == null">{{ upload.statusCode }} / {{ upload.statusText }}</span>\n                                <span ng-if="upload.errorText != null">{{ upload.errorText }}</span>\n                            </span>\n                            <span ng-show="upload.stats.transferType == \'extract\' &amp;&amp; upload.isArchive" translate>\n                                UPLOAD_ARCHIVE_TRANSFERRING_MESSAGE\n                            </span>\n                        </div>\n                    </div>\n                </div>\n            </div>\n            <div class="modal-footer">\n                <button type="button" class="btn btn-danger" ng-click="vm.abortAll()" translate>DISMISS_CANCEL_ALL_ACTION</button>\n            </div>\n        </div>\n    </div>\n</div>');
$templateCache.put('application/frontend/templates/modal-update.html','<div class="modal fade" id="modal-update" tabindex="-1" role="dialog" aria-labelledby="modal-update-label" ng-controller="UpdateController as vm">\n    <div class="modal-dialog" role="document">\n        <div class="modal-content">\n            <div class="modal-header label-warning">\n                <button type="button" class="close" data-dismiss="modal"\n                        aria-label="{{ \'DISMISS_CLOSE_ACTION\'|translate}}">\n                    <span aria-hidden="true">&times;</span>\n                </button>\n                <h4 class="modal-title" id="modal-update-label">{{ vm.modalTitle|translate }}</h4>\n            </div>\n            <div class="modal-body">\n                <div ng-if="!vm.downloadInProgress &amp;&amp; !vm.installInProgress &amp;&amp; !vm.upgradeComplete">\n                    <p ng-bind-html="vm.latestVersionMessage|html_safe"></p>\n                    \n                    <div class="alert alert-danger" ng-if="!vm.automaticUpgradeAvailable" role="alert">\n                        <p ng-bind-html="vm.licensedOnlyMessage|html_safe" ng-if="!vm.isLicensed"></p>\n                        <p ng-if="vm.automaticUpgradeUnavailableReason != \'\'" translate>{{vm.automaticUpgradeUnavailableReason}}</p>\n                    </div>\n                    \n                    <p ng-bind-html="vm.releaseNotesMessage|html_safe"></p>\n\n                    <p ng-if="!vm.automaticUpgradeAvailable">\n                        <a href="http://redirect.monstaftp.com/download" target="mftp-new" rel="noopener noreferrer">{{ \'DOWNLOAD_UPDATE_DEFERRED_ACTION\'|translate }}</a>\n                    </p>\n\n                    <div class="alert alert-danger" role="alert"\n                         ng-hide="vm.storedAuthenticationErrorMessage == null || vm.storedAuthenticationErrorMessage == \'\'">\n                        <strong class="error--attention" translate>ERROR_ATTENTION</strong> {{ vm.storedAuthenticationErrorMessage|translate }}\n                    </div>\n\n                    <div ng-if="vm.isLicensed &amp;&amp; vm.hasServerSavedAuthentication && !vm.startUpgradeEnabled" class="input-wrapper float-fix">\n                        <div class="float-left width-passwd">\n                            <input type="password" name="" ng-model="vm.model.masterPassword"\n                                   ng-keypress="vm.handlePasswordKeypress($event)"\n                                   placeholder="{{ \'MASTER_PASSWORD_ENTER_PLACEHOLDER\'|translate }}">\n                        </div>\n                        <div class="spacer"></div>\n                        <div class="float-right width-login">\n                            <i class="fa fa-sign-in fa-2x fa-fw" ng-click="vm.validatePassword()"></i>\n                        </div>\n                    </div>\n                    <div class="alert alert-success" ng-if="vm.startUpgradeEnabled" role="alert" translate>\n                        USER_UI_AUTHORISED_MESSAGE\n                    </div>\n                </div>\n                <div ng-if="vm.downloadInProgress || vm.installInProgress">\n                    <div class="file">\n                        <div class="status">\n                            <div class="icon">\n                                <i class="fa fa-file-archive-o fa-fw"></i>\n                            </div>\n                            <div class="name">\n                                Version {{ vm.latestVersion }} Install Package\n                            </div>\n                        </div>\n                        <div class="progress">\n                            <div class="progress-bar progress-bar-success progress-bar-striped active" role="progressbar" style="width: 100%;"></div>\n                        </div>\n                        <div class="status">\n                            <span>\n                                Downloading&hellip;\n                            </span>\n                        </div>\n                    </div>\n                </div>\n                <div ng-if="vm.upgradeComplete">\n                    {{ vm.upgradeCompleteMessage }}\n                </div>\n            </div>\n            <div class="modal-footer">\n                <div ng-if="!vm.downloadInProgress &amp;&amp; !vm.installInProgress &amp;&amp; !vm.upgradeComplete">\n                    <button ng-if="!vm.isLicensed" type="button" class="btn btn-default" data-dismiss="modal" translate>DISMISS_CLOSE_ACTION</button>\n                    <button ng-if="vm.isLicensed" type="button" class="btn btn-default float-left" data-dismiss="modal" translate>DISMISS_CANCEL_ACTION</button>\n                    <button ng-if="vm.isLicensed" type="button" class="btn btn-primary right" ng-class="{\'disabled\': !vm.startUpgradeEnabled}" ng-click="vm.startUpgrade()" translate>START_UPGRADE_ACTION</button>\n                </div>\n                <button ng-if="vm.upgradeComplete" type="button" class="btn btn-primary right" ng-click="vm.refresh()" translate>REFRESH</button>\n                <div ng-if="vm.downloadInProgress || vm.installInProgress">\n                    <p class="text-center" translate>DO_NOT_CLOSE_DURING_UPGRADE_BROWSER_MESSAGE</p>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>');
$templateCache.put('application/frontend/templates/modal-upgrade-required.html','<div class="modal fade" id="modal-upgrade-required" tabindex="-1" role="dialog" aria-labelledby="modal-upgrade-required-label"\n     ng-controller="ModalUpgradeRequiredController as vm">\n    <div class="modal-dialog" role="document">\n        <div class="modal-content">\n            <div class="modal-header label-warning">\n                <button type="button" class="close" data-dismiss="modal" aria-label="{{ \'DISMISS_CLOSE_ACTION\'|translate }}">\n                    <span aria-hidden="true">&times;</span>\n                </button>\n                <h4 class="modal-title" id="modal-upgrade-required-label" translate>UPGRADE_REQUIRED</h4>\n            </div>\n            <div class="modal-body">\n                <p translate>{{ vm.upgradeRequiredMessage }}</p>\n            </div>\n            <div class="modal-footer">\n                <button type="button" class="btn btn-default" data-dismiss="modal" translate>DISMISS_CLOSE_ACTION</button>\n            </div>\n        </div>\n    </div>\n</div>');}]);