<?php
require_once("admin/inc/protecao-final.php");


@mysqli_query($conexao,"CREATE TABLE `pedidos_musicais_config` (
  `codigo` int(10) NOT NULL AUTO_INCREMENT,
  `codigo_stm` int(10) NOT NULL,
  `url_logo` VARCHAR(255) NOT NULL,
  `cor_fundo` CHAR(10) NOT NULL DEFAULT '#D7ECE6',
  `pasta` VARCHAR(255) NOT NULL,
  `intervalo_execucao` int(10) NOT NULL DEFAULT '20',
  `intervalo_pedidos` int(10) NOT NULL DEFAULT '10',
  `status` CHAR(3) NOT NULL DEFAULT 'on',
  PRIMARY KEY (`codigo`)
) ENGINE=MyISAM;");

@mysqli_query($conexao,"ALTER TABLE `pedidos_musicais` ADD `ip` VARCHAR(255) NOT NULL DEFAULT '';");
@mysqli_query($conexao,"ALTER TABLE `pedidos_musicais` ADD `data_execucao` DATETIME NOT NULL;");
@mysqli_query($conexao,"ALTER TABLE `pedidos_musicais` ADD `tipo` VARCHAR(255) NOT NULL DEFAULT 'manual';");
@mysqli_query($conexao,"ALTER TABLE `pedidos_musicais` ADD `status` CHAR(3) NOT NULL DEFAULT 'off';");
@mysqli_query($conexao,"ALTER TABLE `pedidos_musicais_config` ADD `url_logo` VARCHAR(255) NOT NULL;");

$total_avisos_ativos = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM avisos WHERE area = 'streaming'"));
$checar_status_aviso = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM avisos_desativados WHERE area = 'streaming' AND codigo_usuario = '".$dados_stm["porta"]."'"));
$total_avisos_exibir = ($total_avisos_ativos > $checar_status_aviso) ? $total_avisos_ativos-$checar_status_aviso : 0;

$dados_config_pedidos = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM pedidos_musicais_config WHERE codigo_stm = '".$dados_stm["codigo"]."'"));

$url_pedidos = (!empty($dados_revenda["dominio_padrao"])) ? "player.".$dados_revenda["dominio_padrao"]."" : "player.".$dados_config["dominio_padrao"]."";


if($_POST) {

if($dados_config_pedidos["codigo"] == 0) {

mysqli_query($conexao,"INSERT INTO pedidos_musicais_config (codigo_stm,url_logo,cor_fundo,pasta,intervalo_execucao,intervalo_pedidos,status) VALUES ('".$dados_stm["codigo"]."','".$_POST['url_logo']."','".$_POST['cor_fundo']."','".$_POST['pasta']."','".$_POST['intervalo_execucao']."','".$_POST['intervalo_pedidos']."','".$_POST['status']."')") or die("Erro ao processar query.<br>Mensagem do servidor: ".mysqli_error($conexao));

} else {

mysqli_query($conexao,"Update pedidos_musicais_config set url_logo = '".$_POST["url_logo"]."', cor_fundo = '".$_POST["cor_fundo"]."', pasta = '".$_POST["pasta"]."', intervalo_execucao = '".$_POST["intervalo_execucao"]."', intervalo_pedidos = '".$_POST["intervalo_pedidos"]."', status = '".$_POST["status"]."' where codigo = '".$dados_config_pedidos["codigo"]."'") or die("Erro ao processar query.<br>Mensagem do servidor: ".mysqli_error($conexao));

}


// Cria o sess&atilde;o do status das ações executadas e redireciona.
$_SESSION["status_acao"] = '<div class="alert alert-success text-center" role="alert">'.$lang['lang_info_config_painel_resultado_ok'].'</div>';

header("Location: /pedidos");
exit();

}

function geoip_pedido($ip) {

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "https://get.geojs.io/v1/ip/geo/".$ip.".json");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE); 
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE); 
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 2);
curl_setopt($ch, CURLOPT_TIMEOUT, 2);
curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows; U; Windows NT 6.0; en-US; rv:1.9.2) Gecko/20100115 Firefox/3.6 (.NET CLR 3.5.30729)');
$resultado = curl_exec($ch);
curl_close($ch);

$dados_geoip = json_decode($resultado);

$pais_codigo = ($dados_geoip->country_code) ? $dados_geoip->country_code : "desconhecido";
$pais_nome = ($dados_geoip->country) ? utf8_decode($dados_geoip->country) : "Desconhecido/Unknown";

return array("pais_sigla" => $pais_codigo, "pais_nome" => $pais_nome, "estado" => utf8_decode(addslashes($dados_geoip->region)), "cidade" => utf8_decode(addslashes($dados_geoip->city)), "latitude" => $dados_geoip->latitude , "longitude" => $dados_geoip->longitude );
}

/////////////////////////////////////////////////
/////////////////// Idioma //////////////////////
/////////////////////////////////////////////////
if($dados_stm["idioma_painel"] == "pt-br") {
$lang[ 'lang_info_pedidos_novo_info1' ] = 'Selecione a pasta onde disponibilizar&aacute; as m&uacute;sicas para os pedidos autom&aacute;ticos.' ;
$lang[ 'lang_info_pedidos_novo_cor_fundo' ] = 'Cor Fundo Página' ;
$lang[ 'lang_info_pedidos_novo_pasta' ] = 'Pasta de Pedidos' ;
$lang[ 'lang_info_pedidos_novo_pasta_selecionar' ] = 'Selecione uma pasta' ;
$lang[ 'lang_info_pedidos_novo_pasta_info' ] = 'Selecione a pasta contendo as m&uacute;sicas disponibilizadas para o sistema de pedidos autom&aacute;ticos.' ;
$lang[ 'lang_info_pedidos_novo_intervalo_pedidos' ] = 'Intervalo Pedidos' ;
$lang[ 'lang_info_pedidos_novo_intervalo_pedidos_info' ] = 'Informe em minutos o intervalo de tempo em que um mesmo ouvinte pode fazer novos pedidos.' ;
$lang[ 'lang_info_pedidos_novo_intervalo_execucao' ] = 'Intervalo Execu&ccedil;&atilde;o' ;
$lang[ 'lang_info_pedidos_novo_intervalo_execucao_info' ] = 'Informe em minutos o intervalo de tempo na execu&ccedil;&atilde;o de cada pedido.' ;
$lang[ 'lang_info_pedidos_novo_ativar' ] = 'Habilitar Pedidos Autom&aacute;ticos' ;
$lang[ 'lang_info_pedidos_novo_ativar_info' ] = 'Marque para habilitar o sistema de pedidos autom&aacute;ticos.' ;
$lang[ 'lang_info_pedidos_novo_widget_info' ] = '<strong>Autom&aacute;tico:</strong> s&atilde;o pedidos realizados por ouvintes que ser&atilde;o executados <strong>autom&aacute;ticamente</strong> pelo <strong>AutoDJ</strong>.<br /><br /><strong>Manual:</strong> s&atilde;o pedidos realizados por ouvintes onde voc&ecirc; executara <strong>manualmente</strong> quando estiver <strong>ao vivo</strong>.' ;
$lang[ 'lang_info_pedidos_novo_url1' ] = 'URL Pedidos Autom&aacute;tico:' ;
$lang[ 'lang_info_pedidos_novo_widget1' ] = 'Widget Pedidos Autom&aacute;tico:' ;
$lang[ 'lang_info_pedidos_novo_url2' ] = 'URL Pedidos Manual:' ;
$lang[ 'lang_info_pedidos_novo_widget2' ] = 'Widget Pedidos Manual:' ;
$lang[ 'lang_info_pedidos_novo_widget_botao' ] = 'Pedir M&uacute;sica' ;
$lang[ 'lang_info_pedidos_novo_tipo_manual' ] = 'Manual' ;
$lang[ 'lang_info_pedidos_novo_tipo_automatico' ] = 'Autom&aacute;tico em ' ;
$lang[ 'lang_info_pedidos_novo_tipo_automatico_executado' ] = 'Executado em ' ;
} else if($dados_stm["idioma_painel"] == "en") {
$lang[ 'lang_info_pedidos_novo_info1' ] = 'Select the folder where to make available&aacute; the songs for the automatic requests.' ;
$lang[ 'lang_info_pedidos_novo_cor_fundo' ] = 'Page Background' ;
$lang[ 'lang_info_pedidos_novo_pasta' ] = 'Request Folder' ;
$lang[ 'lang_info_pedidos_novo_pasta_selecionar' ] = 'Select a folder' ;
$lang[ 'lang_info_pedidos_novo_pasta_info' ] = 'Select the folder containing the songs made available to the automatic ordering system.' ;
$lang[ 'lang_info_pedidos_novo_intervalo_pedidos' ] = 'Requests Interval' ;
$lang[ 'lang_info_pedidos_novo_intervalo_pedidos_info' ] = 'Enter in minutes the time interval in which the same listener can make new requests.' ;
$lang[ 'lang_info_pedidos_novo_intervalo_execucao' ] = 'Execution Interval' ;
$lang[ 'lang_info_pedidos_novo_intervalo_execucao_info' ] = 'Enter in minutes the time interval in the execution of each request.' ;
$lang[ 'lang_info_pedidos_novo_ativar' ] = 'Enable Automatic Requests' ;
$lang[ 'lang_info_pedidos_novo_ativar_info' ] = 'Check to enable automatic ordering system.' ;
$lang[ 'lang_info_pedidos_novo_widget_info' ] = '<strong>Automatic:</strong> are requests made by listeners that will be executed <strong>automatically</strong> by <strong>AutoDJ</strong>.<br /><br /><strong>Manual:</strong> are requests made by listeners where you will <strong>manually</strong> when you are <strong>live</strong>.' ;
$lang[ 'lang_info_pedidos_novo_url1' ] = 'Automatic Request URL:' ;
$lang[ 'lang_info_pedidos_novo_widget1' ] = 'Automatic Orders Widget:' ;
$lang[ 'lang_info_pedidos_novo_url2' ] = 'Manual Request URL:' ;
$lang[ 'lang_info_pedidos_novo_widget2' ] = 'Manual Request Widget:' ;
$lang[ 'lang_info_pedidos_novo_widget_botao' ] = 'Request Music' ;
$lang[ 'lang_info_pedidos_novo_tipo_manual' ] = 'Manual' ;
$lang[ 'lang_info_pedidos_novo_tipo_automatico' ] = 'Automatic on ' ;
$lang[ 'lang_info_pedidos_novo_tipo_automatico_executado' ] = 'Executed on ' ;
} else {
$lang[ 'lang_info_pedidos_novo_info1' ] = 'Seleccione la carpeta donde poner a disposición&aacute; las canciones para las solicitudes autom&aacute;ticas.' ;
$lang[ 'lang_info_pedidos_novo_cor_fundo' ] = 'Color Pagina' ;
$lang[ 'lang_info_pedidos_novo_pasta' ] = 'Carpeta de pedidos';
$lang[ 'lang_info_pedidos_novo_pasta_selecionar' ] = 'Seleccionar una carpeta';
$lang[ 'lang_info_pedidos_novo_pasta_info' ] = 'Seleccione la carpeta que contiene las canciones disponibles para el sistema de pedido autom&aacute;tico.' ;
$lang[ 'lang_info_pedidos_novo_intervalo_pedidos' ] = 'Intervalo de Pedidos';
$lang[ 'lang_info_pedidos_novo_intervalo_pedidos_info' ] = 'Ingrese en minutos el intervalo de tiempo en el que un mismo oyente puede realizar nuevas solicitudes.' ;
$lang[ 'lang_info_pedidos_novo_intervalo_execucao' ] = 'Intervalo de ejecuci&oacute;n';
$lang[ 'lang_info_pedidos_novo_intervalo_execucao_info' ] = 'Ingrese en minutos el intervalo de tiempo en la ejecuci&oacute;n de cada solicitud.' ;
$lang[ 'lang_info_pedidos_novo_ativar' ] = 'Habilitar pedidos autom&aacute;ticos';
$lang[ 'lang_info_pedidos_novo_ativar_info' ] = 'Marque para habilitar el sistema de pedido autom&aacute;tico.' ;
$lang[ 'lang_info_pedidos_novo_widget_info' ] = '<strong>autom&aacute;tico:</strong> son solicitudes realizadas por oyentes que ser&aacute;n ejecutadas <strong>automáticamente</strong> por <strong>AutoDJ</strong>.<br />< br /><strong>Manual:</strong> son solicitudes realizadas por los oyentes en las que <strong>manualmente</strong> cuando estés <strong>en vivo</strong>.' ;
$lang[ 'lang_info_pedidos_novo_url1' ] = 'URL de pedidos autom&aacute;ticos:' ;
$lang[ 'lang_info_pedidos_novo_widget1' ] = 'Widget de pedidos autom&aacute;ticos:' ;
$lang[ 'lang_info_pedidos_novo_url2' ] = 'URL de pedidos manuales:' ;
$lang[ 'lang_info_pedidos_novo_widget2' ] = 'Widget de pedidos manuales:' ;
$lang[ 'lang_info_pedidos_novo_widget_botao' ] = 'Pedir M&uacute;sica' ;
$lang[ 'lang_info_pedidos_novo_tipo_manual' ] = 'Manual';
$lang[ 'lang_info_pedidos_novo_tipo_automatico' ] = 'Autom&aacute;tico en ';
$lang[ 'lang_info_pedidos_novo_tipo_automatico_executado' ] = 'Ejectutado en ' ;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <title>Streaming <?php echo $dados_stm["porta"]; ?></title>
  <link rel="stylesheet" href="/inc/materialdesignicons.min.css">
  <link rel="stylesheet" href="/inc/font-awesome.min.css">
  <link rel="stylesheet" href="/inc/vendor.bundle.base.css">
  <link rel="stylesheet" href="/inc/vendor.bundle.addons.css">
  <?php if($dados_stm["tema_dark"] == "sim") { ?>
  <link rel="stylesheet" href="/inc/theme-dark.css">
  <?php } else { ?>
  <link rel="stylesheet" href="/inc/theme.css">
  <?php } ?>
  <link rel="shortcut icon" href="/img/favicon.ico">
  <script type="text/javascript" src="/inc/ajax-streaming.js"></script>
  <script type="text/javascript" src="/inc/javascript.js"></script>
  <style type="text/css">
    .even { background-color:#FFF; }
    .odd { background-color:#f1f1f1; }
    .off { background-color:#f6f6f6; }
  </style>
</head>

<body>
  <div class="container-scroller">
      <nav class="navbar col-lg-12 col-12 p-0 fixed-top d-flex flex-row">
      <div class="text-center navbar-brand-wrapper d-flex align-items-center justify-content-center">
        <?php if($dados_revenda["url_logo"]) { ?>
        <a class="navbar-brand brand-logo" href="/dashboard"><img id="logo" src="<?php echo $dados_revenda["url_logo"]; ?>" title="Painel" height="60" border="0"></a>
        <?php } else { ?>
        <a class="navbar-brand brand-logo" href="/dashboard"><span>Painel Streaming</span></a>
        <?php } ?>
        <a class="navbar-brand brand-logo-mini" href="/dashboard"><img src="/img/icones/img-icone-logo.png" title="Painel" width="32" height="32" border="0"></a>
      </div>
      <div class="navbar-menu-wrapper d-flex align-items-center justify-content-end justify-content-lg-start">
        <button class="navbar-toggler navbar-toggler align-self-center" type="button" data-toggle="minimize">
          <span class="mdi mdi-menu text-icones"></span>
        </button>
        <ul class="navbar-nav navbar-nav-right">
          <li class="nav-item nav-profile dropdown show">
            <a class="nav-link dropdown-toggle" href="#" data-toggle="dropdown" id="profileDropdown" aria-expanded="true">
              <i class="fa fa-power-off f-18 text-icones" data-toggle="tooltip" data-placement="bottom" title="<?php echo $lang['lang_botao_titulo_ligar']; ?>/<?php echo $lang['lang_botao_titulo_desligar']; ?>"></i>
            </a>
            <div class="dropdown-menu dropdown-menu-right navbar-dropdown" aria-labelledby="profileDropdown">
              <a class="dropdown-item text-success" href="javascript:ligar_streaming('<?php echo $porta_code; ?>');"> <?php echo $lang['lang_botao_titulo_ligar']; ?> Streaming</a>
              <a class="dropdown-item text-danger" href="javascript:desligar_streaming('<?php echo $porta_code; ?>');"> <?php echo $lang['lang_botao_titulo_desligar']; ?> Streaming</a>
              <?php if($dados_stm["autodj"] == "sim") { ?>
              <div class="dropdown-divider"></div>              
              <a class="dropdown-item text-success" href="javascript:carregar_opcoes_ligar_autodj('<?php echo $porta_code; ?>');"> <?php echo $lang['lang_botao_titulo_ligar']; ?> AutoDJ</a>
              <a class="dropdown-item text-danger" href="javascript:desligar_autodj('<?php echo $porta_code; ?>');"> <?php echo $lang['lang_botao_titulo_desligar']; ?> AutoDJ</a>
              <?php } ?>
            </div>
          </li>
          <li class="nav-item dropdown">
            <a class="nav-link count-indicator dropdown-toggle d-flex align-items-center justify-content-center" id="notificationDropdown" href="#" data-toggle="dropdown" aria-expanded="false">
              <i class="mdi mdi-bell f-22 text-icones" data-toggle="tooltip" data-placement="bottom" title="<?php echo $lang['lang_info_pagina_informacoes_tab_avisos']; ?>"></i>
              <?php if($total_avisos_exibir > 0) { ?><span class="count bg-success"><?php echo $total_avisos_exibir; ?></span><?php } ?>           
            </a>
            <div class="dropdown-menu dropdown-menu-right navbar-dropdown preview-list" aria-labelledby="notificationDropdown">
              <a class="dropdown-item">
                <p class="mb-0 font-weight-normal float-left"><?php echo $lang['lang_info_pagina_informacoes_tab_avisos']; ?></p>
              </a>
              <div class="dropdown-divider"></div>
              <?php carregar_avisos_streaming($conexao,$dados_stm["porta"],$dados_servidor["codigo"]); ?>
            </div>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="/sair"><i class="mdi mdi-logout f-22 text-icones" data-toggle="tooltip" data-placement="bottom" title="Sair/logout"></i></a>
          </li>
          <li>
            <button type="button" class="btn btn-info" id="status-streaming" onClick="status_streaming('<?php echo $porta_code; ?>');" style="margin: 10px;min-width: 150px; min-height: 40px"><i class="fa fa-refresh"></i></button>
          </li>
        </ul>
        <button class="navbar-toggler navbar-toggler-right d-lg-none align-self-center" type="button" data-toggle="offcanvas">
          <span class="mdi mdi-menu text-icones"></span>
        </button>
      </div>
    </nav>

    <!-- modal -->
      <div class="modal fade" id="avisos" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo $lang['lang_info_pagina_informacoes_tab_avisos']; ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body" id="avisos-conteudo"><img src="/img/ajax-loader.gif" align="center" /></div>
            </div>
        </div>
      </div>
                
      <div class="modal fade" id="playlists-autodj" tabindex="-1" role="dialog" aria-hidden="true">
          <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">AutoDJ</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body text-center" id="playlists-autodj-conteudo" style="text-align: center;"><img src="/img/ajax-loader.gif" /></div>
            </div>
          </div>
      </div>
                
      <div class="modal fade" id="log-sistema" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-body" id="log-sistema-conteudo" style="text-align:center"><img src="/img/ajax-loader.gif" /></div>
            </div>
        </div>
      </div>
      
    <div class="container-fluid page-body-wrapper">      
    <?php require_once("menu.php"); ?>
      <div class="main-panel">
        <div class="content-wrapper">
          <div id="local-status-acoes"><?php echo $_SESSION['status_acao'];unset($_SESSION['status_acao']); ?></div>
          <div class="row">            

            <div class="col-lg-12">
              <div class="card">
                  <div class="card-header">
                    <header><?php echo $lang['lang_info_streaming_pedidos_musicais_tab_titulo']; ?></header>
                  </div>
                <div class="card-body">
                    <?php echo $lang['lang_info_streaming_pedidos_musicais_widget_info']; ?><br /><br />
                  <div class="card-block">
                                        <div class="table-responsive">
                                            <table id="data_table" class="table dataTable no-footer" role="grid" aria-describedby="data_table_info">
                                                <thead>
                                                    <tr role="row">
                                                        <th><?php echo $lang['lang_info_streaming_pedidos_musicais_data']; ?></th>
                                                        <th><?php echo $lang['lang_info_streaming_pedidos_musicais_ouvinte']; ?></th>
                                                        <th><?php echo $lang['lang_info_streaming_pedidos_musicais_musica']; ?></th>
                                                        <th>Tipo</th>
                                                        <th class="nosort sorting_disabled"></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
<?php
$sql = mysqli_query($conexao,"SELECT * FROM pedidos_musicais WHERE codigo_stm = '".$dados_stm["codigo"]."' ORDER by codigo DESC LIMIT 500");
while ($dados_pedido = mysqli_fetch_array($sql)) {

$data_execucao = date("d/m/Y H:i:s", strtotime($dados_pedido["data_execucao"]));

$musica = substr($dados_pedido["musica"], strrpos($dados_pedido["musica"], '/') + 1);

if($dados_pedido["ip"]) {

$dados_api_geoip = api_geoip($dados_pedido["ip"]);

$cidade = ($dados_api_geoip["cidade"]) ? "- ".$dados_api_geoip["cidade"] : "";
$estado = ($dados_api_geoip["estado"]) ? "- ".$dados_api_geoip["estado"] : "";

$localizacao = "<img src='/img/icones/paises/".strtolower($dados_api_geoip["pais_sigla"]).".png' width='12' height='auto' border='0' align='absmiddle' />&nbsp;".$dados_api_geoip["pais_nome"]." ".$estado." ".$cidade."";

} else {
$localizacao = "Localiza&ccedil;&atilde;o n&atilde;o dispon&iacute;vel";
}


if($dados_pedido["tipo"] == "manual") {
$tipo = $lang[ 'lang_info_pedidos_novo_tipo_manual' ];
} elseif($dados_pedido["tipo"] == "automatico" && $dados_pedido["status"] == "off") {
$tipo = $lang[ 'lang_info_pedidos_novo_tipo_automatico' ].$data_execucao;
} else {
$tipo = $lang[ 'lang_info_pedidos_novo_tipo_automatico_executado' ].$data_execucao;
}

$cor_linha = ($c++%2==1) ? 'odd' : 'even';
$cor_linha = ($dados_pedido["status"] == "on") ? 'off' : $cor_linha;
$cor_status = ($dados_pedido["status"] == "on") ? "style='color: #b7b7b7'" : "";

$pedido_code = code_decode($dados_pedido["codigo"],"E");

echo "<tr id='".$pedido_code."' class='".$cor_linha."'>
<td height='25' align='left' scope='col' ".$cor_status.">&nbsp;".formatar_data($dados_stm["formato_data"], $dados_pedido["data"], $dados_stm["timezone"])."</td>
<td height='25' align='left' scope='col' ".$cor_status.">&nbsp;".$dados_pedido["nome"]." - <small>".$dados_pedido["email"]."<br>&nbsp;".$localizacao."</small></td>
<td height='25' align='left' scope='col' ".$cor_status.">&nbsp;".$musica."</td>
<td height='25' align='left' scope='col' ".$cor_status.">&nbsp;".$tipo."</td>
<td height='25' align='center' scope='col'>&nbsp;<a href='javascript:remover_pedido_musical(\"".$pedido_code."\");'><i class='fa fa-trash-o text-danger'></i></a></td>
</tr>";
unset($cor_linha);
unset($cor_status);
}
?>
                                                </tbody>
                                            </table>
                </div>
              </div>
            </div>

            <div class="col-lg-12">
              <div class="card">
                  <div class="card-header">
                    <header><?php echo $lang['lang_acao_stm_config']; ?></header>
                  </div>
                  <div class="card-body">
                      <div class="alert alert-warning text-center" role="alert"><?php echo $lang['lang_info_pedidos_novo_info1']; ?></div>
                  <form method="post" action="/pedidos" style="padding:0px; margin:0px" name="configuracoes">
                    <table width="100%" border="0" align="center" cellpadding="0" cellspacing="0">
                        <tr>
                          <td height="50" align="left"><strong>URL Logo</strong></td>
                          <td align="left" class="texto_padrao"><input name="url_logo" type="text" class="form-control" id="url_logo" style="display: inherit;" value="<?php echo $dados_config_pedidos["url_logo"]; ?>" /></td>
                        </tr>
                        <tr>
                          <td height="50" align="left"><strong><?php echo $lang['lang_info_pedidos_novo_cor_fundo']; ?></strong></td>
                          <td align="left" class="texto_padrao"><input name="cor_fundo" type="color" class="form-control" id="cor_fundo" style="display: inherit;" value="<?php echo $dados_config_pedidos["cor_fundo"]; ?>" /></td>
                        </tr>
                        <tr>
                          <td width="160" height="50" align="left"><strong><?php echo $lang['lang_info_pedidos_novo_pasta']; ?></strong></td>
                          <td align="left" class="texto_padrao"><select name="pasta" class="form-control" id="pasta" required="required" style="display: inherit;width: 97%;">
                        <optgroup label="<?php echo $lang['lang_info_pedidos_novo_pasta_selecionar']; ?>">
              <?php
              $xml_pastas = @simplexml_load_file("http://".$dados_servidor["ip"].":555/listar-pastas.php?porta=".$dados_stm["porta"]."");
                
              $total_pastas = count($xml_pastas->pasta);

              if($total_pastas > 0) {

                for($i=0;$i<$total_pastas;$i++){
                  
                  if($xml_pastas->pasta[$i]->nome == $dados_config_pedidos["pasta"]) {
                    echo '<option value="' . $xml_pastas->pasta[$i]->nome . '" selected="selected">' . $xml_pastas->pasta[$i]->nome . ' (' . $xml_pastas->pasta[$i]->total . ')</option>';
                  } else {
                    echo '<option value="' . $xml_pastas->pasta[$i]->nome . '">' . $xml_pastas->pasta[$i]->nome . ' (' . $xml_pastas->pasta[$i]->total . ')</option>';
                  }
                }
                
              }
              ?>
                    </optgroup>
                        </select>&nbsp;<i class='fa fa-question-circle'  onclick="alert('<?php echo $lang['lang_info_pedidos_novo_pasta_info']; ?>');" style="cursor:pointer; font-size: 20px" /></i></td>
                        </tr>
                        <tr>
                          <td height="50" align="left"><strong><?php echo $lang['lang_info_pedidos_novo_intervalo_pedidos']; ?></strong></td>
                          <td align="left" class="texto_padrao"><input name="intervalo_pedidos" type="number" min="5" class="form-control" id="intervalo_pedidos"  style="display: inherit;width: 95%;" value="<?php echo $dados_config_pedidos["intervalo_pedidos"]; ?>" required="required" />&nbsp;<i class='fa fa-question-circle' onclick="alert('<?php echo $lang['lang_info_pedidos_novo_intervalo_pedidos_info']; ?>');" style="cursor:pointer; font-size: 20px" /></i></td>
                        </tr>
                        <tr>
                          <td height="50" align="left"><strong><?php echo $lang['lang_info_pedidos_novo_intervalo_execucao']; ?></strong></td>
                          <td align="left" class="texto_padrao"><input name="intervalo_execucao" type="number" min="15" class="form-control" id="intervalo_execucao"  style="display: inherit;width: 95%;" value="<?php echo $dados_config_pedidos["intervalo_execucao"]; ?>" required="required" />&nbsp;<i class='fa fa-question-circle' onclick="alert('<?php echo $lang['lang_info_pedidos_novo_intervalo_execucao_info']; ?>');" style="cursor:pointer; font-size: 20px" /></i></td>
                        </tr>
                        <tr>
                          <td height="50" align="left"><strong><?php echo $lang['lang_info_pedidos_novo_ativar']; ?></strong></td>
                          <td align="left"><input name="status" type="checkbox" id="status" value="on" style="vertical-align:middle"<?php if($dados_config_pedidos["status"] == "on") { echo ' checked="checked"'; } ?> />&nbsp;<?php echo $lang['lang_info_pedidos_novo_ativar_info']; ?></td>
                        </tr>
                                          <tr>
                                            <td height="50" colspan="2" align="right" style="padding-right:20px;"><input name="alterar" type="hidden" id="alterar" value="<?php echo time(); ?>" /><button type="button" class="btn btn-info" onClick="document.configuracoes.submit();"><?php echo $lang['lang_botao_titulo_alterar_config']; ?></button></td>
                                          </tr>
                      </table>
                    </form>
                  </div>
              </div>
            </div>

            <div class="col-lg-12">
              <div class="card">
                  <div class="card-header">
                    <header><?php echo $lang['lang_info_streaming_pedidos_musicais_widget_tab_titulo']; ?></header>
                  </div>
                  <div class="card-body">
                      <?php echo $lang['lang_info_streaming_pedidos_musicais_widget_info']; ?><br /><br />
                 <?php echo $lang['lang_info_pedidos_novo_widget_info']; ?>
                 <br /><br />
                 <span class="texto_padrao_destaque"><?php echo $lang['lang_info_pedidos_novo_url1']; ?></span><br />
<input class="form-control" type="text" value="<?php echo "https://".$url_pedidos."/pedir-musica/".$dados_stm["porta"].""; ?>" style="height:30px"  onclick="this.select()" readonly="readonly" /><br />
<br />
<span class="texto_padrao_destaque"><?php echo $lang['lang_info_pedidos_novo_widget1']; ?></span><br />
<textarea class="form-control" readonly="readonly" style="height:90px; font-size:10px"  onclick="this.select()">
<script type="text/javascript">
function abrir_pedido( url,largura,altura ) {
window.open( url, "","width="+largura+",height="+altura+",toolbar=no,location=no,directories=no,status=yes,menubar=no,scrollbars=yes,resizable=NO" );
}
</script>
<a href="javascript:abrir_pedido( '<?php echo "https://".$url_pedidos."/pedir-musica/".$dados_stm["porta"].""; ?>','505','180' );"><?php echo $lang['lang_info_pedidos_novo_widget_botao']; ?></a>
</textarea><br /><br />
                 <span class="texto_padrao_destaque"><?php echo $lang['lang_info_pedidos_novo_widget2']; ?></span><br />
<input class="form-control" type="text" value="<?php echo "https://".$url_pedidos."/pedido/".$dados_stm["porta"].""; ?>" style="height:30px"  onclick="this.select()" readonly="readonly" /><br />
<br />
<span class="texto_padrao_destaque"><?php echo $lang['lang_info_pedidos_novo_widget2']; ?></span><br />
<textarea class="form-control" readonly="readonly" style="height:90px; font-size:10px"  onclick="this.select()">
<script type="text/javascript">
function abrir_pedido( url,largura,altura ) {
window.open( url, "","width="+largura+",height="+altura+",toolbar=no,location=no,directories=no,status=yes,menubar=no,scrollbars=yes,resizable=NO" );
}
</script>
<a href="javascript:abrir_pedido( '<?php echo "https://".$url_pedidos."/pedido/".$dados_stm["porta"].""; ?>','505','180' );"><?php echo $lang['lang_info_pedidos_novo_widget_botao']; ?></a>
</textarea>
                  </div>
              </div>
            </div>

          </div>
        </div>
      </div>      

    </div>
  </div>
  <script src="/inc/vendor.bundle.base.js"></script>
  <script src="/inc/vendor.bundle.addons.js"></script>
  <script src="/inc/theme.js"></script>
  <script>
  status_streaming('<?php echo $porta_code; ?>');
  setInterval("status_streaming('<?php echo $porta_code; ?>')",60000);
        $(document).ready(function() {

            var table = $('#data_table').DataTable({
                responsive: true,
                "lengthMenu": [[25, 50, 100, 200, -1], [25, 50, 100, 200, "Todos/All"]],
                language: {
                    "url": "//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/<?php echo $lang_sortable; ?>.json"
                },
                select: true,
                'aoColumnDefs': [{
                    'bSortable': false,
                    'aTargets': ['nosort']
                }]
            });
            $('#data_table tbody').on( 'click', 'tr', function() {
                if ( $(this).hasClass('selected') ) {
                    $(this).removeClass('selected');
                }
                else {
                    table.$('tr.selected').removeClass('selected');
                    $(this).addClass('selected');
                }
            });

        });
  </script>
</body>
</html>