<?php
require_once("admin/inc/protecao-final.php");

$total_avisos_ativos = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM avisos WHERE area = 'streaming'"));
$checar_status_aviso = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM avisos_desativados WHERE area = 'streaming' AND codigo_usuario = '".$dados_stm["porta"]."'"));
$total_avisos_exibir = ($total_avisos_ativos > $checar_status_aviso) ? $total_avisos_ativos-$checar_status_aviso : 0;

?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <title>Streaming <?php echo $dados_stm["porta"]; ?></title>
  <link rel="stylesheet" href="/inc/materialdesignicons.min.css">
  <link rel="stylesheet" href="/inc/font-awesome.min.css">
  <link rel="stylesheet" href="/inc/vendor.bundle.base.css">
  <link rel="stylesheet" href="/inc/vendor.bundle.addons.css">
  <?php if($dados_stm["tema_dark"] == "sim") { ?>
  <link rel="stylesheet" href="/inc/theme-dark.css">
  <?php } else { ?>
  <link rel="stylesheet" href="/inc/theme.css">
  <?php } ?>
  <link rel="shortcut icon" href="/img/favicon.ico">
  <script type="text/javascript" src="/inc/ajax-streaming.js"></script>
  <script type="text/javascript" src="/inc/javascript.js"></script>
</head>

<body>
  <div class="container-scroller">
      <nav class="navbar col-lg-12 col-12 p-0 fixed-top d-flex flex-row">
      <div class="text-center navbar-brand-wrapper d-flex align-items-center justify-content-center">
        <?php if($dados_revenda["url_logo"]) { ?>
        <a class="navbar-brand brand-logo" href="/dashboard"><img id="logo" src="<?php echo $dados_revenda["url_logo"]; ?>" title="Painel" height="60" border="0"></a>
        <?php } else { ?>
        <a class="navbar-brand brand-logo" href="/dashboard"><span>Painel Streaming</span></a>
        <?php } ?>
        <a class="navbar-brand brand-logo-mini" href="/dashboard"><img src="/img/icones/img-icone-logo.png" title="Painel" width="32" height="32" border="0"></a>
      </div>
      <div class="navbar-menu-wrapper d-flex align-items-center justify-content-end justify-content-lg-start">
        <button class="navbar-toggler navbar-toggler align-self-center" type="button" data-toggle="minimize">
          <span class="mdi mdi-menu text-icones"></span>
        </button>
        <ul class="navbar-nav navbar-nav-right">
          <li class="nav-item nav-profile dropdown show">
            <a class="nav-link dropdown-toggle" href="#" data-toggle="dropdown" id="profileDropdown" aria-expanded="true">
              <i class="fa fa-power-off f-18 text-icones" data-toggle="tooltip" data-placement="bottom" title="<?php echo $lang['lang_botao_titulo_ligar']; ?>/<?php echo $lang['lang_botao_titulo_desligar']; ?>"></i>
            </a>
            <div class="dropdown-menu dropdown-menu-right navbar-dropdown" aria-labelledby="profileDropdown">
              <a class="dropdown-item text-success" href="javascript:ligar_streaming('<?php echo $porta_code; ?>');"> <?php echo $lang['lang_botao_titulo_ligar']; ?> Streaming</a>
              <a class="dropdown-item text-danger" href="javascript:desligar_streaming('<?php echo $porta_code; ?>');"> <?php echo $lang['lang_botao_titulo_desligar']; ?> Streaming</a>
              <div class="dropdown-divider"></div>              
              <a class="dropdown-item text-success" href="javascript:carregar_opcoes_ligar_autodj('<?php echo $porta_code; ?>');"> <?php echo $lang['lang_botao_titulo_ligar']; ?> AutoDJ</a>
              <a class="dropdown-item text-danger" href="javascript:desligar_autodj('<?php echo $porta_code; ?>');"> <?php echo $lang['lang_botao_titulo_desligar']; ?> AutoDJ</a>
            </div>
          </li>
          <li class="nav-item dropdown">
            <a class="nav-link count-indicator dropdown-toggle d-flex align-items-center justify-content-center" id="notificationDropdown" href="#" data-toggle="dropdown" aria-expanded="false">
              <i class="mdi mdi-bell f-22 text-icones" data-toggle="tooltip" data-placement="bottom" title="<?php echo $lang['lang_info_pagina_informacoes_tab_avisos']; ?>"></i>
              <?php if($total_avisos_exibir > 0) { ?><span class="count bg-success"><?php echo $total_avisos_exibir; ?></span><?php } ?>           
            </a>
            <div class="dropdown-menu dropdown-menu-right navbar-dropdown preview-list" aria-labelledby="notificationDropdown">
              <a class="dropdown-item">
                <p class="mb-0 font-weight-normal float-left"><?php echo $lang['lang_info_pagina_informacoes_tab_avisos']; ?></p>
              </a>
              <div class="dropdown-divider"></div>
              <?php carregar_avisos_streaming($conexao,$dados_stm["porta"],$dados_servidor["codigo"]); ?>
            </div>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="/sair"><i class="mdi mdi-logout f-22 text-icones" data-toggle="tooltip" data-placement="bottom" title="Sair/logout"></i></a>
          </li>
          <li>
            <button type="button" class="btn btn-info" id="status-streaming" onClick="status_streaming('<?php echo $porta_code; ?>');" style="margin: 10px;min-width: 150px; min-height: 40px"><i class="fa fa-refresh"></i></button>
          </li>
        </ul>
        <button class="navbar-toggler navbar-toggler-right d-lg-none align-self-center" type="button" data-toggle="offcanvas">
          <span class="mdi mdi-menu text-icones"></span>
        </button>
      </div>
    </nav>

    <!-- modal -->
      <div class="modal fade" id="avisos" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo $lang['lang_info_pagina_informacoes_tab_avisos']; ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body" id="avisos-conteudo"><img src="/img/ajax-loader.gif" align="center" /></div>
            </div>
        </div>
      </div>
                
      <div class="modal fade" id="playlists-autodj" tabindex="-1" role="dialog" aria-hidden="true">
          <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">AutoDJ</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body text-center" id="playlists-autodj-conteudo" style="text-align: center;"><img src="/img/ajax-loader.gif" /></div>
            </div>
          </div>
      </div>
                
      <div class="modal fade" id="log-sistema" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-body" id="log-sistema-conteudo" style="text-align:center"><img src="/img/ajax-loader.gif" /></div>
            </div>
        </div>
      </div>
      
    <div class="container-fluid page-body-wrapper">      
    <?php require_once("menu.php"); ?>
      <div class="main-panel">
        <div class="content-wrapper">
          <div id="local-status-acoes"><?php echo $_SESSION['status_acao'];unset($_SESSION['status_acao']); ?></div>
          <div class="row">            

            <div class="col-xl-6 col-md-6">
                                <div class="card table-card">
                                    <div class="card-header">
                                        <header><?php echo $lang['lang_info_streaming_dados_conexao_aba_streaming']; ?></header>
                                    </div>
                                    <div class="card-body">
                                        <div class="table-responsive">
                                            <table width="100%" border="0" align="center" cellpadding="0" cellspacing="0">
                                              <tr>
                                                <td width="160" height="30" align="left" style="padding-left:5px;"><strong>Servidor/Server</strong></td>
                                                <td align="left"><?php echo dominio_servidor($conexao,$dados_servidor["nome"]); ?>&nbsp;&nbsp;<span class="badge badge-primary"  onClick="copiar_texto('<?php echo dominio_servidor($conexao,$dados_servidor["nome"]); ?>');" style="cursor:pointer;padding: 4px;" title="Copiar/Copy"><i class="fa fa-files-o" style="font-size: 11px;"></i></span></td>
                                              </tr>
                                              <?php if($dados_stm["tipo_servidor"] == "icecast") { ?>
                                              <tr>
                                                <td height="30" align="left" style="padding-left:5px;"><strong>Porta/Port</strong></td>
                                                <td align="left"><code><?php echo $dados_stm["porta"]+1; ?><code>&nbsp;&nbsp;<span class="badge badge-primary"  onClick="copiar_texto('<?php echo $dados_stm["porta"]+1; ?>');" style="cursor:pointer;padding: 4px;" title="Copiar/Copy"><i class="fa fa-files-o" style="font-size: 11px;"></i></span></td>
                                              </tr>
                                              <?php } ?>
                                              <?php if($dados_stm["tipo_servidor"] == "shoutcast") { ?>
                                              <tr>
                                                <td height="30" align="left" style="padding-left:5px;"><strong>Porta/Port</strong></td>
                                                <td align="left"><?php echo $dados_stm["porta"]; ?>&nbsp;&nbsp;<span class="badge badge-primary"  onClick="copiar_texto('<?php echo $dados_stm["porta"]; ?>');" style="cursor:pointer;padding: 4px;" title="Copiar/Copy"><i class="fa fa-files-o" style="font-size: 11px;"></i></span></td>
                                              </tr>
                                              <?php } ?>
                                              <tr>
                                                <td width="160" height="30" align="left" style="padding-left:5px;"><strong>Senha/Password</strong></td>
                                                <td align="left"><?php echo $dados_stm["senha"]; ?>&nbsp;&nbsp;<span class="badge badge-primary"  onClick="copiar_texto('<?php echo $dados_stm["senha"]; ?>');" style="cursor:pointer;padding: 4px;" title="Copiar/Copy"><i class="fa fa-files-o" style="font-size: 11px;"></i></span></td>
                                              </tr>
                                              <tr>
                                                <td height="30" align="left" style="padding-left:5px;"><strong>Bitrate</strong></td>
                                                <td align="left"><?php echo $dados_stm["bitrate"]; ?> Kbps</td>
                                              </tr>
                                              <?php if($dados_stm["tipo_servidor"] == "icecast") { ?>
                                              <tr>
                                                <td height="30" align="left" style="padding-left:5px;"><strong>IceCast Mount</strong></td>
                                                <td align="left">/stream</td>
                                              </tr>
                                              <?php } ?>
                                              <?php if($dados_stm["tipo_servidor"] == "shoutcast") { ?>
                                              <tr>
                                                <td height="30" align="left" style="padding-left:5px;"><strong>ShoutCast</strong></td>
                                                <td align="left" class="texto_padrao_vermelho_destaque">v2</td>
                                              </tr>
                                              <tr>
                                                <td height="30" align="left" style="padding-left:5px;"><strong>SID</strong></td>
                                                <td align="left">1 <?php echo $lang['lang_info_streaming_dados_conexao_streaming_info_sid']; ?></td>
                                              </tr>
                                              <?php } ?>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php if($dados_stm["autodj"] == "sim") { ?>
                            <div class="col-xl-6 col-md-6">
                                <div class="card table-card">
                                    <div class="card-header">
                                        <header><?php echo $lang['lang_info_streaming_dados_conexao_aba_autodj']; ?></header>
                                    </div>
                                    <div class="card-body">
                                        <div class="table-responsive">
                                            <table width="100%" border="0" align="center" cellpadding="0" cellspacing="0">
                                              <tr>
                                                <td width="160" height="30" align="left" style="padding-left:5px;"><strong>Servidor/Server</strong></td>
                                                <td align="left"><?php echo dominio_servidor($conexao,$dados_servidor["nome"]); ?>&nbsp;&nbsp;<span class="badge badge-primary"  onClick="copiar_texto('<?php echo dominio_servidor($conexao,$dados_servidor["nome"]); ?>');" style="cursor:pointer;padding: 4px;" title="Copiar/Copy"><i class="fa fa-files-o" style="font-size: 11px;"></i></span></td>
                                              </tr>
                                              <tr>
                                                <td height="30" align="left" style="padding-left:5px;"><strong>Porta/Port</strong></td>
                                                <td align="left"><?php echo $dados_stm["porta_dj"]; ?>&nbsp;&nbsp;<span class="badge badge-primary"  onClick="copiar_texto('<?php echo $dados_stm["porta_dj"]; ?>');" style="cursor:pointer;padding: 4px;" title="Copiar/Copy"><i class="fa fa-files-o" style="font-size: 11px;"></i></span></td>
                                              </tr>
                                              <tr>
                                                <td width="160" height="30" align="left" style="padding-left:5px;"><strong>Senha/Password</strong></td>
                                                <td align="left"><?php echo $lang['lang_info_streaming_dados_conexao_autodj_info_senha']; ?></td>
                                              </tr>
                                              <?php if($dados_stm["tipo_servidor"] == "icecast") { ?>
                                              <tr>
                                                <td height="30" align="left" style="padding-left:5px;"><strong>IceCast Mount</strong></td>
                                                <td align="left">/stream</td>
                                              </tr>
                                              <?php } ?>
                                              <?php if($dados_stm["tipo_servidor"] == "shoutcast") { ?>
                                              <tr>
                                                <td height="30" align="left" style="padding-left:5px;"><strong>ShoutCast</strong></td>
                                                <td align="left" class="texto_padrao_vermelho_destaque">v1</td>
                                              </tr>  
                                              <?php } ?>  
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-xl-6 col-md-6">
                                <div class="card table-card">
                                    <div class="card-header">
                                        <header><?php echo $lang['lang_info_streaming_dados_conexao_aba_ftp']; ?></header>
                                    </div>
                                    <div class="card-body">
                                        <div class="table-responsive">
                                            <table width="100%" border="0" align="center" cellpadding="0" cellspacing="0">
                                              <tr>
                                                <td width="160" height="30" align="left" style="padding-left:5px;"><strong>Servidor/Server/Host</strong></td>
                                                <td align="left"><?php echo dominio_servidor($conexao,$dados_servidor["nome"]); ?>&nbsp;&nbsp;<span class="badge badge-primary"  onClick="copiar_texto('<?php echo dominio_servidor($conexao,$dados_servidor["nome"]); ?>');" style="cursor:pointer;padding: 4px;" title="Copiar/Copy"><i class="fa fa-files-o" style="font-size: 11px;"></i></span></td>
                                              </tr>
                                              <tr>
                                                <td height="30" align="left" style="padding-left:5px;"><strong>Usu&aacute;rio/User/Login</strong></td>
                                                <td align="left"><?php echo $dados_stm["porta"]; ?>&nbsp;&nbsp;<span class="badge badge-primary"  onClick="copiar_texto('<?php echo $dados_stm["porta"]; ?>');" style="cursor:pointer;padding: 4px;" title="Copiar/Copy"><i class="fa fa-files-o" style="font-size: 11px;"></i></span></td>
                                              </tr>
                                              <tr>
                                                <td width="160" height="30" align="left" style="padding-left:5px;"><strong>Senha/Password</strong></td>
                                                <td align="left"><?php echo $dados_stm["senha"]; ?>&nbsp;&nbsp;<span class="badge badge-primary"  onClick="copiar_texto('<?php echo $dados_stm["senha"]; ?>');" style="cursor:pointer;padding: 4px;" title="Copiar/Copy"><i class="fa fa-files-o" style="font-size: 11px;"></i></span></td>
                                              </tr>
                                              <tr>
                                                <td height="30" align="left" style="padding-left:5px;"><strong>Porta/Port</strong></td>
                                                <td align="left">21 <?php echo $lang['lang_info_streaming_dados_conexao_ftp_info_porta']; ?></td>
                                              </tr>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php } ?>

                            <?php if($dados_stm["tipo_servidor"] == "icecast") { ?>                            
                            <div class="col-xl-6 col-md-6">
                                <div class="card table-card">
                                    <div class="card-header">
                                        <header>IceCast Admins</header>
                                    </div>
                                    <div class="card-body">
                                        <div class="table-responsive">
                                            <table width="100%" border="0" align="center" cellpadding="0" cellspacing="0">
                                              <tr>
                                                <td width="160" height="30" align="left" style="padding-left:5px;"><strong>URL</strong></td>
                                                <td align="left"><a href="https://<?php echo $dados_servidor["nome"]; ?>.<?php echo $dados_config["dominio_padrao"]; ?>:<?php echo $dados_stm["porta"]; ?>" target="_blank">https://<?php echo $dados_servidor["nome"]; ?>.<?php echo $dados_config["dominio_padrao"]; ?>:<?php echo $dados_stm["porta"]; ?></a></td>
                                              </tr>
                                              <tr>
                                                <td height="30" align="left" style="padding-left:5px;"><strong><?php echo $lang['lang_info_streaming_dados_conexao_shoutcast_admin_usuario']; ?></strong></td>
                                                <td align="left">admin</td>
                                              </tr>
                                              <tr>
                                                <td width="160" height="30" align="left" style="padding-left:5px;"><strong><?php echo $lang['lang_info_streaming_dados_conexao_shoutcast_admin_senha']; ?></strong></td>
                                                <td align="left">
                                                <?php
                                                if($dados_stm["senha_admin"]) {
                                                echo $dados_stm["senha_admin"];
                                                } else {
                                                echo $lang['lang_info_streaming_dados_conexao_shoutcast_admin_senha_info'];
                                                }
                                                ?></td>
                                              </tr>                                              
                                              <tr>
                                                <td height="37" colspan="2"></td>
                                              </tr>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php } ?>
                            
                            <?php if($dados_stm["tipo_servidor"] == "shoutcast") { ?>  
                            <div class="col-xl-6 col-md-6">
                                <div class="card table-card">
                                    <div class="card-header">
                                        <header><?php echo $lang['lang_info_streaming_dados_conexao_aba_shoutcast_admin']; ?></header>
                                    </div>
                                    <div class="card-body">
                                        <div class="table-responsive">
                                            <table width="100%" border="0" align="center" cellpadding="0" cellspacing="0">
                                              <tr>
                                                <td width="160" height="30" align="left" style="padding-left:5px;"><strong>URL</strong></td>
                                                <td align="left"><a href="http://<?php echo dominio_servidor($conexao,$dados_servidor["nome"]); ?>:<?php echo $dados_stm["porta"]; ?>" target="_blank">http://<?php echo dominio_servidor($conexao,$dados_servidor["nome"]); ?>:<?php echo $dados_stm["porta"]; ?></a></td>
                                              </tr>
                                              <tr>
                                                <td height="30" align="left" style="padding-left:5px;"><strong><?php echo $lang['lang_info_streaming_dados_conexao_shoutcast_admin_usuario']; ?></strong></td>
                                                <td align="left">admin</td>
                                              </tr>
                                              <tr>
                                                <td width="160" height="30" align="left" style="padding-left:5px;"><strong><?php echo $lang['lang_info_streaming_dados_conexao_shoutcast_admin_senha']; ?></strong></td>
                                                <td align="left">
                                                <?php
                                                if($dados_stm["senha_admin"]) {
                                                echo $dados_stm["senha_admin"];
                                                } else {
                                                echo $lang['lang_info_streaming_dados_conexao_shoutcast_admin_senha_info'];
                                                }
                                                ?></td>
                                              </tr>                                              
                                              <tr>
                                                <td height="37" colspan="2"></td>
                                              </tr>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php } ?>

          </div>
        </div>
      </div>      

    </div>
  </div>
  <script src="/inc/vendor.bundle.base.js"></script>
  <script src="/inc/vendor.bundle.addons.js"></script>
  <script src="/inc/theme.js"></script>
  <script>
  status_streaming('<?php echo $porta_code; ?>');
  setInterval("status_streaming('<?php echo $porta_code; ?>')",60000);
  </script>
</body>
</html>