package com.shoutcast.stm.radio_nome.activities;

import static com.shoutcast.stm.radio_nome.Config.PORTA;

import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.WindowManager;
import android.view.animation.AnimationUtils;
import android.view.inputmethod.InputMethodManager;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;
import android.widget.VideoView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.ActionBarDrawerToggle;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.core.content.ContextCompat;
import androidx.core.view.GravityCompat;
import androidx.drawerlayout.widget.DrawerLayout;

import com.airbnb.lottie.LottieAnimationView;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.StringRequest;
import com.android.volley.toolbox.Volley;
import com.shoutcast.stm.radio_nome.BuildConfig;
import com.shoutcast.stm.radio_nome.Config;
import com.shoutcast.stm.radio_nome.R;
import com.shoutcast.stm.radio_nome.models.Radio;
import com.shoutcast.stm.radio_nome.services.RadioPlayerService;
import com.shoutcast.stm.radio_nome.utils.Constant;
import com.shoutcast.stm.radio_nome.utils.SharedPref;
import com.shoutcast.stm.radio_nome.utils.Utils;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.load.resource.drawable.DrawableTransitionOptions;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.target.Target;
import com.glide.slider.library.SliderLayout;
import com.glide.slider.library.indicators.PagerIndicator;
import com.glide.slider.library.slidertypes.BaseSliderView;
import com.glide.slider.library.slidertypes.DefaultSliderView;
import com.google.android.material.navigation.NavigationView;
import com.makeramen.roundedimageview.RoundedImageView;
import com.next.androidintentlibrary.BrowserIntents;
import com.next.androidintentlibrary.MarketIntents;
import com.next.androidintentlibrary.ShareIntents;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class MainActivity extends AppCompatActivity implements NavigationView.OnNavigationItemSelectedListener {

    private static final String TAG = "MainActivity";
    private static final String SELECTED_TAG = "selected_index";

    ProgressBar progressBar;
    RoundedImageView imgRadioLarge;
    RoundedImageView imgAlbumArtLarge;
    ImageView imgMusicBackground, expanded_menu;
    ImageView logo;
    ImageView fabPlayExpand;
    TextView txtRadioExpand, txtRadioMusicSong, txtSongExpand;
    private ImageView btn_whatsapp, btn_facebook, btn_tv, btn_youtube, btn_twitter, btn_share, btn_instagram, btn_site;
    private SliderLayout imgSlider;
    // EqualizerView equalizerView;
    Utils utils;
    private NavigationView navigationView;
    private ImageView iv_header;
    LottieAnimationView logoanime;
    String video_url;
    private VideoView videoBG;
    MediaPlayer mMediaPlayer;
    int mCurrentVideoPosition;
    LinearLayout lytExit;
    View lytDialog;
    ArrayList<Radio> radios;
    SharedPref sharedPref;

    //LinearLayout socialLyt;
    private ImageView socialFacebook, socialInstagram, socialTwitter;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        MyApplication.theme.setTheme(MainActivity.this);
        MyApplication.theme(MainActivity.this);
        switch (MyApplication.layout) {
            case "layout01":
                setContentView(R.layout.activity_main1);
                break;
            case "layout02":
                setContentView(R.layout.activity_main2);
                break;
            case "layout03":
                setContentView(R.layout.activity_main3);
                break;
            default:
                setContentView(R.layout.activity_main1);
                break;

        }


        if (Config.ENABLE_RTL_MODE) {
            getWindow().getDecorView().setLayoutDirection(View.LAYOUT_DIRECTION_RTL);
        }

        sharedPref = new SharedPref(this);
        sharedPref.setCheckSleepTime();
        navigationView = (NavigationView) findViewById(R.id.nav_view);
        expanded_menu = findViewById(R.id.bt_menu);
        socialFacebook = findViewById(R.id.bt_facebook);
        socialInstagram = findViewById(R.id.bt_instagram);
        socialTwitter = findViewById(R.id.bt_twitter);
        logoanime = findViewById(R.id.logoanime);
        imgSlider = findViewById(R.id.slider);

        utils = new Utils(this);
        radios = Constant.item_radio;

        Toolbar toolbar = findViewById(R.id.toolbar_main);
        setSupportActionBar(toolbar);

        DrawerLayout drawer = findViewById(R.id.drawer_layout);
        ActionBarDrawerToggle toggle = new ActionBarDrawerToggle(this, drawer, toolbar, R.string.navigation_drawer_open, R.string.navigation_drawer_close);
        drawer.addDrawerListener(toggle);
        toggle.syncState();
        navigationView.setNavigationItemSelectedListener(this);
        if (savedInstanceState != null) {
            navigationView.getMenu().getItem(savedInstanceState.getInt(SELECTED_TAG)).setChecked(true);
            return;
        }
        View header = navigationView.getHeaderView(0);
        iv_header = header.findViewById(R.id.imageView);
        btn_whatsapp = findViewById(R.id.bt_whatsapp);
        btn_facebook = findViewById(R.id.bt_facebook);
        btn_tv = findViewById(R.id.bt_tv);
        btn_instagram = findViewById(R.id.bt_instagram);
        btn_site = findViewById(R.id.bt_site);
        btn_youtube = findViewById(R.id.bt_youtube);
        btn_twitter = findViewById(R.id.bt_twitter);
        btn_share = findViewById(R.id.bt_share);
    /*    socialFacebook.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                loadWebsite(getString(R.string.facebook));
            }
        });

        socialInstagram.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                loadWebsite(getString(R.string.instagram));
            }
        });

        socialTwitter.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                loadWebsite(getString(R.string.twitter));
            }
        });*/
       StringRequest postRequest = new StringRequest(Request.Method.POST, Config.BASE_URL + "api-source-3.0.php?porta="+PORTA+"&get_video=get_video",
                new Response.Listener<String>() {
                    @Override
                    public void onResponse(String response) {
                        // response
                        Log.d("tvlog", response);
                        if (response.length() > 0) {
                            JSONArray jsonArr = null;
                            try {
                                jsonArr = new JSONArray(response);
                                for (int i = 0; i < jsonArr.length(); i++) {
                                    JSONObject jsonObj = jsonArr.getJSONObject(i);
                                    video_url = jsonObj.getString("video_url");
                                    //initializeVideoStreaming(video_url);
                                    if (jsonObj.has("video_url" )) {
                                        videoBG = (VideoView) findViewById(R.id.video);
                                        ImageView thumbnailView=findViewById(R.id.videoView_thumbnail);
                                        Glide.with(getApplicationContext())
                                                .load(Config.URL_IMAGE_RADIO + jsonObj.getString("video_url"))
                                                .transition(DrawableTransitionOptions.withCrossFade(200))
                                                .into(thumbnailView);
                                    }
                                }
                            } catch (JSONException e) {
                                e.printStackTrace();
                            }
                        } else {
                            //Uri uri = Uri.parse("android.resource://" + getPackageName() + "/" + R.raw.pp);
                        }


                    }
                },
                new Response.ErrorListener() {
                    @Override
                    public void onErrorResponse(VolleyError error) {
                        // error
                        Log.d("Error.Response", error.toString());
                    }
                }
        ) {
            @Override
            protected Map<String, String> getParams() {
                Map<String, String> params = new HashMap<String, String>();
                params.put("get_video", "get_video");

                return params;
            }
        };

        RequestQueue mRequestQueue = Volley.newRequestQueue(getApplicationContext());
        // Adding request to request queue
        mRequestQueue.add(postRequest);

        videoBG = (VideoView) findViewById(R.id.video);
        ImageView thumbnailView=findViewById(R.id.videoView_thumbnail);
        //Uri uri = Uri.parse("android.resource://" + getPackageName() + "/" + R.raw.pp);
        Glide.with(getApplicationContext())
                .load(R.drawable.bgvideo)
                .transition(DrawableTransitionOptions.withCrossFade(200))
                .into(thumbnailView);
        // in the raw folder.

        // Set the new Uri to our VideoView
        //videoBG.setVideoURI(uri);
        videoBG.start();

        btn_facebook.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse(Config.FACEBOOK_URL)));
            }
        });

        btn_tv.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (isServiceRunning()) {
                    Intent stop = new Intent(MainActivity.this, RadioPlayerService.class);
                    stop.setAction(RadioPlayerService.ACTION_STOP);
                    startService(stop);}
                startActivity(new Intent(getApplicationContext(), TvActivity.class));
            }
        });

        btn_instagram.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse(Config.INSTAGRAM_URL)));
            }
        });

        btn_site.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse(Config.SITE_URL)));
            }
        });

        btn_whatsapp.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse(Config.WHATSAPP_URL)));
            }
        });

        btn_share.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent sendInt = new Intent(Intent.ACTION_SEND);
                sendInt.putExtra(Intent.EXTRA_SUBJECT, getString(R.string.app_name));
                sendInt.putExtra(Intent.EXTRA_TEXT, getString(R.string.share_text) + "\nhttps://play.google.com/store/apps/details?id=" + getPackageName());
                sendInt.setType("text/plain");
                startActivity(Intent.createChooser(sendInt, "Share"));            }
        });

        btn_youtube.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse(Config.YOUTUBE_URL)));
            }
        });

        expanded_menu.setOnClickListener(new View.OnClickListener() {
            public void onClick(View v) {
                drawer.openDrawer(GravityCompat.START); //use drawer from parent activity
            }
        });

        videoBG.setOnPreparedListener(new MediaPlayer.OnPreparedListener() {
            @Override
            public void onPrepared(MediaPlayer mediaPlayer) {
                thumbnailView.setVisibility(View.GONE);
                mMediaPlayer = mediaPlayer;
                mMediaPlayer.setVolume(0f,0f);

                // We want our video to play over and over so we set looping to true.
                mMediaPlayer.setLooping(true);
                // We then seek to the current posistion if it has been set and play the video.
                if (mCurrentVideoPosition != 0) {
                    mMediaPlayer.seekTo(mCurrentVideoPosition);
                    mMediaPlayer.start();
                }
            }
        });
        videoBG.setOnCompletionListener(new MediaPlayer.OnCompletionListener()

        {
            @Override
            public void onCompletion (MediaPlayer mediaPlayer){
                //videoBG.stopPlayback();
                thumbnailView.setVisibility(View.VISIBLE);

            }
        });

        initComponent();
        initExitDialog();
        displayData();
        carregarMenu();
        makeGetSliderRequest();
        menuLateral();
        carregarlogo();



        final AudioManager am = (AudioManager) getSystemService(Context.AUDIO_SERVICE);
        assert am != null;


        /*SeekBar volumeSeekBar = findViewById(R.id.volumeSeekBar);
        volumeSeekBar.setMax(am.getStreamMaxVolume(AudioManager.STREAM_MUSIC));
        volumeSeekBar.setProgress(am.getStreamVolume(AudioManager.STREAM_MUSIC));
        volumeSeekBar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener() {
            @Override
            public void onProgressChanged(SeekBar seekBar, int i, boolean b) {
                try {
                    am.setStreamVolume(AudioManager.STREAM_MUSIC, i, 0);
                } catch (Exception e) {
                    e.printStackTrace();
                    am.setStreamVolume(AudioManager.STREAM_MUSIC, i, 0);
                }
            }

            @Override
            public void onStartTrackingTouch(SeekBar seekBar) {

            }

            @Override
            public void onStopTrackingTouch(SeekBar seekBar) {

            }
        });*/

    }

    private void carregarlogo() {
        RequestQueue queue = Volley.newRequestQueue(this);
        String url = Config.BASE_URL + "api-source-3.0.php?porta="+PORTA+"&get_radio=true";

        StringRequest stringRequest = new StringRequest(Request.Method.GET, url,
                new Response.Listener<String>() {
                    @Override
                    public void onResponse(String response) {
                        Log.e("livro", response);
                        try {
                            JSONArray jsonArr = new JSONArray(response);
                            JSONObject jsonObj = jsonArr.getJSONObject(0);
                            if (jsonObj.has("radio_image" )) {
                                Glide.with(getApplicationContext()).load(Config.URL_IMAGE_RADIO + jsonObj.getString("radio_image")).into(iv_header);
                            }
                        } catch (JSONException e) {
                            e.printStackTrace();
                        }

                    }
                }, new Response.ErrorListener() {
            @Override
            public void onErrorResponse(VolleyError error) {
            }
        });

        // Add the request to the RequestQueue.
        queue.add(stringRequest);
    }

    private void menuLateral() {
        StringRequest postRequest = new StringRequest(Request.Method.POST, Config.BASE_URL + "api-source-3.0.php?porta="+PORTA+"&get_MenuApp=true",
                new Response.Listener<String>() {

                    public void onResponse(String response) {
                        JSONArray jsonArr = null;

                        try {
                            jsonArr = new JSONArray(response);
                            JSONObject jsonObj = jsonArr.getJSONObject(0);

                        /*    if (jsonObj.optString("tv_status").equalsIgnoreCase("ativado")) {
                                Menu navigation_menu = navigationView.getMenu();
                                navigation_menu.findItem(R.id.drawer_tv).setVisible(true);
                                Config.TV_URL = "" + jsonObj.get("tv_link");
                            } else {
                                Menu navigation_menu = navigationView.getMenu();
                                navigation_menu.findItem(R.id.drawer_tv).setVisible(false);
                            }

                            if (jsonObj.optString("programacao_status").equalsIgnoreCase("ativado")) {
                                Menu navigation_menu = navigationView.getMenu();
                                navigation_menu.findItem(R.id.drawer_progamacao).setVisible(true);

                            } else {
                                Menu navigation_menu = navigationView.getMenu();
                                navigation_menu.findItem(R.id.drawer_progamacao).setVisible(false);
                            }

                            if (jsonObj.optString("equipe_status").equalsIgnoreCase("ativado")) {
                                Menu navigation_menu = navigationView.getMenu();
                                navigation_menu.findItem(R.id.drawer_equipe).setVisible(true);

                            } else {
                                Menu navigation_menu = navigationView.getMenu();
                                navigation_menu.findItem(R.id.drawer_equipe).setVisible(false);
                            }

                            if (jsonObj.optString("noticias_status").equalsIgnoreCase("ativado")) {
                                Menu navigation_menu = navigationView.getMenu();
                                navigation_menu.findItem(R.id.drawer_noticias).setVisible(true);

                            } else {
                                Menu navigation_menu = navigationView.getMenu();
                                navigation_menu.findItem(R.id.drawer_noticias).setVisible(false);
                            }

                            if (jsonObj.optString("recados_status").equalsIgnoreCase("ativado")) {
                                Menu navigation_menu = navigationView.getMenu();
                                navigation_menu.findItem(R.id.drawer_mural).setVisible(true);

                            } else {
                                Menu navigation_menu = navigationView.getMenu();
                                navigation_menu.findItem(R.id.drawer_mural).setVisible(false);
                            }*/

                            if (jsonObj.optString("site_status").equalsIgnoreCase("ativado")) {
                                Menu navigation_menu = navigationView.getMenu();
                                navigation_menu.findItem(R.id.web).setVisible(true);
                                Config.SITE_URL = "" + jsonObj.get("site_link");
                            } else {
                                Menu navigation_menu = navigationView.getMenu();
                                navigation_menu.findItem(R.id.web).setVisible(false);
                            }

                            if (jsonObj.optString("tv_status").equalsIgnoreCase("ativado")) {
                                Menu navigation_menu = navigationView.getMenu();
                                navigation_menu.findItem(R.id.tv).setVisible(true);
                                Config.WHATSAPP_URL = "" + jsonObj.get("tv_link");
                            } else {
                                Menu navigation_menu = navigationView.getMenu();
                                navigation_menu.findItem(R.id.tv).setVisible(false);
                            }

                            if (jsonObj.optString("facebook_status").equalsIgnoreCase("ativado")) {
                                Menu navigation_menu = navigationView.getMenu();
                                navigation_menu.findItem(R.id.facebook).setVisible(true);
                                Config.FACEBOOK_URL = "" + jsonObj.get("facebook_link");
                            } else {
                                Menu navigation_menu = navigationView.getMenu();
                                navigation_menu.findItem(R.id.facebook).setVisible(false);
                            }

                            if (jsonObj.optString("twitter_status").equalsIgnoreCase("ativado")) {
                                Menu navigation_menu = navigationView.getMenu();
                                navigation_menu.findItem(R.id.twitter).setVisible(true);
                                Config.TWITTER_URL = "" + jsonObj.get("twitter_link");
                            } else {
                                Menu navigation_menu = navigationView.getMenu();
                                navigation_menu.findItem(R.id.twitter).setVisible(false);
                            }

                            if (jsonObj.optString("instagram_status").equalsIgnoreCase("ativado")) {
                                Menu navigation_menu = navigationView.getMenu();
                                navigation_menu.findItem(R.id.instagram).setVisible(true);
                                Config.INSTAGRAM_URL = "" + jsonObj.get("instagram_link");
                            } else {
                                Menu navigation_menu = navigationView.getMenu();
                                navigation_menu.findItem(R.id.instagram).setVisible(false);
                            }

                            if (jsonObj.optString("youtube_status").equalsIgnoreCase("ativado")) {
                                Menu navigation_menu = navigationView.getMenu();
                                navigation_menu.findItem(R.id.youtube).setVisible(true);
                                Config.YOUTUBE_URL = "" + jsonObj.get("youtube_link");
                            } else {
                                Menu navigation_menu = navigationView.getMenu();
                                navigation_menu.findItem(R.id.youtube).setVisible(false);
                            }

                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                },
                new Response.ErrorListener() {
                    @Override
                    public void onErrorResponse(VolleyError error) {

                    }
                }
        ) {
            @Override
            protected Map<String, String> getParams() {
                Map<String, String> params = new HashMap<String, String>();
                params.put("get_MenuApp", "get_MenuApp");

                return params;
            }
        };


        RequestQueue mRequestQueue = Volley.newRequestQueue(getApplicationContext());
        // Adding request to request queue
        mRequestQueue.add(postRequest);

    }

    private void makeGetSliderRequest() {

        StringRequest postRequest = new StringRequest(Request.Method.POST, Config.BASE_URL + "api-source-3.0.php?porta="+PORTA+"",
                new Response.Listener<String>() {
                    @Override
                    public void onResponse(String response) {
                        // response
                        Log.d("slider", response);

                        JSONArray jsonArr = null;
                        try {
                            jsonArr = new JSONArray(response);
                            for (int i = 0; i < jsonArr.length(); i++) {
                                final JSONObject jsonObj = jsonArr.getJSONObject(i);
                                //TextSliderView sliderView = new TextSliderView(getApplication());
                                DefaultSliderView defaultSliderView = new DefaultSliderView(getApplication());

                                // initialize a SliderLayout
                                defaultSliderView
                                        .image(Config.BASE_URL + "img/" + jsonObj.getString("imagem"))
                                        //.description(jsonObj.getString("titulo"))
                                        .setOnSliderClickListener(new BaseSliderView.OnSliderClickListener() {
                                            @Override
                                            public void onSliderClick(BaseSliderView slider) {
                                                if (jsonObj.has("link")) {
                                                    try {
                                                        openWebPage(jsonObj.getString("link"));
                                                    } catch (JSONException e) {
                                                        e.printStackTrace();
                                                    }
                                                }
                                            }
                                        });

                                //add your extra information
                                defaultSliderView.bundle(new Bundle());
                                defaultSliderView.getBundle()
                                        .putString("extra", jsonObj.getString("titulo"));

                                imgSlider.addSlider(defaultSliderView);
                            }


                            imgSlider.setPresetTransformer(SliderLayout.Transformer.Default.toString());
                            //imgSlider.setPresetIndicator(SliderLayout.PresetIndicators.Center_Bottom);
                            //imgSlider.setCustomAnimation(new DescriptionAnimation());
                            imgSlider.setDuration(4000);
                            imgSlider.setIndicatorVisibility(PagerIndicator.IndicatorVisibility.Invisible);
                            // imgSlider.addOnPageChangeListener(this);
                            imgSlider.stopCyclingWhenTouch(false);
                        } catch (JSONException e) {
                            e.printStackTrace();
                            Toast.makeText(getApplication(),
                                    "Error: " + e.getMessage(),
                                    Toast.LENGTH_LONG).show();
                        }


                    }
                },
                new Response.ErrorListener() {
                    @Override
                    public void onErrorResponse(VolleyError error) {
                        // error
                        Log.d("Error.Response", error.toString());
                    }
                }
        ) {
            @Override
            protected Map<String, String> getParams() {
                Map<String, String> params = new HashMap<String, String>();
                params.put("get_slides", "get_slider");
                return params;
            }
        };


        RequestQueue mRequestQueue = Volley.newRequestQueue(getApplication());
        // Adding request to request queue
        mRequestQueue.add(postRequest);

    }

    private void openWebPage(String url) {

        if (!url.equals("")) {
            Uri webpage = Uri.parse(url);

            if (!url.startsWith("http://") && !url.startsWith("https://")) {
                webpage = Uri.parse("http://" + url);
            }

            Intent intent = new Intent(Intent.ACTION_VIEW, webpage);
            if (intent.resolveActivity(MainActivity.this.getPackageManager()) != null) {
                startActivity(intent);
            }
        }
    }
    private void carregarMenu() {
        StringRequest postRequest = new StringRequest(Request.Method.POST, Config.BASE_URL + "api-source-3.0.php?porta="+PORTA+"",
                new Response.Listener<String>() {
                    @Override
                    public void onResponse(String response) {
                        JSONArray jsonArr = null;

                        try {
                            jsonArr = new JSONArray(response);
                            JSONObject jsonObj = jsonArr.getJSONObject(0);

                            if (jsonObj.optString("tv_status").equalsIgnoreCase("ativado")) {
                                Config.TV_URL = "" + jsonObj.get("tv_link");
                                btn_tv.setVisibility(View.VISIBLE);
                            } else {
                                btn_tv.setVisibility(View.GONE);
                            }

                            if (jsonObj.optString("facebook_status").equalsIgnoreCase("ativado")) {
                                Config.FACEBOOK_URL = "" + jsonObj.get("facebook_link");
                                btn_facebook.setVisibility(View.VISIBLE);
                            } else {
                                btn_facebook.setVisibility(View.GONE);
                            }

                            if (jsonObj.optString("whatsapp_status").equalsIgnoreCase("ativado")) {
                                Config.WHATSAPP_URL = "http://api.whatsapp.com/send?1=pt_BR&phone=" + jsonObj.get("whatsapp_link");
                                btn_whatsapp.setVisibility(View.VISIBLE);
                            } else {
                                btn_whatsapp.setVisibility(View.GONE);
                            }

                            if (jsonObj.optString("instagram_status").equalsIgnoreCase("ativado")) {
                                Config.INSTAGRAM_URL = "" + jsonObj.get("instagram_link");
                                btn_instagram.setVisibility(View.VISIBLE);
                            } else {
                                btn_instagram.setVisibility(View.GONE);
                            }

                            if (jsonObj.optString("site_status").equalsIgnoreCase("ativado")) {
                                Config.SITE_URL = "" + jsonObj.get("site_link");
                                btn_site.setVisibility(View.VISIBLE);
                            } else {
                                btn_site.setVisibility(View.GONE);
                            }

                            if (jsonObj.optString("youtube_status").equalsIgnoreCase("ativado")) {
                                Config.YOUTUBE_URL = "" + jsonObj.get("youtube_link");
                                btn_youtube.setVisibility(View.VISIBLE);
                            } else {
                                btn_youtube.setVisibility(View.GONE);
                            }


                            if (jsonObj.optString("twitter_status").equalsIgnoreCase("ativado")) {
                                Config.YOUTUBE_URL = "" + jsonObj.get("twitter_link");
                                btn_twitter.setVisibility(View.VISIBLE);
                            } else {
                                btn_twitter.setVisibility(View.GONE);
                            }

                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }

                },
                new Response.ErrorListener() {
                    @Override
                    public void onErrorResponse(VolleyError error) {

                    }
                }
        ) {
            @Override
            protected Map<String, String> getParams() {
                Map<String, String> params = new HashMap<String, String>();
                params.put("get_MenuApp", "get_MenuApp");

                return params;
            }
        };

        RequestQueue mRequestQueue = Volley.newRequestQueue(getApplication());
        // Adding request to request queue
        mRequestQueue.add(postRequest);

    }


    @Override
    public boolean onNavigationItemSelected(MenuItem item) {

        int id = item.getItemId();

        if (id == R.id.nav_home) {

        }

        if (id == R.id.privacy_policy) {
            startActivity(new Intent(getApplicationContext(), ActivityPrivacyPolicy.class));
            //BrowserIntents.from(this).openLink(getResources().getString(R.string.privacy_policy_url)).show();
        }

        if (id == R.id.share) {
            ShareIntents.from(this).shareText("Hey check out the", +R.string.app_name + " appat: https://play.google.com/store/apps/details?id=" + BuildConfig.APPLICATION_ID).show();
        }

        if (id == R.id.rate) {
            MarketIntents.from(this).showThisAppInGooglePlay().show();
        }

        if (id == R.id.exit) {
            onBackPressed();
        }

        if (id == R.id.web) {
            BrowserIntents.from(this).openLink(Config.SITE_URL).show();
        }

        if (id == R.id.facebook) {
            BrowserIntents.from(this).openLink(Config.FACEBOOK_URL).show();
        }

        if (id == R.id.instagram) {
            BrowserIntents.from(this).openLink(Config.INSTAGRAM_URL).show();
        }

        if (id == R.id.twitter) {
            BrowserIntents.from(this).openLink(Config.TWITTER_URL).show();
        }

        if (id == R.id.youtube) {
            BrowserIntents.from(this).openLink(Config.YOUTUBE_URL).show();
        }

        if (id == R.id.tv) {
            if (isServiceRunning()) {
                Intent stop = new Intent(MainActivity.this, RadioPlayerService.class);
                stop.setAction(RadioPlayerService.ACTION_STOP);
                startService(stop);
            }
            startActivity(new Intent(getApplicationContext(), TvActivity.class));
        }

        DrawerLayout drawer = findViewById(R.id.drawer_layout);
        drawer.closeDrawer(GravityCompat.START);
        return true;
    }

    private void displayData() {
        fabPlayExpand.setOnClickListener(view -> {
            if (!utils.isNetworkAvailable()) {
                Toast.makeText(MainActivity.this, getResources().getString(R.string.internet_not_connected), Toast.LENGTH_SHORT).show();
            } else {
                Radio radio = radios.get(0);
                final Intent intent = new Intent(MainActivity.this, RadioPlayerService.class);

                if (RadioPlayerService.getInstance() != null) {
                    Radio playerCurrentRadio = RadioPlayerService.getInstance().getPlayingRadioStation();
                    if (playerCurrentRadio != null) {
                        if (radio.getRadio_id() != RadioPlayerService.getInstance().getPlayingRadioStation().getRadio_id()) {
                            RadioPlayerService.getInstance().initializeRadio(MainActivity.this, radio);
                            intent.setAction(RadioPlayerService.ACTION_PLAY);
                        } else {
                            intent.setAction(RadioPlayerService.ACTION_TOGGLE);
                        }
                    } else {
                        RadioPlayerService.getInstance().initializeRadio(MainActivity.this, radio);
                        intent.setAction(RadioPlayerService.ACTION_PLAY);
                    }
                } else {
                    RadioPlayerService.createInstance().initializeRadio(MainActivity.this, radio);
                    intent.setAction(RadioPlayerService.ACTION_PLAY);
                }
                startService(intent);

//                if (!Constant.is_playing) {
//                   //TODO
//                }

            }
        });

        if (Config.AUTOPLAY) {
            if (utils.isNetworkAvailable()) {
                new Handler(Looper.getMainLooper()).postDelayed(() -> fabPlayExpand.performClick(), Constant.DELAY_PERFORM_CLICK);
            }
        }

    }

 //   private void initializeVideoStreaming(String videoStreamUrl) {
 //       Uri videoUri = Uri.parse(videoStreamUrl);
 //       videoBG.setVideoURI(videoUri);
 //       videoBG.start();
 //   }

    public void initComponent() {
        // equalizerView = findViewById(R.id.equalizer);
        progressBar = findViewById(R.id.progress_bar);

        imgRadioLarge = findViewById(R.id.img_radio_large);
        logo = findViewById(R.id.logo);

        imgAlbumArtLarge = findViewById(R.id.img_album_art_large);

        if (Config.CIRCULAR_IMAGE_ALBUM_ART) {
            imgRadioLarge.setOval(true);
            imgAlbumArtLarge.setOval(true);
        } else {
            imgRadioLarge.setOval(false);
            imgAlbumArtLarge.setOval(false);
        }

        fabPlayExpand = findViewById(R.id.fab_play);
        txtRadioExpand = findViewById(R.id.txt_radio_name_expand);
        txtSongExpand = findViewById(R.id.txt_metadata_expand);

        if (!utils.isNetworkAvailable()) {
            txtRadioExpand.setText(getResources().getString(R.string.app_name));
            txtSongExpand.setText(getResources().getString(R.string.internet_not_connected));
        }

        setIfPlaying();

    }

    private void loadWebsite(String link) {
        BrowserIntents.from(MainActivity.this).openLink(Uri.parse(link)).show();
    }

    @Override
    protected void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
    }

    public void changePlayPause(Boolean flag) {
        Constant.is_playing = flag;
        if (flag) {
            Radio radio = RadioPlayerService.getInstance().getPlayingRadioStation();
            if (radio != null) {
                changeText(radio);
                fabPlayExpand.setImageDrawable(ContextCompat.getDrawable(MainActivity.this, R.drawable.pause));
                logoanime.playAnimation();

                // equalizerView.animateBars();
            }
        } else {
            if (Constant.item_radio.size() > 0) {
                changeText(Constant.item_radio.get(Constant.position));
            }
            fabPlayExpand.setImageDrawable(ContextCompat.getDrawable(MainActivity.this, R.drawable.play));
            logoanime.pauseAnimation();
            imgAlbumArtLarge.setVisibility(View.GONE);
            //imgMusicBackground.setVisibility(View.GONE);
        }
    }

    public void showImageAlbumArt(boolean show) {
        if (show) {
            imgAlbumArtLarge.setVisibility(View.VISIBLE);
//            imgMusicBackground.setVisibility(View.VISIBLE);
        } else {
            imgAlbumArtLarge.setVisibility(View.GONE);
//            imgMusicBackground.setVisibility(View.GONE);
        }
    }

    public void changeText(Radio radio) {
        if (Constant.radio_type) {
            changeSongName(Constant.metadata);

            if (Constant.metadata == null || Constant.metadata.equals(radio.getRadio_genre())) {
                imgAlbumArtLarge.setVisibility(View.GONE);
//                imgMusicBackground.setVisibility(View.GONE);
            } else {
                imgAlbumArtLarge.setVisibility(View.VISIBLE);
//                imgMusicBackground.setVisibility(View.VISIBLE);
            }

            txtSongExpand.setVisibility(View.VISIBLE);
        } else {
            txtRadioMusicSong.setText(radio.radio_name);
            txtSongExpand.setText(radio.getRadio_name());
            txtSongExpand.setVisibility(View.INVISIBLE);
        }
        txtRadioExpand.setText(radio.getRadio_name());

        if (!Constant.is_playing) {
            txtSongExpand.setText(radio.getRadio_genre());
        }

        try {
            Glide.with(this)
                    .load(radio.getRadio_image_url()).into(logo);

        }catch (Exception e){

        }

    /*    Glide.with(getApplicationContext())
                .load(radio.getRadio_image_url().replace(" ", "%20"))
                .placeholder(R.drawable.radio_image)
                .transform(new BlurTransformation(Config.BG_IMAGE_BLUR_AMOUNT))
                .into(imgMusicBackground);

        Glide.with(getApplicationContext())
                .load(radio.getRadio_image_url().replace(" ", "%20"))
                .placeholder(R.drawable.radio_image)
                .into(imgRadioLarge);*/
    }


    public void changeSongName(String songName) {
        Constant.metadata = songName;
        txtSongExpand.setText(songName);
    }

    public void changeAlbumArt(String artworkUrl) {
        Constant.albumArt = artworkUrl;

        Glide.with(getApplicationContext())
                .load(artworkUrl.replace(" ", "%20"))
                .placeholder(android.R.color.transparent)
                .thumbnail(0.3f)
                .diskCacheStrategy(DiskCacheStrategy.ALL)
                .listener(new RequestListener<Drawable>() {
                    @Override
                    public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<Drawable> target, boolean isFirstResource) {
                        imgAlbumArtLarge.setVisibility(View.GONE);
                        return false;
                    }

                    @Override
                    public boolean onResourceReady(Drawable resource, Object model, Target<Drawable> target, DataSource dataSource, boolean isFirstResource) {
                        imgAlbumArtLarge.setVisibility(View.VISIBLE);
                        return false;
                    }
                })
                .into(imgAlbumArtLarge);
    }

    /*    Glide.with(getApplicationContext())
                .load(artworkUrl.replace(" ", "%20"))
                .placeholder(android.R.color.transparent)
                .transform(new BlurTransformation(Config.BG_IMAGE_BLUR_AMOUNT))
                .diskCacheStrategy(DiskCacheStrategy.ALL)
                .listener(new RequestListener<Drawable>() {
                    @Override
                    public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<Drawable> target, boolean isFirstResource) {
                        imgMusicBackground.setVisibility(View.GONE);
                        return false;
                    }

                    @Override
                    public boolean onResourceReady(Drawable resource, Object model, Target<Drawable> target, DataSource dataSource, boolean isFirstResource) {
                        imgMusicBackground.setVisibility(View.VISIBLE);
                        return false;
                    }
                })
                .into(imgMusicBackground);
    }*/

    public void setIfPlaying() {
        if (RadioPlayerService.getInstance() != null) {
            RadioPlayerService.initialize(MainActivity.this);
            changePlayPause(RadioPlayerService.getInstance().isPlaying());
        } else {
            changePlayPause(false);
        }
    }


    public void setBuffer(Boolean flag) {
        if (flag) {
            progressBar.setVisibility(View.VISIBLE);
        } else {
            progressBar.setVisibility(View.INVISIBLE);
        }
    }

    @Override
    public void onBackPressed() {
        showExitDialog(true);
    }

    public void showExitDialog(boolean exit) {
        if (exit) {
            if (lytExit.getVisibility() != View.VISIBLE) {
                lytExit.startAnimation(AnimationUtils.loadAnimation(getApplicationContext(), R.anim.slide_up));
            }
            lytExit.setVisibility(View.VISIBLE);
        } else {
            lytExit.clearAnimation();
            lytExit.setVisibility(View.GONE);
        }
    }

    public void initExitDialog() {

        lytExit = findViewById(R.id.lyt_exit);
        lytDialog = findViewById(R.id.lyt_dialog);

        lytExit.setOnClickListener(v -> {
        });
        lytDialog.setOnClickListener(v -> {
        });

        findViewById(R.id.txt_cancel).setOnClickListener(v -> new Handler(Looper.getMainLooper()).postDelayed(() -> showExitDialog(false), 200));
        findViewById(R.id.txt_minimize).setOnClickListener(v -> {
                    showExitDialog(false);
                    new Handler(Looper.getMainLooper()).postDelayed(this::minimizeApp, 200);
                }
        );
        findViewById(R.id.txt_exit).setOnClickListener(v -> new Handler(Looper.getMainLooper()).postDelayed(() -> {
            finish();

            if (isServiceRunning()) {
                Intent stop = new Intent(MainActivity.this, RadioPlayerService.class);
                stop.setAction(RadioPlayerService.ACTION_STOP);
                startService(stop);
                Log.d(TAG, "Radio service is running");
            } else {
                Log.d(TAG, "Radio service is not running");
            }
        }, 200));

    }

    public void minimizeApp() {
        Intent intent = new Intent(Intent.ACTION_MAIN);
        intent.addCategory(Intent.CATEGORY_HOME);
        intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        startActivity(intent);
    }

    private boolean isServiceRunning() {
        ActivityManager manager = (ActivityManager) getSystemService(Context.ACTIVITY_SERVICE);
        assert manager != null;
        for (ActivityManager.RunningServiceInfo service : manager.getRunningServices(Integer.MAX_VALUE)) {
            if (RadioPlayerService.class.getName().equals(service.service.getClassName())) {
                return true;
            }
        }
        return false;
    }

    public void hideKeyboard() {
        try {
            getWindow().setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_STATE_ALWAYS_HIDDEN);
            if (((getCurrentFocus() != null) && ((getCurrentFocus().getWindowToken() != null)))) {
                ((InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE)).hideSoftInputFromWindow(getCurrentFocus().getWindowToken(), 0);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onPause() {
        super.onPause();
    }

    @Override
    public void onResume() {
        super.onResume();
        videoBG.start();
        initComponent();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
    }

}
