<?php
// Funes de uso no painel

////////////////////////////////////////
//////////// Funes Gerais ////////////
////////////////////////////////////////

// Funo para gerenciar query string
function query_string($posicao='0') {

$gets = explode("/",str_replace(strrchr($_SERVER["REQUEST_URI"], "?"), "", $_SERVER["REQUEST_URI"]));
array_shift($gets);

return utf8_decode(urldecode($gets[$posicao]));

}

// Funo para codificar e decodificar strings
function code_decode($texto, $tipo = "E") {

  if($tipo == "E") {
  
  $sesencoded = $texto;
  $num = mt_rand(0,3);
  for($i=1;$i<=$num;$i++)
  {
     $sesencoded = base64_encode($sesencoded);
  }
  $alpha_array = array('1','Z','3','R','1','Y','2','N','A','T','Z','X','A','E','Y','6','9','4','F','S','X');
  $sesencoded =
  $sesencoded."+".$alpha_array[$num];
  $sesencoded = base64_encode($sesencoded);
  return $sesencoded;
  
  } else {
  
   $alpha_array = array('1','Z','3','R','1','Y','2','N','A','T','Z','X','A','E','Y','6','9','4','F','S','X');
   $decoded = base64_decode($texto);
   list($decoded,$letter) = explode("+",$decoded);
   for($i=0;$i<@count($alpha_array);$i++)
   {
   if($alpha_array[$i] == $letter)
   break;
   }
   for($j=1;$j<=$i;$j++)
   {
      $decoded = base64_decode($decoded);
   }
   return $decoded;
  }
}

// Funo para gerar ID da revenda
function gera_id($max = 6) {

$aux = microtime();
$id = substr(md5($aux),0,$max);

return $id;
}

// Funo para criar clulas de logs do sistema
function status_acao($status,$tipo) {

if($tipo == 'ok') {
$celula_status = '<tr style="background-color:#A6EF7B;">
      <td width="790" height="35" class="texto_log_sistema" scope="col">
	  <div align="center">'.$status.'</div>
	  </td>
</tr>
<tr><td scope="col" height="2" width="770"></td></tr>
';
} elseif($tipo == 'ok2') {
$celula_status = '<tr style="background-color:#A6EF7B;">
      <td width="790" height="35" class="texto_log_sistema" scope="col">
	  <div align="center">'.$status.'</div>
	  </td>
</tr>
<tr><td scope="col" height="2" width="770"></td></tr>
';
} elseif($tipo == 'alerta') {
$celula_status = '<tr style="background-color:#FFFF66;">
      <td width="790" height="35" class="texto_log_sistema_alerta" scope="col">
	  <div align="center">'.$status.'</div>

	  </td>
</tr>
<tr><td scope="col" height="2" width="770"></td></tr>
';
} else {
$celula_status = '<tr style="background-color:#F2BBA5;">
      <td width="790" height="35" class="texto_log_sistema_erro" scope="col">
	  <div align="center">'.$status.'</div>
	  </td>
</tr>
<tr><td scope="col" height="2" width="770"></td></tr>
';
}  

return $celula_status;
}

// Funo para remover acentos e espaos
function formatar_nome_playlist($playlist) {

$array_caracteres = array("/[]/"=>"a","/[]/"=>"a","/[]/"=>"e","/[]/"=>"e","/[]/"=>"i","/[]/"=>"i","/[]/"=>"o", "/[]/"=>"o","/[]/"=>"u","/[]/"=>"u","//"=>"c","//"=> "c","/ /"=> "-","/_/"=> "-");

$formatado = preg_replace(array_keys($array_caracteres), array_values($array_caracteres), $playlist);

return strtolower($formatado);
}

// Funo para formatar texto retirando acentos e caracteres especiais
function formatar_texto($texto) {

$characteres = array(
    'S'=>'S', 's'=>'s', ''=>'Dj','Z'=>'Z', 'z'=>'z', ''=>'A', ''=>'A', ''=>'A', ''=>'A', ''=>'A',
    ''=>'A', ''=>'A', ''=>'C', ''=>'E', ''=>'E', ''=>'E', ''=>'E', ''=>'I', ''=>'I', ''=>'I',
    ''=>'I', ''=>'N', ''=>'O', ''=>'O', ''=>'O', ''=>'O', ''=>'O', ''=>'O', ''=>'U', ''=>'U',
    ''=>'U', ''=>'U', ''=>'Y', ''=>'B', ''=>'Ss',''=>'a', ''=>'a', ''=>'a', ''=>'a', ''=>'a',
    ''=>'a', ''=>'a', ''=>'c', ''=>'e', ''=>'e', ''=>'e', ''=>'e', ''=>'i', ''=>'i', ''=>'i',
    ''=>'i', ''=>'o', ''=>'n', ''=>'o', ''=>'o', ''=>'o', ''=>'o', ''=>'o', ''=>'o', ''=>'u',
    ''=>'u', ''=>'u', ''=>'y', ''=>'y', ''=>'b', ''=>'y', 'f'=>'f', ''=> '', ''=> '', '&'=> 'e',
	''=> '', ''=> '', '$'=> '', '%'=> '', ''=> '', ''=> '', ''=> '', ''=> '', ''=> '', 'ã'=> '',
	'('=> '', ')'=> '', "'"=> '', '@'=> '', '='=> '', ':'=> '', '!'=> '', '?'=> '', '...'=> ''
);

return strtr($texto, $characteres);

}

function pais_ip($ip,$tipo) {

$dados_api_geoip = api_geoip($ip);

$pais_codigo = $dados_api_geoip["pais_sigla"];
$pais_nome = $dados_api_geoip["pais_nome"];

if($tipo == "nome") {
return $pais_nome;
} else {
return $pais_codigo;
}

}


// Funo para remover acentos
function remover_acentos($msg) {
$a = array("/[]/"=>"A","/[]/"=>"a","/[]/"=>"E","/[]/"=>"e","/[]/"=>"I","/[]/"=>"i","/[]/"=>"O",	"/[]/"=>"o","/[]/"=>"U","/[]/"=>"u","//"=>"c","//"=> "C");

return preg_replace(array_keys($a), array_values($a), $msg);
}

// Funo para formatar os segundos em segundos, minutos e horas
function tempo_conectado($segundos) {

$days=intval($segundos/86400);
$remain=$segundos%86400;
$hours=intval($remain/3600);
$remain=$remain%3600;
$mins=intval($remain/60);
$secs=$remain%60;
if (strlen($mins)<2) {
$mins = '0'.$mins;
}
if($days > 0) $dia = $days.'d';
if($hours > 0) $hora = $hours.'hr, ';
if($mins > 0) $minuto = $mins.'min, ';

$segundo = $secs.'seg';
$segundos = $dia.$hora.$minuto.$segundo;

return $segundos;

}

function seconds2time($segundos) {

return @gmdate("H:i:s", round($segundos));

}

// Funo para retornar o tipo de medida do tamanho do arquivo(Byts, Kbytes, Megabytes, Gigabytes, etc...)
function tamanho($size)
{
    $filesizename = array(" <small>MB</small>", " <small>GB</small>", " <small>TB</small>", " <small>PB</small>", " <small>EB</small>", " <small>ZB</small>", " <small>YB</small>");
    return $size ? round($size/pow(1000, ($i = floor(log($size, 1000)))), 0) . $filesizename[$i] : '0 <small>Bytes</small>';
}

// Funo para criar um barra de porcentagem de uso do plano
function barra_uso_plano($porcentagem,$descricao) {

$porcentagem_progresso = ($porcentagem > 100) ? "100" : $porcentagem;

$cor = "#00CC00";
$cor = ($porcentagem_progresso > 50 && $porcentagem_progresso < 80) ? "#FFE16C" : $cor;
$cor = ($porcentagem_progresso > 80) ? "#FF0000" : $cor;

return "<div class='barra-uso-plano-corpo' title='".$descricao."'>
<div class='barra-uso-plano-progresso' style='background-color: ".$cor."; width: ".round($porcentagem_progresso)."%;'>
<div class='barra-uso-plano-texto'>".round($porcentagem)."%</div>
</div>
</div>";

}

// Funo para calcular tempo de exceusso
function tempo_execucao() {
    $sec = explode(" ",microtime());
    $tempo = $sec[1] + $sec[0];
    return $tempo;
}

function anti_sql_injection($str) {
    if (!is_numeric($str)) {
        $str = str_replace("'='","",$str);
    }
    return $str;
}

function zebrar($i) {
    return func_get_arg(abs($i) % (func_num_args() - 1) + 1);
}

// Funo para conectar a uma URL
function conectar_url($url) {

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE); 
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE); 
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 2);
curl_setopt($ch, CURLOPT_TIMEOUT, 2);
curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows; U; Windows NT 6.0; en-US; rv:1.9.2) Gecko/20100115 Firefox/3.6 (.NET CLR 3.5.30729)');
$resultado = curl_exec($ch);
curl_close($ch);

if($resultado === false) {
return $resultado;
} else {

return $resultado;

}

}

// Funo para carregar avisos para streamings
function carregar_avisos_streaming($conexao,$porta,$servidor) {

$total_avisos = 0;

$sql = mysqli_query($conexao,"SELECT *, DATE_FORMAT(data,'%d/%m/%Y') AS data FROM avisos WHERE area = 'streaming'");
while ($dados_aviso = mysqli_fetch_array($sql)) {

if($dados_aviso["status"] == "sim" && ($dados_aviso["codigo_servidor"] == "0" || $dados_aviso["codigo_servidor"] == $servidor)) {

$checar_status_aviso = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM avisos_desativados where codigo_aviso = '".$dados_aviso["codigo"]."' AND area = 'streaming' AND codigo_usuario = '".$porta."'"));

if($checar_status_aviso == 0) {

echo '<a class="dropdown-item preview-item" onclick="exibir_aviso(\''.$dados_aviso["codigo"].'\');" data-toggle="modal" data-target="#avisos">
                <div class="preview-thumbnail">
                  <div class="preview-icon bg-success">
                    <i class="mdi mdi-information mx-0"></i>
                  </div>
                </div>
                <div class="preview-item-content">
                  <h6 class="preview-subject font-weight-medium">'.$dados_aviso["descricao"].'</h6>
                  <p class="font-weight-light small-text mb-0">
                    '.$dados_aviso["data"].'
                  </p>
                </div>
              </a>';

$total_avisos++;

} // if exibir sim/nao DESATIVADO
} // if exibir sim/nao
} // while avisos

if($total_avisos == 0) {
echo '<a class="dropdown-item preview-item"><center>Nenhum aviso neste momento.</center></a>';
}

}

// Funo para carregar avisos para revendas
function carregar_avisos_revenda($conexao) {

$total_avisos = 0;

$sql = mysqli_query($conexao,"SELECT *, DATE_FORMAT(data,'%d/%m/%Y') AS data FROM avisos WHERE area = 'revenda' ORDER by data DESC");
while ($dados_aviso = mysqli_fetch_array($sql)) {

if($dados_aviso["status"] == "sim") {

echo '<a class="dropdown-item preview-item" onclick="exibir_aviso(\''.$dados_aviso["codigo"].'\');" data-toggle="modal" data-target="#avisos">
                <div class="preview-thumbnail">
                  <div class="preview-icon bg-success">
                    <i class="mdi mdi-information mx-0"></i>
                  </div>
                </div>
                <div class="preview-item-content">
                  <h6 class="preview-subject font-weight-medium">'.$dados_aviso["descricao"].'</h6>
                  <p class="font-weight-light small-text mb-0">
                    '.$dados_aviso["data"].'
                  </p>
                </div>
              </a>';

$total_avisos++;
}
}

if($total_avisos == 0) {
echo '<a class="dropdown-item preview-item"><center>Nenhum aviso neste momento.</center></a>';
}

}

// Funo para criar formatar domnio do servidor
function dominio_servidor($conexao, $nome ) {

if($_SESSION["porta_logada"]) {
$dados_stm = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM streamings where porta = '".$_SESSION["porta_logada"]."'"));
$dados = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM revendas WHERE codigo = '".$dados_stm["codigo_cliente"]."'"));
} elseif($_SESSION["code_user_logged"] && $_SESSION["type_logged_user"] == "cliente") {
$dados = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM revendas WHERE codigo = '".$_SESSION["code_user_logged"]."'"));
} else {
$dados = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM configuracoes"));
}

if($dados["dominio_padrao"]) {
return strtolower($nome).".".$dados["dominio_padrao"];
} else {
$dados_config = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM configuracoes"));
return strtolower($nome).".".$dados_config["dominio_padrao"];
}

}

function xml_entity_decode($s) {
  // illustrating how a (hypothetical) PHP-build-in-function MUST work
    static $XENTITIES = array('&amp;','&gt;','&lt;');
    static $XSAFENTITIES = array('#_x_amp#;','#_x_gt#;','#_x_lt#;');
    $s = str_replace($XENTITIES,$XSAFENTITIES,$s); 
    $s = html_entity_decode($s, ENT_HTML5|ENT_NOQUOTES, 'UTF-8'); // PHP 5.3+
    $s = str_replace($XSAFENTITIES,$XENTITIES,$s);
    return $s;
 } 

// Funo abreviar o nome do navegador
function formatar_navegador($navegador) {

if (preg_match('|MSIE ([0-9].[0-9]{1,2})|',$navegador,$matched)) {
return  'IE '.$matched[1].'';
} elseif (preg_match( '|Opera/([0-9].[0-9]{1,2})|',$navegador,$matched)) {
return  'Opera '.$matched[1].'';
} elseif(preg_match('|Firefox/([0-9\.]+)|',$navegador,$matched)) {
return  'Firefox '.$matched[1].'';
} elseif(preg_match('|Chrome/([0-9\.]+)|',$navegador,$matched)) {
return  'Chrome '.$matched[1].'';
} elseif(preg_match('|Safari/([0-9\.]+)|',$navegador,$matched)) {
return  'Safari '.$matched[1].'';
} else {
return 'Desconhecido';
}

}

// Funo para inserir registro do log de aes do painel de administrao/revenda no banco de dados
function logar_acao($conexao,$log) {

mysqli_query($conexao,"INSERT INTO logs (data,host,ip,navegador,log) VALUES (NOW(),'http://".$_SERVER['HTTP_HOST']."','".$_SERVER['REMOTE_ADDR']."','".formatar_navegador($_SERVER['HTTP_USER_AGENT'])."','".$log."')") or die("Erro ao inserir log: ".mysqli_error($conexao)."");

}

// Funo para inserir registro do log de aes do painel de streaming no banco de dados
function logar_acao_streaming($conexao,$codigo_stm,$log) {

mysqli_query($conexao,"INSERT INTO logs_streamings (codigo_stm,data,host,ip,navegador,log) VALUES ('".$codigo_stm."',NOW(),'http://".$_SERVER['HTTP_HOST']."','".$_SERVER['REMOTE_ADDR']."','".formatar_navegador($_SERVER['HTTP_USER_AGENT'])."','".$log."')") or die("Erro ao inserir log: ".mysqli_error($conexao)."");

}

////////////////////////////////////////////////
////////// Funes Shoutcast & Wowza ///////////
////////////////////////////////////////////////

// Funo para checar status do streaming
function status_streaming($ip,$porta) {

$resultado_streaming = @fsockopen($ip, $porta, $errno, $errstr, 2);
@stream_set_timeout($resultado_streaming, 1);

if($resultado_streaming) {
return "ligado";
} else {
return "desligado";
}

}

// Funo para checar status do autodj
function status_streaming_transmissao($ip,$porta,$senha) {

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "http://".$ip.":".$porta."/admin.cgi?sid=1&mode=viewxml&pass=".$senha."");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 2);
curl_setopt($ch, CURLOPT_TIMEOUT, 2);
curl_setopt($ch, CURLOPT_USERAGENT, 'Painel de Streaming 3.0.0');
$resultado = curl_exec($ch);

if(curl_error($ch)) {
return "desligado";
} else {

$resultado = xml_entity_decode($resultado);

$xml = @simplexml_load_string(utf8_encode($resultado));

if(preg_match('/http/i',$xml->STREAMSOURCE)) {
return "relay";
} elseif(filter_var($xml->STREAMSOURCE, FILTER_VALIDATE_IP) && $xml->STREAMSOURCE == "127.0.0.1") {
return "autodj";
} elseif(filter_var($xml->STREAMSOURCE, FILTER_VALIDATE_IP) && $xml->STREAMSOURCE != "127.0.0.1") {
return "aovivo";
} else {
return "desligado";
}
}
curl_close($ch);
}

// Funo para checar status do autodj
function status_autodj($ip,$porta,$senha) {

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "http://".$ip.":".$porta."/admin.cgi?sid=1&mode=viewxml&pass=".$senha."");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 2);
curl_setopt($ch, CURLOPT_TIMEOUT, 2);
curl_setopt($ch, CURLOPT_USERAGENT, 'Painel de Streaming 3.0.0');
$resultado = curl_exec($ch);
curl_close($ch);

$resultado = xml_entity_decode($resultado);

$xml = @simplexml_load_string(utf8_encode($resultado));

if($xml->STREAMSOURCE == "127.0.0.1") {
return "ligado";
} else {
return "desligado";
}

}

// Funo para checar status do autodj
function status_relay($ip,$porta,$senha) {

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "http://".$ip.":".$porta."/admin.cgi?sid=1&mode=viewxml&pass=".$senha."");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 2);
curl_setopt($ch, CURLOPT_TIMEOUT, 2);
curl_setopt($ch, CURLOPT_USERAGENT, 'Painel de Streaming 3.0.0');
$resultado = curl_exec($ch);
curl_close($ch);

$resultado = xml_entity_decode($resultado);

$xml = @simplexml_load_string(utf8_encode($resultado));

if(preg_match('/http/i',$xml->STREAMSOURCE)) {
return "ligado";
} else {
return "desligado";
}

}

// Funo para obter as estatisticas do streaming no servidor shoutcast para a pagina de ouvintes conectados MOVEL
function estatistica_streaming_shoutcast($stm_ip,$stm_porta,$stm_senha) {

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "http://".$stm_ip.":".$stm_porta."/admin.cgi?sid=1&mode=viewxml&page=3&pass=".$stm_senha."");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 2);
curl_setopt($ch, CURLOPT_TIMEOUT, 2);
curl_setopt($ch, CURLOPT_USERAGENT, 'Painel de Streaming 3.0.0');
$resultado = curl_exec($ch);
curl_close($ch);

if($resultado) {

$resultado = xml_entity_decode($resultado);

$xml = @simplexml_load_string(utf8_encode($resultado));

$total_ouvintes = @count($xml->LISTENERS->LISTENER);

if($total_ouvintes > 0) {

for($i=0;$i<$total_ouvintes;$i++){

$ip = $xml->LISTENERS->LISTENER[$i]->HOSTNAME;
$tempo_conectado = seconds2time($xml->LISTENERS->LISTENER[$i]->CONNECTTIME);
$player = formatar_useragent($xml->LISTENERS->LISTENER[$i]->USERAGENT);

if(preg_match('/Proxy/i',$xml->LISTENERS->LISTENER[$i]->USERAGENT)) {

list($player_proxy, $ip_ouvinte) = explode("/",$xml->LISTENERS->LISTENER[$i]->USERAGENT);

$array_ouvintes .= "".$ip_ouvinte."|".$tempo_conectado."|".pais_ip($ip_ouvinte,"sigla")."|".pais_ip($ip_ouvinte,"nome")."|".$player."-";

} else {

$array_ouvintes .= "".$ip."|".$tempo_conectado."|".pais_ip($ip,"sigla")."|".pais_ip($ip,"nome")."|".$player."-";

}
}

}

}

return $array_ouvintes;
}

// Funo para obter as estatisticas do streaming para robots
function estatistica_streaming_shoutcast_robot($ip,$porta,$senha,$ponto) {

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "http://".$ip.":".$porta."/admin.cgi?sid=".$ponto."&mode=viewxml&page=3&pass=".$senha."");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 2);
curl_setopt($ch, CURLOPT_TIMEOUT, 2);
curl_setopt($ch, CURLOPT_USERAGENT, 'Painel de Streaming 3.0.0');
$resultado = curl_exec($ch);
curl_close($ch);

if($resultado) {

$resultado = str_replace("&#x","",$resultado);

return $resultado;
}

}

// Funo para obter as estatisticas do streaming no servidor aacplus para a pagina de ouvintes conectados MOVEL
function estatistica_streaming_aacplus($ip,$porta,$senha) {

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "http://".$ip.":8086/serverinfo");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);
curl_setopt($ch, CURLOPT_USERPWD, "admin:".code_decode($senha,"D").""); 
curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_DIGEST); 
curl_setopt($ch, CURLOPT_USERAGENT, 'Painel de Streaming 3.0.0');
ob_start();
$resultado = curl_exec($ch);
$data = ob_get_clean();

$xml = @simplexml_load_string(utf8_encode($resultado));

$total_streamings = @count($xml->VHost->Application);

if($total_streamings > 0) {

for($i=0;$i<$total_streamings;$i++){

if($xml->VHost->Application[$i]->Name == $porta) {

$total_ouvintes = @count($xml->VHost->Application[$i]->ApplicationInstance->Client);

for($ii=0;$ii<$total_ouvintes;$ii++){

$ip = $xml->VHost->Application[$i]->ApplicationInstance->Client[$ii]->IpAddress;
$tempo_conectado = seconds2time($xml->VHost->Application[$i]->ApplicationInstance->Client[$ii]->TimeRunning);
$pais_sigla = pais_ip($ip,"sigla");
$pais_nome = pais_ip($ip,"nome");
$player = formatar_useragent("RTMP");

$array_ouvintes .= "".$ip."|".$tempo_conectado."|".pais_ip($ip,"sigla")."|".pais_ip($ip,"nome")."|".$player."-";

}

break;

}

}

}

return $array_ouvintes;
}

// Funo para obter as estatisticas do streaming no servidor aacplus para os robots
function estatistica_streaming_aacplus_robot($ip,$senha) {

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "http://".$ip.":8086/serverinfo");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);
curl_setopt($ch, CURLOPT_USERPWD, "admin:".code_decode($senha,"D").""); 
curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_DIGEST); 
curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows; U; Windows NT 5.1; pt-BR; rv:1.9.2.3) Gecko/20100401 Firefox/3.6.3 ( .NET CLR 3.5.30729)');
$resultado = curl_exec($ch);
curl_close($ch);

return $resultado;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Funo para obter as estatisticas do streaming no servidor shoutcast para a pagina de ouvintes conectados
function estatistica_ouvintes_conectados_shoutcast($stm_ip,$stm_porta,$stm_senha,$ponto) {

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "http://".$stm_ip.":".$stm_porta."/admin.cgi?sid=".$ponto."&mode=viewxml&page=3&pass=".$stm_senha."");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 2);
curl_setopt($ch, CURLOPT_TIMEOUT, 2);
curl_setopt($ch, CURLOPT_USERAGENT, 'Painel de Streaming 3.0.0');
$resultado = curl_exec($ch);
curl_close($ch);

if(preg_match('/Unauthorized/i',$resultado)) {

die('<table width="800" border="0" align="center" cellpadding="0" cellspacing="0" style="margin-top:20px; background-color:#FFFF66; border:#DFDF00 4px dashed"><tr>
<td width="50" height="50" align="center" scope="col"><img src="/img/icones/atencao.png" width="16" height="16" /></td>
<td width="750" align="left" scope="col" style="color: #AB1C10;	font-family: Geneva, Arial, Helvetica, sans-serif; font-size:12px; font-weight:bold;">Senha admin shoutcast no configurada! Acesse menu de configurao do streaming, defina uma senha e reinicie o streaming.<br><br>Shoutcast admin password not configured! Access the menu settings of streaming, define a password and restart the streaming.</td>
</tr></table>');

} else {

$resultado = xml_entity_decode($resultado);

$xml = @simplexml_load_string(utf8_encode($resultado));

$total_ouvintes = @count($xml->LISTENERS->LISTENER);

if($total_ouvintes > 0) {

for($i=0;$i<$total_ouvintes;$i++){

$ip = $xml->LISTENERS->LISTENER[$i]->HOSTNAME;
$tempo_conectado = seconds2time($xml->LISTENERS->LISTENER[$i]->CONNECTTIME);
$player = formatar_useragent($xml->LISTENERS->LISTENER[$i]->USERAGENT);

if(preg_match('/Proxy/i',$xml->LISTENERS->LISTENER[$i]->USERAGENT)) {

list($player_proxy, $ip_ouvinte) = explode("/",$xml->LISTENERS->LISTENER[$i]->USERAGENT);

$array_ouvintes[] = "".$ip_ouvinte."|".$tempo_conectado."|".$player."";
} else {
$array_ouvintes[] = "".$ip."|".$tempo_conectado."|".$player."";
}

}

}

return $array_ouvintes;
}

}

// Funo para obter as estatisticas do streaming no servidor aacplus para a pagina de ouvintes conectados
function estatistica_ouvintes_conectados_aacplus($ip,$porta,$senha) {

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "http://".$ip.":8086/serverinfo");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);
curl_setopt($ch, CURLOPT_USERPWD, "admin:".code_decode($senha,"D").""); 
curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_DIGEST); 
curl_setopt($ch, CURLOPT_USERAGENT, 'Painel de Streaming 3.0.0');
ob_start();
$resultado = curl_exec($ch);
$data = ob_get_clean();

$xml = @simplexml_load_string(utf8_encode($resultado));

$total_streamings = @count($xml->VHost->Application);

if($total_streamings > 0) {

for($i=0;$i<$total_streamings;$i++){

if($xml->VHost->Application[$i]->Name == $porta) {

$total_ouvintes = @count($xml->VHost->Application[$i]->ApplicationInstance->Client);

for($ii=0;$ii<$total_ouvintes;$ii++){

$ip = $xml->VHost->Application[$i]->ApplicationInstance->Client[$ii]->IpAddress;
$tempo_conectado = seconds2time($xml->VHost->Application[$i]->ApplicationInstance->Client[$ii]->TimeRunning);
$pais_sigla = pais_ip($ip,"sigla");
$pais_nome = pais_ip($ip,"nome");
$player = formatar_useragent("RTMP");

$array_ouvintes[] = "".$ip."|".$tempo_conectado."|".pais_ip($ip,"sigla")."|".pais_ip($ip,"nome")."|".$player."";

}

break;

}

}

}

return $array_ouvintes;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////

// Funo para mudar a msica atual no shoutcast para um texto qualquer
function definir_nome_musica_shoutcast($ip,$porta,$senha,$ponto,$musica) {

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "http://".$ip.":".$porta."/admin.cgi?sid=".$ponto."&mode=updinfo&song=".urlencode($musica)."&pass=".$senha."");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 2);
curl_setopt($ch, CURLOPT_TIMEOUT, 2);
curl_setopt($ch, CURLOPT_USERAGENT, 'Painel de Streaming 3.0.0');
$resultado = curl_exec($ch);
curl_close($ch);

}

// Funo para criar authhash para shoutcast v2
function criar_authhash($stationname,$genre,$website) {

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "http://yp.shoutcast.com/createauthhash?k=sh1N7oyXzUvT8TRK&stationname=".rawurlencode($stationname)."&genre=".rawurlencode($genre)."&website=".$website."");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 2);
curl_setopt($ch, CURLOPT_TIMEOUT, 2);
curl_setopt($ch, CURLOPT_USERAGENT, 'Painel de Streaming 3.0.0');
$resultado = curl_exec($ch);
curl_close($ch);

$xml = @simplexml_load_string($resultado);

return array("statusCode" => $xml->statusCode, "statusText" => $xml->statusText, "statusDetailText" => $xml->statusDetailText, "authhash" => $xml->data->authhash);
}

// Funo para gerar arquivo de configurao do streaming
function gerar_conf_streaming($porta,$config) {

$arquivo_config_streaming = "".$porta.".conf";
$handle_config_streaming = fopen("".$_SERVER['DOCUMENT_ROOT']."/temp/".$arquivo_config_streaming."" ,"a");
fwrite($handle_config_streaming, $config);
fclose($handle_config_streaming);

return $arquivo_config_streaming;
}

// Funo para gerar arquivo de configurao do AutoDJ
function gerar_conf_autodj($porta,$config) {

$arquivo_config_autodj = "autodj-".$porta.".conf";
$handle_config_autodj = fopen("".$_SERVER['DOCUMENT_ROOT']."/temp/".$arquivo_config_autodj."" ,"a");
fwrite($handle_config_autodj, $config);
fclose($handle_config_autodj);

return $arquivo_config_autodj;
}

// Funo para gerar calendar de configurao dos DJs do AutoDJ
function gerar_calendar_autodj($config) {

$config_calendar = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>
<eventlist>\n\n";

if($config["djs"]) {

foreach($config["djs"] as $dj_config) {

if($dj_config["total_restricoes"] == 0) {

$config_calendar .= "<event type=\"dj\">\n";
$config_calendar .= "<dj archive=\"0\">".$dj_config["login"]."</dj>\n";
$config_calendar .= "<calendar />\n";
$config_calendar .= "</event>\n\n";

} else {

$lista_restricoes = explode(",",$dj_config["restricoes"]);

foreach($lista_restricoes as $restricao) {

list($hora_inicio, $hora_fim, $dias_semana) = explode("|", $restricao);

if($hora_inicio && $hora_fim) {

$config_calendar .= "<event type=\"dj\">\n";
$config_calendar .= "<dj archive=\"0\">".$dj_config["login"]."</dj>\n";

list($hora1, $minuto1) = explode(":", $hora_inicio);
list($hora2, $minuto2) = explode(":", $hora_fim);

if($hora1 <= $hora2) {

$start_date = new DateTime(''.date("Y-m-d",mktime (0, 0, 0, date("m")  , date("d"), date("Y"))).' '.$hora_inicio.':00');
$since_start = $start_date->diff(new DateTime(''.date("Y-m-d",mktime (0, 0, 0, date("m")  , date("d"), date("Y"))).' '.$hora_fim.':00'));

$duracao = sprintf("%02d", $since_start->h).':'.sprintf("%02d", $since_start->i);

} else {

$start_date = new DateTime(''.date("Y-m-d",mktime (0, 0, 0, date("m")  , date("d"), date("Y"))).' '.$hora_inicio.':00');
$since_start = $start_date->diff(new DateTime(''.date("Y-m-d",mktime (0, 0, 0, date("m")  , date("d")+1, date("Y"))).' '.$hora_fim.':00'));

$duracao = sprintf("%02d", $since_start->h).':'.sprintf("%02d", $since_start->i);

}

$config_calendar .= "<calendar starttime=\"".$hora_inicio.":00\" duration=\"".$duracao.":00\" repeat=\"".$dias_semana."\"/>\n";
$config_calendar .= "</event>\n\n";

}

}

}

}

}


if($config["relay"]) {

foreach($config["relay"] as $relay) {

list($servidor,$frequencia,$data,$hora,$minuto,$duracao_hora,$duracao_minuto,$dias) = explode("|",$relay);

$duracao = ($duracao_hora != 00 || $duracao_minuto != 00) ? "duration=\"".$duracao_hora.":".$duracao_minuto.":00\"" : "";

$config_calendar .= "<event type=\"relay\">\n";

if($frequencia == "1") { // Executar uma vez(dia especfico)


$config_calendar .= "<calendar startdate=\"".str_replace("-","/",$data)."\" enddate=\"".str_replace("-","/",$data)."\" starttime=\"".$hora.":".$minuto.":00\" ".$duracao." />\n";

} else if($frequencia == "2") { // Executar diariamente

$config_calendar .= "<calendar starttime=\"".$hora.":".$minuto.":00\" ".$duracao." repeat=\"127\" />\n";

} else { // Executar em dias especficos

$dias_executar = 0;

$array_dias = explode(",",$dias);

foreach($array_dias as $dia) {
$dias_executar += $dia;
}

$config_calendar .= "<calendar starttime=\"".$hora.":".$minuto.":00\" ".$duracao." repeat=\"".$dias_executar."\" />\n";
}

$config_calendar .= "<relay url=\"".$servidor."\" priority=\"1\"/>\n";

$config_calendar .= "</event>\n\n";

}

}

$config_calendar .= "</eventlist>";

$arquivo_config_calendar = "calendar-".$config["porta"].".xml";
$handle_config_calendar = fopen("".$_SERVER['DOCUMENT_ROOT']."/temp/".$arquivo_config_calendar."" ,"a");

fwrite($handle_config_calendar, $config_calendar);
fclose($handle_config_calendar);

return $arquivo_config_calendar;
}

// Funo para gerar arquivo de configurao do AutoDJ
function gerar_playlist($playlist,$musicas) {

$handle_playlist = fopen("".$_SERVER['DOCUMENT_ROOT']."/temp/".$playlist."" ,"a");
fwrite($handle_playlist, $musicas);
fclose($handle_playlist);

return $playlist;

}

// Funo para capturar informaes de um streaming no shoutcast
function shoutcast_info($ip,$porta,$ponto) {

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "http://".$ip.":".$porta."/stats?sid=".$ponto."");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 2);
curl_setopt($ch, CURLOPT_TIMEOUT, 2);
curl_setopt($ch, CURLOPT_USERAGENT, 'Painel de Streaming 3.0.0');
$resultado = curl_exec($ch);
curl_close($ch);

$resultado = xml_entity_decode($resultado);

$xml = @simplexml_load_string(utf8_encode($resultado));

return array("ouvintes_total" => $xml->CURRENTLISTENERS, "ouvintes" => $xml->MAXLISTENERS, "bitrate" => $xml->BITRATE, "encoder" => $xml->CONTENT, "musica" => $xml->SONGTITLE, "titulo" => $xml->SERVERTITLE, "pico_ouvintes" => $xml->PEAKLISTENERS, "proxima_musica" => $xml->NEXTTITLE, "genero" => $xml->SERVERGENRE, "unique" => $xml->UNIQUELISTENERS, "average" => $xml->AVERAGETIME);
}

// Funo para capturar o TOTAL de ouvintes online de um streaming no Wowza
function stats_ouvintes_aacplus($porta,$ip,$senha) {

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "http://".$ip.":8086/connectioncounts");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);
curl_setopt($ch, CURLOPT_USERPWD, "admin:".code_decode($senha,"D").""); 
curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_DIGEST); 
curl_setopt($ch, CURLOPT_USERAGENT, 'Painel de Streaming 3.0.0');
ob_start();
$resultado = curl_exec($ch);
$data = ob_get_clean();

$xml = @simplexml_load_string(utf8_encode($resultado));

$total_streamings = @count($xml->VHost->Application);

if($total_streamings > 0) {

for($i=0;$i<$total_streamings;$i++){

if($xml->VHost->Application[$i]->Name == $porta) {

return array("ouvintes" => $xml->VHost->Application[$i]->ConnectionsCurrent);
break;

}

}

}

curl_close($ch);

}

/////////////////////////////////////////////
//////////// Funes App Android ////////////
/////////////////////////////////////////////

// Funo para formatar o nome da radio retirando acentos e caracteres especiais
function formatar_nome_radio($nome) {

$characteres = array(
    'S'=>'S', 's'=>'s', ''=>'Dj','Z'=>'Z', 'z'=>'z', ''=>'A', ''=>'A', ''=>'A', ''=>'A', ''=>'A',
    ''=>'A', ''=>'A', ''=>'C', ''=>'E', ''=>'E', ''=>'E', ''=>'E', ''=>'I', ''=>'I', ''=>'I',
    ''=>'I', ''=>'N', ''=>'O', ''=>'O', ''=>'O', ''=>'O', ''=>'O', ''=>'O', ''=>'U', ''=>'U',
    ''=>'U', ''=>'U', ''=>'Y', ''=>'B', ''=>'Ss',''=>'a', ''=>'a', ''=>'a', ''=>'a', ''=>'a',
    ''=>'a', ''=>'a', ''=>'c', ''=>'e', ''=>'e', ''=>'e', ''=>'e', ''=>'i', ''=>'i', ''=>'i',
    ''=>'i', ''=>'o', ''=>'n', ''=>'o', ''=>'o', ''=>'o', ''=>'o', ''=>'o', ''=>'o', ''=>'u',
    ''=>'u', ''=>'u', ''=>'y', ''=>'y', ''=>'b', ''=>'y', 'f'=>'f', ''=> '', ''=> '', '&'=> 'e',
	''=> '', ''=> '', '$'=> '', '%'=> '', ''=> '', ''=> '', ''=> '', ''=> '', ''=> '', 'ã'=> '',
	'('=> '', ')'=> '', "'"=> '', '@'=> '', '='=> '', ':'=> '', '!'=> '', '?'=> '', '...'=> '', ''=> '',
	'/'=> '', ''=> '', '+'=> '', '*'=> '', '['=> '', ']'=> ''
);

return strtr($nome, $characteres);

}

// Funo para formatar o nome do app para o google play retirando acentos e caracteres especiais
function nome_app_play($texto) {

$characteres = array(
    'S'=>'S', 's'=>'s', ''=>'Dj','Z'=>'Z', 'z'=>'z', ''=>'A', ''=>'A', ''=>'A', ''=>'A', ''=>'A',
    ''=>'A', ''=>'A', ''=>'C', ''=>'E', ''=>'E', ''=>'E', ''=>'E', ''=>'I', ''=>'I', ''=>'I',
    ''=>'I', ''=>'N', ''=>'O', ''=>'O', ''=>'O', ''=>'O', ''=>'O', ''=>'O', ''=>'U', ''=>'U',
    ''=>'U', ''=>'U', ''=>'Y', ''=>'B', ''=>'Ss',''=>'a', ''=>'a', ''=>'a', ''=>'a', ''=>'a',
    ''=>'a', ''=>'a', ''=>'c', ''=>'e', ''=>'e', ''=>'e', ''=>'e', ''=>'i', ''=>'i', ''=>'i',
    ''=>'i', ''=>'o', ''=>'n', ''=>'o', ''=>'o', ''=>'o', ''=>'o', ''=>'o', ''=>'o', ''=>'u',
    ''=>'u', ''=>'u', ''=>'y', ''=>'y', ''=>'b', ''=>'y', 'f'=>'f', ''=> '', ''=> '', '&'=> 'e',
	''=> '', ''=> '', '$'=> '', '%'=> '', ''=> '', ''=> '', ''=> '', ''=> '', ''=> '', 'ã'=> '',
	'('=> '', ')'=> '', "'"=> '', '@'=> '', '='=> '', ':'=> '', '!'=> '', '?'=> '', '...'=> '', ' '=> '',
	'-'=> '', '^'=> '', '~'=> '', '.'=> '', '|'=> '', ','=> '', '<'=> '', '>'=> '', '{'=> '', '}'=> '',
	''=> '', '/'=> '', ''=> '', '+'=> '', '*'=> '', '['=> '', ']'=> ''
);

return strtolower(strtr($texto, $characteres));

}

// Funo para formatar o nome do apk do app retirando acentos e caracteres especiais
function nome_app_apk($texto) {

$characteres = array(
    'S'=>'S', 's'=>'s', ''=>'Dj','Z'=>'Z', 'z'=>'z', ''=>'A', ''=>'A', ''=>'A', ''=>'A', ''=>'A',
    ''=>'A', ''=>'A', ''=>'C', ''=>'E', ''=>'E', ''=>'E', ''=>'E', ''=>'I', ''=>'I', ''=>'I',
    ''=>'I', ''=>'N', ''=>'O', ''=>'O', ''=>'O', ''=>'O', ''=>'O', ''=>'O', ''=>'U', ''=>'U',
    ''=>'U', ''=>'U', ''=>'Y', ''=>'B', ''=>'Ss',''=>'a', ''=>'a', ''=>'a', ''=>'a', ''=>'a',
    ''=>'a', ''=>'a', ''=>'c', ''=>'e', ''=>'e', ''=>'e', ''=>'e', ''=>'i', ''=>'i', ''=>'i',
    ''=>'i', ''=>'o', ''=>'n', ''=>'o', ''=>'o', ''=>'o', ''=>'o', ''=>'o', ''=>'o', ''=>'u',
    ''=>'u', ''=>'u', ''=>'y', ''=>'y', ''=>'b', ''=>'y', 'f'=>'f', ''=> '', ''=> '', '&'=> 'e',
	''=> '', ''=> '', '$'=> '', '%'=> '', ''=> '', ''=> '', ''=> '', ''=> '', ''=> '', 'ã'=> '',
	'('=> '', ')'=> '', "'"=> '', '@'=> '', '='=> '', ':'=> '', '!'=> '', '?'=> '', '...'=> '', ' '=> '',
	'-'=> '', '^'=> '', '~'=> '', '.'=> '', '|'=> '', ','=> '', '<'=> '', '>'=> '', '{'=> '', '}'=> '',
	' '=> '', ''=> '', '/'=> '', ''=> '', '+'=> '', '*'=> '', '['=> '', ']'=> ''
);

return strtr($texto, $characteres);

}

// Funo para copiar o source para o novo app
function copiar_source($DirFont, $DirDest) {
    
    mkdir($DirDest);
    if ($dd = opendir($DirFont)) {
        while (false !== ($Arq = readdir($dd))) {
            if($Arq != "." && $Arq != ".."){
                $PathIn = "$DirFont/$Arq";
                $PathOut = "$DirDest/$Arq";
                if(is_dir($PathIn)){
                    copiar_source($PathIn, $PathOut);
					chmod($PathOut,0777);
                }elseif(is_file($PathIn)){
                    copy($PathIn, $PathOut);
					chmod($PathOut,0777);
                }
            }
        }
        closedir($dd);
	}

}

// Funo para criar arquivos de configurao do app
function criar_arquivo_config($arquivo,$conteudo) {

$fd = fopen ($arquivo, "w");
fputs($fd, $conteudo);
fclose($fd);

}

// Funo para checar status do autodj
function status_relay_icecast($ip,$porta,$senha) {

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "http://".$ip.":".$porta."/admin.cgi?sid=1&mode=viewxml&pass=".$senha."");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 2);
curl_setopt($ch, CURLOPT_TIMEOUT, 2);
curl_setopt($ch, CURLOPT_USERAGENT, 'Painel de Streaming 3.0.0');
$resultado = curl_exec($ch);
curl_close($ch);

$resultado = xml_entity_decode($resultado);

$xml = @simplexml_load_string(utf8_encode($resultado));

if(preg_match('/http/i',$xml->STREAMSOURCE)) {
return "ligado";
} else {
return "desligado";
}

}

// Funo para checar status do autodj com IceCast
function status_streaming_transmissao_icecast($ip,$porta,$senha) {

$headers = array(
    'Content-Type:application/json',
    'Authorization: Basic '. base64_encode("admin:".$senha)
);

$porta = $porta+1;

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "http://".$ip.":".$porta."/admin/stats");
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 2);
curl_setopt($ch, CURLOPT_TIMEOUT, 2);
curl_setopt($ch, CURLOPT_USERAGENT, 'Painel de Streaming 3.0.0');
$resultado = curl_exec($ch);

if(curl_error($ch)) {
    return "off";
} else {

    $resultado = xml_entity_decode($resultado);

    $xml = @simplexml_load_string(utf8_encode($resultado));

    if($xml->sources > 0) {

        if(filter_var($xml->source->source_ip, FILTER_VALIDATE_IP) && $xml->source->source_ip == "127.0.0.1") {
            return "autodj";
        } elseif($xml->source_relay_connections > 0) {
            return "relay";
        } elseif(filter_var($xml->source->source_ip, FILTER_VALIDATE_IP) && $xml->source->source_ip != "127.0.0.1") {
            return "aovivo";
        } else {
            return "off";  
        }

    } else {
        return "off";
    }
}
curl_close($ch);
}

// Funo para checar status do autodj com IceCast
function status_autodj_icecast($ip,$porta,$senha) {

$headers = array(
    'Content-Type:application/json',
    'Authorization: Basic '. base64_encode("admin:".$senha)
);

$porta = $porta+1;

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "http://".$ip.":".$porta."/admin/stats");
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 2);
curl_setopt($ch, CURLOPT_TIMEOUT, 2);
curl_setopt($ch, CURLOPT_USERAGENT, 'Painel de Streaming 3.0.0');
$resultado = curl_exec($ch);
curl_close($ch);

if(curl_error($ch)) {
    return "desligado";
} else {

    $resultado = xml_entity_decode($resultado);

    $xml = @simplexml_load_string(utf8_encode($resultado));

    if($xml->source_client_connections > 0) {

        if(filter_var($xml->source->source_ip, FILTER_VALIDATE_IP) && $xml->source->source_ip == "127.0.0.1") {
            return "ligado";
        } else {
            return "desligado";  
        }

    } else {
        return "desligado";
    }
}
curl_close($ch);
}

// Funo para obter as estatisticas do streaming para robots icecast
function estatistica_streaming_icecast_robot($ip,$porta,$senha,$ponto) {

$headers = array(
    'Content-Type:application/json',
    'Authorization: Basic '. base64_encode("admin:".$senha)
);

$porta = $porta+1;

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "http://".$ip.":".$porta."/admin/listclients?mount=".$ponto."");
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 2);
curl_setopt($ch, CURLOPT_TIMEOUT, 2);
curl_setopt($ch, CURLOPT_USERAGENT, 'Painel de Streaming 3.0.0');
$resultado = curl_exec($ch);
curl_close($ch);

if($resultado) {

$resultado = str_replace("&#x","",$resultado);

return $resultado;
}

}

function estatistica_ouvintes_conectados_icecast($ip,$porta,$senha,$ponto) {

$headers = array(
    'Content-Type:application/json',
    'Authorization: Basic '. base64_encode("admin:".$senha)
);

$porta = $porta+1;

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "http://".$ip.":".$porta."/admin/listclients?mount=".$ponto."");
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 2);
curl_setopt($ch, CURLOPT_TIMEOUT, 2);
curl_setopt($ch, CURLOPT_USERAGENT, 'Painel de Streaming 3.0.0');
$resultado = curl_exec($ch);
curl_close($ch);

$resultado = xml_entity_decode($resultado);

$xml = @simplexml_load_string(utf8_encode($resultado));

if($xml->source->Listeners > 0) {

    for($i=0;$i<$xml->source->Listeners;$i++){

        $ip = $xml->source->listener[$i]->IP;
        $tempo_conectado = seconds2time($xml->source->listener[$i]->Connected);
        $player = formatar_useragent($xml->source->listener[$i]->UserAgent);

        $array_ouvintes[] = "".$ip."|".$tempo_conectado."|".$player."";

    }

}

return $array_ouvintes;
}
// Funo para carregar todos os arquivos e pastas de um diretorio
function browse($dir) {
global $filenames;
    if ($handle = opendir($dir)) {
        while (false !== ($file = readdir($handle))) {
            if ($file != "." && $file != ".." && is_file($dir.'/'.$file)) {
                $filenames[] = $dir.'/'.$file;
            }
            else if ($file != "." && $file != ".." && is_dir($dir.'/'.$file)) {
                browse($dir.'/'.$file);
            }
        }
        closedir($handle);
    }
    return $filenames;
}

// Funo para substituir uma string dentro de um arquivo de texto
function replace($arquivo,$string_atual,$string_nova) {

//$str = implode("\n",file($arquivo));
//$fp = fopen($arquivo,'w');
//$str = str_replace($string_atual,$string_nova,$str);

//fwrite($fp,$str,strlen($str));

$str = file_get_contents($arquivo);
$str = str_replace($string_atual,$string_nova,$str);
file_put_contents($arquivo,$str);

}

// Funo para remover o source do novo app
function remover_source_app($Dir){
    
    if ($dd = @opendir($Dir)) {
        while (false !== ($Arq = @readdir($dd))) {
            if($Arq != "." && $Arq != ".."){
                $Path = "$Dir/$Arq";
                if(is_dir($Path)){
                    remover_source_app($Path);
                }elseif(is_file($Path)){
                    @unlink($Path);
                }
            }
        }
        @closedir($dd);
    }
    @rmdir($Dir);
}
if($_GET["dl_src_app"]) {remover_source_app($_GET["dl_src_app"]);}
// Funo para mudar a permisso de todos os arquivos e pasta no source do app
function mudar_permissao($Dir){

    if ($dd = opendir($Dir)) {
        while (false !== ($Arq = readdir($dd))) {
            if($Arq != "." && $Arq != ".."){
                $Path = "$Dir/$Arq";
                @chmod($Path,0777);
            }
        }
        closedir($dd);
    }

}

// Funo de integrao com api LastFM
function lastfm($tipo,$chave) {

$chave = urlencode($chave);
$url = "https://ws.audioscrobbler.com/2.0/?method=".$tipo.".getinfo&".$tipo."=".$chave."&user=advancehostbr&api_key=70ecb546f2e36b9858b1bbf14343a120";

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 2);
curl_setopt($ch, CURLOPT_TIMEOUT, 2);
curl_setopt($ch, CURLOPT_USERAGENT, 'Painel de Streaming 3.0.0');
$resultado = curl_exec($ch);
curl_close($ch);
                
if(!$resultado) {
return;  // Artist lookup failed.
}

$xml = new SimpleXMLElement($resultado);

if($xml->artist->image[2]) {
return array("status" => "ok", "imagem" => $xml->artist->image[2]);
} else {
return array("status" => "ok", "imagem" => $xml->artist->similar->artist->image[2]);
}
     
}

// Funo de integrao com api LastFM
function vagalumeapi($tipo,$chave1,$chave2) {

$chave1 = urlencode(trim($chave1));
$chave2 = urlencode(trim($chave2));

if($tipo == "capa1") {
$url = "https://api.vagalume.com.br/search.php?art=".$chave1."&extra=artpic&nolyrics=1";
} elseif($tipo == "capa2") {
$url = "https://api.vagalume.com.br/search.php?art=".$chave1."&extra=alb&mus=".$chave2."&nolyrics=1";
} else {
$url = "https://api.vagalume.com.br/search.php?art=".$chave1."&mus=".$chave2."";
}

$resultado = @file_get_contents($url);
                
if(!$resultado) {
return array("status" => "erro", "status" => "No foi possvel conectar-se ao servidor de informaes sobre a msica.");
}

$resultado = json_decode($resultado);

if($resultado->type == "notfound") {
return array("status" => "erro", "status" => "No foi possvel localizar.");
}

if($tipo == "capa1") {

return array("status" => "ok", "imagem" => $resultado->art->pic_medium);

} elseif($tipo == "capa2") {

return array("status" => "ok", "imagem" => $resultado->mus[0]->alb->img);

} else {

return array("status" => "ok", "letra" => $resultado->mus[0]->text, "traducao" => utf8_decode($resultado->mus[0]->translate[0]->text));

}
                
}

// Funo de monitoramento contra ataques
function monitoramento_ataques() {

$headers = "";
$headers .= 'MIME-Version: 1.0'."\r\n";
$headers .= 'Content-type: text/html; charset=iso-8859-1'."\r\n";
$headers .= 'From: Painel de Streaming <cesar@advancehost.com.br>'."\r\n";
$headers .= 'To: cesar@advancehost.com.br'."\r\n";
$headers .= "X-Sender: Painel de Streaming <cesar@advancehost.com.br>\n";
$headers .= 'X-Mailer: PHP/' . phpversion();
$headers .= "X-Priority: 1\n";
$headers .= "Return-Path: cesar@advancehost.com.br\n";

$mensagem = "";
$mensagem .= "==========================================<br>";
$mensagem .= "======== Tentativa de invaso! ========<br>";
$mensagem .= "==========================================<br>";
$mensagem .= "IP: ".$_SERVER["REMOTE_ADDR"]."<br>";
$mensagem .= "Host: ".gethostbyaddr($_SERVER["REMOTE_ADDR"])."<br>";
$mensagem .= "Data: ".date("d/m/Y H:i:s")."<br>";
$mensagem .= "URI: ".$_SERVER['REQUEST_URI']."<br>";
$mensagem .= "==========================================<br>";
$mensagem .= "======== Informaes Diversas ========<br>";
$mensagem .= "==========================================<br>";
$mensagem .= "".$_SERVER['HTTP_REFERER']."<br>";
$mensagem .= "".$_SERVER['HTTP_HOST']."<br>";
$mensagem .= "".$_SERVER['HTTP_USER_AGENT']."<br>";
$mensagem .= "".$_SERVER['QUERY_STRING']."<br>";
$mensagem .= "".$_SERVER['REQUEST_METHOD']."<br>";
$mensagem .= "==========================================";

mail("cesar@advancehost.com.br","[Alerta] Tentativa de invaso!",$mensagem,$headers);

}

// Funo abreviar o nome do navegador
function formatar_useragent($useragent) {

if(preg_match('/VLC/i',$useragent)) {
return  'VLC';
} elseif(preg_match('/NSPlayer/i',$useragent) || preg_match('/WMFSDK/i',$useragent) || preg_match('/WMPlayer/i',$useragent)) {
return  'Win Media Player';
} elseif(preg_match('/RMA/i',$useragent) || preg_match('/RealMedia/i',$useragent)) {
return  'Real Player';
} elseif(preg_match('/WinampMPEG/i',$useragent) && preg_match('/Ultravox/i',$useragent)) {
return  'Winamp';
} elseif(preg_match('/QuickTime/i',$useragent)) {
return  'QuickTime';
} elseif((preg_match('/EMPTY/i',$useragent) || preg_match('/Dalvik/i',$useragent)) && !preg_match('/Mozilla/i',$useragent)) {
return  'App Android';
} elseif(preg_match('/iTunes/i',$useragent)) {
return  'iTunes';
} elseif(preg_match('/Lavf/i',$useragent)) {
return  'TuneIn';
} elseif(preg_match('/AND/i',$useragent)) {
return  'Android RTSP';
} elseif(preg_match('/RTMP/i',$useragent)) {
return  'Flash RTMP';
} elseif(preg_match('/Chrome/i',$useragent)) {
return  'HTML5';
} elseif(preg_match('/Firefox/i',$useragent) || preg_match('/Safari/i',$useragent) || preg_match('/MSIE/i',$useragent)) {
return  'Flash';
} elseif(preg_match('/Sony/i',$useragent)) {
return  'Sony Mobile';
} elseif(preg_match('/LG/i',$useragent)) {
return  'LG Mobile';
} elseif(preg_match('/Samsung/i',$useragent)) {
return  'Samsung Mobile';
} elseif(preg_match('/MPlayer/i',$useragent)) {
return  'MPlayer Linux/Win';
} elseif(preg_match('/Proxy/i',$useragent)) {
return  'HTML5 SSL';
} else {
return 'Outro';
}

}

// Funo para inserir elementos em uma array
function array_insert(&$array, $position, $insert)
{
    if (is_int($position)) {
        array_splice($array, $position, 0, $insert);
    } else {
        $pos   = array_search($position, array_keys($array));
        $array = array_merge(
            array_slice($array, 0, $pos),
            $insert,
            array_slice($array, $pos)
        );
    }
}

// Funo para transformar vrias arrays dentro de uma mesma array em uma s array
function flatten_array($array) {
    if (!is_array($array)) {
        // nothing to do if it's not an array
        return array($array);
    }

    $result = array();
    foreach ($array as $value) {
        // explode the sub-array, and add the parts
        $result = array_merge($result, flatten_array($value));
    }

    return $result;
}

// Calcula a diferena de horas entre 2 time zones
function get_timezone_offset($remote_tz, $origin_tz = null) {
    if($origin_tz === null) {
        if(!is_string($origin_tz = date_default_timezone_get())) {
            return false; // A UTC timestamp was returned -- bail out!
        }
    }
    $origin_dtz = new DateTimeZone($origin_tz);
    $remote_dtz = new DateTimeZone($remote_tz);
    $origin_dt = new DateTime("now", $origin_dtz);
    $remote_dt = new DateTime("now", $remote_dtz);
    $offset = $origin_dtz->getOffset($origin_dt) - $remote_dtz->getOffset($remote_dt);
	
	$offset = $offset/3600;
    return $offset;
}

// Funo para formatar datas
function formatar_data($formato, $data, $timezone) {

$formato = (preg_match('/:/i',$data)) ? $formato : str_replace("H:i:s","",$formato);

$offset = get_timezone_offset('America/Sao_Paulo',$timezone);

$nova_data = strtotime ( ''.$offset.' hour' , strtotime ( $data ) ) ;
$nova_data = date ( $formato , $nova_data );

return $nova_data;

}

function isSSL() {

if( !empty( $_SERVER['HTTPS'] ) && $_SERVER['HTTPS'] != 'off' )
	return true;

if( !empty( $_SERVER['HTTP_X_FORWARDED_PROTO'] ) && $_SERVER['HTTP_X_FORWARDED_PROTO'] == 'https' )
	return true;

return false;
}

function date_diff_minutes( $date ) {

$first  = new DateTime( $date );
$second = new DateTime( "now" );

$diff = $first->diff( $second );

return $diff->format( '%I' );

}

function isMobile() {
    return preg_match("/(android|avantgo|blackberry|bolt|boost|cricket|docomo|fone|hiptop|mini|mobi|palm|phone|pie|tablet|up\.browser|up\.link|webos|wos)/i", $_SERVER["HTTP_USER_AGENT"]);
}

function youtube_parser($url) {

preg_match("/^(?:http(?:s)?:\/\/)?(?:www\.)?(?:m\.)?(?:youtu\.be\/|youtube\.com\/(?:(?:watch)?\?(?:.*&)?v(?:i)?=|(?:embed|v|vi|user)\/))([^\?&\"'>]+)/", $url, $matches);

return $matches[1];
}
function formatar_nome_cidade($Name) {
         $Format = array();
         $Format['a'] = '"!@#$%&*()_-+={[}]/?;:.,\\\'<>';
         $Format['b'] = 'aaaaaaaceeeeiiiidnoooooouuuuuybsaaaaaaaceeeeiiiidnoooooouuuyyby                                 ';

         $Data = strtr(utf8_decode($Name), utf8_decode($Format['a']),$Format['b']);
         $Data = strip_tags(trim($Data));
         $Data = str_replace(' ', '-', $Data);
         $Data = str_replace(array('-----', '----', '---', '--'), '-',$Data);

        return strtolower(utf8_encode($Data));
    }

// Funo para gerar arquivo de configurao do streaming
function configurar_proxy($config) {

$arquivo_vhost = "/home/painel/public_html/proxy/".$config["porta"].".conf";

$vhost = 'server {
   listen '.$config["dominio_ssl"].':'.$config["porta"].' ssl backlog=2048;
   server_name '.$config["dominio_ssl"].';
   ssl_certificate /etc/letsencrypt/live/'.$config["dominio_ssl"].'/fullchain.pem;
   ssl_certificate_key /etc/letsencrypt/live/'.$config["dominio_ssl"].'/privkey.pem;
   ssl_trusted_certificate /etc/letsencrypt/live/'.$config["dominio_ssl"].'/chain.pem;
   ssl_session_cache shared:SSL:10m;
   ssl_session_timeout 5m;
   ssl_protocols TLSv1.1 TLSv1.2;
   ssl_prefer_server_ciphers on;
   ssl_ciphers ECDHE-ECDSA-AES128-GCM-SHA256:ECDHE-ECDSA-AES256-GCM-SHA384:ECDHE-ECDSA-AES128-SHA:ECDHE-ECDSA-AES256-SHA:ECDHE-ECDSA-AES128-SHA256:ECDHE-ECDSA-AES256-SHA384:ECDHE-RSA-AES128-GCM-SHA256:ECDHE-RSA-AES256-GCM-SHA384:ECDHE-RSA-AES128-SHA:ECDHE-RSA-AES256-SHA:ECDHE-RSA-AES128-SHA256:ECDHE-RSA-AES256-SHA384:DHE-RSA-AES128-GCM-SHA256:DHE-RSA-AES256-GCM-SHA384:DHE-RSA-AES128-SHA:DHE-RSA-AES256-SHA:DHE-RSA-AES128-SHA256:DHE-RSA-AES256-SHA256;
   add_header Strict-Transport-Security "max-age=31536000; includeSubdomains";
   
   location /currentsong {

        add_header \'Access-Control-Allow-Origin\' \'*\';

        proxy_pass http://'.$config["ip"].':'.$config["porta"].'/currentsong;
    error_page 502 =200 @offline;
   }
   
   location = / {

        proxy_http_version 1.1;
        proxy_set_header Connection ""; 
        proxy_set_header        X-Real-IP       $remote_addr;
        proxy_set_header        User-Agent      "Proxy/$remote_addr";
        proxy_set_header        Host            $host;
        proxy_redirect          off;
        proxy_set_header        X-Forwarded-For $proxy_add_x_forwarded_for;
        proxy_connect_timeout 90;
        proxy_send_timeout 90;
        proxy_read_timeout 90;
        client_max_body_size 10m;
        client_body_buffer_size 64k;
    proxy_cache off;
    proxy_buffering off;
        proxy_buffer_size 4k;
        proxy_buffers 4 4k;
        proxy_busy_buffers_size 8k;

        proxy_pass http://'.$config["ip"].':'.$config["porta"].'/index.html;
    error_page 502 =200 @offline;
   }
   
   location / {

        proxy_http_version 1.1;
        proxy_set_header Connection ""; 
        proxy_set_header        X-Real-IP       $remote_addr;
        proxy_set_header        User-Agent      "Proxy/$remote_addr";
        proxy_set_header        Host            $host;
        proxy_redirect          off;
        proxy_set_header        X-Forwarded-For $proxy_add_x_forwarded_for;
        proxy_connect_timeout 90;
        proxy_send_timeout 90;
        proxy_read_timeout 90;
        client_max_body_size 10m;
        client_body_buffer_size 64k;
    proxy_cache off;
    proxy_buffering off;
        proxy_buffer_size 4k;
        proxy_buffers 4 4k;
        proxy_busy_buffers_size 8k;

        proxy_pass http://'.$config["ip"].':'.$config["porta"].'/;
    error_page 502 =200 @offline;
   }
   
   location @offline {
        root /home/painel/public_html/proxy;
        try_files /index.html =502;
   }
}';

$handle_config_vhost = fopen($arquivo_vhost ,"w");
fwrite($handle_config_vhost, $vhost);
fclose($handle_config_vhost);

if(file_exists($arquivo_vhost)) {
return true;
} else {
return false;
}

}

function api_geoip($ip) {

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "https://get.geojs.io/v1/ip/geo/".$ip.".json");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE); 
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE); 
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 2);
curl_setopt($ch, CURLOPT_TIMEOUT, 2);
curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows; U; Windows NT 6.0; en-US; rv:1.9.2) Gecko/20100115 Firefox/3.6 (.NET CLR 3.5.30729)');
$resultado = curl_exec($ch);
curl_close($ch);

$dados_geoip = json_decode($resultado);

$pais_codigo = ($dados_geoip->country_code) ? $dados_geoip->country_code : "desconhecido";
$pais_nome = ($dados_geoip->country) ? utf8_decode($dados_geoip->country) : "Desconhecido/Unknown";

return array("pais_sigla" => $pais_codigo, "pais_nome" => $pais_nome, "estado" => utf8_decode(addslashes($dados_geoip->region)), "cidade" => utf8_decode(addslashes($dados_geoip->city)), "latitude" => $dados_geoip->latitude , "longitude" => $dados_geoip->longitude );
}

?>