<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>
<%@ attribute name="obj" required="true" rtexprvalue="true" %>
<%@ attribute name="columns" required="true" rtexprvalue="true" %>
<!-- %@ attribute name="title" required="false" rtexprvalue="true" % -->

<re:mark>Display a tabe</re:mark>

<c:set var="ctrlGroupClass">
	<wmsform:getctrlgroupclass obj="${obj}"/>
</c:set>

<div class="${ctrlGroupClass}">
	<h4>
		<wmsform:getlocalestring page="${page}" obj="${obj}"/>
	</h4>
	<table class="table table-striped">
		<tr>
			<c:if test="${! empty columns}">
				<c:forEach var="itemKey" items="${fn:split(columns,',')}">
					<th><wmsform:getlocalestring page="${page}" obj="${obj}.${fn:trim(itemKey)}"/></th>
				</c:forEach>
			</c:if>	
		</tr>
		<c:if test="${! empty obj}">
			<c:forEach var="item" items="${formData[obj]}">
			<tr>
				<c:forEach var="itemKey" items="${fn:split(columns,',')}">
					<td>${item[itemKey]}</td>
				</c:forEach>
			</tr>
			</c:forEach>
		</c:if>	
				
	</table>
	<wmsform:warnings path="view.${obj}" cssClass="alert alert-warning"/>
</div>