<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="wmsdialog" tagdir="/WEB-INF/tags/wmsdialog" %>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<%@ taglib prefix="wmsutil" uri="/WEB-INF/tlds/wmsutil.tld" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>
<%@ attribute name="readonly" required="true" rtexprvalue="true" %>

<re:mark>Display all smilFiles table</re:mark>

<c:set var="obj" >
	smilFiles
</c:set>

<c:if test="${fn:length(requestScope.formData[obj])>0}">
	<table class="table table-striped">
		<tr>
			<th><wmsform:getlocalestring page="${page}" obj="${obj}.name"/></th>
			<c:choose>
				<c:when test="${fn:startsWith(appType, 'live') || empty appType}">
					<th style="width:160px"><wmsform:getlocalestring page="${page}" obj="${obj}.action"/></th>
				</c:when>
				<c:otherwise>
					<th style="width:80px"><wmsform:getlocalestring page="${page}" obj="${obj}.action"/></th>
				</c:otherwise>
			</c:choose>				
		</tr>
		<c:forEach items="${requestScope.formData[obj]}" var="item">
			<c:set var="item" value="${wmsutil:escapeHtml(item)}"/>
			<tr>
				<c:choose>
					<c:when test="${readonly}">
						<td class="breakall">${item}</td>
						<td></td>
					</c:when>
					<c:otherwise>
						<td class="breakall"><a onclick='javascript:showSMILFile("${item}")' title='View'>${item}.smil</a></td>
						<td class="action-icons-triple">
							<sec:authorize access="hasAnyRole('admin')">
								<c:if test="${fn:startsWith(appType, 'live') || empty appType}">
									<a onclick='javascript:connectSMILFileShow("${wmsutil:escapeHtml(appName)}", "${item}.smil")'><i class='fa fa-sign-in fa-2x icon-standalone-link' title='' data-placement='left' data-toggle='tooltip' data-delay='250' data-original-title='Connect this SMIL file'></i></a>&nbsp;&nbsp;
									<a onclick='javascript:addSMILToStartupStreamsShow("${wmsutil:escapeHtml(appName)}","${item}.smil")'><i class='fa fa-plus fa-2x icon-standalone-link' title='' data-placement='left' data-toggle='tooltip' data-delay='250' data-original-title='Add to Startup Streams'></i></a>&nbsp;&nbsp;
								</c:if>
								<a onclick='javascript:showEditSMILFile("${item}")' ><i class='fa fa-pencil fa-2x icon-standalone-link' title='' data-placement='left' data-toggle='tooltip' data-delay='250' data-original-title='Edit this SMIL file'></i></a>
								<a onclick='javascript:removeSMILFile("${item}")' ><i class='fa fa-trash-o fa-2x icon-standalone-link' title='' data-placement='left' data-toggle='tooltip' data-delay='250' data-original-title='Delete this SMIL file'></i></a></center>
							</sec:authorize>
						</td>
					</c:otherwise>
				</c:choose>
			</tr>
		</c:forEach>
	</table>
</c:if>

<wmsdialog:deletesmilfile page="${page}"/>
<wmsdialog:connectstreamfile page="${page}"/>
<script>

var deleteSMILFileName="";

function removeSMILFile(name)
{
	deleteSMILFileName=name;
	deleteSMILFileShow();
}

function showSMILFile(name)
{
	name=encodeURIComponent(name);
	if("${appType}" == "")
	{
		loadAjaxMainContent("server/vhost/smilfile/view.htm", "vhost=${wmsutil:urlEncode(vhost)}&smilFile="+name); 	
	}
	else 
	{
		loadAjaxMainContent("applications/${appType}/smilfile/view.htm", "vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}&smilFile="+name); 			
	}
}

function showEditSMILFile(name)
{
	name=encodeURIComponent(name);
	lastTab='Basic';
	if("${appType}" == "")
	{
		loadAjaxMainContent("server/vhost/smilfile/edit.htm", "vhost=${wmsutil:urlEncode(vhost)}&smilFile="+name+"&action=quickEdit"); 	
	}
	else 
	{
		loadAjaxMainContent("applications/${appType}/smilfile/edit.htm", "vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}&smilFile="+name+"&action=quickEdit");
	}
}

var tblDataSMILFiles = new Array();

initTableDataSMILFiles();

function initTableDataSMILFiles()
{
	<c:set var="count" value="0"/>
	<c:forEach items="${requestScope.formData[obj]}" var="item">
		var newItem = new Object();
		newItem.name = "${item}";
		tblDataSMILFiles.push(newItem);
		<c:set var="count" value="${count + 1}"/>
	</c:forEach>
}
</script>
<script type="text/javascript">
    $(function () {
        $("[data-toggle='tooltip']").tooltip();
    });
</script>