<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>
<%@ attribute name="obj" required="true" rtexprvalue="true" %>
<%@ attribute name="bind" required="false" rtexprvalue="true" %>
<%@ attribute name="ctrlGroupClass" required="false" rtexprvalue="true" %>

<re:mark>Display a checkbox</re:mark>

<c:if test="${ empty ctrlGroupClass}">
	<c:set var="ctrlGroupClass" value="checkbox"/>
</c:if>

<div class="${ctrlGroupClass}">
	<label style="cursor:default">
		<c:if test="${empty bind or bind=='true'}">
			<c:set var="objValue"> 
				<wmsform:objvalue page="${page}" obj="${obj}"/>
			</c:set>
		</c:if>
		<c:choose>
			<c:when test='${objValue=="true"}'>
				<i class="fa fa-check-circle fa-fw text-success" style="margin-left:-22px"></i>
			</c:when>
			<c:otherwise>
				<i class="fa fa-times-circle fa-fw text-danger"  style="margin-left:-22px"></i>
			</c:otherwise>
		</c:choose>
		<wmsform:getlocalestring page="${page}" obj="${obj}"/>
	</label>
	<wmsform:warnings path="view.${obj}"/>
</div>