<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>
<%@ attribute name="obj" required="true" rtexprvalue="true" %>
<%@ attribute name="tooltip" required="true" rtexprvalue="true" %>

<re:mark>if tooltip is empty:</re:mark>
<re:mark>  see if objName.objVar.tooltip exists in messages.properties</re:mark>
<re:mark>  if it doesn't, see if common.objVar.tooltip exists in messages.properties</re:mark>
<re:mark>  if it doesn't, return "Please enter the objVar"</re:mark>
<re:mark>if tooltip is not empty:<fmt> </re:mark>
<re:mark>  see if tooltip exists in messages.properties</re:mark>
<re:mark>  if it doesn't, return tooltip</re:mark>


<c:set var="tooltip_fmt" value="Unknown"/>
<c:choose>
	<c:when test="${empty tooltip}">
		<c:set var="tooltip_fmt" >
			<fmt:message key="${page}.${obj}.tooltip" />
		</c:set>
		<c:if test='${fn:startsWith(tooltip_fmt, "??")}'>
			<c:set var="tooltip_fmt" >
				<fmt:message key="common.${obj}.tooltip" />
			</c:set>
		</c:if>		
		<c:if test='${fn:startsWith(tooltip_fmt, "??")}'>
			<c:set var="tooltip_fmt" >
				<c:set var="objLabel" >
					<wmsform:getlocalestring page="${page}" obj="${obj}"/>	
				</c:set>
				Enter the ${objLabel} 
			</c:set>
		</c:if>		
 	</c:when>
	<c:otherwise>
		<c:set var="tooltip_fmt" >
			<fmt:message key="${tooltip}" />
		</c:set>
		<c:if test='${fn:startsWith(tooltip_fmt, "??")}'>
			<c:set var="tooltip_fmt" >
				${tooltip} 
			</c:set>
		</c:if>		
	</c:otherwise>
</c:choose>
${tooltip_fmt}