<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>
<%@ attribute name="obj" required="true" rtexprvalue="true" %>
<%@ attribute name="objValue" required="true" rtexprvalue="true" %>
<%@ attribute name="showTitle" required="false" rtexprvalue="true" %>
<%@ attribute name="tooltip" required="false" rtexprvalue="true" %>
<%@ attribute name="required" required="false" rtexprvalue="true" %>
<%@ attribute name="boldTitle" required="false" rtexprvalue="true" %>
<%@ attribute name="twoLine" required="false" rtexprvalue="true" %>

<re:mark>Display true/false radio buttons</re:mark>

<re:mark>Get the tooltip based on objName and objVar</re:mark>
<c:set var="tooltip_msg">
	<wmsform:getlocaletooltip page="${page}" obj="${obj}" tooltip="${tooltip}"/>
</c:set>
 
<re:mark>Radio button</re:mark>
<c:set var="ctrlGroupClass">
	<wmsform:getctrlgroupclass obj="${obj}"/>
</c:set>
<c:set var="objName">
	${fn:replace(obj,'[','')}
</c:set>
<c:set var="objName">
	${fn:replace(objName,']','')}
</c:set>

<div class="${ctrlGroupClass}" id="${obj}CtrlGroup">
	<p>
		<re:mark>Title</re:mark>
		<c:if test="${ empty showTitle}">
			<c:set var="title">
				<wmsform:getlocalestring page="${page}" obj="${obj}"/>
			</c:set>
			<c:choose>
				<c:when test='${! empty boldTitle}'>
					<label class="control-label">${title}</label>
				</c:when>
				<c:otherwise>
					${title}	
				</c:otherwise>
			</c:choose>
		</c:if>
		<c:if test="${! empty required}">
		*
		</c:if>
		<c:if test="${! empty twoLine}">
			<br>
		</c:if>
		<label class="radio-inline">
		<re:mark>Would be easier to use the form:radiobutton, but it would not check true when the obj equaled true, always false, for advanced settings</re:mark>
			<c:choose>
				<c:when test='${objValue=="true"}'>
					<input id="${objName}1" name="${obj}" type="radio" value="true" checked="checked">
				</c:when>
				<c:otherwise>
					<input id="${objName}1" name="${obj}" type="radio" value="true">
				</c:otherwise>
			</c:choose>
			True
		</label>
		<label class="radio-inline">
			<c:choose>
				<c:when test='${objValue=="false"}'>
					<input id="${objName}2" name="${obj}" type="radio" value="false" checked="checked">
				</c:when>
				<c:otherwise>
					<input id="${objName}2" name="${obj}" type="radio" value="false">
				</c:otherwise>
			</c:choose>
			False
		</label>
	</p>
	<re:mark>Errors and warnings</re:mark>
	<wmsform:errors path="${obj}"/>
	<wmsform:warnings path="${obj}"/>
</div>