<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>
<%@ attribute name="obj" required="true" rtexprvalue="true" %>
<%@ attribute name="cssClass" required="false" rtexprvalue="true" %>
<%@ attribute name="selectClass" required="false" rtexprvalue="true" %>
<%@ attribute name="title" required="false" rtexprvalue="true" %>
<%@ attribute name="tooltip" required="false" rtexprvalue="true" %>

<re:mark>Display a listbox of current options allowing the user to add/remove items from a text box</re:mark>


<re:mark>Get the tooltip based on objName and objVar</re:mark>
<c:set var="tooltip_msg">
	<wmsform:getlocaletooltip page="${page}" obj="${obj}" tooltip="${tooltip}"/>
</c:set>

<re:mark>Get the add button label, defaults to add</re:mark>
<c:set var="btn_add_label">
	<wmsform:getlocalebutton page="${page}" obj="${obj}"  button="add"/>
</c:set>

<re:mark>Get the remove button label, defaults to remove</re:mark>
<c:set var="btn_remove_label">
	<wmsform:getlocalebutton page="${page}" obj="${obj}"  button="remove"/>
</c:set>

<re:mark>Get the current list</re:mark>
<c:set var="currentList">
	<wmsform:objvaluearray  page="${page}" obj="${obj}" leavecomma="true" />
</c:set>

<c:set var="ctrlGroupClass">
	<wmsform:getctrlgroupclass obj="${obj}"/>
</c:set>

<div class="${ctrlGroupClass}" id="${obj}CtrlGroup">
	<re:mark>Title</re:mark>
	<label>
		<wmsform:getlocalestring page="${page}" obj="${obj}" />
	</label>
	<div class="row">
		<div class="col-md-8">
			<re:mark>Textbox for new item</re:mark>
			<input id="${obj}.newValue" name="${obj}.newValue" title="{tooltip_msg}" type="text" value="" class="${cssClass}" placeholder="Enter a license key">
		</div>
		<div class="col-md-4">
			<re:mark>Add button</re:mark>
			<input name="btnAdd${obj}" type="button" class="btn btn-default" id="btnAdd${obj}" onClick="javascript:addOption('${obj}');" value="${btn_add_label}"/><br>
		</div>
	</div>
	<div class="row">
		<div class="col-md-8">
			<re:mark>We need the spring from:select hidden.  When we submit the form, all options must be selected</re:mark>
			<form:select path="${obj}" size="5" style="display:none;">
				<c:if test="${! empty currentList}">
					<c:forEach var="itemKey" items="${fn:split(currentList,',')}">
						<option value="${fn:trim(itemKey)}" selected="selected">${fn:trim(itemKey)}</option>
					</c:forEach>
				</c:if>
			</form:select>
				<re:mark>This is the <select> element the user sees</re:mark>
				<select id="${obj}.visible" class="${selectClass}" multiple >
					<c:if test="${! empty currentList}">
						<c:forEach var="itemKey" items="${fn:split(currentList,',')}">
							<option value="${fn:trim(itemKey)}" >${fn:trim(itemKey)}</option>
						</c:forEach>
					</c:if>
				</select>
		</div>
		<div class="col-md-4">
			<re:mark>Remove Button</re:mark>
			<input name="btnRemove${obj}" type="button" class="btn btn-default btn-license" id="btnRemove${obj}" onClick="javascript:removeOption('${obj}');" value="${btn_remove_label}" /><br>
		</div>
	</div>
	<re:mark>Errors and warnings</re:mark>
	<wmsform:errors path="${obj}"/>
	<wmsform:warnings path="${obj}"/>
</div>