<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform"%>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form"%>

<%@ attribute name="page" required="true" rtexprvalue="true"%>

<div id="newEulaModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="newEulaModalLabel" aria-hidden="true">
	<div class="modal-dialog" style="width:1000px">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" onClick="javascript:newEulaClose()">x</button>
				<h4 id="newEulaModalLabel" class="modal-title">
					<wmsform:getlocalestring page="newEulaModal" obj="header" />
				</h4>
			</div>
			<div class="modal-body">
				<wmsform:getlocalestring page="newEulaModal" obj="leadText" />
				<br><br>
				<div id="eulaStuff" style="height:200px;overflow-y:scroll;">
				</div>
			</div>
			<div class="modal-footer">
				<div class="row">
					<div class="col-md-8">
						<re:mark> add error or warnings. this is needed to right justify buttons. </re:mark>
					</div>
					<div class="col-md-4">
						<wmsform:buttoncancel onClick="javascript:newEulaClose()" />
						<a class="btn btn-primary" name="acceptEula" onClick="javascript:acceptEula()" id="acceptEulaBtn"><fmt:message key="newEulaModal.accept"/></a>
					</div>
				</div>
				<input type="submit" style="display: none" />
			</div>
		</div>
	</div>
</div>
<c:set var="emptyName">
	<wmsform:getlocalestring page="appconfig.main" obj="uiAppName.empty" />
</c:set>

<script>
	$(document).ready(function() {
		$("#defaultForm").bind("keypress", function(e) {
			if (e.keyCode == 13) {
				//don't accept without acceptEulaBtn
				//return response(false);
			}
		});
	});

	
	var response=null;
	var eula=null;
	function newEulaShow(eulaHtml, cb) {
		$('#newEulaModal').on('shown.bs.modal', function() {
			$('#acceptEulaBtn').focus();
			//set the EULA html as the html for our eulaStuff div in the modal.
			document.getElementById('eulaStuff').innerHTML = eulaHtml;
		});
		$('#newEulaModal').modal('show');
		//set up a callback for the other functions to use when we exit the modal
		response = cb;
	}

	function newEulaClose() {
		$('#newEulaModal').modal('hide');
		return response(false);
	}

	function acceptEula() {
		$('#newEulaModal').modal('hide');
		return response(true);
	}
</script>