<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%@ taglib prefix="wmsutil" uri="/WEB-INF/tlds/wmsutil.tld" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>

<div id="enableStreamTargetModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="enableStreamTargetModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<form class="form-modal"><fieldset>
				  <div class="modal-header">
					<button type="button" class="close" onClick="javascript:enableStreamTargetClose()">x</button>
					<h4 id="enableStreamTargetModalLabel" class="modal-title"><wmsform:getlocalestring page="enableStreamTargetDialog" obj="title"/></h4>
				  </div>
				  <div class="modal-body">
						<p class="breakall"><wmsform:getlocalestring page="enableStreamTargetDialog" obj="message"/> <b><span id="enableStreamTargetName"></span></b>?</p>
						<p class="text-warning"><wmsform:getlocalestring page="enableStreamTargetDialog" obj="warning"/></p>
				  </div>
				  <div class="modal-footer">
					<wmsform:buttoncancel  onClick="javascript:enableStreamTargetClose()"/>
					<wmsform:buttonok  onClick="javascript:doEnableStreamTarget()"/>
				  </div>
			</fieldset></form>
		</div>
	</div>
</div>
<script>
var currentStreamTarget;
var currentApp;

function enableStreamTargetShow(app, streamTargetName) {
	$('#enableStreamTargetName').text(streamTargetName);
	currentApp=app;
	currentStreamTarget=streamTargetName;
	$('#enableStreamTargetModal').on("shown.bs.modal", function() {});
	$('#enableStreamTargetModal').modal('show');
}

function enableStreamTargetClose() {
	$('#enableStreamTargetModal').modal('hide');
	restartRefresh();
}

function doEnableStreamTarget() {
	$('#enableStreamTargetModal').on('hidden.bs.modal', function() {
		postAJAXForm('streamTarget/enable.htm','vhost=${wmsutil:urlEncode(vhost)}&appName='+encodeURIComponent(currentApp)+'&appType=${appType}&appSection=${appSection}&streamTargetName='+encodeURIComponent(currentStreamTarget)+'&returnPage=${page}');
	});
	enableStreamTargetClose();
}

</script>