<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%@ taglib prefix="wmsutil" uri="/WEB-INF/tlds/wmsutil.tld" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>

<div id="deleteStartupStreamModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="deleteStartupStreamModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<form class="form-modal">
				<fieldset>
					  <div class="modal-header">
						<button type="button" class="close" onClick="javascript:deleteStartupStreamClose()">x</button>
						<h4 id="deleteStartupStreamModalLabel" class="modal-title"><wmsform:getlocalestring page="${page}" obj="deleteStartupStreamDialog.title"/></h4>
					  </div>
					  <div class="modal-body">
							<p class="breakall"><wmsform:getlocalestring page="${page}" obj="deleteStartupStreamDialog.message"/> <b><span id="deleteStartupStreamName"></span></b></p>
							<p class="text-warning"><wmsform:getlocalestring page="${page}" obj="deleteStartupStreamDialog.warning"/></p>
					  </div>
					  <div class="modal-footer">
						<wmsform:buttoncancel  onClick="javascript:deleteStartupStreamClose()"/>
						<wmsform:buttonok  onClick="javascript:doDelete()"/>
					  </div>
				</fieldset>
			</form>
		</div>
	</div>
</div>

<script>

function deleteStartupStreamShow() {
	$('#deleteStartupStreamName').text(deleteStartupStreamName);
	$('#deleteStartupStreamModal').on("shown.bs.modal", function() {
	});
	$('#deleteStartupStreamModal').modal('show');	
}

function deleteStartupStreamClose() {
	$('#deleteStartupStreamModal').modal('hide');
}

function doDelete() {
	$('#deleteStartupStreamModal').on('hidden.bs.modal', function() {
		loadAjaxMainContent('server/vhost/startupstreams/delete.htm','vhost=${wmsutil:urlEncode(vhost)}&appName='+encodeURIComponent(deleteStartupStreamAppName)+'&appInstance='+deleteStartupStreamAppInstance+'&streamName='+encodeURIComponent(deleteStartupStreamName));
	});
	deleteStartupStreamClose();
	return;
}

</script>