<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>

<div id="deletePublisherModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="deletePublisherModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<form class="form-modal">
				<fieldset>
					  <div class="modal-header">
						<button type="button" class="close" onClick="javascript:deletePublisherClose()">x</button>
						<h4 id="deletePublisherModalLabel" class="modal-title"><wmsform:getlocalestring page="${page}" obj="deletePublisherDialog.title"/></h4>
					  </div>
					  <div class="modal-body">
							<p class="breakall"><wmsform:getlocalestring page="${page}" obj="deletePublisherDialog.message"/> <b><span id="deletePublisherName"></span></b>?</p>
							<p class="text-warning"><wmsform:getlocalestring page="${page}" obj="deletePublisherDialog.warning"/></p>
					  </div>
					  <div class="modal-footer">
						<wmsform:buttoncancel  onClick="javascript:deletePublisherClose()"/>
						<wmsform:buttonok  onClick="javascript:doDelete()"/>
					  </div>
				</fieldset>
			</form>
		</div>
	</div>	
</div>

<script>

function deletePublisherShow() {
	$('#deletePublisherName').html(deletePublisherName);
	$('#deletePublisherModal').on("shown.bs.modal", function() {
	});
	$('#deletePublisherModal').modal('show');	
}

function deletePublisherClose() {
	$('#deletePublisherModal').modal('hide');
}

function doDelete() {
	$('#deletePublisherModal').on('hidden.bs.modal', function() {
		loadAjaxMainContent('server/publisher/delete.htm','publisherName='+deletePublisherName);
	});
	deletePublisherClose();
	return;
}

</script>