<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%@ taglib prefix="wmsutil" uri="/WEB-INF/tlds/wmsutil.tld" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>

<div id="copyTranscoderEncodeModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="copyTranscoderEncodeModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<form id="copyForm" class="form-modal"><fieldset>
				  <div class="modal-header">
					<button type="button" class="close" onClick="javascript:copyTranscoderEncodeClose()">x</button>
					<h4 id="copyTranscoderEncodeModalLabel" class="modal-title"><wmsform:getlocalestring page="${page}" obj="copyTranscoderEncodeDialog.title"/></h4>
				  </div>
				  <div class="modal-body">
						<p class="breakall"><wmsform:getlocalestring page="${page}" obj="copyTranscoderEncodeDialog.message"/> <b><span id="copyEncodeName"></span></b>?</p>
						<label><wmsform:getlocalestring page="${page}" obj="copyTranscoderEncodeDialog.prompt"/></label><input id="newEncodeName" path="newEncodeName" value="" class="form-control"/>
				  </div>
				  <div class="modal-footer">
					<div class="row">
						<div class="col-md-8">
							<div id="newEncodeNameWarnings" class="alert alert-danger">aaa</div>
						</div>
						<div class="col-md-4">
						   	<wmsform:buttoncancel  onClick="javascript:copyTranscoderEncodeClose()"/>
							<wmsform:buttonok  onClick="javascript:doCopyTranscoderEncode()"/>
						</div>
					</div>
				  </div>
			</fieldset></form>
		</div>
	</div>
</div>
<c:set var="dupOverlayNameError">
	<wmsform:getlocalestring page="${page}" obj="encodeName.dup"/>
</c:set>
<c:set var="blankNameError">
	<wmsform:getlocalestring page="${page}" obj="encodeName.empty"/>
</c:set>
<script>
$(document).ready(function() {
	$("#copyForm").bind("keypress", function(e) {
         if (e.keyCode == 13) {   
        	 doCopyTranscoderEncode();
             return false;
        }
     });
});

function copyTranscoderEncodeShow() {
	$("#copyEncodeName").text(copyEncodeDisplayName);
	$('#newEncodeNameWarnings').hide();
	$('#newEncodeName').val("");
	$('#copyTranscoderEncodeModal').on("shown.bs.modal", function() {
		$('#newEncodeName').focus();
	});
	$('#copyTranscoderEncodeModal').modal('show');
}

function copyTranscoderEncodeClose() {
	$('#copyTranscoderEncodeModal').modal('hide');
}

function doCopyTranscoderEncode()
{
	var ok=true;
	if($("#newEncodeName").val().trim()=="")
	{
		$('#newEncodeNameWarnings').text("${blankNameError}");
		$('#newEncodeNameWarnings').show();
		ok=false;					
	}
	if(ok)
	{
		createCopyTranscoderEncode();		
	}
}

function createCopyTranscoderEncode() {
	var result=$('#newEncodeName').val();
	lastTranscoderEncode=result.trim();
	lastTranscoderEncodeType="${EncodeType}";
	lastTranscoderEncodeSection='main';
	$('#copyTranscoderEncodeModal').on('hidden.bs.modal', function() {
		postAJAXForm('transcoderencode/copy.htm','vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}&appType=${appType}&templateName=${wmsutil:urlEncode(templateName)}&srcEncode='+ encodeURIComponent(copyEncodeName) +'&dstEncode='+encodeURIComponent(result.trim()));
	});
	copyTranscoderEncodeClose();
}

</script>