<p>Use the following settings to specify how the encoding preset is processed.</p>

<h5>Preset Name</h5>
<p>The name of the encoding preset. You should use a name to help you identify it from other presets that are included in the template. For example, you could use a profile name to show that the preset is targeted at a specific class of devices. The presets in the default templates use names that refer to the image display resolution (for example, <strong>720p</strong>). The preset name value must be unique and can't contain less-than (&lt;), greater-than (&gt;), colon (&#58;), quotation (&#39; and &quot;), forward slash (&#47;), backslash (&#92;), pipe (&#124;), question mark (&#63;), asterisk (&#42;), double-dot (..), and tilde (&#126;) characters.</p>

<h5>Outgoing Stream Name</h5>
<p>The transcoded (outgoing) stream name. All transcoded stream names must be unique for a given application. Be sure that the outgoing stream name for this preset doesn't conflict with any outgoing stream names for stream name groups that you configure on the <strong>Stream Name Groups</strong> tab.</p>

<p>To help ensure that the outgoing stream name is unique, you can append the <strong>Preset Name</strong> to the stream name. For example:</p>

<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<strong>mp4:&#36;&#123;SourceStreamName&#125;&#95;720p</strong></p>

<p>This outgoing stream name example appends the underscore character (&#95;) and the preset name (<strong>720p</strong>) to the stream name.</p>

<p>The above example uses the &#36;&#123;SourceStreamName&#125; variable, which is replaced with the source stream name in the outgoing stream name, and the media type prefix <strong>mp4:</strong>. The media type prefixes <strong>mp4:</strong> and <strong>flv:</strong> specify the digital container that identifies and interleaves the data in the stream. If you intend to stream adaptive bitrate H.264 video with AAC or MP3 audio, be sure to use the <strong>mp4:</strong> prefix to specify the MP4 (QuickTime) container. The <strong>flv:</strong> prefix specifies the Flash Video container file format for Adobe Flash Player.</p>

<blockquote><strong>Note:</strong> The outgoing stream name value can't contain less-than (&lt;), greater-than (&gt;), quotation (&#39; and &quot;), forward slash (&#47;), backslash (&#92;), pipe (&#124;), question mark (&#63;), double-dot (..), and tilde (&#126;) characters.</blockquote>

<hr />
<h4>Video Settings</h4>

<h5>Video Codec</h5>
<p>The video codec to use:
	<ul>
		<li><strong>H.263</strong>. Transcode video to H.263. Note that if you select this option, the <strong>Transcoder</strong> accelerated encoding options (<strong>QuickSync</strong> and <strong>NVENC</strong>) aren't supported.
		<li><strong>H.264</strong>. Transcode video to H.264. Also use when transrating source H.264 video to achieve a different bitrate, profile, and so on.
		<li><strong>H.265</strong>. Transcode video to H.265. Also use when transrating source H.265 video to achieve a different bitrate, and so on. Note that the H.265/HEVC codec isn't widely supported by playback protocols and players.
		<li><strong>VP8</strong>. Transcode video to VP8. Use when transcoding to WebM for MPEG-DASH playback.
		<li><strong>VP9</strong>. Transcode video to VP9. Use when transcoding to WebM for MPEG-DASH playback.
		<li><strong>Passthrough</strong>. Pass the source video stream through to output renditions without making any changes.
		<li><strong>Disabled</strong>. Disable video in the transcoded streams.
</ul></p>

<h5>Video Bitrate</h5>
<p>The target video bitrate to use, in bits per second (bps). Valid values range from <strong>10000</strong> to <strong>24000000</strong> bps. The value is ignored if the <strong>Video Codec</strong> option is set to <strong>Passthrough</strong>.</p>

<h5>Encode Implementation</h5>
<p>The encoding implementation to use. The server supports the following software and accelerated hardware encoding implementations:</p>
<ul>
	<li><strong>Default</strong>. The built-in MainConcept software encoder (not hardware-accelerated).
	<li><strong>QuickSync</strong>. Intel Quick Sync encoding acceleration. If your hardware doesn't support the Quick Sync instruction set, the MainConcept software encoder is used.
	<li><strong>NVENC</strong>. NVIDIA NVENC encoding acceleration. If your NVIDIA graphics card doesn't have the NVENC hardware-based video encoder, which comes with most NVIDIA graphics cards with the Kepler GPU architecture, the MainConcept software encoder is used.
</ul>

<h5>GPU ID</h5>
<p>The Transcoder can be used with more than one graphics card when using NVENC encoding implementations; however, it won't automatically load balance between multiple cards. The available graphics processor units (GPUs) are enumerated when the Transcoder is started with ID values starting at <strong>0</strong>. Select <strong>Use first available GPU</strong> to specify that the first GPU in the list of enumerated GPUs should always be used for transcoding. To always use a specific GPU, enter its enumeration ID value in the <strong>Use GPU ID</strong> box.</p>

<h5>Profile</h5>
<p>The video profile to use. A profile is a defined set of capabilities that are intended to optimize the viewer's experience on specific classes of applications. <br>The following video profiles are supported for H.264:
	<ul>
		<li><strong>Baseline</strong>. For low-complexity streams for mobile streaming.
		<li><strong>Main</strong>. For higher complexity and higher quality streams for desktop and over-the-top streaming.
	<li><strong>High</strong>. For high-complexity streams for broadcast and disc storage applications.
</ul></p>
<p>For H.265, only the <strong>Main</strong> profile is supported.</p>

<h5>Key Frame Interval</h5>
<p>The keyframe interval to use. Select <strong>Same as source</strong> to specify that the keyframe interval of the transcoded video is the same as the keyframe interval of the source video (this is required when transrating). Alternatively for transcoding, you can enter an integer value between <strong>1</strong> and <strong>10000</strong> for a specific keyframe interval.</p>

<hr />
<h4>Frame Size</h4>

<h5>Fit Mode, Width, and Height</h5>
<p>Options for specifying the transcoded frame size:</p>
<ul>
	<li><strong>match-source</strong>. Uses the same frame width and height as the source video.
	<li><strong>letterbox</strong>. Maintains the aspect ratio of the source video and scales to fit the destination frame size (<strong>Width</strong> and <strong>Height</strong>) with black bars to fill empty space.
	<li><strong>fit-width</strong>. Adjusts the height to fit the specified <strong>Width</strong> while maintaining the incoming aspect ratio.
	<li><strong>fit-height</strong>. Adjusts the width to fit the specified <strong>Height</strong> while maintaining the incoming aspect ratio.
	<li><strong>crop</strong>. Scales and crops the source video to fit the destination frame size (<strong>Width</strong> and <strong>Height</strong>) while maintaining the incoming aspect ratio.
	<li><strong>stretch</strong>. Stretches the video to the fit the specified <strong>Width</strong> and <strong>Height</strong>.
</ul>
<blockquote><strong>Note:</strong> <strong>Width</strong> and <strong>Height</strong> values must be at least <strong>16</strong> pixels.</blockquote>

<h5>Crop</h5>
<p>Enter a non-zero integer value in <strong>Left</strong>, <strong>Top</strong>, <strong>Right</strong> and <strong>Bottom</strong> to remove the outer parts of the source video frame by the corresponding number of pixels. This tool can help you to improve framing, accentuate subject matter, or change the aspect ratio.</p>

<hr />
<h4>Audio Settings</h4>

<h5>Audio Codec</h5>
<p>The audio codec to use:
	<ul>
		<li><strong>AAC</strong>. Transcode audio to AAC.
		<li><strong>Vorbis</strong>. Transcode audio to Vorbis. Use when transcoding to WebM for MPEG-DASH playback.
		<li><strong>Opus</strong>. Transcode audio to Opus. Use when transcoding to WebM for MPEG-DASH playback.
		<li><strong>Passthrough</strong>. Pass the source audio stream through to output renditions without making any changes.
		<li><strong>Disabled</strong>. Disable audio in the output renditions.
	</ul></p>

<h5>Audio Bitrate</h5>
<p>The target audio bitrate to use, in bits per second (bps). Valid values range from <strong>3000</strong> to <strong>1000000</strong> bps. The value is ignored if <strong>Audio Codec</strong> is set to <strong>Passthrough</strong>.</p>

<hr />
<h4>Overlay Images</h4>
<p>You can apply static GIF, JPEG, PNG, and BMP overlay images to streams to achieve stationary image effects such as a watermark to your video. You can customize the location, size, alignment, and opacity of the image using the settings below.</p>

<p>To view overlay image settings, click the overlay image name in the list.</p>

<p>To enable an overlay image, click the <strong>Enabled</strong> check box for the overlay image. You can enable multiple overlay images for a single preset. If you enable multiple overlay images, you can use the <strong>Move Up</strong> and <strong>Move Down</strong> icons to arrange them in the proper order. In the video, images that are higher in the list are displayed on top of images that are lower in the list.</p>

<p>To add an overlay image, click <strong>Add Overlay Image</strong>.</p>

<p>To change overlay image settings, click the <strong>Edit</strong> icon for the overlay image.</p>

<p>To delete an overlay image, click the <strong>Delete</strong> icon for the overlay image.</p>

<blockquote><strong>Notes:</strong><br />Images with a transparency require extra CPU resources.<br /><br />If you want to have the same overlay image for all encoded output renditions, you should apply it to the decoded stream on the template's <strong>Decoding Preset</strong> tab.<br /><br />You can apply dynamic overlay images to video using a Java-based API. For more information, see <a href="https://www.wowza.com/docs/how-to-add-graphic-overlays-to-live-streams-with-wowza-transcoder" target="_blank"><i class="fa fa-external-link"></i>&nbsp;Add graphic overlays to live streams with Wowza Transcoder</a>.</blockquote>

<h5>Overlay Image Settings</h5>
	<ul>
		<li><strong>Image Name</strong>. A unique name for the overlay image to differentiate it from other images. The name can't contain less-than (&lt;), greater-than (&gt;), quotation (&#39; and &quot;), forward slash (&#47;), backslash (&#92;), pipe (&#124;), question mark (&#63;), double-dot (..), and tilde (&#126;) characters.
		<li><strong>Image Path</strong>. The path to the overlay image. The path value can't contain less-than (&lt;), greater-than (&gt;), quotation (&#39; and &quot;), backslash (&#92;), pipe (&#124;), question mark (&#63;), and asterisk (&#42;) characters.
		<li><strong>Update overlay image when source image updates</strong>. Check the source image file for updates every 750 milliseconds and refresh the overlay image if it has changed.
		<li><strong>Width</strong> and <strong>Height</strong>. The overly image width and height. To specify that the source image width and/or height be used, select the <strong>Same as source image</strong> option. The minimum supported width and height is <strong>4</strong> pixels and the sum of these values must be an even number.
		<li><strong>Opacity</strong>. The overlay image opacity. Valid values range from <strong>0</strong> (completely transparent) to <strong>100</strong> (completely opaque).
	</ul>

<h5>Overlay Image Placement Settings</h5>
<ul>
	<li><strong>Location</strong>. Select an option button in this box to specify the base position of the overlay image. You can think of the <strong>Location</strong> box as analogous to the display on a playback device.
	<li><strong>Horizontal Offset</strong> and <strong>Vertical Offset</strong>. Specify a horizontal and/or vertical offset (in pixels) for the overlay image from the base position that you specified in the <strong>Location</strong> box. Values must be zero or greater (even-numbered values recommended).
</ul>

<p>As an example, to align an overlay image 10&nbsp;pixels above the lower-right corner of the output frame, select the option button in the lower-right corner of the <strong>Location</strong> box, and then enter <strong>10</strong> in the <strong>Vertical Offset</strong> box.</p>