<%@ include file="/WEB-INF/jsp/taglibs.jsp" %>

<wmsform:setpagetitle page="mediacache"/>

<div>
	<div id="generic.warnings" class="alert alert-warning" style="display:none"></div>
	<div class="row">
		<c:forEach var="msg" items="${formData.genericMessages}">
				<div class="col-md-12">
					<div class="alert alert-success">
						<strong>${msg}</strong>
					</div> 
				</div>
		</c:forEach>
	</div>

	<div class="row">
        <div class="col-md-7">
      		<happ>Media Cache Source &gt; ${sourceName}</happ><br>
	      	<small class="text-muted">${sourceType}</small>
        </div>
        <div class="col-md-6 appbuttons" id="MediaCacheSourceButtons">
	        <!--wmsform:buttonrestart onClick="javascript:restartServerShow()"/-->
	        <!--wmsform:buttonstop onClick="javascript:stopServerShow()" /-->
        </div>
    </div>

	<p><a href="javascript:returnMediaCache()"><i class="fa fa-arrow-left"></i> Return to Media Cache Sources</a></p>

	<sec:authorize access="hasAnyRole('advUser')">
	    <div class="row">
			<div class="col-md-12">
				<ul class="nav nav-tabs" >
					<li id="Basic" class="active">
						<a href="javascript:showBasicTab()">Basic</a>
					</li>
					<li id="Advanced" >
						<a href="javascript:showAdvTab()">Properties</a>
					</li>
				</ul>
			</div>
		</div>    
	</sec:authorize>
	<sec:authorize access="!hasAnyRole('advUser')">
		<hr>
	</sec:authorize>
	<div class="row" id="tabContent">
		<div class="col-md-12">
	      	<div class="row">
				<div id="ViewMode">
					<div  id="TabBasic">
						<jsp:include page="ViewBasic.jsp" flush="true" />
					</div>
					<div id="TabAdv" style="display:none">
						<jsp:include page="ViewAdv.jsp" flush="true" />
				 	</div>
				 </div>
				 <div id="EditMode">
					<div  id="TabEditBasic">
                       	<div class="col-md-8 main-content">
                            <form:form method="post" commandName="formData" id="defaultForm"> 
                                <wmsform:errors path="errorMessage" cssClass="alert alert-danger"/>
                                <wmsform:rightrailhideshow/>
                                <jsp:include page="EditBasic.jsp" flush="true" />
                                <form:hidden path="ignoreWarnings" />	
                            </form:form>
                         </div>
                         <div id="HelpSources" class="col-md-4 right-rail well-help pull-right">
                             <jsp:include page="HelpBasic_${formData.currentLocale}.jsp" flush="true" />
                         </div>
					</div>
                    <div id="TabEditAdv" style="display:none">
                       	<div class="col-md-12">
                               <form:form method="post" commandName="formDataAdv" id="defaultFormAdv"> 
                                   <wmsform:errors path="errorMessage" cssClass="alert alert-danger"/>
		                            <jsp:include page="EditAdv.jsp" flush="true" />
                                   <form:hidden path="ignoreWarnings" />	
                               </form:form>
                           </div>
                    </div>
			 	</div>
			</div>
		</div>
	</div>
   	<wmsform:setwarnings/>	
	<wmsdialog:restartserver page="serversetup" returnPage="mediaCacheSource.${sourceName}"/>
</div>

<script>

function returnMediaCache()
{
	lastTab="Sources";
	loadAjaxMainContent('server/mediacache/view.htm','');
}

$(document).ready(function() {
	
	if(typeof(lastTab) === 'undefined') {
		lastTab="Basic";
	}
		
	if("${mode}"=="edit")
	{
		$('#ViewMode').hide();	
		$('#EditMode').show();
		$('#MediaCacheSourceButtons').hide();				
	}
	else 
	{
		$('#ViewMode').show();		
		$('#EditMode').hide();		
		$('#MediaCacheSourceButtons').show();				
	}
	if(lastTab=="Advanced")
	{
		showAdvTab();
	}
	else 
	{
		showBasicTab();		
	}
	if("${action}" == "new")
	{
		$('#Advanced').hide();
		lastTab="Sources"; //so we return back to the right tab
	}
	else 
	{
		lastMediaCacheSource="${sourceName}";
		createCookie("lastMediaCacheSource",lastMediaCacheSource);
	}

});

function showBasicTab() {
	if("${mode}"=="edit" && lastTab!='Basic')
	{
		lastTab='Basic';
		showMediaCacheSource('${sourceName}');
		return;
	}
	lastTab='Basic';
	createCookie("lastTab",lastTab);
	$('#TabBasic').show();
	$('#TabEditBasic').show();
	$('#TabAdv').hide();
	$('#TabEditAdv').hide();
	$('#TabSources').hide();
	$('#TabEditSources').hide();
	$('#Basic').addClass('active');
	$('#Advanced').removeClass();
}



function showAdvTab() {
	if("${mode}"=="edit" && lastTab!='Advanced')
	{
		lastTab='Advanced';
		showMediaCacheSource('${sourceName}');
		return;
	}
	lastTab='Advanced';
	createCookie("lastTab",lastTab);
	$('#TabBasic').hide();
	$('#TabEditBasic').hide();
	$('#TabAdv').show();
	$('#TabEditAdv').show();
	$('#TabSources').hide();
	$('#TabEditSources').hide();
	$('#Basic').removeClass();
	$('#Advanced').addClass('active');	
}



</script>






