<%@ include file="/WEB-INF/jsp/taglibs.jsp" %>

<h4>About Wowza Transcoder</h4>
<p>Wowza Transcoder provides the ability to ingest a live stream, decode the video and audio, and then re-encode the stream to suit desired playback devices. Transcoder is a real-time video transcoding and transrating solution. It can decode and re-encode audio and video in multiple formats with aligned keyframes for adaptive bitrate delivery over any protocol supported by Wowza Streaming Engine. For more information, see our documentation on how to <a href="https://www.wowza.com/docs/wowza-transcoder" target="_blank"><i class="fa fa-external-link"></i>&nbsp;Use Wowza Transcoder</a>.</p>

<blockquote><strong>Note:</strong> If you purchased a license for Wowza media server software before January&nbsp;1,&nbsp;2015, contact <a href="mailto:sales@wowza.com">sales@wowza.com</a> to learn more about how to license Wowza Transcoder.</blockquote>

<h5>Transcoder Templates</h5>
<p>Transcoder templates enable you to customize the video and audio encoding parameters to target multiple playback devices. You can apply different encoding settings to an application or stream using one or more templates. The following default templates are included:</p>
<ul>
	<li><strong>Audio Only</strong>. Used to ingest an H.264 video/Speex audio source stream from Adobe Flash Player. The Speex audio format is converted to AAC to make the stream compatible with additional player technologies.

	<li><strong>Transcode</strong>. Used to ingest a source stream that isn't encoded with H.264 video and/or AAC or MP3 audio. The transcoded output has multiple bitrates, each encoded with H.264 video and AAC or MP3 audio, that are keyframe-aligned for adaptive streaming.

	<li><strong>Transcode H.265</strong>. Used to transcode source streams into H.265 video and AAC audio. The transcoded output has multiple bitrates that are keyframe-aligned for adaptive streaming.

	<li><strong>Transrate</strong>. Used to ingest a source stream that's encoded with H.264 video and AAC or MP3 audio. The transrated output has multiple bitrates that are keyframe-aligned for adaptive streaming. The highest output bitrate is the original source stream.
</ul>

<p>To create a new template based on another template's settings, click <strong>Copy Template</strong>, select a template to copy in the <strong>Copy Transcoder Template</strong> dialog box, and give it a new name. To create a new template that has no defined settings, click <strong>Add Template</strong> and specify the name of the new template in the <strong>Add Transcoder Template</strong> dialog box. The template name value must be unique and can't contain less-than (&lt;), greater-than (&gt;), colon (&#58;), quotation (&#39; and &quot;), forward slash (&#47;), backslash (&#92;), pipe (&#124;), question mark (&#63;), asterisk (&#42;), double-dot (..), tilde (&#126;), and comma (&#44;) characters.</p>

<p>To change the encoding parameters in a template, click the template name in the list.</p>

<p>To delete a template, click the <strong>Delete</strong> icon for the template. The default templates can't be deleted.</p>

<h5>Configuring Transcoder</h5>
<p>To configure Transcoder for your live application, click <strong>Edit</strong> and do the following:</p>
<ol>
	<li>The default <strong>Template Directory</strong> stores transcoder templates that are available to the server and all live applications. To specify that a custom transcoder template is only available to this application, store it in an application-specific directory by changing the <strong>Template Directory</strong> path value. The directory path value can't contain less-than (&lt;), greater-than (&gt;), quotation (&#39; and &quot;), backslash (&#92;), pipe (&#124;), question mark (&#63;), and asterisk (&#42;) characters.

	<li>Configure the default transcoder templates or add and configure a custom transcoder template. You can ensure that an incoming stream is processed by a specific template by creating a template with the same name as the stream name. The default transcoder templates are only available if the default <strong>Template Directory</strong> is used.

	<li>To specify that the incoming stream name always be processed by your custom transcoder template with the same name, select <strong>Match incoming stream name to template name</strong>. When this option is selected, the incoming stream name is processed by your transcoder template with the same name if it exists. If the incoming stream name and template name differ or if the template doesn't exist, then the template that's selected in the <strong>Fallback Template</strong> list is used instead.

	<li>To specify that the incoming stream name always be processed by a specific transcoder template, clear <strong>Match incoming stream name to template name</strong>, and then select the template that you want to use in the <strong>Fallback Template</strong> list.

	<li>Click <strong>Save</strong> and then click <strong>Enable Transcoder</strong>.
<ol>
