#!/bin/bash

# NOTE: Here you can configure the JVM's built in JMX interface.
# See the "Server Management Console and Monitoring" chapter
# of the "User's Guide" for more information on how to configure the
# remote JMX interface in the [install-dir]/conf/Server.xml file.

CloudPlatformFlag=0


if [ -d /Library/WowzaStreamingEngine ]
then
	# OS X
	. /Library/WowzaStreamingEngine/manager/bin/setmgrenv.sh
	
else
	# Linux
	. /usr/local/WowzaStreamingEngine/manager/bin/setmgrenv.sh
	
	ulimit -n 20000

fi

JMXOPTIONS=-Dcom.sun.management.jmxremote=true
#JMXOPTIONS="$JMXOPTIONs
#JMXOPTIONS="$JMXOPTIONS -Dcom.sun.management.jmxremote.authenticate=true"
#JMXOPTIONS="$JMXOPTIONS -Dcom.sun.management.jmxremote.ssl=false"
#JMXOPTIONS="$JMXOPTIONS -Dcom.sun.management.jmxremote.password.file=$WMSCONFIG_HOME/conf/jmxremote.password"
#JMXOPTIONS="$JMXOPTIONS -Dcom.sun.management.jmxremote.access.file=$WMSCONFIG_HOME/conf/jmxremote.access"
#JMXOPTIONS="$JMXOPTIONS -Djava.rmi.server.hostname=192.168.1.7"
BACKGRND=" > /dev/null"
RUNCMD="`which nohup` "
if [ "$WMSMGRCOMMAND" != "start" ]; then
        JMXOPTIONS=""
fi

if [[ $PWD = / ]]; then
        cd $WMSMGR_HOME
fi

rc=0

CLASSPATH=""

CLASSPATH="$CLASSPATH:$WMSMGR_HOME/lib/lib-jaxb/FastInfoset-1.2.13.jar"
CLASSPATH="$CLASSPATH:$WMSMGR_HOME/lib/lib-jaxb/istack-commons-runtime-3.0.5.jar"
CLASSPATH="$CLASSPATH:$WMSMGR_HOME/lib/lib-jaxb/jaxb-api-2.3.0.jar"
CLASSPATH="$CLASSPATH:$WMSMGR_HOME/lib/lib-jaxb/jaxb-core-2.3.0.jar"
CLASSPATH="$CLASSPATH:$WMSMGR_HOME/lib/lib-jaxb/jaxb-runtime-2.3.0.jar"
CLASSPATH="$CLASSPATH:$WMSMGR_HOME/lib/lib-jaxb/stax-ex-1.7.8.jar"
CLASSPATH="$CLASSPATH:$WMSMGR_HOME/lib/lib-jaxb/txw2-2.3.0.jar"

CLASSPATH="$CLASSPATH:$WMSMGR_HOME/lib/lib-tomcat/classmate-1.3.4.jar"
CLASSPATH="$CLASSPATH:$WMSMGR_HOME/lib/lib-tomcat/ecj-4.6.1.jar"
CLASSPATH="$CLASSPATH:$WMSMGR_HOME/lib/lib-tomcat/hibernate-validator-6.0.17.Final.jar"
CLASSPATH="$CLASSPATH:$WMSMGR_HOME/lib/lib-tomcat/jackson-annotations-2.10.0.jar"
CLASSPATH="$CLASSPATH:$WMSMGR_HOME/lib/lib-tomcat/jackson-core-2.10.0.jar"
CLASSPATH="$CLASSPATH:$WMSMGR_HOME/lib/lib-tomcat/jackson-databind-2.10.0.jar"
CLASSPATH="$CLASSPATH:$WMSMGR_HOME/lib/lib-tomcat/jackson-datatype-jdk8-2.10.0.jar"
CLASSPATH="$CLASSPATH:$WMSMGR_HOME/lib/lib-tomcat/jackson-datatype-jsr310-2.10.0.jar"
CLASSPATH="$CLASSPATH:$WMSMGR_HOME/lib/lib-tomcat/jackson-module-parameter-names-2.10.0.jar"
CLASSPATH="$CLASSPATH:$WMSMGR_HOME/lib/lib-tomcat/javax.annotation-api-1.3.2.jar"
CLASSPATH="$CLASSPATH:$WMSMGR_HOME/lib/lib-tomcat/jboss-logging-3.3.2.Final.jar"
CLASSPATH="$CLASSPATH:$WMSMGR_HOME/lib/lib-tomcat/jstl-1.2.jar"
CLASSPATH="$CLASSPATH:$WMSMGR_HOME/lib/lib-tomcat/jul-to-slf4j-1.7.26.jar"
CLASSPATH="$CLASSPATH:$WMSMGR_HOME/lib/lib-tomcat/log4j-api-2.11.2.jar"
CLASSPATH="$CLASSPATH:$WMSMGR_HOME/lib/lib-tomcat/log4j-to-slf4j-2.11.2.jar"
CLASSPATH="$CLASSPATH:$WMSMGR_HOME/lib/lib-tomcat/logback-classic-1.2.3.jar"
CLASSPATH="$CLASSPATH:$WMSMGR_HOME/lib/lib-tomcat/logback-core-1.2.3.jar"
CLASSPATH="$CLASSPATH:$WMSMGR_HOME/lib/lib-tomcat/slf4j-api-1.7.25.jar"
CLASSPATH="$CLASSPATH:$WMSMGR_HOME/lib/lib-tomcat/snakeyaml-1.23.jar"
CLASSPATH="$CLASSPATH:$WMSMGR_HOME/lib/lib-tomcat/spring-aop-5.1.9.RELEASE.jar"
CLASSPATH="$CLASSPATH:$WMSMGR_HOME/lib/lib-tomcat/spring-beans-5.1.9.RELEASE.jar"
CLASSPATH="$CLASSPATH:$WMSMGR_HOME/lib/lib-tomcat/spring-boot-2.1.7.RELEASE.jar"
CLASSPATH="$CLASSPATH:$WMSMGR_HOME/lib/lib-tomcat/spring-boot-autoconfigure-2.1.7.RELEASE.jar"
CLASSPATH="$CLASSPATH:$WMSMGR_HOME/lib/lib-tomcat/spring-boot-starter-2.1.7.RELEASE.jar"
CLASSPATH="$CLASSPATH:$WMSMGR_HOME/lib/lib-tomcat/spring-boot-starter-json-2.1.7.RELEASE.jar"
CLASSPATH="$CLASSPATH:$WMSMGR_HOME/lib/lib-tomcat/spring-boot-starter-logging-2.1.7.RELEASE.jar"
CLASSPATH="$CLASSPATH:$WMSMGR_HOME/lib/lib-tomcat/spring-boot-starter-tomcat-2.1.7.RELEASE.jar"
CLASSPATH="$CLASSPATH:$WMSMGR_HOME/lib/lib-tomcat/spring-boot-starter-web-2.1.7.RELEASE.jar"
CLASSPATH="$CLASSPATH:$WMSMGR_HOME/lib/lib-tomcat/spring-context-5.1.9.RELEASE.jar"
CLASSPATH="$CLASSPATH:$WMSMGR_HOME/lib/lib-tomcat/spring-core-5.1.9.RELEASE.jar"
CLASSPATH="$CLASSPATH:$WMSMGR_HOME/lib/lib-tomcat/spring-expression-5.1.9.RELEASE.jar"
CLASSPATH="$CLASSPATH:$WMSMGR_HOME/lib/lib-tomcat/spring-jcl-5.1.9.RELEASE.jar"
CLASSPATH="$CLASSPATH:$WMSMGR_HOME/lib/lib-tomcat/spring-web-5.1.9.RELEASE.jar"
CLASSPATH="$CLASSPATH:$WMSMGR_HOME/lib/lib-tomcat/spring-webmvc-5.1.9.RELEASE.jar"
CLASSPATH="$CLASSPATH:$WMSMGR_HOME/lib/lib-tomcat/tomcat-embed-core-9.0.22.jar"
CLASSPATH="$CLASSPATH:$WMSMGR_HOME/lib/lib-tomcat/tomcat-embed-el-9.0.22.jar"
CLASSPATH="$CLASSPATH:$WMSMGR_HOME/lib/lib-tomcat/tomcat-embed-jasper-9.0.22.jar"
CLASSPATH="$CLASSPATH:$WMSMGR_HOME/lib/lib-tomcat/tomcat-embed-websocket-9.0.22.jar"
CLASSPATH="$CLASSPATH:$WMSMGR_HOME/lib/lib-tomcat/validation-api-2.0.1.Final.jar"

CLASSPATH="$CLASSPATH:$WMSMGR_HOME/lib/lib/bcprov-jdk15on-160.jar"
CLASSPATH="$CLASSPATH:$WMSMGR_HOME/lib/lib/servlet-api-2.5.jar"
CLASSPATH="$CLASSPATH:$WMSMGR_HOME/lib/lib/wowza-extras-log4j-1.2.17.jar"

CLASSPATH="$CLASSPATH:$WMSMGR_HOME/lib/wms-tomcat-9.0.22.jar"

WMSLOGGING_PROPERTIES=$WMSMGR_HOME/conf/tomcat-log4j.properties

JAVA_SYSTEM_PROPERTIES="\
	-Djava.security.egd=file:/dev/./urandom \
	-Dcom.wowza.wms.ConfigURL=\"\" \
	-Dcom.wowza.wms.ConfigHome=$WMSMGR_HOME \
	-Djava.io.tmpdir=$WMSMGR_HOME/temp \
	-Djava.net.preferIPv4Stack=true \
	-Djava.util.logging.manager=org.apache.juli.ClassLoaderLogManager \
	-Djava.util.logging.config.file=$WMSLOGGING_PROPERTIES"

if [[ 1 == $CloudPlatformFlag ]]; then
	JAVA_SYSTEM_PROPERTIES="$JAVA_SYSTEM_PROPERTIES -Dfile.encoding=UTF-8"
	CMD="$_EXECJAVA -cp $CLASSPATH $JAVA_SYSTEM_PROPERTIES launch.Main --prefix=/enginemanager --defaultWebApp=/enginemanager --tempDirectory=$WMSMGR_HOME/temp  --webroot=$WMSMGR_HOME/temp --warfile=$WMSMGR_HOME/lib/WMSManager.war --httpPort=8088 --ajp13Port=-1 --directoryListings=false"
else
	CMD="$_EXECJAVA -cp $CLASSPATH $JAVA_SYSTEM_PROPERTIES launch.Main --prefix=/enginemanager --defaultWebApp=/enginemanager --tempDirectory=$WMSMGR_HOME/temp  --webroot=$WMSMGR_HOME/temp --warfile=$WMSMGR_HOME/lib/WMSManager.war --httpPort=8088 --config=$WMSMGR_HOME/conf/tomcat.properties --ajp13Port=-1 --directoryListings=false"
fi
	if [ "$WMSMGRCOMMAND" = "start" ]; then
	   $RUNCMD $CMD $BACKGRND &
	else
  	   $CMD
	fi
PID=$!
rc=$?

if ! [ -d /Library/WowzaStreamingEngine ]
then
	# Linux
	if [ "$WMSMGRCOMMAND" = "start" ]; then
		echo $! > ${WMSMGRPID_FILE}
		wait $PID
	fi
	if [ "$WMSMGRCOMMAND" = "start" ] ; then
		WMSMGRBASE_NAME=WowzaStreamingEngineManager
		WMSMGRLOCK_FILE="/var/run/$WMSMGRBASE_NAME"
		if test -w "/var/lock/subsys" ; then
	        	WMSMGRLOCK_FILE="/var/lock/subsys/$WMSMGRBASE_NAME"
		fi
		echo $WMSMGRLOCK_FILE > /tmp/enc.txt
		rm -f $WMSMGRLOCK_FILE
	fi
	serviceName=$WowzaMGRVersion
#	service $serviceName stop >/dev/null
fi
#done
exit 0
