#!/bin/bash

ROOTUID="0"

if [ "$(id -u)" -ne "$ROOTUID" ] ; then
    echo "This script must be executed with root privileges."
    exit 1
fi

# Set up the symbolic links for the new services
ln -fs /usr/local/WowzaStreamingEngine/bin/WowzaStreamingEngine /etc/init.d/WowzaStreamingEngine
ln -fs /usr/local/WowzaStreamingEngine/manager/bin/WowzaStreamingEngineManager /etc/init.d/WowzaStreamingEngineManager
ln -fs /usr/local/WowzaStreamingEngine/bin/WowzaStreamingEngined /usr/bin/WowzaStreamingEngined
ln -fs /usr/local/WowzaStreamingEngine/manager/bin/WowzaStreamingEngineManagerd /usr/bin/WowzaStreamingEngineManagerd

# ask about autostart only if we can find an API for it
# the script currently supports chkconfig and update-rc.d
if [ -a "/usr/sbin/update-rc.d" ] ; then
	AUTOSTARTCMD=update-rc.d
elif [ -a "/sbin/chkconfig" ] ; then
	AUTOSTARTCMD=chkconfig
else
	AUTOSTARTCMD=
fi

if [ -n "$AUTOSTARTCMD" ] ; then
	STARTSERVICES=
	while [ -z "$STARTSERVICES" ]; do
		echo
		echo "Start Wowza Streaming Engine automatically when this system reboots? [yes or no] "
		read reply leftover
		case $reply in
			[yY] | [yY][eE][sS])
				if [ "$AUTOSTARTCMD" = "update-rc.d" ] ; then
					update-rc.d WowzaStreamingEngine defaults
					update-rc.d WowzaStreamingEngineManager defaults
				else
					/sbin/chkconfig --add WowzaStreamingEngine
					/sbin/chkconfig WowzaStreamingEngine on
					/sbin/chkconfig --add WowzaStreamingEngineManager
					/sbin/chkconfig WowzaStreamingEngineManager on
				fi

				# start the services
				echo "Starting WowzaStreamingEngine (via systemctl):"
				service WowzaStreamingEngine --full-restart
				echo "Starting WowzaStreamingEngine (via systemctl):"
				service WowzaStreamingEngineManager --full-restart
				STARTSERVICES=1
			;;
			[nN] | [nN][oO])
				echo -e "To start the Wowza Streaming Engine manually:\n"
				echo -e "cd /usr/local/WowzaStreamingEngine/bin\n  ./startup.sh\n"
				echo -e "cd /usr/local/WowzaStreamingEngine/manager/bin\n  ./startmgr.sh\n"
				STARTSERVICES=0
			;;
		esac
	done
fi
