<?php
ini_set("memory_limit", "256M");
ini_set("max_execution_time", 3600);
ini_set("date.timezone","America/Sao_Paulo");

require_once("/home/painel/public_html/admin/inc/conecta.php");
require_once("/home/painel/public_html/admin/inc/funcoes.php");
require_once("/home/painel/public_html/admin/inc/classe.ssh.php");

parse_str($argv[1],$opcoes);

list($inicial,$final) = explode("-",$opcoes["registros"]);

echo "[".date("d/m/Y H:i:s")."] Processo Iniciado.\n";

$hora_atual_servidor = date("H:i");

/////////////////////////////////
// Finalizao de Agendamentos //
/////////////////////////////////

$query_finalizacao = mysqli_query($conexao,"SELECT * FROM relay_agendamentos WHERE conectado = 'sim' AND finalizacao <= NOW() ORDER by codigo ASC");
while ($dados_agendamento_finalizar = mysqli_fetch_array($query_finalizacao)) {

$dados_stm = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM streamings where codigo = '".$dados_agendamento_finalizar["codigo_stm"]."'"));
$dados_servidor = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM servidores where codigo = '".$dados_stm["codigo_servidor"]."'"));

// Conexo SSH
$ssh = new SSH();
$ssh->conectar($dados_servidor["ip"],$dados_servidor["porta_ssh"]);
$ssh->autenticar("root",code_decode($dados_servidor["senha"],"D"));

// Envia comando de iniciar relay
$ssh->executar('(echo gerenciar_relay.stop;echo quit;echo quit) | curl telnet://localhost:'.$dados_stm["porta_telnet"].'');

echo "[Finalizacao][".$dados_stm["porta"]."][".date("d/m/Y H:i:s")."] Finalizando relay ".$dados_agendamento_finalizar["servidor"]."\n";

// Atualiza o status para conectado
mysqli_query($conexao,"Update relay_agendamentos set conectado = 'nao' where codigo = '".$dados_agendamento_finalizar["codigo"]."'");

// Loga a ao executada
mysqli_query($conexao,"INSERT INTO relay_agendamentos_logs (codigo_agendamento,codigo_stm,data,status) VALUES ('".$dados_agendamento_finalizar["codigo"]."','".$dados_stm["codigo"]."',NOW(),'Relay finalizado com sucesso.')");

}

echo "\n\n";

$query1 = mysqli_query($conexao,"SELECT * FROM relay_agendamentos ORDER by codigo ASC LIMIT ".$inicial.", ".$final."");
while ($dados_agendamento = mysqli_fetch_array($query1)) {

$dados_stm = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM streamings where codigo = '".$dados_agendamento["codigo_stm"]."'"));

$timezone = (empty($dados_stm["timezone"]) || strlen($dados_stm["timezone"]) < 4) ? "America/Sao_Paulo" : $dados_stm["timezone"];

$hora_inicio = sprintf("%02d",$dados_agendamento["hora"]).":".sprintf("%02d",$dados_agendamento["minuto"]);
$hora_atual = formatar_data("H:i", $hora_atual_servidor, $timezone);
$data_atual = date("Y-m-d");

@$duracao_minutos = ($dados_agendamento["duracao_hora"]*60)+$dados_agendamento["duracao_minuto"];

$horario_finalizacao = date('Y-m-d H:i:s',strtotime('+'.$duracao_minutos.' minutes ',strtotime(date("Y-m-d H:i:s"))));

if($dados_stm["status"] == 1) {

$dados_servidor = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM servidores where codigo = '".$dados_stm["codigo_servidor"]."'"));

if($dados_servidor["status"] == "on") {

//////////////////////////////////////////////////////////////
//// Frequncia 1 -> Executar em data especfica(uma vez) ////
//////////////////////////////////////////////////////////////

if($dados_agendamento["frequencia"] == 1) {

// Verifica se a data especfica  hoje e se esta na hora de iniciar
if($dados_agendamento["data"] == $data_atual && $hora_inicio == $hora_atual) {

// Verifica se o relay esta online
//$dados_servidor_relay = parse_url($dados_agendamento["servidor"]);
//$resultado_status_servidor_relay = @fsockopen($dados_servidor_relay['host'], $dados_servidor_relay['port'], $errno, $errstr, 2);

$resultado_status_servidor_relay = true;

if($resultado_status_servidor_relay) {

// Conexo SSH
$ssh = new SSH();
$ssh->conectar($dados_servidor["ip"],$dados_servidor["porta_ssh"]);
$ssh->autenticar("root",code_decode($dados_servidor["senha"],"D"));

// Atualiza o status para conectado
mysqli_query($conexao,"Update relay_agendamentos set conectado = 'sim', finalizacao = '".$horario_finalizacao."' where codigo = '".$dados_agendamento["codigo"]."'");

// Envia comando de iniciar relay
$ssh->executar('(echo gerenciar_relay.stop;echo quit;echo quit) | curl telnet://localhost:'.$dados_stm["porta_telnet"].'');
$ssh->executar('(echo gerenciar_relay.url '.$dados_agendamento["servidor"].';echo quit;echo quit) | curl telnet://localhost:'.$dados_stm["porta_telnet"].'');
$ssh->executar('(echo gerenciar_relay.start;echo quit;echo quit) | curl telnet://localhost:'.$dados_stm["porta_telnet"].'');
$resultado = $ssh->executar('(echo gerenciar_relay.status;echo quit;echo quit) | curl telnet://localhost:'.$dados_stm["porta_telnet"].'');

if(preg_match('/connected/i',$resultado) || preg_match('/polling/i',$resultado)) {

$log = "Relay iniciado com sucesso.";

echo "[0x01][".$dados_stm["porta"]."][".$dados_agendamento["frequencia"]."][".date_default_timezone_get()."][".$timezone."][".$hora_atual_servidor."][".$hora_inicio."] Iniciando relay ".$dados_agendamento["servidor"]." em ".$dados_agendamento["data"]." as ".$hora_inicio."\n";

} else {

sleep(5);

// Segunda tentativa

// Envia comando de iniciar relay
$ssh->executar('(echo gerenciar_relay.stop;sleep 1;echo gerenciar_relay.url '.$dados_agendamento["servidor"].';sleep 1;echo gerenciar_relay.start;echo quit) | netcat localhost '.$dados_stm["porta_telnet"].'');
$resultado = $ssh->executar('(echo gerenciar_relay.status;echo quit) | netcat localhost '.$dados_stm["porta_telnet"].'');

if(preg_match('/connected/i',$resultado) || preg_match('/polling/i',$resultado)) {

$log = "Relay iniciado com sucesso.";

echo "[0x01][".$dados_stm["porta"]."][".$dados_agendamento["frequencia"]."][".date_default_timezone_get()."][".$timezone."][".$hora_atual_servidor."][".$hora_inicio."] Iniciando relay ".$dados_agendamento["servidor"]." em ".$dados_agendamento["data"]." as ".$hora_inicio." na segunda tentativa.\n";

} else {

$log = "Falha ao iniciar relay. Log: ".$resultado;

echo "[0x01][".$dados_stm["porta"]."][".$dados_agendamento["frequencia"]."][".date_default_timezone_get()."][".$timezone."][".$hora_atual_servidor."][".$hora_inicio."] Erro ao iniciar relay ".$dados_agendamento["servidor"]." -> ".$resultado."\n";

// Atualiza o status para desconectado
mysqli_query($conexao,"Update relay_agendamentos set conectado = 'nao' where codigo = '".$dados_agendamento["codigo"]."'");

}

}

} else {  // FIM -> status relay

$log = "Falha ao iniciar relay, servidor remoto OFFLINE.";

echo "[0x01][".$dados_stm["porta"]."][".$dados_agendamento["frequencia"]."][".date_default_timezone_get()."][".$timezone."][".$hora_atual_servidor."][".$hora_inicio."] Erro ao iniciar relay ".$dados_agendamento["servidor"]." -> OFFLINE\n";

}

// Loga a ao executada
mysqli_query($conexao,"INSERT INTO relay_agendamentos_logs (codigo_agendamento,codigo_stm,data,status) VALUES ('".$dados_agendamento["codigo"]."','".$dados_stm["codigo"]."',NOW(),'".$log."')");

// Remove o agendamento
mysqli_query($conexao,"Delete From playlists_agendamentos where codigo = '".$dados_agendamento["codigo"]."'");

} // FIM -> Verifica se esta na hora de iniciar / Frequncia 1

} elseif($dados_agendamento["frequencia"] == 2) { // Else -> frequencia 2

//////////////////////////////////////////////
//// Frequncia 2 -> Executar Diariamente ////
//////////////////////////////////////////////

// Verifica se esta na hora de iniciar
if($hora_inicio == $hora_atual) { 

// Verifica se o relay esta online
//$dados_servidor_relay = parse_url($dados_agendamento["servidor"]);
//$resultado_status_servidor_relay = @fsockopen($dados_servidor_relay['host'], $dados_servidor_relay['port'], $errno, $errstr, 2);

$resultado_status_servidor_relay = true;

if($resultado_status_servidor_relay) {

// Conexo SSH
$ssh = new SSH();
$ssh->conectar($dados_servidor["ip"],$dados_servidor["porta_ssh"]);
$ssh->autenticar("root",code_decode($dados_servidor["senha"],"D"));

// Atualiza o status para conectado
mysqli_query($conexao,"Update relay_agendamentos set conectado = 'sim', finalizacao = '".$horario_finalizacao."' where codigo = '".$dados_agendamento["codigo"]."'");

// Envia comando de iniciar relay
$ssh->executar('(echo gerenciar_relay.stop;echo quit;echo quit) | curl telnet://localhost:'.$dados_stm["porta_telnet"].'');
$ssh->executar('(echo gerenciar_relay.url '.$dados_agendamento["servidor"].';echo quit;echo quit) | curl telnet://localhost:'.$dados_stm["porta_telnet"].'');
$ssh->executar('(echo gerenciar_relay.start;echo quit;echo quit) | curl telnet://localhost:'.$dados_stm["porta_telnet"].'');
$resultado = $ssh->executar('(echo gerenciar_relay.status;echo quit;echo quit) | curl telnet://localhost:'.$dados_stm["porta_telnet"].'');

if(preg_match('/connected/i',$resultado) || preg_match('/polling/i',$resultado)) {

$log = "Relay iniciado com sucesso.";

echo "[0x02][".$dados_stm["porta"]."][".$dados_agendamento["frequencia"]."][".date_default_timezone_get()."][".$timezone."][".$hora_atual_servidor."][".$hora_inicio."] Iniciando relay ".$dados_agendamento["servidor"]." em ".$hora_inicio."\n";

} else {

sleep(5);

// Segunda tentativa

// Envia comando de iniciar relay
$ssh->executar('(echo gerenciar_relay.stop;sleep 1;echo gerenciar_relay.url '.$dados_agendamento["servidor"].';sleep 1;echo gerenciar_relay.start;echo quit) | netcat localhost '.$dados_stm["porta_telnet"].'');
$resultado = $ssh->executar('(echo gerenciar_relay.status;echo quit) | netcat localhost '.$dados_stm["porta_telnet"].'');

if(preg_match('/connected/i',$resultado) || preg_match('/polling/i',$resultado)) {

$log = "Relay iniciado com sucesso.";

echo "[0x02][".$dados_stm["porta"]."][".$dados_agendamento["frequencia"]."][".date_default_timezone_get()."][".$timezone."][".$hora_atual_servidor."][".$hora_inicio."] Iniciando relay ".$dados_agendamento["servidor"]." em ".$hora_inicio." na segunda tentativa.\n";

} else {

$log = "Falha ao iniciar relay. Log: ".$resultado;

echo "[0x02][".$dados_stm["porta"]."][".$dados_agendamento["frequencia"]."][".date_default_timezone_get()."][".$timezone."][".$hora_atual_servidor."][".$hora_inicio."] Erro ao iniciar relay ".$dados_agendamento["servidor"]." -> ".$resultado."\n";

// Atualiza o status para desconectado
mysqli_query($conexao,"Update relay_agendamentos set conectado = 'nao' where codigo = '".$dados_agendamento["codigo"]."'");

}

}

} else {  // FIM -> status relay

$log = "Falha ao iniciar relay, servidor remoto OFFLINE.";

echo "[0x02][".$dados_stm["porta"]."][".$dados_agendamento["frequencia"]."][".date_default_timezone_get()."][".$timezone."][".$hora_atual_servidor."][".$hora_inicio."] Erro ao iniciar relay ".$dados_agendamento["servidor"]." -> OFFLINE\n";

}

// Loga a ao executada
mysqli_query($conexao,"INSERT INTO relay_agendamentos_logs (codigo_agendamento,codigo_stm,data,status) VALUES ('".$dados_agendamento["codigo"]."','".$dados_stm["codigo"]."',NOW(),'".$log."')");

} // FIM -> Verifica se esta na hora de iniciar


} else { // Else -> frequencia 3

///////////////////////////////////////////////
/// Frequncia 3 -> Executar Dias da Semana ///
///////////////////////////////////////////////

$dia_semana = date("N");
$array_dias = explode(",",rtrim($dados_agendamento["dias"], ','));

// Verifica se esta na hora de iniciar
if(in_array($dia_semana, $array_dias) === true && $hora_inicio == $hora_atual) { 

// Verifica se o relay esta online
//$dados_servidor_relay = parse_url($dados_agendamento["servidor"]);
//$resultado_status_servidor_relay = @fsockopen($dados_servidor_relay['host'], $dados_servidor_relay['port'], $errno, $errstr, 2);

$resultado_status_servidor_relay = true;

if($resultado_status_servidor_relay) {

// Conexo SSH
$ssh = new SSH();
$ssh->conectar($dados_servidor["ip"],$dados_servidor["porta_ssh"]);
$ssh->autenticar("root",code_decode($dados_servidor["senha"],"D"));

// Atualiza o status para conectado
mysqli_query($conexao,"Update relay_agendamentos set conectado = 'sim', finalizacao = '".$horario_finalizacao."' where codigo = '".$dados_agendamento["codigo"]."'");

// Envia comando de iniciar relay
$ssh->executar('(echo gerenciar_relay.stop;echo quit;echo quit) | curl telnet://localhost:'.$dados_stm["porta_telnet"].'');
$ssh->executar('(echo gerenciar_relay.url '.$dados_agendamento["servidor"].';echo quit;echo quit) | curl telnet://localhost:'.$dados_stm["porta_telnet"].'');
$ssh->executar('(echo gerenciar_relay.start;echo quit;echo quit) | curl telnet://localhost:'.$dados_stm["porta_telnet"].'');
$resultado = $ssh->executar('(echo gerenciar_relay.status;echo quit;echo quit) | curl telnet://localhost:'.$dados_stm["porta_telnet"].'');

if(preg_match('/connected/i',$resultado) || preg_match('/polling/i',$resultado)) {

$log = "Relay iniciado com sucesso.";

echo "[0x03][".$dados_stm["porta"]."][".$dados_agendamento["frequencia"]."][".date_default_timezone_get()."][".$timezone."][".$hora_atual_servidor."][".$hora_inicio."] Iniciando relay ".$dados_agendamento["servidor"]." em ".$hora_inicio."\n";

} else {

sleep(5);

// Segunda tentativa

// Envia comando de iniciar relay
$ssh->executar('(echo gerenciar_relay.stop;sleep 1;echo gerenciar_relay.url '.$dados_agendamento["servidor"].';sleep 1;echo gerenciar_relay.start;echo quit) | netcat localhost '.$dados_stm["porta_telnet"].'');
$resultado = $ssh->executar('(echo gerenciar_relay.status;echo quit) | netcat localhost '.$dados_stm["porta_telnet"].'');

if(preg_match('/connected/i',$resultado) || preg_match('/polling/i',$resultado)) {

$log = "Relay iniciado com sucesso.";

echo "[0x03][".$dados_stm["porta"]."][".$dados_agendamento["frequencia"]."][".date_default_timezone_get()."][".$timezone."][".$hora_atual_servidor."][".$hora_inicio."] Iniciando relay ".$dados_agendamento["servidor"]." em ".$hora_inicio." na segunda tentativa.\n";

} else {

$log = "Falha ao iniciar relay. Log: ".$resultado;

echo "[0x03][".$dados_stm["porta"]."][".$dados_agendamento["frequencia"]."][".date_default_timezone_get()."][".$timezone."][".$hora_atual_servidor."][".$hora_inicio."] Erro ao iniciar relay ".$dados_agendamento["servidor"]." -> ".$resultado."\n";

// Atualiza o status para desconectado
mysqli_query($conexao,"Update relay_agendamentos set conectado = 'nao' where codigo = '".$dados_agendamento["codigo"]."'");

}

}

} else {  // FIM -> status relay

$log = "Falha ao iniciar relay, servidor remoto OFFLINE.";

echo "[0x03][".$dados_stm["porta"]."][".$dados_agendamento["frequencia"]."][".date_default_timezone_get()."][".$timezone."][".$hora_atual_servidor."][".$hora_inicio."] Erro ao iniciar relay ".$dados_agendamento["servidor"]." -> OFFLINE\n";

}

// Loga a ao executada
mysqli_query($conexao,"INSERT INTO relay_agendamentos_logs (codigo_agendamento,codigo_stm,data,status) VALUES ('".$dados_agendamento["codigo"]."','".$dados_stm["codigo"]."',NOW(),'".$log."')");

} // FIM -> Verifica se o dia da semana  o atual e se esta na hora de iniciar

} // FIM -> frequencia

} // FIM -> Verifica se o servidor esta ON/OFF

} // FIM -> Verifica se o streaming esta ON/OFF

} // FIM -> while


echo "[".date("d/m/Y H:i:s")."] Processo Concludo.\n";

?>