// $('#avisos').modal('show');
////////////////////////////////////////////////////////
/////////// Funes Gerenciamento Streaming ////////////
////////////////////////////////////////////////////////

// Funo para ligar o streaming
function ligar_streaming( porta ) {
	
  document.getElementById("local-status-acoes").innerHTML = '<div class="alert alert-info text-center" role="alert"><img src="/img/ajax-loader.gif" /></div>';
  $("#local-status-acoes").show();
  
  var http = new Ajax();
  http.open("GET", "/funcoes-ajax/ligar_streaming/"+porta , true);
  http.onreadystatechange = function() {
	
  if(http.readyState == 4) {
  
	resultado = http.responseText;

	document.getElementById("local-status-acoes").innerHTML = resultado;
	$("#local-status-acoes").delay(15000).fadeOut(300);
	status_streaming( porta );
	
  }
  
  }
  http.send(null);
  delete http;
}

// Funo para desligar o streaming
function desligar_streaming( porta ) {
	
  document.getElementById("local-status-acoes").innerHTML = '<div class="alert alert-info text-center" role="alert"><img src="/img/ajax-loader.gif" /></div>';
  $("#local-status-acoes").show();
  
  var http = new Ajax();
  http.open("GET", "/funcoes-ajax/desligar_streaming/"+porta , true);
  http.onreadystatechange = function() {
	
  if(http.readyState == 4) {
  
	resultado = http.responseText;
	
	document.getElementById("local-status-acoes").innerHTML = resultado;
	$("#local-status-acoes").delay(15000).fadeOut(300);	
	status_streaming( porta );
	
  }
  
  }
  http.send(null);
  delete http;
}

// Funo para checar o status do streaming e autodj
function status_streaming( porta ) {
  
  document.getElementById( 'status-streaming' ).innerHTML = "<i class='fa fa-refresh'></i>";
  document.getElementById( 'status-streaming' ).className = "btn btn-info";
	
  var http = new Ajax();
  http.open("GET", "/funcoes-ajax/status_streaming/"+porta , true);
  http.onreadystatechange = function() {
	
  if(http.readyState == 4) {
  
	resultado = http.responseText;
	
	dados = resultado.split("|");
	
	document.getElementById( 'status-streaming' ).innerHTML = dados[0];
	document.getElementById( 'status-streaming' ).className = "btn btn-"+dados[1];

  }
  
  }
  http.send(null);
  delete http;
}

// Funo para desconectar source do streaming(kick)
function kick_streaming( porta ) {
	
  document.getElementById("local-status-acoes").innerHTML = '<div class="alert alert-info text-center" role="alert"><img src="/img/ajax-loader.gif" /></div>';
  $("#local-status-acoes").show();
  
  var http = new Ajax();
  http.open("GET", "/funcoes-ajax/kick_streaming/"+porta , true);
  http.onreadystatechange = function() {
	
  if(http.readyState == 4) {
  
	resultado = http.responseText;
	
	document.getElementById("local-status-acoes").innerHTML = resultado;
	$("#local-status-acoes").delay(15000).fadeOut(300);	
	status_streaming( porta );
	
  }
  
  }
  http.send(null);
  delete http;
}

// Funo para ativar proteo contra ataques ao streaming
function ativar_desativar_protecao( porta ) {
	
  document.getElementById("local-status-acoes").innerHTML = '<div class="alert alert-info text-center" role="alert"><img src="/img/ajax-loader.gif" /></div>';
  $("#local-status-acoes").show();
  
  var http = new Ajax();
  http.open("GET", "/funcoes-ajax/ativar_desativar_protecao/"+porta , true);
  http.onreadystatechange = function() {
	
  if(http.readyState == 4) {
  
	resultado = http.responseText;

	document.getElementById("local-status-acoes").innerHTML = resultado;
	$("#local-status-acoes").delay(15000).fadeOut(300);
  }
  
  }
  http.send(null);
  delete http;
}

// Funo para exibir a msica atual tocando no streaming
function transmissao_atual() {
  
  document.getElementById("musica_atual").innerHTML = "<img src='/img/spinner.gif' />";
  document.getElementById("total_ouvintes").innerHTML = "<img src='/img/spinner.gif' />";
  
  var http = new Ajax();
  http.open("GET", "/funcoes-ajax/transmissao_atual" , true);
  http.onreadystatechange = function() {
	
  if(http.readyState == 4) {
  
	resultado = http.responseText;
	dados = resultado.split("|");
	
    document.getElementById("musica_atual").innerHTML = dados[0];
    document.getElementById("capa_artista").src = dados[2];
    document.getElementById("total_ouvintes").innerHTML = dados[3];
    document.getElementById("porcentagem_uso_ouvintes").style.width = dados[4]+"%";
	
  }
  
  }
  http.send(null);
  delete http;
}

// Funo para remover um ponto do multipoint
function remover_multipoint( codigo ) {
	
  document.getElementById("local-status-acoes").innerHTML = '<div class="alert alert-info text-center" role="alert"><img src="/img/ajax-loader.gif" /></div>';
  $("#local-status-acoes").show();
  
  var http = new Ajax();
  http.open("GET", "/funcoes-ajax/remover_multipoint/"+codigo , true);
  http.onreadystatechange = function() {
	
  if(http.readyState == 4) {
  
	resultado = http.responseText;
	
	document.getElementById("local-status-acoes").innerHTML = resultado;	
	$('#' + $.escapeSelector(codigo)).remove();
	$("#local-status-acoes").delay(15000).fadeOut(300);
	
  }
  
  }
  http.send(null);
  delete http;
}

// Funo para remover um pedido de musica
function remover_pedido_musical( codigo ) {
	
  document.getElementById("local-status-acoes").innerHTML = '<div class="alert alert-info text-center" role="alert"><img src="/img/ajax-loader.gif" /></div>';
  $("#local-status-acoes").show();
  
  var http = new Ajax();
  http.open("GET", "/funcoes-ajax/remover_pedido_musical/"+codigo , true);
  http.onreadystatechange = function() {
	
  if(http.readyState == 4) {
  
	resultado = http.responseText;
	
	document.getElementById("local-status-acoes").innerHTML = resultado;	
	$('#' + $.escapeSelector(codigo)).remove();
	$("#local-status-acoes").delay(15000).fadeOut(300);
	
  }
  
  }
  http.send(null);
  delete http;
}

// Funo para mudar a msica atual no shoutcast para um texto qualquer
function definir_nome_musica( porta, msg ) {
	
  document.getElementById("local-status-acoes").innerHTML = '<div class="alert alert-info text-center" role="alert"><img src="/img/ajax-loader.gif" /></div>';
  $("#local-status-acoes").show();
  
  var musica = prompt(msg);
  
  var http = new Ajax();
  http.open("GET", "/funcoes-ajax/definir_nome_musica/"+porta+"/"+musica , true);
  http.onreadystatechange = function() {
	
  if(http.readyState == 4) {
	  
	resultado = http.responseText;
  
	document.getElementById("local-status-acoes").innerHTML = resultado;
	$("#local-status-acoes").delay(15000).fadeOut(300);	
	
  }
  
  }
  http.send(null);
  delete http;
}

////////////////////////////////////////////////////////
///////////// Funes Gerenciamento AutoDJ /////////////
////////////////////////////////////////////////////////

// Funo para carregar lista de playlists do streaming
function carregar_opcoes_ligar_autodj( porta ) {
	
  document.getElementById("playlists-autodj-conteudo").innerHTML = '<img src="/img/ajax-loader.gif" />';
  $('#playlists-autodj').modal('show');
	
  var http = new Ajax();
  http.open("GET", "/funcoes-ajax/carregar_opcoes_ligar_autodj/"+porta , true);
  http.onreadystatechange = function() {
	
  if(http.readyState == 4) {
  
	resultado = http.responseText;
	
	document.getElementById("playlists-autodj-conteudo").innerHTML = resultado;
	
  }
  
  }
  http.send(null);
  delete http;
}

// Funo para ligar o autodj
function ligar_autodj( porta,playlist,shuffle,bitrate,xfade,samplerate,canal,encoder ) {
	
  document.getElementById("local-status-acoes").innerHTML = '<div class="alert alert-info text-center" role="alert"><img src="/img/ajax-loader.gif" /></div>';
  $('#playlists-autodj').modal('hide');
  $("#local-status-acoes").show();

  var http = new Ajax();
  http.open("GET", "/funcoes-ajax/ligar_autodj/"+porta+"/"+playlist+"/"+shuffle+"/"+bitrate+"/"+xfade+"/"+samplerate+"/"+canal+"/"+encoder+"" , true);
  http.onreadystatechange = function() {
	
  if(http.readyState == 4) {
  
	resultado = http.responseText;
	
	document.getElementById("local-status-acoes").innerHTML = resultado;
	$("#local-status-acoes").delay(15000).fadeOut(300);
	status_streaming( porta );
	
  }
  
  }
  http.send(null);
  delete http;
}

// Funo para recarregar playlist no autodj
function recarregar_playlist( porta ) {
	
  document.getElementById("local-status-acoes").innerHTML = '<div class="alert alert-info text-center" role="alert"><img src="/img/ajax-loader.gif" /></div>';
  $("#local-status-acoes").show();
  
  var http = new Ajax();
  http.open("GET", "/funcoes-ajax/recarregar_playlist/"+porta , true);
  http.onreadystatechange = function() {
	
  if(http.readyState == 4) {
  
	resultado = http.responseText;
	
	document.getElementById("local-status-acoes").innerHTML = resultado;
	$("#local-status-acoes").delay(15000).fadeOut(300);	
	
  }
  
  }
  http.send(null);
  delete http;
}

// Funo para trocar playlist no autodj sem reiniciar
function trocar_playlist( porta,acao,playlist ) {
	
  document.getElementById("playlists-autodj-conteudo").innerHTML = '<img src="/img/ajax-loader.gif" />';
  $('#playlists-autodj').modal('show');
	
  var http = new Ajax();
  http.open("GET", "/funcoes-ajax/trocar_playlist/"+porta+"/"+acao+"/"+playlist , true);
  http.onreadystatechange = function() {
	
  if(http.readyState == 4) {
  
	resultado = http.responseText;
	
	document.getElementById("playlists-autodj-conteudo").innerHTML = resultado;
	
  }
  
  }
  http.send(null);
  delete http;
}

// Funo para pular musica atual playlist no autodj
function pular_musica( porta ) {
	
  document.getElementById("local-status-acoes").innerHTML = '<div class="alert alert-info text-center" role="alert"><img src="/img/ajax-loader.gif" /></div>';
  $("#local-status-acoes").show();
  
  var http = new Ajax();
  http.open("GET", "/funcoes-ajax/pular_musica/"+porta , true);
  http.onreadystatechange = function() {
	
  if(http.readyState == 4) {
  
	resultado = http.responseText;
	
	document.getElementById("local-status-acoes").innerHTML = resultado;
	$("#local-status-acoes").delay(15000).fadeOut(300);	
	
  }
  
  }
  http.send(null);
  delete http;
}

// Funo para desligar o autodj
function desligar_autodj( porta ) {
  
  document.getElementById("local-status-acoes").innerHTML = '<div class="alert alert-info text-center" role="alert"><img src="/img/ajax-loader.gif" /></div>';
  $("#local-status-acoes").show();
  
  var http = new Ajax();
  http.open("GET", "/funcoes-ajax/desligar_autodj/"+porta , true);
  http.onreadystatechange = function() {
	
  if(http.readyState == 4) {
  
	resultado = http.responseText;
	
	document.getElementById("local-status-acoes").innerHTML = resultado;
	$("#local-status-acoes").delay(15000).fadeOut(300);	
	
  }
  
  }
  http.send(null);
  delete http;
}

// Funo para remover um DJ do AutoDJ
function remover_dj( codigo ) {
  
  document.getElementById("local-status-acoes").innerHTML = '<div class="alert alert-info text-center" role="alert"><img src="/img/ajax-loader.gif" /></div>';
  $("#local-status-acoes").show();
  
  var http = new Ajax();
  http.open("GET", "/funcoes-ajax/remover_dj/"+codigo , true);
  http.onreadystatechange = function() {
	
  if(http.readyState == 4) {
  
	resultado = http.responseText;
	
	document.getElementById("local-status-acoes").innerHTML = resultado;	
	$('#' + $.escapeSelector(codigo)).remove();
	$("#local-status-acoes").delay(15000).fadeOut(300);
	
  }
  
  }
  http.send(null);
  delete http;
}

// Funo para remover uma restrio de um DJ
function remover_dj_restricao( codigo ) {
  
  document.getElementById("local-status-acoes").innerHTML = '<div class="alert alert-info text-center" role="alert"><img src="/img/ajax-loader.gif" /></div>';
  $("#local-status-acoes").show();
	
  var http = new Ajax();
  http.open("GET", "/funcoes-ajax/remover_dj_restricao/"+codigo , true);
  http.onreadystatechange = function() {
	
  if(http.readyState == 4) {
  
	resultado = http.responseText;
	
	document.getElementById("local-status-acoes").innerHTML = resultado;	
	$('#' + $.escapeSelector(codigo)).remove();
	$("#local-status-acoes").delay(15000).fadeOut(300);
	
  }
  
  }
  http.send(null);
  delete http;
}

// Funo para diagnosticar erros no AutoDJ
function diagnosticar_autodj( porta ) {
  
  document.getElementById("local-status-acoes").innerHTML = '<div class="alert alert-info text-center" role="alert"><img src="/img/ajax-loader.gif" /></div>';
  $("#local-status-acoes").show();
  
  var http = new Ajax();
  http.open("GET", "/funcoes-ajax/diagnosticar_autodj/"+porta , true);
  http.onreadystatechange = function() {
	
  if(http.readyState == 4) {
  
	resultado = http.responseText;
	
	document.getElementById("local-status-acoes").innerHTML = resultado;
	$("#local-status-acoes").delay(15000).fadeOut(300);	
	
  }
  
  }
  http.send(null);
  delete http;
}

// Funo para remover um agendamento de playlist
function remover_agendamento( codigo ) {
  
  document.getElementById("local-status-acoes").innerHTML = '<div class="alert alert-info text-center" role="alert"><img src="/img/ajax-loader.gif" /></div>';
  $("#local-status-acoes").show();
  
  var http = new Ajax();
  http.open("GET", "/funcoes-ajax/remover_agendamento/"+codigo , true);
  http.onreadystatechange = function() {
	
  if(http.readyState == 4) {
  
	resultado = http.responseText;
	
	document.getElementById("local-status-acoes").innerHTML = resultado;
	$('#' + $.escapeSelector(codigo)).remove();
	$("#local-status-acoes").delay(15000).fadeOut(300);	
	
  }
  
  }
  http.send(null);
  delete http;
}

// Funo para remover um agendamento de relay
function remover_agendamento_relay( codigo ) {
  
  document.getElementById("local-status-acoes").innerHTML = '<div class="alert alert-info text-center" role="alert"><img src="/img/ajax-loader.gif" /></div>';
  $("#local-status-acoes").show();
  
  var http = new Ajax();
  http.open("GET", "/funcoes-ajax/remover_agendamento_relay/"+codigo , true);
  http.onreadystatechange = function() {
	
  if(http.readyState == 4) {
  
	resultado = http.responseText;
	
	document.getElementById("local-status-acoes").innerHTML = resultado;	
	$('#' + $.escapeSelector(codigo)).remove();
	$("#local-status-acoes").delay(15000).fadeOut(300);	
	
  }
  
  }
  http.send(null);
  delete http;
}

// Funo para desligar o streaming
function remover_app_android( codigo ) {
  
  document.getElementById("local-status-acoes").innerHTML = '<div class="alert alert-info text-center" role="alert"><img src="/img/ajax-loader.gif" /></div>';
  $("#local-status-acoes").show();
  
  var http = new Ajax();
  http.open("GET", "/funcoes-ajax/remover_app_android/"+codigo , true);
  http.onreadystatechange = function() {
	
  if(http.readyState == 4) {
  
	resultado = http.responseText;
	
	document.getElementById("local-status-acoes").innerHTML = resultado;
    setTimeout(function(){ window.location.reload(1);}, 3000);
	
  }
  
  }
  http.send(null);
  delete http;
}

////////////////////////////////////////////////////////
///////////// Funes Gerenciamento Painel /////////////
////////////////////////////////////////////////////////

// Funo para exibir avisos
function exibir_aviso( codigo ) {
	
  document.getElementById("avisos-conteudo").innerHTML = "<img src='/img/ajax-loader.gif' />";
  
  var http = new Ajax();
  http.open("GET", "/funcoes-ajax/exibir_aviso/"+codigo , true);
  http.onreadystatechange = function() {
	
  if(http.readyState == 4) {
  
	resultado = http.responseText;
	
	document.getElementById("avisos-conteudo").innerHTML = resultado;	
	
  }
  
  }
  http.send(null);
  delete http;
}

// Funo para marcar um aviso como vizualizado
function desativar_exibicao_aviso( codigo, area, codigo_usuario ) {
  
  var http = new Ajax();
  http.open("GET", "/funcoes-ajax/desativar_exibicao_aviso/"+codigo+"/"+area+"/"+codigo_usuario , true);
  http.send(null);
  delete http;
  
}

// Funo para sincronizar streaming no servidor AAC+
function sincronizar_aacplus( porta ) {
  
  document.getElementById("local-status-acoes").innerHTML = '<div class="alert alert-info text-center" role="alert"><img src="/img/ajax-loader.gif" /></div>';
  $("#local-status-acoes").show();

  var http = new Ajax();
  http.open("GET", "/funcoes-ajax/sincronizar_aacplus/"+porta , true);
  http.onreadystatechange = function() {
	
  if(http.readyState == 4) {
  
	resultado = http.responseText;

	document.getElementById("local-status-acoes").innerHTML = resultado;
	$("#local-status-acoes").delay(15000).fadeOut(300);	
	
  }
  
  }
  http.send(null);
  delete http;
}

// Funo para migrar msicas de um FTP remoto
function migrar_musicas_ftp_remoto( servidor_stm, porta_stm, servidor_ftp, usuario_ftp, senha_ftp ) {

  if(servidor_stm == "" || porta_stm == "" || servidor_ftp == "" || usuario_ftp == "" || senha_ftp == "") {
  alert("Erro! Tente novamente ou contate o suporte.");
  } else {
  
  document.getElementById("log_migracao").innerHTML = "<center><br><br><br><img src='/img/ajax-loader.gif' /><br><br><br></center>";
  
  var http = new Ajax();
  http.open("GET", "https://"+servidor_stm+":1443/migrar-musicas-ftp.php?porta="+porta_stm+"&servidor="+servidor_ftp+"&usuario="+usuario_ftp+"&senha="+senha_ftp+"" , true);
  http.onreadystatechange = function() {
	
  if(http.readyState == 4) {
	  
	resultado = http.responseText;
  
	document.getElementById("log_migracao").innerHTML = resultado;	
	
  }
  
  }
  http.send(null);
  delete http;
  }
}

// Funo para executar o script de download de videos do youtube
function youtube_downloader( servidor, porta, url ) {
  
  if(url == "") {
  alert("Error!\n\nPortugus: URL do vdeo invlida.\n\nEnglish: Invalid video URL.\n\nEspaol: URL del vdeo no es vlido.");
  document.getElementById("quadro_requisicao").style.display = "none";
  } else {
  
  var id_youtube = youtube_parser(url);
  
  if(id_youtube == "") {
  alert("Error!\n\nPortugus: URL do vdeo invlida.\n\nEnglish: Invalid video URL.\n\nEspaol: URL del vdeo no es vlido.");
  document.getElementById("quadro_requisicao").style.display = "none";
  } else {

  document.getElementById("img_loader").style.display = "block";
  document.getElementById("quadro_requisicao").style.display = "block";
  document.getElementById("resultado_requisicao").innerHTML = "";
  
  var http = new Ajax();
  http.open("GET", "https://"+servidor+":1443/youtube.php?porta="+porta+"&video="+id_youtube+"" , true);
  http.onreadystatechange = function() {
  
  document.getElementById("resultado_requisicao").innerHTML = http.responseText;
  
  // Auto scroll
  var elem = document.getElementById('resultado_requisicao');
  elem.scrollTop = elem.scrollHeight;
  
  if(http.readyState == 4) {
  document.getElementById("img_loader").style.display = "none";
  }
  
  }
  http.send(null);
  delete http;
  }
  }
}

// Funo para executar o script de download de musicas pela URL
function mp3_downloader( servidor, porta) {
	
  var nome = document.getElementById('nome').value;
  var tipo = document.getElementById("download_mp3").elements["tipo"].value;
  var pasta = document.getElementById('pasta').value;
  var url = document.getElementById('url').value;
  
  if( pasta == "" | url == "") {
	  
  alert("Error!\n\nPortugus: Dados faltando.\n\nEnglish: Missing filds data.\n\nEspaol: Datos no vlidos.");
  document.getElementById("resultado_requisicao").style.display = "none";

  } else {

  document.getElementById("img_loader").style.display = "block";
  document.getElementById("resultado_requisicao").style.display = "block";
  document.getElementById("resultado_requisicao").innerHTML = "";
  
  var http = new Ajax();
  http.open("GET", "https://"+servidor+":1443/download-mp3.php?porta="+porta+"&nome="+nome+"&tipo="+tipo+"&pasta="+pasta+"&url="+url+"" , true);
  http.onreadystatechange = function() {
  
  document.getElementById("resultado_requisicao").innerHTML = http.responseText;
  
  // Auto scroll
  var elem = document.getElementById('resultado_requisicao');
  elem.scrollTop = elem.scrollHeight;
  
  if(http.readyState == 4) {
  document.getElementById("img_loader").style.display = "none";
  }
  
  }
  http.send(null);
  delete http;
  }
}

// Funo para executar o script de download de musicas do soundcloud
function soundcloud_downloader( servidor, porta) {
	
  var pasta = document.getElementById('pasta').value;
  var url = document.getElementById('url').value;
  
  if( pasta == "" | url == "") {
	  
  alert("Error!\n\nPortugus: Dados faltando.\n\nEnglish: Missing filds data.\n\nEspaol: Datos no vlidos.");
  document.getElementById("resultado_requisicao").style.display = "none";

  } else {

  document.getElementById("img_loader").style.display = "block";
  document.getElementById("resultado_requisicao").style.display = "block";
  document.getElementById("resultado_requisicao").innerHTML = "Obtendo dados... Getting data...";
  
  var http = new Ajax();
  http.open("GET", "https://"+servidor+":1443/download-soundcloud.php?porta="+porta+"&pasta="+pasta+"&url="+url+"" , true);
  http.onreadystatechange = function() {
  
  document.getElementById("resultado_requisicao").innerHTML = http.responseText;
  
  // Auto scroll
  var elem = document.getElementById('resultado_requisicao');
  elem.scrollTop = elem.scrollHeight;
  
  if(http.readyState == 4) {
  document.getElementById("img_loader").style.display = "none";
  }
  
  }
  http.send(null);
  delete http;
  }
}

////////////////////////////////////////////////////////
/////////// Funes Gravador de Transmisso ////////////
////////////////////////////////////////////////////////

// Funo para iniciar gravao da transmisso
function iniciar_gravacao( porta ) {
  
  document.getElementById('botao').innerHTML = '<img id="botao" src="img/icones/img-icone-stop-64x64.png" width="64" height="64" onclick="finalizar_gravacao('+porta+');" style="cursor:pointer" title="Parar/Stop" />';
  
  document.getElementById('log').innerHTML = 'Aguarde, iniciando gravao...';
  
  document.getElementById('icone_gravando').innerHTML = '<img src="img/icones/img-icone-rec-animado.gif" width="16" height="16" />';
  
  document.getElementById('icone_gravando').style.display = "block";
  document.getElementById('timer').style.display = "block";
  
  var http = new Ajax();
  http.open("GET", "/funcoes-ajax/gravador/"+porta+"/iniciar" , true);
  http.onreadystatechange = function() {
	
  if(http.readyState == 4) {
  
	arquivo = http.responseText;
	
	document.getElementById('log').innerHTML = 'Gravao iniciada!<br>Arquivo: '+arquivo+'';
	
	contador_gravacao();
	
  }
  
  }
  http.send(null);
  delete http;
  
}

// Funo para parar gravao da transmisso
function finalizar_gravacao( porta ) {
  
  document.getElementById('botao').innerHTML = '<img id="botao" src="img/icones/img-icone-gravar-64x64.png" width="64" height="64" onclick="iniciar_gravacao('+porta+');" style="cursor:pointer" title="Gravar/Record" />';
  
  document.getElementById('log').innerHTML = 'Aguarde, finalizando gravao...';
  
  document.getElementById('icone_gravando').style.display = "none";
  document.getElementById('timer').style.display = "none";
  
  var http = new Ajax();
  http.open("GET", "/funcoes-ajax/gravador/"+porta+"/finalizar" , true);
  http.onreadystatechange = function() {
	
  if(http.readyState == 4) {
  
	resultado = http.responseText.split("|");
	
	document.getElementById('log').innerHTML = 'Gravao finalizada!<br>Arquivo: '+resultado[0]+'<br>Durao Aprox.: '+resultado[1]+'';
	
	document.getElementById('icone_gravando').innerHTML = '<audio oncontextmenu="return false;" controls controlsList="nodownload" autoplay><source src="'+resultado[2]+'" type="audio/mp3"></audio>';
	
	document.getElementById('icone_gravando').style.display = "block";
	
  }
  
  }
  http.send(null);
  delete http;
  
}

function remover_acao_autodj( codigo ) {

  if(window.confirm("Pt-BR: Continuar?\nEn-US: Continue?\nES: Continuar?")) {
  
  document.getElementById("local-status-acoes").innerHTML = '<div class="alert alert-info text-center" role="alert"><img src="/img/ajax-loader.gif" /></div>';
  $("#local-status-acoes").show();
  
  var http = new Ajax();
  http.open("GET", "/gerenciar-acoes-autodj/remover/"+codigo , true);
  http.onreadystatechange = function() {
  
  if(http.readyState == 4) {
  
  resultado = http.responseText;

  document.getElementById("local-status-acoes").innerHTML = resultado;
  $('#' + $.escapeSelector(codigo)).remove();
  $("#local-status-acoes").delay(15000).fadeOut(300); 
  
  }
  
  }
  http.send(null);
  delete http;
  
  } else {
  return false;
  }
}

// Funo para atualizar cache de pastas
function atualizar_cache_pastas( porta ) {
  
  if(porta != "") {
  
  document.getElementById("local-status-acoes").innerHTML = '<div class="alert alert-info text-center" role="alert"><img src="/img/ajax-loader.gif" /></div>';
  $("#local-status-acoes").show();
  
  var http = new Ajax();
  http.open("GET", "/funcoes-ajax/atualizar_cache_pastas/"+porta , true);
  http.onreadystatechange = function() {
  
  if(http.readyState == 4) {
  
  resultado = http.responseText;

  document.getElementById("local-status-acoes").innerHTML = resultado;
  $("#local-status-acoes").delay(15000).fadeOut(300); 
  
  }
  
  }
  http.send(null);
  delete http;
  }
}

// Rotina AJAX
function Ajax() {
var req;

try {
 req = new ActiveXObject("Microsoft.XMLHTTP");
} catch(e) {
 try {
	req = new ActiveXObject("Msxml2.XMLHTTP");
 } catch(ex) {
	try {
	 req = new XMLHttpRequest();
	} catch(exc) {
	 alert("Esse browser no tem recursos para uso do Ajax");
	 req = null;
	}
 }
}

return req;
}
